/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.tools;

import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.scene.tools.SceneNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;

public class SceneNodeParser {
    private static Logger logger = Logger.getLogger(SceneNodeParser.class);
    private char m_cSplitChar = (char)9;
    private Stack m_ClassInfoStack = new Stack();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SceneNode importFormFileByName(String string) throws Exception {
        String string3;
        File file = new File(string);
        if (!file.exists()) {
            try {
                string3 = FilesMan.getFilesMan().mapFilePath(string, 0);
                file = new File(string3 + string);
                if (!file.exists()) throw new WCMException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + string + "]");
                if (!file.isFile()) {
                    throw new WCMException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + string + "]");
                }
            }
            catch (Exception exception) {
                throw new WCMException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + string + "]");
            }
        }
        string3 = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        SceneNode sceneNode = null;
        try {
            try {
                String string2;
                fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "GBK"));
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    ++n;
                    if (string2.trim().length() == 0) continue;
                    int n2 = this.getTabCount(string2, this.m_cSplitChar);
                    SceneNode sceneNode2 = this.makeParentNode(n2 - 1);
                    if (n2 > 0 && sceneNode2 == null) {
                        throw new WCMException("\u6587\u4ef6\u7b2c[" + n + "]\u884c\u6570\u636e\u5b58\u5728\u95ee\u9898\uff01\u662f\u4e0d\u662f\u591a\u952e\u5165\u4e86Tab\u4e2a\u6570\uff1fTab\u4e2a\u6570\u4e3a[" + n2 + "]\u4e2a\uff01");
                    }
                    String string4 = string2.trim();
                    String[] stringArray = string4.split(this.m_cSplitChar + "+");
                    String string5 = "";
                    String string6 = "";
                    if (stringArray.length > 1) {
                        string6 = stringArray[0];
                        string5 = stringArray[1];
                    } else if (stringArray.length > 0) {
                        string5 = stringArray[0];
                    }
                    SceneNode sceneNode3 = null;
                    if (sceneNode2 == null) {
                        sceneNode = sceneNode3 = new SceneNode(string5, 1);
                        sceneNode3 = sceneNode3.addChildNode("\u7b2c\u4e00\u6761\u8fde\u7ebf", n2);
                        logger.info((Object)("\u7b2c\u4e00\u4e2a\u8282\u70b9\uff01[" + string5 + "]"));
                    } else {
                        sceneNode3 = sceneNode2.addChildNode(string5, n2);
                    }
                    this.m_ClassInfoStack.push(sceneNode3);
                }
                Object var17_19 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception("\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=" + string + "]", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new Exception("\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=" + string + "]", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            try {
                if (string3 != null) {
                    ((InputStreamReader)((Object)string3)).close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (string3 != null) {
            ((InputStreamReader)((Object)string3)).close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        this.supplementLastNode(sceneNode);
        return sceneNode;
    }

    private void supplementLastNode(SceneNode sceneNode) throws WCMException {
        if (sceneNode.getType() == 3 && (sceneNode.getChildren() == null || sceneNode.getChildren().isEmpty())) {
            sceneNode.addChildNode(sceneNode.getName(), sceneNode.getTabCount() + 1);
            return;
        }
        ArrayList arrayList = sceneNode.getChildren();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SceneNode sceneNode2 = (SceneNode)arrayList.get(i);
            this.supplementLastNode(sceneNode2);
        }
    }

    private int getTabCount(String string, char c) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < string.length() && string.charAt(i) == c; ++i) {
            ++n;
        }
        return n;
    }

    private SceneNode makeParentNode(int n) {
        if (this.m_ClassInfoStack.isEmpty() || n == -1) {
            return null;
        }
        SceneNode sceneNode = (SceneNode)this.m_ClassInfoStack.peek();
        while (sceneNode != null) {
            int n2 = sceneNode.getTabCount();
            if (n >= n2) {
                return sceneNode;
            }
            this.m_ClassInfoStack.pop();
            if (this.m_ClassInfoStack.isEmpty()) {
                return null;
            }
            sceneNode = (SceneNode)this.m_ClassInfoStack.peek();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "c:\\\u573a\u666f\u5f0f\u670d\u52a1\u6279\u91cf\u521b\u5efa\\";
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                File file2 = fileArray[i];
                String string2 = file2.getName();
                int n2 = string2.indexOf(46, n = string2.lastIndexOf(File.separatorChar));
                if (n2 < 0) continue;
                SceneNodeParser sceneNodeParser = new SceneNodeParser();
                SceneNode sceneNode = sceneNodeParser.importFormFileByName(file2.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

