/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.portal;

import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.MyBaseObj;
import com.trs.infra.persistent.MyBaseObjs;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.IChannelService;
import com.trs.service.IRecentService;
import com.trs.service.IWCMProcessService;
import com.trs.service.ServiceHelper;

public class PortalHelper {
    public static String getRecentDocs(int n, int n2) throws WCMException {
        String string = null;
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IRecentService iRecentService = ServiceHelper.createRecentService();
        WCMFilter wCMFilter = null;
        wCMFilter = n > 0 ? new WCMFilter("", "", "", "DOCID, CHNLID", n) : new WCMFilter("", "", "", "DOCID, CHNLID");
        ChnlDocs chnlDocs = null;
        try {
            chnlDocs = iRecentService.getChnlDocs(wCMFilter);
        }
        catch (Exception exception) {
            chnlDocs = null;
        }
        int n3 = chnlDocs != null ? chnlDocs.size() : 0;
        ChnlDoc chnlDoc = null;
        Document document = null;
        Channel channel = null;
        for (int i = 0; i < n3; ++i) {
            chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (document = chnlDoc.getDocument()) == null || (channel = chnlDoc.getChannel()) == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("RECID", chnlDoc.getId());
            myBaseObj.setProperty("DOCID", chnlDoc.getDocId());
            myBaseObj.setProperty("CHNLID", chnlDoc.getChannelId());
            Status status = document.getStatus();
            myBaseObj.setProperty("DOCSTATUSDESC", status != null ? status.getDisp() : I18NMessage.get(PortalHelper.class, "PortalHelper.label1", "\u672a\u77e5"));
            myBaseObj.setProperty("DOCTITLE", CMyString.truncateStr(document.getTitle(), n2));
            myBaseObj.setProperty("CHNLDESC", channel.getDesc());
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        string = objToXmlConverter.toXMLString(myBaseObjs);
        return string;
    }

    public static String getRecentChannels(int n) throws WCMException {
        String string = null;
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IRecentService iRecentService = ServiceHelper.createRecentService();
        WCMFilter wCMFilter = null;
        wCMFilter = n > 0 ? new WCMFilter("", "", "", "DOCID, CHNLID", n) : new WCMFilter("", "", "", "DOCID, CHNLID");
        Channels channels = null;
        try {
            channels = iRecentService.getChannels(wCMFilter);
        }
        catch (Exception exception) {
            channels = null;
        }
        int n2 = channels != null ? channels.size() : 0;
        Channel channel = null;
        for (int i = 0; i < n2; ++i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("CHNLID", channel.getId());
            myBaseObj.setProperty("CHNLDESC", channel.getDesc());
            myBaseObj.setProperty("SITEDESC", channel.getSite().getDesc());
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        string = objToXmlConverter.toXMLString(myBaseObjs);
        return string;
    }

    public static String getMyFlowDocs(int n, int n2) throws WCMException {
        String string = null;
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IWCMProcessService iWCMProcessService = ServiceHelper.createWCMProcessService();
        WCMFilter wCMFilter = null;
        wCMFilter = n > 0 ? new WCMFilter("", "", "", "", n) : new WCMFilter("", "", "", "");
        FlowDocs flowDocs = null;
        try {
            flowDocs = iWCMProcessService.getFlowDocs(1, wCMFilter);
        }
        catch (Exception exception) {
            flowDocs = null;
        }
        int n3 = flowDocs != null ? flowDocs.size() : 0;
        FlowDoc flowDoc = null;
        IFlowContent iFlowContent = null;
        for (int i = 0; i < n3; ++i) {
            flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null || (iFlowContent = flowDoc.getFlowContent()) == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("FLOWDOCID", flowDoc.getId());
            myBaseObj.setProperty("CONTENTTYPE", iFlowContent.getContentType());
            myBaseObj.setProperty("DOCUMENTID", iFlowContent.getSubinstanceId());
            myBaseObj.setProperty("CONTENTSHOWPAGE", iFlowContent.getContentShowPage());
            myBaseObj.setProperty("CONTENTDESC", CMyString.truncateStr(iFlowContent.getDesc(), n2));
            myBaseObj.setProperty("POSTUSERNAME", flowDoc.getPostUserName());
            myBaseObj.setProperty("POSTTIME", flowDoc.getPostTime().toString("MM-dd HH:mm"));
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        string = objToXmlConverter.toXMLString(myBaseObjs);
        return string;
    }

    public static String getDocumentsByChannelId(int n, int n2, int n3) throws WCMException {
        String string = null;
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IChannelService iChannelService = ServiceHelper.createChannelService();
        Channel channel = Channel.findById(n);
        if (channel == null) {
            return objToXmlConverter.toXMLString(myBaseObjs);
        }
        WCMFilter wCMFilter = null;
        wCMFilter = n2 > 0 ? new WCMFilter("", "", "", "DOCID,DOCTITLE,DOCSTATUS", n2) : new WCMFilter("", "", "", "DOCID,DOCTITLE,DOCSTATUS");
        Documents documents = null;
        try {
            documents = iChannelService.getDocuments(channel, wCMFilter);
        }
        catch (Exception exception) {
            documents = null;
        }
        int n4 = documents != null ? documents.size() : 0;
        Document document = null;
        for (int i = 0; i < n4; ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("DOCID", document.getId());
            myBaseObj.setProperty("DOCTITLE", CMyString.truncateStr(document.getTitle(), n3));
            myBaseObj.setProperty("CHNLID", channel.getId());
            myBaseObj.setProperty("STATUSNAME", document.getStatusName());
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        string = objToXmlConverter.toXMLString(myBaseObjs);
        return string;
    }

    public static void main(String[] stringArray) {
    }
}

