/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DbConfig {
    private static final String CONF = "/database.conf";
    private String dbtype;
    private String jdbcDriver;
    private String bakTable4WcmRight;
    private String oldUser;
    private String oldPasswd;
    private String oldUrl;
    private String newUser;
    private String newPasswd;
    private String newUrl;

    public void load(String string) {
        InputStream inputStream = null;
        if (string != null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            inputStream = DbConfig.class.getResourceAsStream(CONF);
        }
        if (inputStream == null) {
            inputStream = DbConfig.class.getResourceAsStream(CONF.substring(1));
        }
        this.load(inputStream);
    }

    public void load(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            System.out.println("Can't load database config.");
            iOException.printStackTrace(System.out);
            return;
        }
        this.dbtype = properties.getProperty("dbtype", "mssql");
        this.jdbcDriver = properties.getProperty("jdbcdriver");
        this.oldUser = properties.getProperty("old.db.user");
        this.oldPasswd = properties.getProperty("old.db.passwd");
        this.oldUrl = properties.getProperty("old.db.url");
        this.newUser = properties.getProperty("new.db.user");
        this.newPasswd = properties.getProperty("new.db.passwd");
        this.newUrl = properties.getProperty("new.db.url");
        this.bakTable4WcmRight = properties.getProperty("wcmright.bak");
        properties.clear();
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getOldUser() {
        return this.oldUser;
    }

    public String getOldPasswd() {
        return this.oldPasswd;
    }

    public String getOldUrl() {
        return this.oldUrl;
    }

    public String getNewUser() {
        return this.newUser;
    }

    public String getNewPasswd() {
        return this.newPasswd;
    }

    public String getNewUrl() {
        return this.newUrl;
    }

    public String getOldSchema() {
        if ("oracle".equals(this.dbtype) || "db2".equals(this.dbtype)) {
            return this.oldUser.toUpperCase();
        }
        return null;
    }

    public String getNewSchema() {
        if ("oracle".equals(this.dbtype) || "db2".equals(this.dbtype)) {
            return this.newUser.toUpperCase();
        }
        return null;
    }

    public String getBakTable4WcmRight() {
        return this.bakTable4WcmRight;
    }
}

