/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.job;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;

public class JobFailedResult
extends BaseObj {
    private int m_nJobId = 0;
    private String m_sRootCauseMessage = null;
    public static final String DB_TABLE_NAME = "WCMJOBEXERESULT";
    public static final String DB_ID_NAME = "RESULTID";

    public JobFailedResult() {
    }

    public JobFailedResult(int n, Exception exception) {
        this.m_nJobId = n;
        if (exception instanceof WCMException) {
            WCMException wCMException = (WCMException)exception;
            this.m_sRootCauseMessage = wCMException.getMyMessage();
            if (wCMException.getRootCause() != null) {
                this.m_sRootCauseMessage = this.m_sRootCauseMessage + " " + wCMException.getRootCause().getMessage();
            }
        } else {
            this.m_sRootCauseMessage = exception.getMessage();
        }
        if (this.m_sRootCauseMessage == null) {
            this.m_sRootCauseMessage = exception.toString();
        }
    }

    public int getWCMType() {
        return -1;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public void insert() throws WCMException {
        this.setProperty("JOBSCHEDULEID", this.m_nJobId);
        this.setProperty("JOBFAIELDROOTCAUSE", this.m_sRootCauseMessage);
        this.setProperty("CRTIME", CMyDateTime.now());
        super.insert();
    }

    public void update() throws WCMException {
        throw new WCMException(1100, "unsupport!");
    }

    public boolean isValid() {
        return this.m_sRootCauseMessage != null;
    }

    public static final JobFailedResult findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (JobFailedResult)BaseObj.findById(JobFailedResult.class, n);
    }

    public static final JobFailedResult createNewInstance() throws WCMException {
        return (JobFailedResult)BaseObj.createNewInstance(JobFailedResult.class);
    }

    public static final JobFailedResult findByKey(Object object) throws WCMException {
        return (JobFailedResult)BaseObj.findByKey(JobFailedResult.class, object);
    }
}

