/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.job;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.job.JobFailedResult;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class BaseJob
implements Job {
    private JobDataMap m_oDataMap = null;
    private static Logger s_logger = Logger.getLogger(BaseJob.class);

    protected int getArgAsInt(String string) {
        return this.m_oDataMap.getInt(string.toUpperCase());
    }

    protected String getArgAsString(String string) {
        return this.m_oDataMap.getString(string.toUpperCase());
    }

    protected Object getArgAsObject(String string) {
        return this.m_oDataMap.get((Object)string.toUpperCase());
    }

    protected boolean containsArg(String string) {
        return this.m_oDataMap.containsKey((Object)string.toUpperCase());
    }

    protected void putArg(String string, int n) {
        this.m_oDataMap.put(string.toUpperCase(), n);
    }

    protected void putArg(String string, String string2) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("_sArg:" + string));
            s_logger.debug((Object)("_sValue:" + string2));
        }
        this.m_oDataMap.put(string.toUpperCase(), string2);
    }

    protected void putArg(String string, Object object) {
        this.m_oDataMap.put((Object)string.toUpperCase(), object);
    }

    public void execute(JobExecutionContext jobExecutionContext) {
        this.m_oDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        JobExecutionException jobExecutionException = null;
        try {
            this.execute();
        }
        catch (Exception exception) {
            jobExecutionException = new JobExecutionException(exception);
            this.recordFailedResult(this.getArgAsString("ScheduleId"), exception);
        }
        jobExecutionContext.setResult(jobExecutionException);
    }

    private void recordFailedResult(String string, Exception exception) {
        try {
            int n = Integer.parseInt(string);
            JobFailedResult jobFailedResult = new JobFailedResult(n, exception);
            jobFailedResult.insert();
        }
        catch (Exception exception2) {
            s_logger.error((Object)"failed to record job excute fail result.", (Throwable)exception2);
        }
    }

    protected abstract void execute() throws WCMException;
}

