/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import java.util.Calendar;
import java.util.Date;

public class ZipEntry
implements Cloneable {
    private static int KNOWN_SIZE = 1;
    private static int KNOWN_CSIZE = 2;
    private static int KNOWN_CRC = 4;
    private static int KNOWN_TIME = 8;
    private static Calendar cal = Calendar.getInstance();
    private String name;
    private int size;
    private int compressedSize;
    private int crc;
    private int time;
    private short known = 0;
    private short method = (short)-1;
    private byte[] extra = null;
    private String comment = null;
    int zipFileIndex = -1;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this.name = zipEntry.name;
        this.known = zipEntry.known;
        this.size = zipEntry.size;
        this.compressedSize = zipEntry.compressedSize;
        this.crc = zipEntry.crc;
        this.time = zipEntry.time;
        this.method = zipEntry.method;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDOSTime(int n) {
        int n2 = 2 * (n & 0x1F);
        int n3 = n >> 5 & 0x3F;
        int n4 = n >> 11 & 0x1F;
        int n5 = n >> 16 & 0x1F;
        int n6 = (n >> 21 & 0xF) - 1;
        int n7 = (n >> 25 & 0x7F) + 1980;
        try {
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.set(n7, n6, n5, n4, n3, n2);
                this.time = (int)(cal.getTime().getTime() / 1000L);
            }
            this.known = (short)(this.known | KNOWN_TIME);
        }
        catch (RuntimeException runtimeException) {
            this.known = (short)(this.known & ~KNOWN_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDOSTime() {
        if ((this.known & KNOWN_TIME) == 0) {
            return 0;
        }
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.setTime(new Date((long)this.time * 1000L));
            return (cal.get(1) - 1980 & 0x7F) << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        this.time = (int)(l / 1000L);
        this.known = (short)(this.known | KNOWN_TIME);
    }

    public long getTime() {
        return (this.known & KNOWN_TIME) != 0 ? (long)this.time * 1000L : -1L;
    }

    public void setSize(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.size = (int)l;
        this.known = (short)(this.known | KNOWN_SIZE);
    }

    public long getSize() {
        return (this.known & KNOWN_SIZE) != 0 ? (long)this.size & 0xFFFFFFFFL : -1L;
    }

    public void setCompressedSize(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.compressedSize = (int)l;
        this.known = (short)(this.known | KNOWN_CSIZE);
    }

    public long getCompressedSize() {
        return (this.known & KNOWN_CSIZE) != 0 ? (long)this.compressedSize & 0xFFFFFFFFL : -1L;
    }

    public void setCrc(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.crc = (int)l;
        this.known = (short)(this.known | KNOWN_CRC);
    }

    public long getCrc() {
        return (this.known & KNOWN_CRC) != 0 ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException();
        }
        this.method = (short)n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray == null) {
            this.extra = null;
            return;
        }
        if (byArray.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = byArray;
        try {
            int n;
            for (int i = 0; i < byArray.length; i += n) {
                byte by;
                int n2 = byArray[i++] & 0xFF | (byArray[i++] & 0xFF) << 8;
                n = byArray[i++] & 0xFF | (byArray[i++] & 0xFF) << 8;
                if (n2 != 21589 || ((by = byArray[i]) & 1) == 0) continue;
                this.time = byArray[i + 1] & 0xFF | (byArray[i + 2] & 0xFF) << 8 | (byArray[i + 3] & 0xFF) << 16 | (byArray[i + 4] & 0xFF) << 24;
                this.known = (short)(this.known | KNOWN_TIME);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        if (string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        int n = this.name.length();
        return n > 0 && this.name.charAt(n - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

