/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class ContentLinkReplacer {
    public static int KEY_LEN_LIMIT;
    private Hashtable hLinkMap = null;
    private Hashtable hTitleMap = null;
    private boolean[] haveKeysStartWith = new boolean[65535];
    private boolean[] haveKeysWithLen = new boolean[KEY_LEN_LIMIT + 1];
    private int nMaxKeyLen = 0;
    private static String[] TAGS_TOSKIP_ARRAY;
    private static Hashtable TAGS_TOSKIP;
    private static String[] TAGS_SINGLE_SKIP_ARRAY;
    private static Hashtable TAGS_SINGLE_SKIP;

    public ContentLinkReplacer() {
        int n;
        this.hLinkMap = new Hashtable();
        this.hTitleMap = new Hashtable();
        for (n = 0; n < this.haveKeysStartWith.length; ++n) {
            this.haveKeysStartWith[n] = false;
        }
        for (n = 0; n < this.haveKeysWithLen.length; ++n) {
            this.haveKeysWithLen[n] = false;
        }
    }

    public static final String[] getTagsToSkip() {
        return TAGS_TOSKIP_ARRAY;
    }

    public void clear() {
        this.hLinkMap.clear();
        this.hTitleMap.clear();
    }

    public boolean putLinkMap(String string, String string2) {
        return this.putLinkMap(string, string2, "");
    }

    public boolean putLinkMap(String string, String string2, String string3) {
        int n;
        if (string == null || string2 == null) {
            return false;
        }
        int n2 = (string = CMyString.transDisplay(string.trim(), true)).length();
        if (n2 == 0) {
            return false;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return false;
        }
        this.hLinkMap.put(string, string2);
        this.hTitleMap.put(string, string3);
        int n3 = n = n2 > KEY_LEN_LIMIT ? 0 : n2;
        if (!this.haveKeysWithLen[n]) {
            this.haveKeysWithLen[n] = true;
        }
        if (n2 > this.nMaxKeyLen) {
            this.nMaxKeyLen = n2;
        }
        if (!this.haveKeysStartWith[n = (int)string.charAt(0)]) {
            this.haveKeysStartWith[n] = true;
        }
        return true;
    }

    public String removeLinkMap(String string) {
        if (string == null) {
            return null;
        }
        this.hTitleMap.remove(string);
        return (String)this.hLinkMap.remove(string);
    }

    public String getMappedLink(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.hLinkMap.get(string);
    }

    public String replaceLink(String string) throws CMyException {
        return this.replaceLink(string, null);
    }

    public String replaceLink(String string, String string2) throws CMyException {
        if (string == null) {
            return null;
        }
        if (this.hLinkMap.size() <= 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = new char[20];
        int n4 = -1;
        boolean bl = false;
        try {
            stringBuffer = new StringBuffer((int)((double)n * 1.5));
            String string3 = "";
            while (n2 < n) {
                char c;
                if ((c = cArray[n2++]) == '\n' || c == '\r') {
                    stringBuffer.append(c);
                    continue;
                }
                if (n4 >= 0) {
                    if (c == cArray2[n4] && cArray[n2 - 1] != '\\') {
                        --n4;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                bl = false;
                switch (c) {
                    case '\"': 
                    case '\'': {
                        if (n3 != 1 && n3 != 2) break;
                        cArray2[++n4] = c;
                        stringBuffer.append(c);
                        bl = true;
                        break;
                    }
                    case '<': {
                        String string4 = "";
                        stringBuffer.append('<');
                        bl = true;
                        if (n2 >= n) break;
                        if ((c = cArray[n2++]) == '/') {
                            stringBuffer.append('/');
                            if (n3 != 3 || n2 >= n) break;
                            c = cArray[n2++];
                        } else {
                            if (n3 != 0 && c != '!') {
                                stringBuffer.append(c);
                                break;
                            }
                            if (c == '!') {
                                stringBuffer.append(c);
                                c = cArray[n2++];
                                stringBuffer.append(c);
                                c = cArray[n2++];
                                stringBuffer.append(c);
                                boolean bl2 = false;
                                while (!bl2 && n2 < n) {
                                    c = cArray[n2++];
                                    stringBuffer.append(c);
                                    if (c != '-') continue;
                                    char c2 = cArray[n2];
                                    char c3 = cArray[n2 + 1];
                                    if (c2 != '-' || c3 != '>') continue;
                                    stringBuffer.append(c2);
                                    stringBuffer.append(c3);
                                    bl2 = true;
                                    n2 += 2;
                                }
                                break;
                            }
                        }
                        while (Character.isWhitespace(c)) {
                            stringBuffer.append(c);
                            if (n2 >= n) break;
                            c = cArray[n2++];
                        }
                        while (!Character.isWhitespace(c) && c != '>') {
                            string4 = string4 + c;
                            if (n2 >= n) break;
                            c = cArray[n2++];
                        }
                        stringBuffer.append(string4);
                        if (n2 < n) {
                            stringBuffer.append(c);
                        }
                        if (TAGS_TOSKIP.get(string4.toUpperCase()) != null) {
                            if (n3 == 0) {
                                string3 = string4;
                                n3 = 2;
                                break;
                            }
                            n3 = c == '>' ? 0 : 1;
                            break;
                        }
                        if (c == '>') break;
                        n3 = 1;
                        break;
                    }
                    case '>': {
                        stringBuffer.append('>');
                        bl = true;
                        if (n3 == 1) {
                            n3 = 0;
                            break;
                        }
                        if (n3 != 2) break;
                        if (TAGS_SINGLE_SKIP.get(string3.toUpperCase()) != null) {
                            n3 = 0;
                            break;
                        }
                        n3 = 3;
                        break;
                    }
                    default: {
                        if (n3 == 0) break;
                        stringBuffer.append(c);
                        bl = true;
                    }
                }
                if (bl) continue;
                if (!this.haveKeysStartWith[c]) {
                    stringBuffer.append(c);
                    continue;
                }
                String string5 = String.valueOf(c);
                boolean bl3 = false;
                int n5 = n2;
                for (int i = 1; i <= this.nMaxKeyLen; ++i) {
                    char c4;
                    if (this.haveKeysWithLen[i]) {
                        String string6 = (String)this.hLinkMap.get(string5);
                        String string7 = (String)this.hTitleMap.get(string5);
                        if (string6 != null) {
                            stringBuffer.append("<a href=\"").append(string6);
                            stringBuffer.append("\" title=\"").append(CMyString.filterForHTMLValue(string7) + "\" ");
                            if (string2 != null) {
                                stringBuffer.append(' ').append(string2);
                            }
                            stringBuffer.append('>').append(string5).append("</a>");
                            n2 = n5;
                            bl3 = true;
                            break;
                        }
                    }
                    if (n5 >= n || (c4 = cArray[n5++]) == '\n' || c4 == '\r') break;
                    string5 = string5 + c4;
                }
                if (bl3) continue;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(System.out);
            return string;
        }
        catch (Exception exception) {
            throw new CMyException(1, I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label1", "\u66ff\u6362\u94fe\u63a5\u5931\u8d25\uff08DocInnerLinkReplacer.replaceLink\uff09"), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadLinkMap(String string) throws CMyException {
        int n;
        File file = null;
        InputStreamReader fileReader = null;
        Hashtable hashtable = new Hashtable();
        try {
            try {
                String string2;
                file = new File(string);
                fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    n = string2.indexOf(61);
                    if (n < 0) continue;
                    this.putLinkMap(string2.substring(0, n), string2.substring(n + 1));
                }
                bufferedReader.close();
                n = 1;
                Object var9_9 = null;
                if (fileReader == null) return n != 0;
            }
            catch (Exception exception) {
                throw new CMyException(1, I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label2", "\u88c5\u8f7d\u94fe\u63a5\u6620\u5c04\u8868\u5931\u8d25(ContentLinkReplacer.loadLinkMap)"), exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (fileReader == null) throw throwable;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return n != 0;
        }
        fileReader.close();
        return n != 0;
    }

    private int readAttributes(char[] cArray, StringBuffer stringBuffer, int n) {
        int n2 = n;
        int n3 = cArray.length;
        Object var6_6 = null;
        int n4 = 32;
        boolean bl = true;
        block0: while (n2 < n3) {
            while (n2 < n3 && Character.isWhitespace(cArray[n2])) {
                stringBuffer.append(' ');
                ++n2;
            }
            if (n2 >= n3 || cArray[n2] == '>' && bl) break;
            while (n2 < n3) {
                int n5 = cArray[n2];
                if ((n5 == 34 || n5 == 39) && cArray[n2 - 1] != '\\') {
                    if (n4 == 32) {
                        n4 = n5;
                        bl = false;
                    } else if (n5 == n4) {
                        bl = !bl;
                    }
                }
                stringBuffer.append((char)n5);
                if (bl && (Character.isWhitespace((char)n5) || n5 == 62)) continue block0;
                ++n2;
            }
        }
        return ++n2;
    }

    public static void main(String[] stringArray) {
        String string = "d:\\test\\link\\link_table.ini";
        String string2 = "d:\\src.htm";
        String string3 = "d:\\dst.htm";
        String string4 = null;
        try {
            ContentLinkReplacer contentLinkReplacer = new ContentLinkReplacer();
            contentLinkReplacer.putLinkMap(I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label3", "\u5b66\u751f"), "www.trs.com.cn", "titefdfdsf");
            contentLinkReplacer.putLinkMap(I18NMessage.get(ContentLinkReplacer.class, "ContentLinkReplacer.label4", "\u6df1\u5733"), "www.trs.com.cn", "titefdfdsf");
            contentLinkReplacer.putLinkMap("0", "www.trs.com.cn", "test0");
            String string5 = CMyFile.readFile(string2);
            long l = System.currentTimeMillis();
            string4 = contentLinkReplacer.replaceLink(string5);
            long l2 = System.currentTimeMillis();
            System.out.println("==========result=============");
            System.out.println(string5);
            System.out.println(string4);
            CMyFile.writeFile(string3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    static {
        int n;
        KEY_LEN_LIMIT = 200;
        TAGS_TOSKIP_ARRAY = new String[]{"A", "APPLET", "MAP", "OBJECT", "SELECT", "TEXTAREA", "SCRIPT", "OPTION", "INPUT", "STYLE"};
        TAGS_TOSKIP = new Hashtable();
        for (n = 0; n < TAGS_TOSKIP_ARRAY.length; ++n) {
            TAGS_TOSKIP.put(TAGS_TOSKIP_ARRAY[n].toUpperCase(), TAGS_TOSKIP_ARRAY[n]);
        }
        TAGS_SINGLE_SKIP_ARRAY = new String[]{"OPTION", "INPUT"};
        TAGS_SINGLE_SKIP = new Hashtable();
        for (n = 0; n < TAGS_SINGLE_SKIP_ARRAY.length; ++n) {
            TAGS_SINGLE_SKIP.put(TAGS_SINGLE_SKIP_ARRAY[n].toUpperCase(), TAGS_SINGLE_SKIP_ARRAY[n]);
        }
    }
}

