/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.persistent.db.ConnectPasswordEncrypter;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.util.CMyString;
import com.trs.util.dbcp.ConnectionCache;
import com.trs.util.dbcp.ConnectionCacheFactory;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPool {
    private ConnectionCache m_oDataSource;

    public ConnectionPool(DBConnectionConfig dBConnectionConfig) throws SQLException {
        ConnectionCacheFactory connectionCacheFactory = ConnectionCacheFactory.getInstance();
        this.m_oDataSource = connectionCacheFactory.createConnectionCache();
        this.m_oDataSource.setDriverClassName(dBConnectionConfig.getDBType().getDriverClass());
        this.m_oDataSource.setURL(dBConnectionConfig.getConnectionURL());
        this.m_oDataSource.setUserName(dBConnectionConfig.getConnectionUser());
        this.m_oDataSource.setPassWord(ConnectPasswordEncrypter.deEncrypt(dBConnectionConfig.getConnectionPassword()));
        this.m_oDataSource.setTraceAssign(dBConnectionConfig.isTraceAssign());
        this.m_oDataSource.setTTLOverUse(dBConnectionConfig.getTimeToLiveOverUse());
        if (dBConnectionConfig.getCacheScheme() != null) {
            this.m_oDataSource.setCacheScheme(this.getCacheScheme(dBConnectionConfig.getCacheScheme()));
            this.m_oDataSource.setMaxWait(this.getMaxWaitTime(dBConnectionConfig.getCacheScheme()));
        } else if (dBConnectionConfig.isWaitIfBusy()) {
            this.m_oDataSource.setCacheScheme(3);
            this.m_oDataSource.setMaxWait(-1);
        } else {
            this.m_oDataSource.setCacheScheme(2);
        }
        int n = dBConnectionConfig.getInitConnects();
        int n2 = dBConnectionConfig.getMaxConnects();
        if (n > n2) {
            n = n2;
        }
        this.m_oDataSource.setMaxLimit(n2);
        this.m_oDataSource.setMinLimit(n);
        this.m_oDataSource.setMaxSpare(n2);
        this.m_oDataSource.setMinSpare(n);
        this.m_oDataSource.setTestSQL(CMyString.showNull(dBConnectionConfig.getTestSQL()));
        this.m_oDataSource.setTestOnAssign(dBConnectionConfig.isTestOnAssign());
        boolean bl = dBConnectionConfig.isTestOnIdle();
        this.m_oDataSource.setTestOnIdle(bl);
        if (bl) {
            int n3 = dBConnectionConfig.getMonitorInterval() * 60;
            this.m_oDataSource.setMonitorInterval(n3);
            int n4 = dBConnectionConfig.getMaxIdleTime() * 60;
            this.m_oDataSource.setMaxIdleTime(n4);
        }
        this.m_oDataSource.setMaxOrphanTime(dBConnectionConfig.getMaxOrphanTime());
        this.m_oDataSource.start();
    }

    private int getCacheScheme(String string) {
        if (string != null) {
            if (string.startsWith("DYNAMIC_GROW")) {
                return 1;
            }
            if (string.startsWith("FIXED_FAIL")) {
                return 2;
            }
            if (string.startsWith("FIXED_WAIT")) {
                return 3;
            }
        }
        return 3;
    }

    private int getMaxWaitTime(String string) {
        if (string != null && string.startsWith("FIXED_WAIT:")) {
            try {
                return 1000 * Integer.parseInt(string.substring("FIXED_WAIT:".length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public void close() {
        try {
            this.m_oDataSource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void free(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_oDataSource.getConnection();
    }

    public String toString() {
        return this.m_oDataSource.toString();
    }

    public ConnectionCache getConnectionCache() {
        return this.m_oDataSource;
    }
}

