/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.cabfile;

import com.trs.infra.util.cabfile.CFData;
import com.trs.infra.util.cabfile.CFFile;
import com.trs.infra.util.cabfile.CFFolder;
import com.trs.infra.util.cabfile.CFHeader;
import com.trs.infra.util.cabfile.CabConstants;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class CabFileReader
implements CabConstants {
    private static final int MAX_SZ_LENGTH = 4096;
    RandomAccessFile m_oAccess;
    CFHeader m_oHeader;
    byte[] m_oBuffer;

    CabFileReader(File file) throws FileNotFoundException {
        this.m_oAccess = new RandomAccessFile(file, "r");
    }

    CabFileReader(File file, CFHeader cFHeader) throws FileNotFoundException {
        this.m_oAccess = new RandomAccessFile(file, "r");
        this.m_oHeader = cFHeader;
    }

    void skip(int n) throws IOException {
        this.m_oAccess.skipBytes(n);
    }

    void seek(long l) throws IOException {
        this.m_oAccess.seek(l);
    }

    private final void assertHeader() throws IOException {
        if (this.m_oHeader == null) {
            throw new IOException("m_oHeader missing");
        }
    }

    private final void assertSignature() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.m_oAccess.read();
        if ((n4 | (n3 = this.m_oAccess.read()) | (n2 = this.m_oAccess.read()) | (n = this.m_oAccess.read())) < 0) {
            throw new EOFException();
        }
        if (n4 == 77 && n3 == 83 && n2 == 67 && n == 70) {
            return;
        }
        throw new IOException("signature not match");
    }

    long readU4() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.m_oAccess.read();
        if ((n4 | (n3 = this.m_oAccess.read()) | (n2 = this.m_oAccess.read()) | (n = this.m_oAccess.read())) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    int readU2() throws IOException {
        int n;
        int n2 = this.m_oAccess.read();
        if ((n2 | (n = this.m_oAccess.read())) < 0) {
            throw new EOFException();
        }
        return (n << 8) + (n2 << 0);
    }

    final int readU1() throws IOException {
        int n = this.m_oAccess.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    private final byte[] getBuffer() {
        if (this.m_oBuffer == null) {
            this.m_oBuffer = new byte[4096];
        }
        return this.m_oBuffer;
    }

    byte[] readSZ() throws IOException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = this.getBuffer();
        while (n2 < 4096 && (n = this.readU1()) != 0) {
            byArray[n2++] = (byte)n;
        }
        if (n2 == 4096) {
            throw new IOException("SZ string too long: " + n2);
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i];
        }
        return byArray2;
    }

    CFHeader readCFHeader() throws IOException {
        this.assertSignature();
        CFHeader cFHeader = new CFHeader();
        this.skip(4);
        cFHeader.cbCabinet = this.readU4();
        this.skip(4);
        cFHeader.coffFiles = this.readU4();
        this.skip(4);
        cFHeader.versionMinor = this.readU1();
        cFHeader.versionMajor = this.readU1();
        cFHeader.cFolders = this.readU2();
        cFHeader.cFiles = this.readU2();
        cFHeader.flags = this.readU2();
        cFHeader.setID = this.readU2();
        cFHeader.iCabinet = this.readU2();
        if ((cFHeader.flags & 4) != 0) {
            cFHeader.cbCFHeader = this.readU2();
            cFHeader.cbCFFolder = this.readU1();
            cFHeader.cbCFData = this.readU1();
            cFHeader.abReserve = new byte[cFHeader.cbCFHeader];
            this.read(cFHeader.abReserve, 0, cFHeader.cbCFHeader);
        }
        if ((cFHeader.flags & 1) != 0) {
            cFHeader.szCabinetPrev = this.readSZ();
            cFHeader.szDiskPrev = this.readSZ();
        }
        if ((cFHeader.flags & 2) != 0) {
            cFHeader.szCabinetNext = this.readSZ();
            cFHeader.szDiskNext = this.readSZ();
        }
        this.m_oHeader = cFHeader;
        return this.m_oHeader;
    }

    CFFolder readCFFolder() throws IOException {
        this.assertHeader();
        CFFolder cFFolder = new CFFolder();
        cFFolder.coffCabStart = this.readU4();
        cFFolder.cCFData = this.readU2();
        cFFolder.typeCompress = this.readU2();
        if ((this.m_oHeader.flags & 4) != 0 && this.m_oHeader.cbCFFolder > 0) {
            if (cFFolder.abReserve == null || cFFolder.abReserve.length != this.m_oHeader.cbCFFolder) {
                cFFolder.abReserve = new byte[this.m_oHeader.cbCFFolder];
            }
            this.read(cFFolder.abReserve, 0, this.m_oHeader.cbCFFolder);
        }
        return cFFolder;
    }

    CFFile readCFFile() throws IOException {
        CFFile cFFile = new CFFile();
        cFFile.cbFile = this.readU4();
        cFFile.uoffFolderStart = this.readU4();
        cFFile.iFolder = this.readU2();
        cFFile.date = this.readU2();
        cFFile.time = this.readU2();
        cFFile.attribs = this.readU2();
        cFFile.szName = this.readSZ();
        return cFFile;
    }

    CFData fillCFData(CFData cFData) throws IOException {
        this.assertHeader();
        cFData.csum = this.readU4();
        cFData.cbData = this.readU2();
        cFData.cbUncomp = this.readU2();
        if ((this.m_oHeader.flags & 4) != 0 && this.m_oHeader.cbCFData > 0) {
            if (cFData.abReserve == null || cFData.abReserve.length != this.m_oHeader.cbCFData) {
                cFData.abReserve = new byte[this.m_oHeader.cbCFData];
            }
            this.read(cFData.abReserve, 0, this.m_oHeader.cbCFData);
        }
        this.read(cFData.ab, 0, cFData.cbData);
        return cFData;
    }

    private void read(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.m_oAccess.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    void close() {
        if (this.m_oAccess != null) {
            try {
                this.m_oAccess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

