/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class TRSImportsOrgnize {
    public static final String CLASSES_PATH_FLAG = File.separatorChar + "classes" + File.separatorChar;
    public static final String FLAG_PAGE_START = "include file=\"";
    public static final int TYPE_NOFLAG = -1;
    public static final int TYPE_PAGE_START = 0;
    public static final int TYPE_INCLUDE = 1;
    public static final int TYPE_HTML_VALUE = 2;
    public static final int TYPE_CODE_START = 3;
    public static final int TYPE_CODE_END = 4;
    public static final int TYPE_COMMENT = 5;
    public static final String[] OPERATION_STR = new String[]{"<%!", "<%=", "<%", "%>", "-", "=", "(", ")", ".", "!"};
    public static final String[] EXCLUDE_PATH = new String[]{"images", "include", "cvs"};
    public static ArrayList arExcludeClass = new ArrayList();
    public static Hashtable hTRSClasses;
    private static final String FLAG_WCM_IMPORTS_BEGIN = "<!------- WCM IMPORTS BEGIN ------------>";
    private static final String FLAG_WCM_IMPORTS_END = "<!------- WCM IMPORTS END ------------>";

    private static void initClasses(String string) {
        TRSImportsOrgnize.initExcludeClass();
        hTRSClasses = TRSImportsOrgnize.getFileHashtable(string);
    }

    private static void initExcludeClass() {
        arExcludeClass.add("ExceptionNumber.class");
        arExcludeClass.add("User.class");
        arExcludeClass.add("ContextHelper.class");
        arExcludeClass.add("WCMException.class");
        arExcludeClass.add("LoginHelper.class");
        arExcludeClass.add("RequestParser.class");
        arExcludeClass.add("ResponseHelper.class");
        arExcludeClass.add("DreamFactory.class");
    }

    public static boolean isExcludeClass(String string) {
        return arExcludeClass.indexOf(string) >= 0;
    }

    public static String transformPathToClassPath(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0 || n < string.lastIndexOf(File.separatorChar)) {
            return string;
        }
        String string2 = string.substring(0, n);
        n = string.indexOf(CLASSES_PATH_FLAG);
        if (n < 0) {
            return string;
        }
        string2 = string2.substring(n + CLASSES_PATH_FLAG.length());
        return string2.replace(File.separatorChar, '.');
    }

    public static Hashtable getFileHashtable(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return hashtable;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                if (TRSImportsOrgnize.isExcludeClass(fileArray[i].getName())) continue;
                String string2 = TRSImportsOrgnize.transformPathToClassPath(fileArray[i].getAbsolutePath());
                hashtable.put(fileArray[i].getName(), string2);
            }
            if (!fileArray[i].isDirectory()) continue;
            hashtable.putAll(TRSImportsOrgnize.getFileHashtable(fileArray[i].getPath()));
        }
        return hashtable;
    }

    public static String mapClassFullPath(String string) {
        if (string.indexOf(".") < 0) {
            string = string + ".class";
        }
        return (String)hTRSClasses.get(string);
    }

    private static boolean isExcludePath(String string) {
        String string2 = CMyFile.extractFileName(string);
        for (int i = 0; i < EXCLUDE_PATH.length; ++i) {
            if (!EXCLUDE_PATH[i].equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludeFile(String string) {
        String string2 = CMyFile.extractFileExt(string);
        return !string2.equalsIgnoreCase("jsp");
    }

    public static void dowithPath(String string) throws Exception {
        File file = new File(string);
        if (file.isFile()) {
            TRSImportsOrgnize.dowithFile(file.getAbsolutePath());
            return;
        }
        if (TRSImportsOrgnize.isExcludePath(file.getName())) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                TRSImportsOrgnize.dowithFile(fileArray[i].getAbsolutePath());
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            TRSImportsOrgnize.dowithPath(fileArray[i].getPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String dowithFile(String string) throws CMyException {
        ArrayList arrayList;
        BufferedReader bufferedReader;
        FileInputStream fileInputStream;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        InputStreamReader inputStreamReader;
        block36: {
            String string3;
            if (TRSImportsOrgnize.isExcludeFile(string)) {
                return null;
            }
            inputStreamReader = null;
            stringBuffer2 = null;
            stringBuffer = null;
            fileInputStream = null;
            bufferedReader = null;
            arrayList = new ArrayList();
            try {
                try {
                    String string2;
                    fileInputStream = new FileInputStream(string);
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, CMyString.FILE_WRITING_ENCODING));
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = 0;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!bl4) {
                            if (bl3) {
                                if (string2.indexOf(FLAG_WCM_IMPORTS_END) < 0) continue;
                                bl4 = true;
                                bl3 = false;
                                continue;
                            }
                            if (string2.indexOf(FLAG_WCM_IMPORTS_BEGIN) >= 0) {
                                bl3 = true;
                                continue;
                            }
                            if (stringBuffer2 == null) {
                                stringBuffer2 = new StringBuffer();
                            } else {
                                stringBuffer2.append('\n');
                            }
                            stringBuffer2.append(string2);
                            continue;
                        }
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                            stringBuffer2.append('\n');
                        }
                        stringBuffer.append('\n');
                        stringBuffer.append(string2);
                        ++n;
                        int n2 = TRSImportsOrgnize.getLineType(string2);
                        switch (n2) {
                            case 5: {
                                bl2 = false;
                                break;
                            }
                            case 3: {
                                if (!bl) {
                                    bl = string2.indexOf("%>") <= 0;
                                } else {
                                    System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label1", "\u5206\u6790\u7b2c[") + n + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label2", "]\u884c[") + string2 + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label3", "]\u53d1\u73b0\u5f02\u5e38:\u4ee5\u524d\u7684\u4ee3\u7801\u6ca1\u6709\u7ed3\u675f!"));
                                }
                                bl2 = true;
                                break;
                            }
                            case 4: {
                                if (bl) {
                                    bl = false;
                                } else {
                                    System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label1", "\u5206\u6790\u7b2c[") + n + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label2", "]\u884c[") + string2 + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label4", "]\u53d1\u73b0\u5f02\u5e38:\u6ca1\u6709\u5f00\u59cb!"));
                                }
                                bl2 = true;
                                break;
                            }
                            case 2: {
                                string2 = TRSImportsOrgnize.subHTMLValue(string2);
                                bl2 = string2 != null;
                                break;
                            }
                            case -1: {
                                bl2 = bl;
                                break;
                            }
                        }
                        if (!bl2) continue;
                        arrayList = TRSImportsOrgnize.mergeArrayList(arrayList, TRSImportsOrgnize.dowithLine(string2));
                        bl2 = false;
                    }
                    if (stringBuffer != null) break block36;
                    System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label5", "\u6587\u4ef6[") + string + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label6", "]\u4e0d\u662f\u7cfb\u7edf\u89c4\u8303\u6587\u4ef6\uff01\u4e0d\u5728\u5904\u7406\u8303\u56f4\u5185"));
                    string3 = null;
                    Object var16_18 = null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new CMyException(55, I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label7", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new CMyException(53, I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label8", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), iOException);
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return string3;
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream == null) return string3;
            fileInputStream.close();
            return string3;
        }
        Object var16_19 = null;
        try {}
        catch (Exception exception) {}
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        String string4 = TRSImportsOrgnize.createImportContent(arrayList);
        CMyFile.writeFile(string, stringBuffer2 + string4 + stringBuffer);
        return "";
    }

    private static ArrayList dowithLine(String string) {
        String string2 = string;
        if ((string2 = string2.trim()).length() <= 0) {
            return null;
        }
        for (int i = 0; i < OPERATION_STR.length; ++i) {
            string2 = CMyString.replaceStr(string2, OPERATION_STR[i], " ");
        }
        if ((string2 = string2.trim()).length() <= 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        string2 = CMyString.replaceStr(string2, "\t", " ");
        String[] stringArray = string2.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().length() == 0 || (string3 = TRSImportsOrgnize.mapClassFullPath(stringArray[i])) == null || arrayList.indexOf(string3) >= 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private static int getLineType(String string) {
        if ((string = string.trim()).indexOf(FLAG_PAGE_START) >= 0) {
            return 0;
        }
        if (string.indexOf("<%@include ") >= 0) {
            return 1;
        }
        if (string.indexOf("<%=") >= 0) {
            return 2;
        }
        if (string.indexOf("<%") >= 0) {
            return 3;
        }
        if (string.indexOf("%>") >= 0) {
            return 4;
        }
        if (string.indexOf("//") == 0 || string.indexOf("*") == 0 || string.indexOf("/*") == 0 || string.indexOf("page import=") > 0) {
            return 5;
        }
        return -1;
    }

    private static String subHTMLValue(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        while (n2 >= 0) {
            n = string.indexOf("<%=", n2);
            if (n < 0) {
                return string2;
            }
            n2 = string.indexOf("%>", n);
            if (n2 < 0) {
                return string2;
            }
            string2 = string2 + " " + string.substring(n + 3, n2);
        }
        return string2;
    }

    private static ArrayList mergeArrayList(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2 == null || arrayList2.isEmpty()) {
            return arrayList;
        }
        Object e = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            e = arrayList2.get(i);
            if (arrayList.indexOf(e) >= 0) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private static String createImportContent(ArrayList arrayList) {
        Collections.sort(arrayList);
        String string = null;
        String string2 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = (String)arrayList.get(i);
            string2 = string2 + "<%@ page import=\"" + string + "\" %>";
            if (i + 1 >= arrayList.size()) continue;
            string2 = string2 + "\n";
        }
        return "<!------- WCM IMPORTS BEGIN ------------>\n" + string2 + "\n" + FLAG_WCM_IMPORTS_END;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            System.err.println("\u5fc5\u987b\u6307\u5b9a\u4e24\u4e2a\u53c2\u6570\n\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3aClass\u7684\u5b58\u653e\u8def\u5f84\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u4e3a\u5f85\u5904\u7406\u7684\u6587\u4ef6\u6216\u76ee\u5f55");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        File file = new File(string);
        if (!file.exists()) {
            System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label9", "\u6307\u5b9a\u7684ClassPath[") + string + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label10", "]\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        TRSImportsOrgnize.initClasses(string);
        file = new File(string2);
        if (!file.exists()) {
            System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label11", "\u6307\u5b9a\u5f85\u5904\u7406\u7684\u76ee\u5f55\u6216\u6587\u4ef6[") + string2 + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label10", "]\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        try {
            if (file.isDirectory()) {
                TRSImportsOrgnize.dowithPath(string2);
            } else {
                TRSImportsOrgnize.dowithFile(string2);
            }
        }
        catch (Exception exception) {
            System.err.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label12", "\u5904\u7406\u76ee\u5f55\u6216\u6587\u4ef6\u7684Imports[") + string2 + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label13", "]\u65f6\u5019\u51fa\u73b0\u5f02\u5e38\uff01"));
            exception.printStackTrace();
        }
    }

    static {
        try {
            TRSImportsOrgnize.initClasses("D:/MyWorkspace/TRSWCM52SRC/context/WEB-INF/classes/");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

