/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Reports {
    private List m_failedReport = new ArrayList();
    private List m_warnedReport = new ArrayList();
    private List m_sucessedReport = new ArrayList();
    private int[] m_ids;
    private String m_sTitle;
    private ArrayList m_arExtraData;

    public ArrayList getExtraData() {
        return this.m_arExtraData;
    }

    public void setExtraData(ArrayList arrayList) {
        this.m_arExtraData = arrayList;
    }

    public Reports(String string) {
        this.m_sTitle = string;
    }

    public void add(Reports reports) {
        this.m_failedReport.addAll(reports.m_failedReport);
        this.m_warnedReport.addAll(reports.m_warnedReport);
        this.m_sucessedReport.addAll(reports.m_sucessedReport);
    }

    public Report addFailedReport(String string, Throwable throwable) {
        Report report = this.createReport(string, throwable);
        report.setType(5);
        this.m_failedReport.add(report);
        return report;
    }

    public Report addWarnedReport(String string, Throwable throwable) {
        Report report = this.createReport(string, throwable);
        report.setType(4);
        this.m_warnedReport.add(report);
        return report;
    }

    public void addSucessedReport(String string) {
        this.m_sucessedReport.add(this.createReport(string, null));
    }

    public List getFailedReporter() {
        return this.m_failedReport;
    }

    public Report getFailedReporterAt(int n) {
        if (this.m_failedReport.size() <= n) {
            return null;
        }
        return (Report)this.m_failedReport.get(n);
    }

    public List getWarnedReporter() {
        return this.m_warnedReport;
    }

    public Report getWarnedReporterAt(int n) {
        return (Report)this.m_warnedReport.get(n);
    }

    public List getSucessedReporter() {
        return this.m_sucessedReport;
    }

    public Report getSucessedReporterAt(int n) {
        if (this.m_sucessedReport.size() <= n) {
            return null;
        }
        return (Report)this.m_sucessedReport.get(n);
    }

    public int getReportsNum() {
        return this.m_failedReport.size() + this.m_sucessedReport.size();
    }

    public String getTitle() {
        return this.m_sTitle;
    }

    public void setTitle(String string) {
        this.m_sTitle = string;
    }

    private Report createReport(String string, Throwable throwable) {
        return new Report(string, throwable);
    }

    public void merge(Reports reports) {
        List list = reports.getSucessedReporter();
        this.m_sucessedReport.addAll(list);
        List list2 = reports.getFailedReporter();
        this.m_failedReport.addAll(list2);
        List list3 = reports.getWarnedReporter();
        this.m_warnedReport.addAll(list3);
    }

    public String toString() {
        int n;
        String string = "[" + this.m_sTitle + "] Reports:";
        int n2 = this.m_sucessedReport.size();
        for (n = 0; n < n2; ++n) {
            string = string + "\n" + this.getSucessedReporterAt(n);
        }
        n2 = this.m_warnedReport.size();
        for (n = 0; n < n2; ++n) {
            string = string + "\n" + this.getWarnedReporterAt(n);
        }
        n2 = this.m_failedReport.size();
        for (n = 0; n < n2; ++n) {
            string = string + "\n" + this.getFailedReporterAt(n);
        }
        return string;
    }

    public String toXML() {
        return this.toXML(false);
    }

    public String toXML(boolean bl) {
        int n;
        Element element = DocumentHelper.createElement((String)"REPORTS");
        element.addElement("IS" + (bl ? "_" : "-") + "SUCCESS").addText(this.m_failedReport.size() <= 0 ? "true" : "false");
        element.addElement("TITLE").addCDATA(this.m_sTitle);
        if (this.getResultIds() != null && this.getResultIds().length > 0) {
            Element element2 = element.addElement("ObjectIds");
            for (n = 0; n < this.getResultIds().length; ++n) {
                element2.addElement("ObjectId").addText(String.valueOf(this.getResultIds()[n]));
            }
        }
        int n2 = this.m_sucessedReport.size();
        for (n = 0; n < n2; ++n) {
            element.add(this.getSucessedReporterAt(n).toXMLElement(bl));
        }
        n2 = this.m_warnedReport.size();
        for (n = 0; n < n2; ++n) {
            element.add(this.getWarnedReporterAt(n).toXMLElement(bl));
        }
        n2 = this.m_failedReport.size();
        for (n = 0; n < n2; ++n) {
            element.add(this.getFailedReporterAt(n).toXMLElement(bl));
        }
        return element.asXML();
    }

    public String toJSONXML() {
        return this.toXML(true);
    }

    public void addReport(Report report) {
        switch (report.getType()) {
            case 3: {
                this.m_sucessedReport.add(report);
                break;
            }
            case 5: {
                this.m_failedReport.add(report);
                break;
            }
            case 4: {
                this.m_warnedReport.add(report);
                break;
            }
        }
    }

    public void setResultIds(int[] nArray) {
        this.m_ids = this.filterZero(nArray);
    }

    private int[] filterZero(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0) continue;
            ++n;
        }
        int[] nArray2 = new int[nArray.length - n];
        Arrays.sort(nArray);
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i + n];
        }
        return nArray2;
    }

    public int[] getResultIds() {
        return this.m_ids != null ? this.m_ids : new int[]{};
    }
}

