/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.tools.SymbolC2E;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;

public class PropertiesVARProcessor {
    protected String m_sSrcPath = null;
    protected String m_sComparePath = null;
    protected String m_sDstPath = null;
    protected String m_sStartPath = null;
    protected String m_sFileExt = "properties";
    protected String m_sFileEncoding = "GBK";
    private StringBuffer m_sbInfo = new StringBuffer();
    private boolean m_bRecordDetailInfo = false;
    private String m_sAlreadyCompareFile = null;

    public PropertiesVARProcessor(String string, String string2, String string3, String string4) {
        if (string.endsWith(".properties")) {
            string = CMyFile.extractFilePath(string);
        }
        if (string2.endsWith(".properties")) {
            string2 = CMyFile.extractFilePath(string2);
        }
        this.m_sSrcPath = CMyString.setStrEndWith(string, File.separatorChar);
        this.m_sComparePath = CMyString.setStrEndWith(string2, File.separatorChar);
        this.m_sDstPath = CMyString.setStrEndWith(string3, File.separatorChar);
        this.m_sStartPath = CMyString.setStrEndWith(string4, File.separatorChar);
    }

    public String process() throws Exception {
        File file = new File(this.m_sSrcPath);
        if (!file.exists()) {
            throw new Exception("\u6307\u5b9a\u7684\u76ee\u5f55[" + this.m_sSrcPath + "]\u4e0d\u5b58\u5728\uff01");
        }
        if (!file.isDirectory()) {
            throw new Exception("\u6307\u5b9a\u7684\u76ee\u5f55[" + this.m_sSrcPath + "]\u4e0d\u662f\u76ee\u5f55\uff01");
        }
        this.processDIR(file);
        return this.m_sbInfo.toString();
    }

    private void processDIR(File file) throws Exception {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isFile()) {
                this.processDIR(file2);
                continue;
            }
            String string = file2.getName();
            if (!string.endsWith(this.m_sFileExt)) continue;
            String string2 = file2.getAbsolutePath();
            String string3 = this.m_sComparePath.substring(this.m_sStartPath.length());
            int n = string2.indexOf(string3);
            String string4 = this.m_sComparePath + string2.substring(n + string3.length());
            this.process(string2, string4);
        }
    }

    public String process(String string, String string2) throws Exception {
        String string3;
        String string4;
        File file = new File(string2);
        if (!file.exists()) {
            this.m_sbInfo.append(string2.substring(this.m_sStartPath.length()) + "\u4e0d\u5b58\u5728\uff01\n");
            CMyFile.copyFile(string, string2);
            String string5 = this.makeDstFileName(string2);
            CMyFile.copyFile(string, string5);
            return this.m_sbInfo.toString();
        }
        HashMap hashMap = this.toMap(string);
        HashMap hashMap2 = this.toMap(string2);
        Iterator iterator = hashMap.keySet().iterator();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            string3 = (String)hashMap2.get(string4);
            if (string3 == null) {
                if (!bl) {
                    this.m_sbInfo.append("\u6587\u4ef6[" + string2.substring(this.m_sStartPath.length()) + "]\u5b58\u5728\u95ee\u9898\n");
                }
                bl = true;
                if (this.m_bRecordDetailInfo) {
                    this.m_sbInfo.append("\t[" + string4 + "]\u6ca1\u6709\u7ffb\u8bd1\n");
                }
                stringBuffer.append(string4 + "=" + hashMap.get(string4) + "\n");
            }
            if (!PropertiesVARProcessor.isNotEng(string3)) continue;
            if (!bl) {
                this.m_sbInfo.append("\u6587\u4ef6[" + string2.substring(this.m_sStartPath.length()) + "]\u5b58\u5728\u95ee\u9898\n");
            }
            bl = true;
            if (!this.m_bRecordDetailInfo) continue;
            this.m_sbInfo.append("\t[" + string4 + "]\u5b58\u5728\u4e2d\u6587[" + string3 + "]\n");
        }
        if (bl) {
            string4 = this.makeDstFileName(string2);
            if (stringBuffer.length() == 0) {
                if (this.m_sAlreadyCompareFile == null || !this.m_sAlreadyCompareFile.equals(string2)) {
                    SymbolC2E.runtimeSymbols = SymbolC2E.pageSymbols;
                    SymbolC2E.replaceFile(string2, string2);
                    SymbolC2E.runtimeSymbols = SymbolC2E.resourceSymbols;
                    this.m_sAlreadyCompareFile = string2;
                    return this.process(string, string2);
                }
                CMyFile.copyFile(string2, string4);
            } else {
                stringBuffer.setLength(stringBuffer.length() - 1);
                string3 = this.appendVar(string2, stringBuffer);
                String string6 = CharsetDetector.detect(string2);
                CMyFile.writeFile(string2, string3, string6);
                CMyFile.writeFile(string4, string3, string6);
            }
        }
        return this.m_sbInfo.toString();
    }

    private String makeDstFileName(String string) throws Exception {
        int n = string.indexOf(this.m_sStartPath);
        if (n < 0) {
            throw new Exception("\u4f20\u5165\u7684\u8d77\u59cb\u8def\u5f84\u6709\u95ee\u9898\uff01");
        }
        String string2 = this.m_sDstPath + string.substring(this.m_sStartPath.length());
        return string2;
    }

    private String appendVar(String string, StringBuffer stringBuffer) throws Exception {
        String string2 = CharsetDetector.detect(string);
        String string3 = CMyFile.readFile(string, string2);
        return string3 + '\n' + stringBuffer;
    }

    private static boolean isNotEng(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap toMap(String string) throws Exception {
        boolean bl = string.indexOf("wcm6-locale") < 0;
        HashMap<String, String> hashMap = new HashMap<String, String>(30);
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        String string3 = CharsetDetector.detect(string);
        try {
            try {
                String string2;
                fileInputStream = new FileInputStream(string);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3));
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n = (string2 = string2.trim()).indexOf(61);
                    if (n < 0) continue;
                    String string4 = string2.substring(0, n).trim();
                    if (!bl) {
                        string4 = string4.toUpperCase();
                    }
                    String string5 = string2.substring(n + 1).trim();
                    hashMap.put(string4, string5);
                }
                Object var13_14 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CMyException(55, "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new CMyException(53, "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (fileInputStream == null) return hashMap;
        fileInputStream.close();
        return hashMap;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\WebApp\\WEB-INF\\classes\\i18nmessage\\";
            String string2 = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\WebApp\\TT\\WEB-INF\\classes\\i18nmessage\\";
            String string3 = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\Release\\";
            String string4 = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\WebApp\\TT\\";
            PropertiesVARProcessor propertiesVARProcessor = new PropertiesVARProcessor(string, string2, string3, string4);
            System.out.println(propertiesVARProcessor.process());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

