/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.XmlFilterInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;

public class CMyXMLDoc {
    private static String XML_ENCODING = "UTF-8";

    public static Document toXMLDocument(String string) throws CMyException {
        return CMyXMLDoc.toXMLDocument(string, null);
    }

    public static Document toXMLDocument(String string, String string2) throws CMyException {
        if (!CMyFile.fileExists(string)) {
            throw new CMyException(55, I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label1", "\u6307\u5b9a\u7684XML\u6587\u4ef6[") + string + I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label2", "]\u4e0d\u5b58\u5728!"));
        }
        if (string2 != null && string2.length() > 0) {
            CMyXMLDoc.transformXML(string, string2, string);
        }
        try {
            DOMBuilder dOMBuilder = new DOMBuilder();
            return dOMBuilder.build(new File(string));
        }
        catch (Exception exception) {
            throw new WCMException(150, I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label4", "\u5efa\u7acbXML Document\u5bf9\u8c61\u5931\u8d25!"), exception);
        }
    }

    public static boolean transformXML(String string, String string2, String string3) throws CMyException {
        return CMyXMLDoc.transformXML(string, string2, string3, XML_ENCODING);
    }

    public static void toFile(Document document, String string) throws CMyException {
        CMyXMLDoc.toXMLFile(document, string, XML_ENCODING);
    }

    public static void toFile(Document document, String string, String string2) throws CMyException {
        CMyXMLDoc.toXMLFile(document, string, string2, XML_ENCODING);
    }

    public static String toString(Document document) {
        return CMyXMLDoc.toString(document, XML_ENCODING);
    }

    public static String toString(Element element) {
        return CMyXMLDoc.toString(element, XML_ENCODING);
    }

    public static void main(String[] stringArray) {
        try {
            String string = "d:\\temp\\4.xml";
            String string2 = "d:\\temp\\bk.xml";
            CMyXMLDoc.transformXML(string, "d:\\temp\\xmltotrs.xsl", string2);
            string = I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label5", "d:\\temp\\\u4e2d\u6587.xml");
            string2 = "d:\\temp\\bk2.xml";
            CMyXMLDoc.transformXML(string, "d:\\temp\\xmltotrs.xsl", string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public static void toXMLFile(Document document, String string, String string2) throws CMyException {
        try {
            XMLOutputter xMLOutputter = new XMLOutputter("    ", true);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            xMLOutputter.setEncoding(string2);
            xMLOutputter.output(document, (Writer)outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new CMyException(1, I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label6", "\u8f93\u51faDOM\u6811\u5230XML\u6587\u4ef6\u65f6\u5931\u8d25(CMyXMLDoc.toFile)"), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void toXMLFile(Document document, String string, String string2, String string3) throws CMyException {
        File file = null;
        if (string2 == null || string2.length() == 0) {
            CMyXMLDoc.toXMLFile(document, string, string3);
            return;
        }
        try {
            file = File.createTempFile("wcm", ".xml");
        }
        catch (Exception exception) {
            throw new CMyException(50, I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label7", "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25(CMyXMLDoc.toXML)"), exception);
        }
        try {
            try {
                String string4 = file.getPath();
                CMyXMLDoc.toXMLFile(document, string4, string3);
                CMyXMLDoc.transformXML(string4, string2, string);
            }
            catch (Exception exception) {
                throw new CMyException(1, I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label8", "\u751f\u6210XML\u6587\u4ef6\u5931\u8d25(CMyXMLDoc.toFile)"), exception);
            }
            Object var7_8 = null;
            file.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            file.delete();
            throw throwable;
        }
    }

    public static String toString(Document document, String string) {
        String string2 = null;
        document.addContent(new Comment("WCM Version 1.0"));
        XMLOutputter xMLOutputter = new XMLOutputter("  ", true);
        xMLOutputter.setEncoding(string);
        string2 = xMLOutputter.outputString(document);
        return string2;
    }

    public static String toString(Element element, String string) {
        String string2 = null;
        Document document = new Document(element);
        XMLOutputter xMLOutputter = new XMLOutputter("  ", true);
        xMLOutputter.setEncoding(string);
        string2 = xMLOutputter.outputString(document);
        return string2;
    }

    public static boolean transformXML(String string, String string2, String string3, String string4) throws CMyException {
        try {
            Properties properties = new Properties();
            properties.setProperty("version", "1.0");
            properties.setProperty("encoding", string4);
            File file = new File(string2);
            StreamSource streamSource = new StreamSource(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            XmlFilterInputStream xmlFilterInputStream = new XmlFilterInputStream(new BufferedInputStream(new FileInputStream(string)));
            StreamSource streamSource2 = new StreamSource(xmlFilterInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            StreamResult streamResult = new StreamResult(new BufferedOutputStream(fileOutputStream));
            transformer.setOutputProperties(properties);
            transformer.transform(streamSource2, streamResult);
            return true;
        }
        catch (Exception exception) {
            throw new CMyException(1, I18NMessage.get(CMyXMLDoc.class, "CMyXMLDoc.label9", "\u6587\u6863\u8f6c\u6362\u5931\u8d25(CMyXMLDoc.transformXML)"), exception);
        }
    }
}

