/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class CMyDateTime
implements Cloneable,
Serializable {
    private Date m_dtDate = null;
    private SimpleDateFormat m_dtFormater = null;
    public static final int FORMAT_DEFAULT = 0;
    public static final int FORMAT_LONG = 1;
    public static final int FORMAT_SHORT = 2;
    public static final String DEF_DATE_FORMAT_PRG = "yyyy-MM-dd";
    public static final String DEF_TIME_FORMAT_PRG = "HH:mm:ss";
    public static final String DEF_DATETIME_FORMAT_PRG = "yyyy-MM-dd HH:mm:ss";
    public static final String DEF_DATETIME_FORMAT_DB = "YYYY-MM-DD HH24:MI:SS";
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    public static final int HOUR = 4;
    public static final int MINUTE = 5;
    public static final int SECOND = 6;
    public static final int QUATER = 11;
    public static final int WEEK = 12;
    public static final int DAY_OF_MONTH = 13;
    public static final int WEEK_OF_MONTH = 14;
    public static final int DAY_OF_YEAR = 15;
    public static final int WEEK_OF_YEAR = 16;
    public static final long ADAY_MILLIS = 86400000L;
    public static final String[] MONTHS = new String[]{"January", "February", " March", " April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] WEEKS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    public CMyDateTime() {
    }

    public CMyDateTime(long l) {
        this.m_dtDate = new Date(l);
    }

    public static CMyDateTime now() {
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.setDateTimeWithCurrentTime();
        return cMyDateTime;
    }

    public boolean isNull() {
        return this.m_dtDate == null;
    }

    public long getTimeInMillis() {
        return this.m_dtDate == null ? 0L : this.m_dtDate.getTime();
    }

    public static int getTimeZoneRawOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        return n;
    }

    public long compareTo(Date date) {
        long l = this.m_dtDate == null ? 0L : this.m_dtDate.getTime();
        long l2 = date == null ? 0L : date.getTime();
        return l - l2;
    }

    public long compareTo(CMyDateTime cMyDateTime) {
        return this.compareTo(cMyDateTime.getDateTime());
    }

    public long dateDiff(int n, CMyDateTime cMyDateTime) throws CMyException {
        if (cMyDateTime == null) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label1", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61\u53c2\u6570(CMyDateTime.dateDiff(CMyDateTime))"));
        }
        return this.dateDiff(n, cMyDateTime.getDateTime());
    }

    public long dateDiff(int n, Date date) throws CMyException {
        if (date == null) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label2", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u53c2\u6570\uff08CMyDateTime.dateDiff(int,java.util.Date)\uff09"));
        }
        if (this.isNull()) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label3", "\u65e5\u671f\u65f6\u95f4\u4e3a\u7a7a\uff08CMyDateTime.dateDiff(int,java.util.Date)\uff09"));
        }
        if (n == 1) {
            return this.dateDiff_year(date);
        }
        if (n == 2) {
            return this.dateDiff_month(date);
        }
        long l = this.m_dtDate == null ? 0L : this.m_dtDate.getTime();
        long l2 = date == null ? 0L : date.getTime();
        long l3 = (l - l2) / 1000L;
        switch (n) {
            case 3: {
                return l3 / 86400L;
            }
            case 4: {
                return l3 / 3600L;
            }
            case 5: {
                return l3 / 60L;
            }
            case 6: {
                return l3;
            }
            case 11: {
                return l3 / 86400L / 91L;
            }
            case 12: {
                return l3 / 86400L / 7L;
            }
        }
        throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label4", "\u53c2\u6570\u65e0\u6548(CMyDateTime.dateDiff(int,java.util.Date))"));
    }

    private long dateDiff_year(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getDefault());
        gregorianCalendar.setTime(this.m_dtDate);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        gregorianCalendar.setTime(date);
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar.get(2);
        if (n == n3) {
            return 0L;
        }
        if (n > n3) {
            return n - n3 + (n2 >= n4 ? 0 : -1);
        }
        return n - n3 + (n2 > n4 ? 1 : 0);
    }

    public long dateDiff_month(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getDefault());
        gregorianCalendar.setTime(this.m_dtDate);
        int n = gregorianCalendar.get(1) * 12 + gregorianCalendar.get(2);
        int n2 = gregorianCalendar.get(5);
        gregorianCalendar.setTime(date);
        int n3 = gregorianCalendar.get(1) * 12 + gregorianCalendar.get(2);
        int n4 = gregorianCalendar.get(5);
        if (n == n3) {
            return 0L;
        }
        if (n > n3) {
            return n - n3 + (n2 < n4 ? -1 : 0);
        }
        return n - n3 + (n2 > n4 ? 1 : 0);
    }

    public int get(int n) throws CMyException {
        if (this.m_dtDate == null) {
            throw new CMyException(20, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label5", "\u65e5\u671f\u65f6\u95f4\u4e3a\u7a7a\uff08CMyDateTime.get\uff09"));
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getDefault());
        gregorianCalendar.setTime(this.m_dtDate);
        switch (n) {
            case 1: {
                return gregorianCalendar.get(1);
            }
            case 2: {
                return gregorianCalendar.get(2) + 1;
            }
            case 3: {
                return gregorianCalendar.get(5);
            }
            case 4: {
                return gregorianCalendar.get(11);
            }
            case 5: {
                return gregorianCalendar.get(12);
            }
            case 6: {
                return gregorianCalendar.get(13);
            }
            case 12: {
                return gregorianCalendar.get(7);
            }
            case 13: {
                return gregorianCalendar.getActualMaximum(5);
            }
            case 14: {
                return this.getWeekCountsOfMonth(true);
            }
            case 15: {
                return gregorianCalendar.getActualMaximum(6);
            }
            case 16: {
                return gregorianCalendar.getActualMaximum(3);
            }
        }
        throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label6", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u57df\u53c2\u6570\uff08CMyDateTime.get\uff09"));
    }

    public int getYear() throws CMyException {
        return this.get(1);
    }

    public int getMonth() throws CMyException {
        return this.get(2);
    }

    public int getDay() throws CMyException {
        return this.get(3);
    }

    public int getHour() throws CMyException {
        return this.get(4);
    }

    public int getMinute() throws CMyException {
        return this.get(5);
    }

    public int getSecond() throws CMyException {
        return this.get(6);
    }

    public int getDayOfWeek() throws CMyException {
        return this.get(12);
    }

    public CMyDateTime dateAdd(int n, int n2) throws CMyException {
        if (this.m_dtDate == null) {
            throw new CMyException(20, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label7", "\u65e5\u671f\u65f6\u95f4\u4e3a\u7a7a\uff08CMyDateTime.dateAdd\uff09"));
        }
        int n3 = 0;
        switch (n) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 12: {
                n3 = 5;
                n2 *= 7;
                break;
            }
            case 3: {
                n3 = 5;
                break;
            }
            case 4: {
                n3 = 10;
                break;
            }
            case 5: {
                n3 = 12;
                break;
            }
            case 6: {
                n3 = 13;
                break;
            }
            default: {
                throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label8", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u57df\u53c2\u6570\uff08CMyDateTime.dateAdd\uff09"));
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getDefault());
        gregorianCalendar.setTime(this.m_dtDate);
        gregorianCalendar.set(n3, gregorianCalendar.get(n3) + n2);
        this.m_dtDate = gregorianCalendar.getTime();
        return this;
    }

    public synchronized Object clone() {
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.m_dtDate = this.m_dtDate == null ? null : (Date)this.m_dtDate.clone();
        cMyDateTime.m_dtFormater = this.m_dtFormater == null ? null : (SimpleDateFormat)this.m_dtFormater.clone();
        return cMyDateTime;
    }

    public Date getDateTime() {
        return this.m_dtDate;
    }

    public String toString() {
        return this.toString(DEF_DATETIME_FORMAT_PRG);
    }

    public String toString(String string) {
        if (this.m_dtDate == null) {
            return null;
        }
        try {
            return this.getDateTimeAsString(string);
        }
        catch (CMyException cMyException) {
            return null;
        }
    }

    public String toString(String string, String string2, String string3) {
        boolean bl;
        if (this.m_dtDate == null) {
            return null;
        }
        boolean bl2 = !CMyString.isEmpty(string2);
        boolean bl3 = bl = !CMyString.isEmpty(string3);
        if (!bl2 && !bl) {
            return this.toString(string);
        }
        try {
            Locale locale = bl2 ? new Locale(string2) : Locale.getDefault();
            TimeZone timeZone = bl ? TimeZone.getTimeZone(string3) : TimeZone.getDefault();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
            simpleDateFormat.setTimeZone(timeZone);
            return simpleDateFormat.format(this.m_dtDate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public java.sql.Date toDate() {
        if (this.m_dtDate == null) {
            return null;
        }
        return new java.sql.Date(this.m_dtDate.getTime());
    }

    public Time toTime() {
        if (this.m_dtDate == null) {
            return null;
        }
        return new Time(this.m_dtDate.getTime());
    }

    public Timestamp toTimestamp() {
        if (this.m_dtDate == null) {
            return null;
        }
        return new Timestamp(this.m_dtDate.getTime());
    }

    public void setDateTime(Date date) {
        this.m_dtDate = date;
    }

    public boolean setDateTimeWithString(String string, String string2) throws CMyException {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            this.m_dtDate = simpleDateFormat.parse(string);
            return true;
        }
        catch (Exception exception) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label9", "\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u503c\u548c\u683c\u5f0f\u65e0\u6548\uff08CMyDateTime.setDateTimeWithString\uff09"), exception);
        }
    }

    public void setDateTimeWithCurrentTime() {
        if (this.m_dtDate == null) {
            this.m_dtDate = new Date(System.currentTimeMillis());
        } else {
            this.m_dtDate.setTime(System.currentTimeMillis());
        }
    }

    public void setDateTimeWithTimestamp(Timestamp timestamp) throws CMyException {
        try {
            if (timestamp == null) {
                this.m_dtDate = null;
            } else {
                if (this.m_dtDate == null) {
                    this.m_dtDate = new Date();
                }
                this.m_dtDate.setTime(timestamp.getTime());
            }
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label10", "\u4f7f\u7528Timestamp\u5bf9\u8c61\u8bbe\u7f6e\u65e5\u671f\u548c\u65f6\u95f4\u51fa\u9519\uff1aCMyDateTime.setDateTimeWithTimestamp()"), exception);
        }
    }

    public void setDateTimeWithRs(ResultSet resultSet, int n) throws CMyException {
        try {
            Timestamp timestamp = resultSet.getTimestamp(n);
            this.setDateTimeWithTimestamp(timestamp);
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label11", "\u4ece\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6\u65f6\u95f4\u5b57\u6bb5\u65f6\u51fa\u9519\uff1aCMyDateTime.setDateTimeWithRs()"), sQLException);
        }
    }

    public void setDateTimeWithRs(ResultSet resultSet, String string) throws CMyException {
        try {
            Timestamp timestamp = resultSet.getTimestamp(string);
            this.setDateTimeWithTimestamp(timestamp);
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label11", "\u4ece\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6\u65f6\u95f4\u5b57\u6bb5\u65f6\u51fa\u9519\uff1aCMyDateTime.setDateTimeWithRs()"), sQLException);
        }
    }

    public boolean setDate(java.sql.Date date) throws CMyException {
        if (date == null) {
            return false;
        }
        return this.setDateWithString(date.toString(), 0);
    }

    public boolean setTime(Time time) throws CMyException {
        if (time == null) {
            return false;
        }
        return this.setTimeWithString(time.toString(), 0);
    }

    public boolean setDateWithString(String string, int n) throws CMyException {
        boolean bl = false;
        int n2 = string.length();
        if (n2 < 6) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label12", "\u65e5\u671f\u5b57\u7b26\u4e32\u65e0\u6548\uff08CMyDateTime.setDateWithString\uff09"));
        }
        try {
            String string2;
            switch (n) {
                case 1: {
                    bl = n2 >= 10;
                    string2 = string.substring(0, 4) + "-" + string.substring(bl ? 5 : 4, bl ? 7 : 6) + "-" + string.substring(bl ? 8 : 6, bl ? 10 : 8);
                    break;
                }
                case 2: {
                    string2 = string.charAt(0) < '5' ? "20" : "19";
                    bl = n2 >= 8;
                    string2 = string2 + string.substring(0, 2) + "-" + string.substring(bl ? 3 : 2, bl ? 5 : 4) + "-" + string.substring(bl ? 6 : 4, bl ? 8 : 6);
                    break;
                }
                default: {
                    string2 = string;
                }
            }
            if (this.m_dtDate == null) {
                return this.setDateTimeWithString(string2, DEF_DATE_FORMAT_PRG);
            }
            String string3 = this.getDateTimeAsString(DEF_TIME_FORMAT_PRG);
            return this.setDateTimeWithString(string2 + " " + string3, DEF_DATETIME_FORMAT_PRG);
        }
        catch (Exception exception) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label13", "\u65e0\u6548\u7684\u65e5\u671f\u5b57\u7b26\u4e32\uff08CMyException.setDateWithString\uff09"), exception);
        }
    }

    public boolean setTimeWithString(String string, int n) throws CMyException {
        boolean bl = false;
        int n2 = string.length();
        if (n2 < 4) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label14", "\u65f6\u95f4\u5b57\u7b26\u4e32\u683c\u5f0f\u65e0\u6548\uff08\uff09"));
        }
        try {
            String string2;
            switch (n) {
                case 1: {
                    bl = n2 >= 8;
                    string2 = string.substring(0, 2) + ":" + string.substring(bl ? 3 : 2, bl ? 5 : 4) + ":" + string.substring(bl ? 6 : 4, bl ? 8 : 6);
                    break;
                }
                case 2: {
                    bl = n2 >= 5;
                    string2 = string.substring(0, 2) + ":" + string.substring(bl ? 3 : 2, bl ? 5 : 4) + ":00";
                    break;
                }
                default: {
                    string2 = string;
                }
            }
            if (this.m_dtDate == null) {
                return this.setDateTimeWithString(string2, DEF_TIME_FORMAT_PRG);
            }
            String string3 = this.getDateTimeAsString(DEF_DATE_FORMAT_PRG);
            return this.setDateTimeWithString(string3 + " " + string2, DEF_DATETIME_FORMAT_PRG);
        }
        catch (Exception exception) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label15", "\u65e0\u6548\u7684\u65f6\u95f4\u5b57\u7b26\u4e32\uff08CMyException.setTimeWithString\uff09"), exception);
        }
    }

    public void setDateTimeFormat(String string) {
        if (this.m_dtFormater == null) {
            this.m_dtFormater = new SimpleDateFormat(string);
        } else {
            this.m_dtFormater.applyPattern(string);
        }
    }

    public String getDateTimeAsString(String string) throws CMyException {
        if (this.m_dtDate == null) {
            return null;
        }
        try {
            this.setDateTimeFormat(string);
            return this.m_dtFormater.format(this.m_dtDate);
        }
        catch (Exception exception) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label16", "\u6307\u5b9a\u7684\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u6709\u9519\uff08CMyDateTime.getDateTimeAsString\uff09"), exception);
        }
    }

    public String getDateTimeAsString() throws CMyException {
        if (this.m_dtDate == null || this.m_dtFormater == null) {
            return null;
        }
        try {
            return this.m_dtFormater.format(this.m_dtDate);
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label17", "\u683c\u5f0f\u5316\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u51fa\u9519\uff08CMyDateTime.getDateTimeAsString()\uff09"), exception);
        }
    }

    public static String extractDateTimeFormat(String string) {
        char[] cArray = new char[]{'y', 'M', 'd', 'H', 'm', 's'};
        return CMyDateTime.extractFormat(string, cArray);
    }

    public static String extractDateFormat(String string) {
        char[] cArray = new char[]{'y', 'M', 'd'};
        return CMyDateTime.extractFormat(string, cArray);
    }

    public static String extractTimeFormat(String string) {
        char[] cArray = new char[]{'H', 'm', 's'};
        return CMyDateTime.extractFormat(string, cArray);
    }

    private static String extractFormat(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        char[] cArray2 = string.trim().toCharArray();
        if (cArray2.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(19);
        int n = 0;
        int n2 = 0;
        while (n < cArray2.length) {
            char c;
            if (Character.isDigit(c = cArray2[n++])) {
                stringBuffer.append(cArray[n2]);
                continue;
            }
            stringBuffer.append(c);
            if (++n2 < cArray.length) continue;
            break;
        }
        return stringBuffer.toString();
    }

    public boolean setDateTimeWithString(String string) throws CMyException {
        String string2 = CMyDateTime.extractDateTimeFormat(string);
        if (string == null) {
            return false;
        }
        return this.setDateTimeWithString(string, string2);
    }

    public static final String formatTimeUsed(long l) {
        if (l <= 0L) {
            return "";
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(16);
        n = (int)(l / 1000L);
        l %= 1000L;
        if (n > 0) {
            n2 = n / 60;
            n %= 60;
        }
        if (n2 > 0) {
            if (n2 > 1) {
                stringBuffer.append(n2).append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label18", "\u5206"));
            } else {
                stringBuffer.append(n2).append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label20", "\u5206"));
            }
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
        } else {
            stringBuffer.append(n).append('.');
            if (l < 10L) {
                stringBuffer.append('0').append('0');
            } else if (l < 100L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l);
        }
        if (l > 1L) {
            stringBuffer.append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label19", "\u79d2"));
        } else {
            stringBuffer.append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label21", "\u79d2"));
        }
        return stringBuffer.toString();
    }

    public static String getStr(Object object, String string) {
        if (object instanceof CMyDateTime) {
            return ((CMyDateTime)object).toString(string);
        }
        return CMyString.showObjNull(object);
    }

    public static void main(String[] stringArray) {
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            int n;
            CMyDateTime cMyDateTime2 = CMyDateTime.now();
            System.out.println("now:" + cMyDateTime2.toString(DEF_DATETIME_FORMAT_PRG));
            CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime2.clone();
            CMyDateTime cMyDateTime4 = cMyDateTime3.dateAdd(3, -30);
            System.out.println("now-30:" + cMyDateTime4.toString(DEF_DATETIME_FORMAT_PRG));
            System.out.println("now:" + cMyDateTime2.toString(DEF_DATETIME_FORMAT_PRG));
            System.out.println("nowClone:" + cMyDateTime3.toString(DEF_DATETIME_FORMAT_PRG));
            cMyDateTime2 = CMyDateTime.now();
            cMyDateTime4 = cMyDateTime2.dateAdd(3, -3);
            System.out.println("now-3:" + cMyDateTime4.toString(DEF_DATETIME_FORMAT_PRG));
            cMyDateTime2 = CMyDateTime.now();
            cMyDateTime4 = cMyDateTime2.dateAdd(4, -3);
            System.out.println("now-3:" + cMyDateTime4.toString(DEF_DATETIME_FORMAT_PRG));
            cMyDateTime4.setDateTimeWithString("2002.1.1 00:00:00", "yyyy.MM.dd HH:mm:ss");
            System.out.println("time:" + cMyDateTime4.toString(DEF_DATETIME_FORMAT_PRG));
            cMyDateTime4.setDateTimeWithString(cMyDateTime4.toString(DEF_DATE_FORMAT_PRG) + " 23:00:00", DEF_DATETIME_FORMAT_PRG);
            CMyDateTime cMyDateTime5 = CMyDateTime.now();
            cMyDateTime5.setDateTimeWithString(cMyDateTime5.toString(DEF_DATE_FORMAT_PRG) + " 24:00:00", DEF_DATETIME_FORMAT_PRG);
            System.out.println("now:" + cMyDateTime2.toString());
            System.out.println("execStartTime:" + cMyDateTime4.toString());
            System.out.println("now.compareTo(execStartTime):" + cMyDateTime2.compareTo(cMyDateTime4));
            System.out.println("TimeZone = " + CMyDateTime.getTimeZoneRawOffset());
            cMyDateTime.setDateTimeWithCurrentTime();
            System.out.println("Start:" + cMyDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            long l = cMyDateTime.getTimeInMillis() % 3600000L;
            System.out.print("\nTime=" + l);
            Time time = new Time(l);
            System.out.print("  " + time.toString());
            System.out.print("\n");
            cMyDateTime.setDateWithString("2001-04-15", 0);
            System.out.println(cMyDateTime.getDateTimeAsString("yyyy.MM.dd"));
            cMyDateTime.setDateWithString("000505", 2);
            System.out.println(cMyDateTime.getDateTimeAsString("yyyy.MM.dd"));
            cMyDateTime.setTimeWithString("12:01:02", 0);
            System.out.println(cMyDateTime.getDateTimeAsString(DEF_TIME_FORMAT_PRG));
            cMyDateTime.setTimeWithString("00:25", 2);
            System.out.println(cMyDateTime.getDateTimeAsString(DEF_DATETIME_FORMAT_PRG));
            java.sql.Date date = new java.sql.Date(0L);
            Time time2 = new Time(0L);
            date = java.sql.Date.valueOf("1978-02-04");
            time2 = Time.valueOf("12:00:20");
            System.out.println(cMyDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            cMyDateTime.setDate(date);
            System.out.println(cMyDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            cMyDateTime.setTime(time2);
            System.out.println(cMyDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            cMyDateTime.setDateTimeWithCurrentTime();
            System.out.println("End:" + cMyDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            CMyDateTime cMyDateTime6 = new CMyDateTime();
            int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 11, 12};
            cMyDateTime6.setDateTimeWithString("2001-02-07 14:34:00", DEF_DATETIME_FORMAT_PRG);
            cMyDateTime.setDateTimeWithString("2001-03-07 15:35:01", DEF_DATETIME_FORMAT_PRG);
            for (n = 0; n < 8; ++n) {
                long l2 = cMyDateTime.dateDiff(nArray[n], cMyDateTime6.getDateTime());
                System.out.println("DateDiff(" + nArray[n] + ")=" + l2);
            }
            for (n = 0; n < 6; ++n) {
                System.out.println("get(" + nArray[n] + ")=" + cMyDateTime.get(nArray[n]));
            }
            System.out.println("getWeek=" + cMyDateTime.get(12));
            System.out.println("Test for dateAdd()");
            System.out.println("oldDateTime = " + cMyDateTime.toString());
            cMyDateTime.dateAdd(1, 12);
            System.out.println("dateAdd(YEAR,12) = " + cMyDateTime.toString());
            cMyDateTime.dateAdd(1, -12);
            System.out.println("dateAdd(YEAR,-12) = " + cMyDateTime.toString());
            cMyDateTime.dateAdd(2, -3);
            System.out.println("dateAdd(MONTH,-3) = " + cMyDateTime.toString());
            cMyDateTime.dateAdd(3, 10);
            System.out.println("dateAdd(DAY,10) = " + cMyDateTime.toString());
            cMyDateTime.setDateTimeWithCurrentTime();
            n = cMyDateTime.getDayOfWeek();
            cMyDateTime.dateAdd(3, -n);
            System.out.println("Monday of this week is:" + cMyDateTime.toString(DEF_DATE_FORMAT_PRG));
            for (int i = 1; i < 7; ++i) {
                cMyDateTime.dateAdd(3, 1);
                System.out.println(i + 1 + " of this week is:" + cMyDateTime.toString(DEF_DATE_FORMAT_PRG));
            }
            System.out.println("\n\n===== test for CMyDateTime.set() ====== ");
            String[] stringArray2 = new String[]{"2002.06.13 12:00:12", "1900.2.4 3:4:5", "1901-03-15 23:05:10", "1978-2-4 5:6:7", "2001/12/31 21:08:22", "1988/2/5 9:1:2", "1986.12.24", "0019.2.8", "2002-12-20", "1999-8-1", "2001/12/21", "2000/1/5", "78.02.04", "89.2.6", "99-12-31", "22-3-6", "01/02/04", "02/5/8"};
            for (int i = 0; i < stringArray2.length; ++i) {
                cMyDateTime.setDateTimeWithString(stringArray2[i]);
                System.out.println("[" + i + "]" + CMyDateTime.extractDateTimeFormat(stringArray2[i]) + "  " + cMyDateTime.toString());
            }
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace(System.out);
        }
    }

    public boolean isLeapYear() throws CMyException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.m_dtDate);
        return gregorianCalendar.isLeapYear(this.getYear());
    }

    public boolean isToday() {
        CMyDateTime cMyDateTime = CMyDateTime.now();
        return this.toString(DEF_DATE_FORMAT_PRG).equals(cMyDateTime.toString(DEF_DATE_FORMAT_PRG));
    }

    public int getWeekCountsOfMonth(boolean bl) throws CMyException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.m_dtDate);
        int n = gregorianCalendar.getActualMaximum(4);
        if (bl) {
            return n;
        }
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.setDateTime(this.m_dtDate);
        cMyDateTime.setDateTimeWithString(cMyDateTime.getYear() + "-" + cMyDateTime.getMonth() + "-1");
        if (cMyDateTime.getDayOfWeek() == 6) {
            ++n;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CMyDateTime && ((CMyDateTime)object).getTimeInMillis() == this.getTimeInMillis();
    }

    public boolean testDateFormat(String string) {
        try {
            boolean bl = this.setDateTimeWithString(string);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

