/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;

public final class LogType {
    private final int _id;
    private final String _desc;
    public static final int ID_FATAL = 0;
    public static final int ID_ERROR = 1;
    public static final int ID_WARN = 2;
    public static final int ID_INFO = 3;
    public static final int ID_DEBUG = 4;
    public static final LogType FATAL = new LogType(0, I18NMessage.get(LogType.class, "LogType.label1", "\u81f4\u547d\u7684"));
    public static final LogType ERROR = new LogType(1, I18NMessage.get(LogType.class, "LogType.label2", "\u9519\u8bef"));
    public static final LogType WARN = new LogType(2, I18NMessage.get(LogType.class, "LogType.label3", "\u8b66\u544a"));
    public static final LogType INFO = new LogType(3, I18NMessage.get(LogType.class, "LogType.label4", "\u4fe1\u606f"));
    public static final LogType DEBUG = new LogType(4, I18NMessage.get(LogType.class, "LogType.label5", "\u8c03\u8bd5"));

    private LogType(int n, String string) {
        this._id = n;
        this._desc = string;
    }

    public String getDesc() {
        return this._desc;
    }

    public int getId() {
        return this._id;
    }

    public static LogType findById(int n) throws WCMException {
        switch (n) {
            case 1: {
                return ERROR;
            }
            case 2: {
                return WARN;
            }
            case 3: {
                return INFO;
            }
            case 4: {
                return DEBUG;
            }
        }
        throw new WCMException(10, I18NMessage.get(LogType.class, "LogType.label6", "\u6ca1\u6709id\u4e3a[") + n + I18NMessage.get(LogType.class, "LogType.label7", "]\u7684\u65e5\u5fd7\u7c7b\u578b!"));
    }
}

