/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.log.ILog;
import com.trs.infra.support.log.ILogMgr;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogType;
import com.trs.infra.support.log.LogXmlConverter;
import com.trs.infra.support.log.Logs;
import com.trs.infra.support.log.OperType;
import com.trs.infra.support.log.OperTypes;
import com.trs.infra.util.CMyBeanConfig;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LogServer {
    private static Class[] m_arLoggerClazz = null;
    private static final String LOGGER_CONFIG_FILE = "LoggerConfig.xml";
    private static Logger s_logger = Logger.getLogger(LogServer.class);
    public static int CONTEXT_INDEX_IP = BaseContextHelper.getNextIndex();
    public static int CONTEXT_INDEX_TOPID = BaseContextHelper.getNextIndex();
    private static Map m_operTypeMap = null;
    private static final int LOGDESC_MAX_BYTE_LENGTH = 3000;
    private static final int LOGDESC_MAX_LENGTH = 1500;
    private static LogType[] ALL_LOG_TYPE = new LogType[]{LogType.ERROR, LogType.WARN, LogType.INFO, LogType.DEBUG};
    private static final String LOGOBJS_CONFIG = "LogObjectConfig.properties";
    private static Properties m_logObjConf = null;

    private static long save(String string, String string2, String string3, int n, BaseObj baseObj, int n2, String string4, long l) throws WCMException {
        ILog[] iLogArray = LogServer.getLoggers();
        long l2 = 0L;
        ILog iLog = null;
        for (int i = 0; i < iLogArray.length; ++i) {
            iLog = iLogArray[i];
            if (iLog == null) continue;
            iLog.setOpType(LogServer.getOperTypeAsInt(string2));
            iLog.setDesc(string3);
            iLog.setLogType(n);
            iLog.setUser(string);
            iLog.setObj(baseObj);
            iLog.setLogUserIP(string4);
            iLog.setTopLogId(n2);
            iLog.setResult(0);
            iLog.setStartTimeMillis(l);
            iLog.setEndTimeMillis(l);
            iLog.saveLog();
            if (n2 == 0) {
                BaseContextHelper.setArg(CONTEXT_INDEX_TOPID, ((Log)iLog).getKey());
            }
            l2 = iLog.getStartId();
        }
        return l2;
    }

    private static int getOperTypeAsInt(String string) throws WCMException {
        String string2 = string.toUpperCase();
        OperType operType = (OperType)LogServer.initOperTypeMap().get(string2);
        return operType != null ? operType.getId() : 0;
    }

    private static String getLogIP() {
        try {
            return CMyString.showNull((String)BaseContextHelper.getArg(CONTEXT_INDEX_IP), "127.0.0.1");
        }
        catch (Exception exception) {
            s_logger.error((Object)"not accurate logip", (Throwable)exception);
            return "";
        }
    }

    private static int getTopLogId() {
        Integer n = (Integer)BaseContextHelper.getArg(CONTEXT_INDEX_TOPID);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private static ILog[] getLoggers() throws WCMException {
        if (m_arLoggerClazz == null) {
            LogServer.initLoggerClazz();
        }
        ILog[] iLogArray = new ILog[m_arLoggerClazz.length];
        for (int i = 0; i < iLogArray.length; ++i) {
            try {
                Class clazz = m_arLoggerClazz[i];
                if (clazz == null) continue;
                iLogArray[i] = (ILog)clazz.newInstance();
                continue;
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label1", "\u521b\u5efa\u5bf9\u8c61\u5b9e\u4f8b\u5931\u8d25!"), exception);
            }
        }
        return iLogArray;
    }

    private static void initLoggerClazz() throws WCMException {
        CMyBeanConfig[] cMyBeanConfigArray = CMyBeanConfig.fromXMLFile(LOGGER_CONFIG_FILE);
        m_arLoggerClazz = new Class[cMyBeanConfigArray.length];
        CMyBeanConfig cMyBeanConfig = null;
        for (int i = 0; i < cMyBeanConfigArray.length; ++i) {
            cMyBeanConfig = cMyBeanConfigArray[i];
            try {
                LogServer.m_arLoggerClazz[i] = Class.forName(cMyBeanConfig.getProperty("LoggerName"));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                s_logger.error((Object)"load class failed!", (Throwable)classNotFoundException);
                throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label2", "\u6ca1\u6709\u627e\u5230\u76f8\u5339\u914d\u7684Logger[") + cMyBeanConfig.getName() + "]!", classNotFoundException);
            }
        }
    }

    public static boolean delete(ILog iLog) throws WCMException {
        return iLog.deleteLog();
    }

    public static boolean delete(int n) throws WCMException {
        LogServer.getLogMgr().delete(n);
        return true;
    }

    public static boolean delete(BaseObjs baseObjs) throws WCMException {
        if (baseObjs == null) {
            throw new WCMException(10, "args is null");
        }
        if (baseObjs instanceof Logs) {
            baseObjs.removeAll();
            return true;
        }
        return false;
    }

    public static boolean delete(String string) throws WCMException {
        String[] stringArray = null;
        try {
            stringArray = CMyString.split(string, ",");
        }
        catch (Exception exception) {
            s_logger.error((Object)"spilt the logid sequence failed", (Throwable)exception);
            throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label3", "\u89e3\u91ca\u65e5\u5fd7\u7684ID\u5e8f\u5217\u51fa\u9519!"), exception);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            LogServer.delete(stringArray[i]);
        }
        return true;
    }

    public static boolean delete(CMyDateTime cMyDateTime) throws WCMException {
        String string = LogServer.formatDateTimeForSql(cMyDateTime);
        WCMFilter wCMFilter = new WCMFilter("", "CrTime<" + string, "");
        LogServer.getLogMgr().delete(wCMFilter);
        return true;
    }

    public static boolean delete(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        String string = LogServer.formatDateTimeForSql(cMyDateTime);
        String string2 = LogServer.formatDateTimeForSql(cMyDateTime2);
        WCMFilter wCMFilter = new WCMFilter("", "CrTime>" + string + " AND CrTime<" + string2, "");
        LogServer.getLogMgr().delete(wCMFilter);
        return true;
    }

    private static String formatDateTimeForSql(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(LogServer.class, "LogServer.label4", "\u6307\u5b9a\u7684\u65e5\u671f\u65e0\u6548!"));
        }
        DBManager dBManager = DBManager.getDBManager();
        return dBManager.getDBType().sqlDateTime(cMyDateTime.toString(), "YYYY-MM-DD HH24:MI:SS");
    }

    public static boolean clearLogs() throws WCMException {
        return LogServer.getLogMgr().clearLogs();
    }

    public static BaseObjs getLogs(WCMFilter wCMFilter) throws WCMException {
        return LogServer.getLogMgr().getLogs(wCMFilter);
    }

    public static BaseObjs getLogs(int n, WCMFilter wCMFilter) throws WCMException {
        return LogServer.getLogMgr().getLogs(wCMFilter, n);
    }

    public static BaseObjs getLogsByTopId(int n, WCMFilter wCMFilter) throws WCMException {
        return LogServer.getLogMgr().getLogsByTopId(wCMFilter, n);
    }

    public static void archiveLogs(CMyDateTime cMyDateTime) throws WCMException {
        String string = LogServer.formatDateTimeForSql(cMyDateTime);
        WCMFilter wCMFilter = new WCMFilter("", "LogOpTime<" + string, "");
        BaseObjs baseObjs = LogServer.getLogs(wCMFilter);
        if (baseObjs.isEmpty()) {
            return;
        }
        LogServer.bakupLogs(baseObjs);
        LogServer.delete(baseObjs);
    }

    private static void bakupLogs(BaseObjs baseObjs) throws WCMException {
        LogServer.getLogMgr().bakupLogs(baseObjs);
    }

    public static String exportToXMLString(int n) throws WCMException {
        ILog iLog = LogServer.getLogMgr().find(n);
        return LogServer.exportToXMLString(iLog);
    }

    public static String exportToXMLString(ILog iLog) throws WCMException {
        LogXmlConverter logXmlConverter = new LogXmlConverter();
        return logXmlConverter.toXMLString(iLog);
    }

    public static String export(String string) throws WCMException {
        BaseObjs baseObjs = LogServer.getLogMgr().find(string);
        return LogServer.export(baseObjs);
    }

    public static String export(BaseObjs baseObjs) throws WCMException {
        if (baseObjs == null || baseObjs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(LogServer.class, "LogServer.label5", "\u65e0\u6548\u7684\u65e5\u5fd7\u96c6\u5408!"));
        }
        LogXmlConverter logXmlConverter = new LogXmlConverter();
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", "xml", null, true);
        logXmlConverter.toXMLFile(baseObjs, string);
        return CMyFile.extractFileName(string);
    }

    public static BaseObjs getLogBaks(WCMFilter wCMFilter) throws WCMException {
        return LogServer.getLogMgr().getLogBaks(wCMFilter);
    }

    public static BaseObjs getLogBaks(int n, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "LogType=" + n, "");
        wCMFilter2.mergeWith(wCMFilter);
        return LogServer.getLogBaks(wCMFilter2);
    }

    public static boolean deleteLogBaks(CMyDateTime cMyDateTime) throws WCMException {
        String string = LogServer.formatDateTimeForSql(cMyDateTime);
        WCMFilter wCMFilter = new WCMFilter("", "CrTime<" + string, "");
        BaseObjs baseObjs = LogServer.getLogBaks(wCMFilter);
        baseObjs.removeAll();
        return true;
    }

    public static boolean deleteLogBaks(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        String string = LogServer.formatDateTimeForSql(cMyDateTime);
        String string2 = LogServer.formatDateTimeForSql(cMyDateTime2);
        WCMFilter wCMFilter = new WCMFilter("", "CrTime<" + string2 + " AND CrTime>" + string, "");
        BaseObjs baseObjs = LogServer.getLogBaks(wCMFilter);
        baseObjs.removeAll();
        return true;
    }

    public static boolean clearLogBaks() throws WCMException {
        return LogServer.getLogMgr().clearLogBaks();
    }

    public static String getLogTypeName(String string) throws WCMException {
        throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label6", "\u5c1a\u672a\u5b9e\u73b0\u5177\u4f53\u7684\u65b9\u6cd5\u83b7\u53d6\u64cd\u4f5c\u7c7b\u578b:") + string);
    }

    private static Map initOperTypeMap() throws WCMException {
        if (m_operTypeMap == null) {
            OperTypes operTypes = OperTypes.openWCMObjs(null);
            m_operTypeMap = new HashMap(operTypes.size());
            OperType operType = null;
            for (int i = 0; i < operTypes.size(); ++i) {
                operType = (OperType)operTypes.getAt(i);
                m_operTypeMap.put(operType.getName().toUpperCase(), operType);
            }
        }
        return m_operTypeMap;
    }

    private static ILogMgr getLogMgr() {
        return (ILogMgr)DreamFactory.createObjectById("ILogMgr");
    }

    public static LogType[] getLogTypes() {
        return ALL_LOG_TYPE;
    }

    public static long startRecord(String string, String string2, String string3, BaseObj baseObj, int n) {
        int n2 = LogServer.getTopLogId();
        long l = System.currentTimeMillis();
        long l2 = 0L;
        try {
            l2 = LogServer.save(string, string2, string3, n, baseObj, n2, LogServer.getLogIP(), l);
        }
        catch (Exception exception) {
            s_logger.error((Object)"failed to record a log", (Throwable)exception);
        }
        return l2;
    }

    public static long startRecord(String string, String string2, String string3, BaseObj baseObj) {
        return LogServer.startRecord(string, string2, string3, baseObj, 3);
    }

    public static void endRecordSucceedOperation(long l) {
        try {
            LogServer.updateLog(l, 1, 3, null);
        }
        catch (Exception exception) {
            s_logger.error((Object)"failed to update a log", (Throwable)exception);
        }
    }

    public static void endRecordSucceedOperation(long l, int n) {
        try {
            if (l < 0L) {
                return;
            }
            ILog[] iLogArray = LogServer.getLoggers();
            long l2 = System.currentTimeMillis();
            ILog iLog = null;
            for (int i = 0; i < iLogArray.length; ++i) {
                iLog = iLogArray[i];
                iLog.loadByStartId(l);
                iLog.setEndTimeMillis(l2);
                iLog.setExecTime(l2 - iLog.getStartTimeMillis());
                iLog.setResult(1);
                iLog.setLogType(3);
                iLog.setObjId(n);
                if (iLog.getTopLogId() == 0) {
                    BaseContextHelper.setArg(CONTEXT_INDEX_TOPID, null);
                }
                iLog.saveLog();
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)"failed to update a log", (Throwable)exception);
        }
    }

    public static void endRecordFailedOperation(long l, Throwable throwable) {
        try {
            LogServer.updateLog(l, 0, 1, throwable);
        }
        catch (Exception exception) {
            s_logger.error((Object)"failed to update a log", (Throwable)exception);
        }
    }

    private static void updateLog(long l, int n, int n2, Throwable throwable) throws WCMException {
        ILog[] iLogArray = LogServer.getLoggers();
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < iLogArray.length; ++i) {
            if (l <= 0L) continue;
            iLogArray[i].loadByStartId(l);
            iLogArray[i].setEndTimeMillis(l2);
            long l3 = iLogArray[i].getStartTimeMillis();
            iLogArray[i].setExecTime(l2 - l3);
            iLogArray[i].setResult(n);
            iLogArray[i].setLogType(n2);
            if (iLogArray[i].getTopLogId() == 0) {
                BaseContextHelper.setArg(CONTEXT_INDEX_TOPID, null);
            }
            if (throwable != null) {
                String string = iLogArray[i].getDesc();
                if ((string = string + "\n" + CMyException.getStackTraceText(throwable)).getBytes().length > 3000) {
                    string = string.substring(0, 1500);
                }
                iLogArray[i].setDesc(string);
            }
            iLogArray[i].saveLog();
        }
    }

    public static final boolean isRecordNeeded(BaseObj baseObj) {
        if (baseObj == null) {
            return false;
        }
        if (m_logObjConf == null || m_logObjConf.isEmpty()) {
            m_logObjConf = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(CMyFile.mapResouceFullPath(LOGOBJS_CONFIG));
                m_logObjConf.load(fileInputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                s_logger.error((Object)"fatal:get the objects that need to record log config failed!", (Throwable)exception);
                return true;
            }
        }
        return m_logObjConf.containsValue(baseObj.getClassName(true));
    }

    public static boolean existsLogType(String string) {
        try {
            return LogServer.initOperTypeMap().containsKey(string.toUpperCase());
        }
        catch (WCMException wCMException) {
            return false;
        }
    }

    public static void cachedLogtype(OperType operType) {
        if (operType == null) {
            return;
        }
        try {
            LogServer.initOperTypeMap().put(operType.getName().toUpperCase(), operType);
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
    }
}

