/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.file;

import com.trs.DreamFactory;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class FileHelper {
    private static Logger logger = Logger.getLogger(FileHelper.class);
    private static final Set IMAGE_SUFFIX_SET = new HashSet(8);
    private static final long MIN_FILE_SIZE = 10L;
    public static final long KB_MAX = 0x100000L;

    public static String makeAbsoluteFilePathOfImage(String string, int n) throws WCMException {
        String string2 = CMyFile.extractFileName(string);
        FilesMan filesMan = FilesMan.getFilesMan();
        String string3 = filesMan.mapFilePath(string2, 0);
        String string4 = "";
        int n2 = string2.lastIndexOf(46);
        if (n2 > 0) {
            string4 = string2.substring(n2 + 1);
        }
        if (n > 0 && FileHelper.isImageFile(string4)) {
            String string5 = string3 + string2.substring(0, n2) + "_" + n + "." + string4;
            if (FileHelper.isValidFile(string5)) {
                return string5;
            }
            if (CMyFile.fileExists(string3 + string2)) {
                int n3 = 16;
                String string6 = string3 + string2;
                for (int i = n3; i >= 0; --i) {
                    block11: {
                        try {
                            string5 = FileHelper.scaleImage(string6, string5, n);
                            if (CMyFile.fileExists(string5)) {
                                return string5;
                            }
                        }
                        catch (Exception exception) {
                            if (i != 0) break block11;
                            throw new WCMException("Fail to scale image!", exception);
                        }
                    }
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Wait some millis to retry scale: " + string5));
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                logger.warn((Object)("Failed to generate the scale image: " + string5 + ", the original file returned: " + string6));
                return string6;
            }
            logger.error((Object)("No such file: " + string3 + string2));
        }
        return string3 + string2;
    }

    private static boolean isValidFile(String string) {
        File file = new File(string);
        return file.exists() && file.isFile() && file.length() > 10L;
    }

    private static boolean isImageFile(String string) {
        return string != null && IMAGE_SUFFIX_SET.contains(string.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String scaleImage(String string, String string2, int n) throws Exception {
        if (FileHelper.isValidFile(string2)) {
            return string2;
        }
        Class<FileHelper> clazz = FileHelper.class;
        synchronized (FileHelper.class) {
            if (PluginConfig.isStartPhoto()) {
                IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
                if (iImageLibConfig.isCmdUsed()) {
                    String string3 = ImageMagickCmd.scale(string, string2, n, true);
                    if (!CMyFile.fileExists(string3)) {
                        System.err.println("\u8f6c\u6362\u540e\u7684\u56fe\u7247[" + string3 + "]\u7adf\u7136\u4e0d\u5b58\u5728\uff01\uff01\uff01\uff01\uff01\uff01");
                        // ** MonitorExit[clazz] (shouldn't be in output)
                        return string;
                    }
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return string3;
                }
                String string4 = CMyFile.extractFileName(string);
                MagicImageImpl magicImageImpl = new MagicImageImpl();
                magicImageImpl.initMagicImage(string4);
                ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
                imageObj.setFilename(string);
                if (imageObj.width <= n) {
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return string;
                }
                int n2 = imageObj.height * n / imageObj.width;
                if (n2 == 0) {
                    n2 = 1;
                }
                magicImageImpl.scaleImage(n, n2);
                magicImageImpl.writeImage(string2);
                // ** MonitorExit[clazz] (shouldn't be in output)
                return string2;
            }
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            int n3 = bufferedImage.getHeight();
            int n4 = bufferedImage.getWidth();
            if (n4 <= n) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return string;
            }
            int n5 = n;
            int n6 = n3 * n5 / n4;
            if (n6 == 0) {
                n6 = 1;
            }
            BufferedImage bufferedImage2 = new BufferedImage(n5, n6, 1);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, n5, n6, null);
            FileOutputStream fileOutputStream = null;
            int n7 = 5;
            while (--n7 >= 0 && !FileHelper.isValidFile(string2)) {
                Object var16_21;
                try {
                    try {
                        fileOutputStream = new FileOutputStream(string2);
                        ImageIO.write((RenderedImage)bufferedImage2, CMyFile.extractFileExt(string2), fileOutputStream);
                    }
                    catch (Throwable throwable) {
                        if (n7 == 0) {
                            throw new WCMException("Compress image failed ", throwable);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        var16_21 = null;
                        if (fileOutputStream == null) continue;
                        fileOutputStream.close();
                        continue;
                    }
                    var16_21 = null;
                    if (fileOutputStream == null) continue;
                }
                catch (Throwable throwable) {
                    var16_21 = null;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    throw throwable;
                }
                fileOutputStream.close();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return string2;
        }
    }

    public static String makeNewZoomInFileName(String string, int n) throws WCMException {
        String string2 = FileHelper.makeAbsoluteFilePathOfImage(string, n);
        return CMyFile.extractFileName(string2);
    }

    public static boolean isForbidFileExt(String string) {
        String string2 = CMyFile.extractFileExt(string).toUpperCase();
        if (CMyString.isEmpty(string2)) {
            return false;
        }
        String string3 = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_SUFFIX_CONFIG");
        if (CMyString.isEmpty(string3)) {
            return true;
        }
        if ("FILE_UPLOAD_ALLOW_SUFFIX".equals(string3)) {
            String string4 = ConfigServer.getServer().getInitProperty(string3);
            if (CMyString.isEmpty(string4)) {
                return true;
            }
            string4 = string4.toUpperCase().trim();
            return ("," + string4 + ",").indexOf("," + string2 + ",") < 0;
        }
        if ("FILE_UPLOAD_FORBIDEN_SUFFIX".equals(string3)) {
            String string5 = ConfigServer.getServer().getInitProperty(string3);
            if (CMyString.isEmpty(string5)) {
                return false;
            }
            string5 = string5.toUpperCase().trim();
            return ("," + string5 + ",").indexOf("," + string2 + ",") > 0;
        }
        return true;
    }

    public static String convertFileSize(long l) {
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        if (l < 0x100000L) {
            float f = (float)l / 1024.0f;
            return decimalFormat.format(new Float(f).doubleValue()) + "KB";
        }
        float f = (float)l / 1048576.0f;
        return decimalFormat.format(new Float(f).doubleValue()) + "MB";
    }

    static {
        IMAGE_SUFFIX_SET.add("png");
        IMAGE_SUFFIX_SET.add("jpg");
        IMAGE_SUFFIX_SET.add("jpeg");
        IMAGE_SUFFIX_SET.add("gif");
        IMAGE_SUFFIX_SET.add("bmp");
    }
}

