/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseObjToXmlConverterForSpecialProperty
extends BaseObjToXmlConverter {
    private static final String PATTERN_CDATA = "(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*";
    private String m_sPrefix = this.getClass().getName() + ".";
    private NamesRegister m_oSpecialPropertiesRegister = new NamesRegister();
    private HashMap m_hmNewTagNames = new HashMap(1);

    protected abstract void registerHostSpecialProperties();

    protected abstract String[][] getSpecialProperty(BaseObj var1, int var2, String var3, Object var4) throws ConvertException;

    protected Element toXmlElement(BaseObj baseObj, String string) throws WCMException {
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        Object object = null;
        Hashtable hashtable = baseObj.getAllProperty();
        Element element = DocumentHelper.createElement((String)this.getElementTag(baseObj));
        if (this.isAddVersion()) {
            element.addAttribute("Version", "6.0");
        }
        Element element2 = element.addElement("PROPERTIES");
        Element element3 = null;
        String string3 = string;
        if (string3 == null || string3.trim().length() == 0) {
            string3 = this.getFieldList(baseObj);
        }
        stringTokenizer = string3 != null && string3.trim().length() > 0 ? new StringTokenizer(string3.toUpperCase(), ",") : hashtable.keys();
        while (stringTokenizer.hasMoreElements()) {
            try {
                Object object2;
                boolean bl;
                string2 = ((String)stringTokenizer.nextElement()).trim();
                object = baseObj.getProperty(string2);
                if (object == null || !(bl = this.convertSpecialProperty(baseObj, string2, object, element3 = element2.addElement(string2))) || object == null || object instanceof NullValue) continue;
                if (object instanceof String) {
                    object2 = (String)object;
                    if (((String)object2).matches(PATTERN_CDATA)) {
                        element3.setText((String)object2);
                        continue;
                    }
                    element3.addCDATA((String)object2);
                    continue;
                }
                if (object instanceof CDBText) {
                    object2 = ((CDBText)object).getText();
                    if (CMyString.isEmpty((String)object2)) continue;
                    if (((String)object2).matches(PATTERN_CDATA)) {
                        element3.setText((String)object2);
                        continue;
                    }
                    element3.addCDATA((String)object2);
                    continue;
                }
                if (object instanceof CMyDateTime) {
                    object2 = (CMyDateTime)object;
                    if (((CMyDateTime)object2).isNull()) continue;
                    element3.setText(((CMyDateTime)object2).toString());
                    continue;
                }
                element3.setText(object.toString());
            }
            catch (Throwable throwable) {
                throw new WCMException(I18NMessage.get(BaseObjToXmlConverterForSpecialProperty.class, "BaseObjToXmlConverterForSpecialProperty.label1", "\u5904\u7406[") + string2 + I18NMessage.get(BaseObjToXmlConverterForSpecialProperty.class, "BaseObjToXmlConverterForSpecialProperty.label2", "]\u5b57\u6bb5\u5931\u8d25!"), throwable);
            }
        }
        Element[] elementArray = this.getChildElement(baseObj);
        if (elementArray == null) {
            return element;
        }
        for (int i = 0; i < elementArray.length; ++i) {
            Element element4 = elementArray[i];
            if (element4 == null) continue;
            element.add(element4);
        }
        return element;
    }

    private boolean convertSpecialProperty(BaseObj baseObj, String string, Object object, Element element) throws ConvertException {
        String[][] stringArray;
        int n = this.lookupHostSpecialPropertyId(string);
        if (n > 0 && (stringArray = this.getSpecialProperty(baseObj, n, string, object)) != null) {
            String string2 = (String)this.m_hmNewTagNames.get(string);
            if (string2 != null) {
                element.setName(string2);
            }
            if (stringArray.length == 1 && stringArray[0].length == 1) {
                String string3 = stringArray[0][0];
                if (string3.matches(PATTERN_CDATA)) {
                    element.setText(string3);
                } else {
                    element.addCDATA(string3);
                }
                return false;
            }
            if (stringArray.length == 1 && stringArray[0].length == 2) {
                element.addAttribute(stringArray[0][0], stringArray[0][1]);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    element.addAttribute(stringArray[i][0], stringArray[i][1]);
                }
                return false;
            }
        }
        return true;
    }

    protected void registerHostSpecialProperty(String string, int n) {
        this.registerHostSpecialProperty(string, n, null);
    }

    protected void registerHostSpecialProperty(String string, int n, String string2) {
        this.m_oSpecialPropertiesRegister.register(this.m_sPrefix + string.toUpperCase(), n);
        if (string2 != null) {
            this.m_hmNewTagNames.put(string.toUpperCase(), string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialPropertyId(String string) {
        if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
            NamesRegister namesRegister = this.m_oSpecialPropertiesRegister;
            synchronized (namesRegister) {
                if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
                    this.registerHostSpecialProperties();
                    this.m_oSpecialPropertiesRegister.register(this.m_sPrefix, 0);
                }
            }
        }
        return this.m_oSpecialPropertiesRegister.lookup(this.m_sPrefix + string.toUpperCase(), -1);
    }
}

