/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.ObjectTypesFinder;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.ObjectLCMonitorServer;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class BaseObj
implements Cloneable {
    private static Logger s_logger = Logger.getLogger(BaseObj.class);
    protected boolean m_bCheckPropertyValid = true;
    protected Hashtable m_hProperties = null;
    private Hashtable m_hNewProperties = null;
    protected int id = 0;
    protected boolean bAddMode = true;
    protected String sClobFields_toUpdate = null;
    private int nUpdateClobCount;
    private String sTextFieldsList = null;
    private boolean bIsLoadText = false;
    protected boolean m_bFromClone = false;
    protected boolean IS_ENGVERSION = false;
    private boolean m_bEnableListener = true;
    private boolean m_bGetPropertyFromNew = false;
    private static final int[] TYPES_ALLOW_NULL = new int[]{4, 2, 8, 5, 6, -5, 3};
    private boolean m_bLoadNewPropertyById = false;

    public abstract int getWCMType();

    public abstract String getDbTableName();

    public abstract String getIdFieldName();

    public Object getKey() {
        return new Integer(this.id);
    }

    public final boolean isCached() {
        try {
            return BaseObj.getCachedPOMgr().isCached(this.getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final int getCacheIndex() {
        try {
            return BaseObj.getCachedPOMgr().getCacheIndex(this.getClass());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void setEnableListener(boolean bl) {
        if (!bl && this.isCached()) {
            s_logger.info((Object)"\u4f60\u6b63\u5728\u5bf9\u7f13\u51b2\u5bf9\u8c61\u8bbe\u7f6e\u4e3a\u4e0d\u542f\u7528\u76d1\u542c\u5668\uff0c\u7531\u4e8e\u7f13\u51b2\u5bf9\u8c61\u7684\u552f\u4e00\u6027\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u5230\u5176\u4ed6\u5730\u65b9\u5bf9\u8be5\u5bf9\u8c61\u7684\u4f7f\u7528");
        }
        this.m_bEnableListener = bl;
    }

    public boolean isEnableListener() {
        return this.m_bEnableListener;
    }

    public String getClassName(boolean bl) {
        int n;
        String string = this.getClass().getName();
        if (!bl && (n = string.lastIndexOf(46)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public int getId() {
        return this.id;
    }

    public Hashtable getAllProperty() {
        if (this.sTextFieldsList != null) {
            try {
                this.loadTextsFromDB(true);
            }
            catch (WCMException wCMException) {
                s_logger.error((Object)(I18NMessage.get(BaseObj.class, "BaseObj.label1", "\u88c5\u8f7d\u5927\u5b57\u6bb5[") + this.sTextFieldsList + I18NMessage.get(BaseObj.class, "BaseObj.label2", "]\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01")), (Throwable)wCMException);
            }
        }
        return this.getProperties();
    }

    protected void clearProperties() {
        if (this.m_hProperties != null) {
            this.m_hProperties.clear();
        }
    }

    protected void clearNewProperties() {
        if (this.m_hNewProperties != null) {
            this.m_hNewProperties.clear();
        }
        this.m_hNewProperties = null;
    }

    public Hashtable getNewProperties() {
        return this.getNewProperties(false);
    }

    private Hashtable getNewProperties(boolean bl) {
        if (this.m_hNewProperties == null && bl) {
            this.m_hNewProperties = new Hashtable();
        }
        return this.m_hNewProperties;
    }

    public boolean isModified() {
        return this.isModified(false);
    }

    public boolean isModified(boolean bl) {
        if (this.isAddMode()) {
            return this.getProperties() != null;
        }
        Hashtable hashtable = this.getNewProperties();
        if (hashtable != null && hashtable.size() > 0) {
            if (bl) {
                Hashtable hashtable2 = this.getProperties(true);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = hashtable.get(k);
                    if (v.equals(hashtable2.get(k))) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean setProperties(Hashtable hashtable) {
        if (hashtable == null) {
            return false;
        }
        this.getProperties(true).putAll(hashtable);
        return true;
    }

    protected boolean resetProperties(Hashtable hashtable) {
        if (hashtable == null) {
            return false;
        }
        this.clearProperties();
        return this.setProperties(hashtable);
    }

    public boolean isGetPropertyFromNew() {
        return this.m_bGetPropertyFromNew;
    }

    public void setGetPropertyFromNew(boolean bl) {
        this.m_bGetPropertyFromNew = !this.isAddMode() && bl;
    }

    public Object getProperty(String string) {
        if (string == null || this.getProperties() == null) {
            return null;
        }
        string = string.toUpperCase();
        Object var2_2 = null;
        if (this.m_bGetPropertyFromNew && this.m_hNewProperties != null) {
            var2_2 = this.m_hNewProperties.get(string);
        }
        if (var2_2 == null) {
            var2_2 = this.m_hProperties.get(string);
        }
        if (var2_2 == null || var2_2 instanceof NullValue) {
            return null;
        }
        if (var2_2 instanceof CDBText && !((CDBText)var2_2).isLoaded()) {
            try {
                if (this.loadTextsFromDB(false)) {
                    var2_2 = this.getProperties().get(string.toUpperCase());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                var2_2 = null;
            }
        }
        return var2_2;
    }

    public Object getNewProperty(String string) {
        if (this.getNewProperties() == null || string == null) {
            return null;
        }
        string = string.toUpperCase();
        Object v = this.getNewProperties().get(string);
        if (v instanceof NullValue) {
            return null;
        }
        return v;
    }

    public String getPropertyAsString(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String getFinalPropertyAsString(String string) {
        return this.getFinalPropertyAsString(string, null);
    }

    public String getFinalPropertyAsString(String string, String string2) {
        if (this.isAddMode()) {
            return this.getPropertyAsString(string, string2);
        }
        return CMyString.showNull(this.getNewPropertyAsString(string), string2);
    }

    public String getPropertyAsString(String string, String string2) {
        Object object = this.getProperty(string);
        if (object == null) {
            return string2;
        }
        if (object instanceof CMyDateTime && ((CMyDateTime)object).isNull()) {
            return string2;
        }
        return object.toString();
    }

    public boolean containsProperty(String string) {
        if (string == null || this.getProperties() == null) {
            return false;
        }
        return this.getProperties().containsKey(string.toUpperCase());
    }

    public boolean containsNewProperty(String string) {
        if (string == null || this.getNewProperties() == null) {
            return false;
        }
        return this.getNewProperties().containsKey(string.toUpperCase());
    }

    public CMyDateTime getPropertyAsDateTime(String string) {
        Object object = this.getProperty(string);
        if (object instanceof CMyDateTime) {
            return (CMyDateTime)object;
        }
        CMyDateTime cMyDateTime = new CMyDateTime();
        if (this.isNullValue(object)) {
            return cMyDateTime;
        }
        try {
            cMyDateTime.setDateTimeWithString(object.toString());
            return cMyDateTime;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new CMyDateTime();
        }
    }

    public long getPropertyAsLong(String string, long l) {
        Object object = this.getProperty(string);
        if (this.isNullValue(object)) {
            return l;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    public int getPropertyAsInt(String string, int n) {
        Object object = this.getProperty(string);
        if (this.isNullValue(object)) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    private boolean isNullValue(Object object) {
        return object == null || object instanceof NullValue;
    }

    public boolean getPropertyAsBoolean(String string, boolean bl) {
        int n = this.getPropertyAsInt(string, bl ? 1 : 0);
        return n != 0;
    }

    protected boolean loadTextsFromDB(boolean bl) throws WCMException {
        try {
            String string;
            if (bl) {
                int n = this.sTextFieldsList.indexOf(44);
                String string2 = n > 0 ? this.sTextFieldsList.substring(0, n) : this.sTextFieldsList;
                try {
                    CDBText cDBText = (CDBText)this.getProperty(string2);
                    if (cDBText != null && cDBText.isLoaded()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
                string = this.sTextFieldsList;
            } else {
                StringBuffer stringBuffer = new StringBuffer(20);
                Enumeration enumeration = this.getProperties().keys();
                String string3 = "";
                Object var6_11 = null;
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    var6_11 = this.getProperties().get(string3);
                    if (var6_11 == null || !(var6_11 instanceof CDBText) || ((CDBText)var6_11).isLoaded()) continue;
                    stringBuffer.append(string3 + ",");
                }
                if (stringBuffer.toString().length() <= 0) {
                    return false;
                }
                string = stringBuffer.substring(0, stringBuffer.toString().length() - 1);
            }
            return this.loadTextsFromDB(string);
        }
        catch (Exception exception) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label3", "\u88c5\u8f7d\u5927\u6587\u672c\u5b57\u6bb5\u65f6\u5931\u8d25(") + this.getClass().getName() + "loadTextFromDB)", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadTextsFromDB(String string) throws WCMException {
        boolean bl2;
        Connection connection = null;
        boolean bl = false;
        Statement statement = null;
        String string2 = null;
        String string3 = CMyString.filterForSQL2(this.getIdFieldName() + "," + string);
        try {
            string2 = "select " + string3 + " from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=?";
            connection = this.getDBManager().getConnection();
            statement = connection.prepareStatement(string2);
            statement.setInt(1, this.id);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = (String)stringTokenizer.nextElement();
                    CDBText cDBText = new CDBText(this.getDBManager().getDBType());
                    cDBText.readFromRs(resultSet, string4);
                    this.getProperties(true).put(string4, cDBText);
                }
                bl = true;
            }
            resultSet.close();
            bl2 = bl;
        }
        catch (Exception exception) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label4", "\u88c5\u8f7d\u5927\u6587\u672c\u5b57\u6bb5\u65f6\u5931\u8d25(SQL=") + string2 + ")", exception);
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (connection != null) {
            this.getDBManager().freeConnection(connection);
        }
        return bl2;
    }

    public boolean refreshProperty(String string, Object object) throws WCMException {
        return this.refreshProperty(string, object, true);
    }

    public boolean refreshProperty(String string, Object object, boolean bl) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label5", "\u5c5e\u6027\u540d\u79f0\u4e3a\u7a7a(") + this.getClass().getName() + ".refreshProperty)");
        }
        string = string.toUpperCase();
        this.checkPropertyValid(string, object);
        this.getProperties(true).put(string, object);
        if (bl && this.isCached() && object instanceof Long) {
            try {
                IClusterMsgCenter iClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
                String[] stringArray = new String[]{String.valueOf(this.getWCMType()), this.getKey().toString(), string, object.toString()};
                iClusterMsgCenter.send("PO.RP", stringArray);
            }
            catch (Exception exception) {
                throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", exception);
            }
        }
        return true;
    }

    public boolean refreshProperty(String string, long l) throws WCMException {
        return this.refreshProperty(string, new Long(l));
    }

    public boolean refreshProperty(String string, boolean bl) throws WCMException {
        return this.refreshProperty(string, new Long(bl ? 1L : 0L));
    }

    public void refreshProperty(BaseObj baseObj) {
        this.getProperties(true).putAll(baseObj.getNewProperties(true));
    }

    private boolean checkPropertyValid(String string, Object object) throws WCMException {
        if (this.isNullValue(object)) {
            return true;
        }
        FieldInfo fieldInfo = this.getDBManager().getFieldInfo(this.getDbTableName(), string);
        if (fieldInfo == null) {
            throw new WCMException(1101, I18NMessage.get(BaseObj.class, "BaseObj.label6", "\u5c5e\u6027") + string + I18NMessage.get(BaseObj.class, "BaseObj.label7", "\u5728\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728(") + this.getClass().getName() + ".setProperty)");
        }
        boolean bl = false;
        boolean bl2 = true;
        switch (fieldInfo.getDataType().getType()) {
            case 1: 
            case 12: {
                bl = object instanceof String;
                if (!bl) break;
                int n = ((String)object).length();
                if (n == 0) {
                    bl2 = fieldInfo.isNullable();
                    break;
                }
                bl2 = fieldInfo.getDataLength() == 0 ? true : n <= fieldInfo.getDataLength();
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                bl = object instanceof Number;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                bl = object instanceof CMyDateTime;
                if (!bl) break;
                bl2 = fieldInfo.isNullable() || !((CMyDateTime)object).isNull();
                break;
            }
            case -1: 
            case 2005: {
                bl = object instanceof CDBText;
                if (!bl) break;
                bl2 = fieldInfo.isNullable() || !((CDBText)object).isNull();
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            String string2 = "null";
            if (object != null) {
                string2 = object.getClass().getName();
            }
            throw new WCMException(1103, I18NMessage.get(BaseObj.class, "BaseObj.label8", "\u5c5e\u6027\u7c7b\u578b\u4e0d\u5339\u914d\uff1a") + string + I18NMessage.get(BaseObj.class, "BaseObj.label9", "\u5e94\u4e3a") + fieldInfo.getDataTypeName() + I18NMessage.get(BaseObj.class, "BaseObj.label10", "\u578b[TypeId=") + fieldInfo.getDataType().getType() + "][Value.class=" + string2 + "]");
        }
        if (!bl2) {
            throw new WCMException(1104, CMyString.format(I18NMessage.get(BaseObj.class, "BaseObj.label11", "\u5c5e\u6027{0}\u503c[{1}]\u4e0d\u6ee1\u8db3\u9650\u5236\u8981\u6c42({2})"), new String[]{string, object.toString(), this.getClass().getName()}));
        }
        return true;
    }

    public boolean setProperty(String string, long l) throws WCMException {
        return this.setProperty(string, new Long(l));
    }

    public boolean setProperty(String string, boolean bl) throws WCMException {
        return this.setProperty(string, new Long(bl ? 1L : 0L));
    }

    public boolean setProperty(String string, Object object, boolean bl) throws WCMException {
        Object object2 = object != null && object instanceof Integer ? new Long(((Integer)object).intValue()) : object;
        string = string.toUpperCase();
        if (this.m_bCheckPropertyValid && bl) {
            this.checkPropertyValid(string, object2);
        }
        (this.isAddMode() ? this.getProperties(true) : this.getNewProperties(true)).put(string, object2 == null ? this.makeNullValue(string) : object2);
        return true;
    }

    private Object makeNullValue(String string) throws WCMException {
        FieldInfo fieldInfo = this.getDBManager().getFieldInfo(this.getDbTableName(), string);
        if (fieldInfo == null) {
            throw new WCMException(1101, I18NMessage.get(BaseObj.class, "BaseObj.label6", "\u5c5e\u6027") + string + I18NMessage.get(BaseObj.class, "BaseObj.label7", "\u5728\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728(") + this.getClass().getName() + ".setProperty)");
        }
        return new NullValue(fieldInfo.getDataType().getType());
    }

    public boolean setProperty(String string, Object object) throws WCMException {
        return this.setProperty(string, object, true);
    }

    public Object removeProperty(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        if (this.isAddMode()) {
            return this.getProperties().remove(string);
        }
        if (this.getNewProperties() != null) {
            return this.getNewProperties().remove(string);
        }
        if (this.isCached()) {
            return null;
        }
        return this.getProperties().remove(string);
    }

    public boolean setTextProperty(String string, String string2) throws WCMException {
        return this.setProperty(string, new CDBText(this.getDBManager().getDBType(), string2));
    }

    public boolean setPropertyWithString(String string, String string2) throws WCMException {
        return this.setProperty(string, this.transformStringToObject(string, string2), false);
    }

    private Object transformStringToObject(String string, String string2) throws WCMException {
        if (string2 == null) {
            return null;
        }
        FieldInfo fieldInfo = this.getDBManager().getFieldInfo(this.getDbTableName(), string);
        if (fieldInfo == null) {
            throw new WCMException(1101, I18NMessage.get(BaseObj.class, "BaseObj.label6", "\u5c5e\u6027") + string + I18NMessage.get(BaseObj.class, "BaseObj.label13", "\u5728\u8868[") + this.getDbTableName() + I18NMessage.get(BaseObj.class, "BaseObj.label14", "]\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728(") + this.getClass().getName() + ".setProperty)");
        }
        int n = fieldInfo.getDataType().getType();
        if (this.isNullValue(string2, n)) {
            return new NullValue(n);
        }
        Object object = string2;
        try {
            switch (n) {
                case 2: 
                case 3: {
                    string2 = string2.trim();
                    if (fieldInfo.getDataScale() == 0) {
                        object = new Long(string2);
                        break;
                    }
                    object = new Double(string2);
                    break;
                }
                case 6: 
                case 8: {
                    string2 = string2.trim();
                    object = new Double(string2);
                    break;
                }
                case 1: 
                case 12: {
                    object = string2 == null ? "" : string2;
                    break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    string2 = string2.trim();
                    object = new Long(string2);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    string2 = string2.trim();
                    object = new CMyDateTime();
                    if (string2 != null && string2.trim().length() > 0) {
                        ((CMyDateTime)object).setDateTimeWithString(string2.trim());
                    }
                    break;
                }
                case -1: 
                case 2005: {
                    object = new CDBText(this.getDBManager().getDBType(), string2);
                    break;
                }
                default: {
                    object = string2 == null ? "" : string2;
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(I18NMessage.get(BaseObj.class, "BaseObj.label15", "\u65e0\u6548\u7684\u5c5e\u6027\u503c(") + string + I18NMessage.get(BaseObj.class, "BaseObj.label16", "):\u7c7b\u578b\u5e94\u4e3a") + fieldInfo.getDataTypeName() + "(" + this.getClass().getName() + ".setProperty); nType=" + n);
            exception.printStackTrace();
            object = null;
        }
        return object;
    }

    private boolean isNullValue(String string, int n) {
        if (string != null && string.length() > 0) {
            return false;
        }
        for (int i = 0; i < TYPES_ALLOW_NULL.length; ++i) {
            if (n != TYPES_ALLOW_NULL[i]) continue;
            return true;
        }
        return false;
    }

    public AttributesString getAttributesString() {
        String string = this.getAttribute();
        return new AttributesString(string);
    }

    public AttributesString getNewAttributesString() {
        String string = this.getNewAttribute();
        return new AttributesString(string);
    }

    public String getAttribute() {
        if (this.getProperty("Attribute") == null) {
            return "";
        }
        return (String)this.getProperty("Attribute");
    }

    public String getNewAttribute() {
        if (this.getNewPropertyAsString("Attribute") == null) {
            return "";
        }
        return this.getNewPropertyAsString("Attribute");
    }

    public String getAttributeValue(String string) {
        AttributesString attributesString = this.getAttributesString();
        if (attributesString == null) {
            return "";
        }
        return attributesString.getAttributeValue(string);
    }

    public String getNewAttributeValue(String string) {
        AttributesString attributesString = this.getNewAttributesString();
        if (attributesString == null) {
            return "";
        }
        return attributesString.getAttributeValue(string);
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("Attribute", string);
    }

    public boolean setAttribute(AttributesString attributesString) throws WCMException {
        if (attributesString == null) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label17", "\u65e0\u6548\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61(") + this.getClass().getName() + ".setAttribute)");
        }
        return this.setAttribute(attributesString.toString());
    }

    public boolean setAttribute(String string, String string2) throws WCMException {
        String string3;
        AttributesString attributesString = this.getAttributesString();
        if (!this.isAddMode() && (string3 = (String)this.getNewProperty("ATTRIBUTE")) != null) {
            attributesString.setAttributes(string3);
        }
        attributesString.putAttributeValue(string, string2);
        return this.setAttribute(attributesString);
    }

    public CMyDateTime getCrTime() {
        return (CMyDateTime)this.getProperty("CRTIME");
    }

    protected boolean setCrTime() throws WCMException {
        return this.setProperty("CRTIME", CMyDateTime.now());
    }

    public boolean isValidInstance() {
        return !this.bAddMode && this.id > 0;
    }

    public boolean isAddMode() {
        return this.bAddMode;
    }

    public final void readFromRs(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws WCMException {
        this.readFromRs(resultSet, resultSetMetaData, this.getIdFieldName());
    }

    public final void readFromRs(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String string) throws WCMException {
        try {
            if (resultSet == null) {
                return;
            }
            Object object = null;
            ResultSetMetaData resultSetMetaData2 = resultSetMetaData != null ? resultSetMetaData : resultSet.getMetaData();
            int n = resultSetMetaData2.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string2 = resultSetMetaData2.getColumnLabel(i).toUpperCase();
                object = null;
                switch (resultSetMetaData2.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (resultSetMetaData2.getScale(i) <= 0) {
                            long l = resultSet.getLong(i);
                            if (resultSet.wasNull()) break;
                            object = new Long(l);
                            break;
                        }
                        Double d = new Double(resultSet.getDouble(i));
                        if (resultSet.wasNull()) break;
                        object = d;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long l = resultSet.getLong(i);
                        if (resultSet.wasNull()) break;
                        object = new Long(l);
                        break;
                    }
                    case 1: 
                    case 12: {
                        object = resultSet.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        object = new CMyDateTime();
                        ((CMyDateTime)object).setDateTimeWithRs(resultSet, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        object = new CDBText(this.getDBManager().getDBType());
                        if (this.bIsLoadText || this.isCached()) {
                            ((CDBText)object).readFromRs(resultSet, i);
                        }
                        if (this.isCached()) break;
                        this.sTextFieldsList = (this.sTextFieldsList == null ? "" : this.sTextFieldsList + ",") + string2;
                        break;
                    }
                    case 8: {
                        double d = resultSet.getDouble(i);
                        if (resultSet.wasNull()) break;
                        object = new Double(d);
                        break;
                    }
                    default: {
                        object = resultSet.getObject(i);
                    }
                }
                if (object == null) continue;
                if (this.m_bLoadNewPropertyById) {
                    this.getNewProperties(true).put(string2, object);
                    continue;
                }
                this.getProperties(true).put(string2, object);
            }
            if (!this.m_bLoadNewPropertyById) {
                this.id = this.getPropertyAsInt(string, 0);
                this.bAddMode = false;
            }
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label18", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".readFromRs).", sQLException);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1, I18NMessage.get(BaseObj.class, "BaseObj.label18", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".readFromRs).", cMyException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label18", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".readFromRs).", exception);
        }
    }

    public boolean equals(int n) {
        return !this.bAddMode && this.id == n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof BaseObj)) {
            return false;
        }
        if (this.bAddMode) {
            return false;
        }
        BaseObj baseObj = (BaseObj)object;
        return this.getWCMType() == baseObj.getWCMType() && this.id == baseObj.getId();
    }

    public Hashtable cloneProperties() {
        Hashtable hashtable = this.getAllProperty();
        return hashtable == null ? null : (Hashtable)hashtable.clone();
    }

    public synchronized Object clone() {
        BaseObj baseObj = null;
        try {
            baseObj = (BaseObj)this.getClass().newInstance();
            baseObj.setProperties(this.getProperties());
            baseObj.setNewProperties(this.getNewProperties());
            baseObj.id = this.id;
            baseObj.bAddMode = this.bAddMode;
            baseObj.m_bFromClone = true;
            return baseObj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized BaseObj cloneToNewObj() throws WCMException {
        BaseObj baseObj = null;
        try {
            baseObj = (BaseObj)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new WCMException(1351, I18NMessage.get(BaseObj.class, "BaseObj.label19", "\u4ea7\u751f\u5f53\u524d\u5bf9\u8c61\u5b9e\u4f8b\u5931\u8d25\uff01"), exception);
        }
        baseObj.bAddMode = true;
        baseObj.setProperties(this.getAllProperty());
        baseObj.removeProperty(this.getIdFieldName());
        baseObj.removeProperty("CRTIME");
        return baseObj;
    }

    public synchronized BaseObj cloneToNewWCMObj() throws WCMException {
        return this.cloneToNewObj();
    }

    public abstract boolean isValid() throws WCMException;

    public boolean checkExists(String string) throws WCMException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = "select count(*) from " + this.getDbTableName() + " where " + string;
        boolean bl = false;
        try {
            connection = this.getDBManager().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            resultSet.next();
            bl = resultSet.getInt(1) > 0;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label20", "\u5728\u6570\u636e\u4e2d\u68c0\u67e5\u5bf9\u8c61\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519(") + this.getClass().getName() + ".checkExists)", sQLException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label20", "\u5728\u6570\u636e\u4e2d\u68c0\u67e5\u5bf9\u8c61\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519(") + this.getClass().getName() + ".checkExists)", exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert() throws WCMException {
        Object object;
        Connection connection;
        block18: {
            if (!this.isAddMode()) throw new WCMException(1105, I18NMessage.get(BaseObj.class, "BaseObj.label21", "\u6dfb\u52a0\u7684\u5bf9\u8c61\u65e0\u6548(") + this.getClass().getName() + ".insert)");
            if (!this.isValid()) throw new WCMException(1105, I18NMessage.get(BaseObj.class, "BaseObj.label21", "\u6dfb\u52a0\u7684\u5bf9\u8c61\u65e0\u6548(") + this.getClass().getName() + ".insert)");
            if (this.getProperties() == null) {
                throw new WCMException(1105, I18NMessage.get(BaseObj.class, "BaseObj.label21", "\u6dfb\u52a0\u7684\u5bf9\u8c61\u65e0\u6548(") + this.getClass().getName() + ".insert)");
            }
            connection = null;
            Statement statement = null;
            try {
                this.getNextId(connection);
                this.setProperty(this.getIdFieldName(), new Long(this.id));
                if (this.isEnableListener() && ((ObjectLCMonitorServer)(object = ObjectLCMonitorServer.getMonitorServer())).isDoNotify(-1, this)) {
                    ((ObjectLCMonitorServer)object).notifyOnBeforeAddObj(this);
                }
                connection = this.getDBManager().getConnection();
                statement = connection.prepareStatement(this.createInsertSQL());
                this.setParameters((PreparedStatement)statement);
                statement.executeUpdate();
                this.bAddMode = false;
                if (this.sClobFields_toUpdate != null) {
                    this.updateClobFields(connection, true);
                }
                if (statement == null) break block18;
            }
            catch (SQLException sQLException) {
                try {
                    throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label22", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25(") + this.getClass().getName() + ".insert).", sQLException);
                    catch (Exception exception) {
                        throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label22", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25(") + this.getClass().getName() + ".insert).", exception);
                    }
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (connection == null) throw throwable;
                    this.getDBManager().freeConnection(connection);
                    throw throwable;
                }
            }
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            this.getDBManager().freeConnection(connection);
        }
        if (this.isCached()) {
            this.loadFromDB();
            BaseObj.getCachedPOMgr().notifyOnAddObj(this);
        }
        if (this.isEnableListener() && ((ObjectLCMonitorServer)(object = ObjectLCMonitorServer.getMonitorServer())).isDoNotify(1, this)) {
            ((ObjectLCMonitorServer)object).notifyOnAddObj(this);
        }
        try {
            object = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            object.send(this.getWCMType(), this.getId(), 1, null);
            return;
        }
        catch (Exception exception) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() throws WCMException {
        if (!this.isModified()) {
            return;
        }
        try {
            if (!this.isValid()) {
                return;
            }
            ObjectLCMonitorServer objectLCMonitorServer = ObjectLCMonitorServer.getMonitorServer();
            if (this.isEnableListener() && objectLCMonitorServer.isDoNotify(5, this)) {
                objectLCMonitorServer.notifyOnModifyObj(this, 5);
            }
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.getDBManager().getConnection();
                String string = this.createUpdateSQL();
                if (string != null) {
                    statement = connection.prepareStatement(string);
                    int n = this.setParameters((PreparedStatement)statement);
                    statement.setInt(n, this.id);
                    statement.executeUpdate();
                }
                if (this.sClobFields_toUpdate != null) {
                    this.updateClobFields(connection, false);
                }
            }
            catch (SQLException sQLException) {
                throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label23", "\u66f4\u65b0\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".update" + ")", sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label23", "\u66f4\u65b0\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".update" + ")", exception);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
            }
            this.updateOthersAfterModified();
            if (this.isEnableListener() && objectLCMonitorServer.isDoNotify(2, this)) {
                objectLCMonitorServer.notifyOnModifyObj(this, 2);
            }
            try {
                IClusterMsgCenter iClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
                iClusterMsgCenter.send(this, 2);
            }
            catch (Exception exception) {
                throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", exception);
            }
            this.setProperties(this.getNewProperties());
        }
        finally {
            this.clearNewProperties();
        }
    }

    protected void updateOthersAfterModified() {
    }

    public synchronized void cancelUpdate() {
        this.clearNewProperties();
        this.sClobFields_toUpdate = null;
        this.nUpdateClobCount = 0;
    }

    protected String createInsertSQL() throws WCMException {
        String string = this.getDbTableName();
        FieldInfo fieldInfo = null;
        boolean bl = true;
        Enumeration enumeration = null;
        this.sClobFields_toUpdate = null;
        this.nUpdateClobCount = 0;
        String string2 = "INSERT INTO " + string + "(";
        String string3 = " VALUES(";
        enumeration = this.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            String string4;
            String string5 = (String)enumeration.nextElement();
            fieldInfo = this.getDBManager().getFieldInfo(string, string5);
            if (fieldInfo == null) {
                s_logger.warn((Object)("The field[" + string + "." + string5 + "] not exists! Ignore to insert!"));
                continue;
            }
            switch (fieldInfo.getDataType().getType()) {
                case 2005: {
                    this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? string5 : this.sClobFields_toUpdate + "," + string5;
                    ++this.nUpdateClobCount;
                    int n = this.getDBManager().getDBTypeAsInt();
                    if (n == 6 || n == 3 || n == 5) {
                        string4 = "clob('')";
                        break;
                    }
                    if (n == 7) {
                        string4 = "' '";
                        break;
                    }
                    string4 = "empty_clob()";
                    break;
                }
                case -1: {
                    int n = this.getDBManager().getDBTypeAsInt();
                    if (n == 3 || n == 5 || n == 7) {
                        this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? string5 : this.sClobFields_toUpdate + "," + string5;
                        ++this.nUpdateClobCount;
                        if (n == 7) {
                            string4 = "' '";
                            break;
                        }
                        string4 = "clob('')";
                        break;
                    }
                    string4 = "?";
                    break;
                }
                default: {
                    string4 = "?";
                }
            }
            if (bl) {
                string2 = string2 + string5;
                string3 = string3 + string4;
                bl = false;
                continue;
            }
            string2 = string2 + "," + string5;
            string3 = string3 + "," + string4;
        }
        if (bl) {
            return null;
        }
        return string2 + ") " + string3 + ")";
    }

    protected int setParameters(PreparedStatement preparedStatement) throws WCMException {
        if (preparedStatement == null) {
            return 0;
        }
        FieldInfo fieldInfo = null;
        String string = this.getDbTableName();
        DBType dBType = this.getDBManager().getDBType();
        String string2 = null;
        Object object = null;
        int n = 1;
        try {
            Hashtable hashtable = this.isAddMode() ? this.getProperties() : this.getNewProperties();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                fieldInfo = this.getDBManager().getFieldInfo(string, string2);
                if (fieldInfo == null) {
                    s_logger.warn((Object)(I18NMessage.get(BaseObj.class, "BaseObj.label24", "\u5b57\u6bb5[") + string2 + I18NMessage.get(BaseObj.class, "BaseObj.label25", "]\u5728\u8868[") + string + I18NMessage.get(BaseObj.class, "BaseObj.label26", "]\u4e2d\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\uff01")));
                    continue;
                }
                object = hashtable.get(string2);
                if (object instanceof NullValue) {
                    preparedStatement.setNull(n++, ((NullValue)object).getDataType());
                    continue;
                }
                if (object instanceof Long) {
                    preparedStatement.setLong(n++, (Long)object);
                    continue;
                }
                if (object instanceof Double) {
                    preparedStatement.setDouble(n++, (Double)object);
                    continue;
                }
                if (object instanceof Integer) {
                    preparedStatement.setInt(n++, (Integer)object);
                    continue;
                }
                if (object instanceof String) {
                    object = dBType.encodeStrToWrite((String)object);
                    dBType.setStringFieldValue(preparedStatement, n++, (String)object, fieldInfo.isNullable());
                    continue;
                }
                if (object instanceof CMyDateTime) {
                    preparedStatement.setTimestamp(n++, ((CMyDateTime)object).toTimestamp());
                    continue;
                }
                if (object instanceof CDBText) {
                    if (!dBType.canWriteTextDirectly()) continue;
                    preparedStatement.setString(n++, dBType.encodeStrToWrite(((CDBText)object).getText()));
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(BaseObj.class, "BaseObj.label27", "\u672a\u77e5\u7684\u5bf9\u8c61") + string2 + I18NMessage.get(BaseObj.class, "BaseObj.label28", "\u5c5e\u6027\u7c7b\u578b\uff1a(") + this.getClass().getName() + ".setParameters)");
            }
        }
        catch (SQLException sQLException) {
            String string3 = "";
            if (object != null && object instanceof NullValue) {
                string3 = "Is Null Value FieldName=" + string2 + ", Value.Type=" + ((NullValue)object).getDataType();
            } else if (object != null) {
                string3 = "FieldName=" + string2 + ", Value.Type=" + object.getClass();
            }
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label29", "\u5199\u5165\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38(") + string3 + ")", sQLException);
        }
        catch (Exception exception) {
            String string4 = "";
            if (object != null && object instanceof NullValue) {
                string4 = "Is Null Value FieldName=" + string2 + ", Value.Type=" + ((NullValue)object).getDataType();
            } else if (object != null) {
                string4 = "TableName=" + this.getDbTableName() + ", FieldName=" + string2 + ", Value.Type=" + object.getClass();
            }
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label30", "\u5199\u5165\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u51fa\u9519(") + string4 + ")", exception);
        }
        return n;
    }

    protected synchronized void updateClobFields(Connection connection, boolean bl) throws WCMException {
        if (this.sClobFields_toUpdate == null) {
            return;
        }
        boolean bl2 = true;
        if (bl2) {
            this.updClob(connection, bl);
            return;
        }
        String string = this.getIdFieldName();
        CDBText cDBText = null;
        try {
            if (this.nUpdateClobCount == 1) {
                cDBText = (CDBText)(bl ? this.getProperties() : this.getNewProperties()).get(this.sClobFields_toUpdate);
                if (cDBText == null) {
                    return;
                }
                this.getDBManager().getDBType().setClob(connection, this.getDbTableName(), string + "=" + this.getId(), string, this.sClobFields_toUpdate, cDBText.getText());
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.sClobFields_toUpdate, ",");
                String[] stringArray = new String[this.nUpdateClobCount * 2];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = (String)stringTokenizer.nextElement();
                    cDBText = (CDBText)(bl ? this.getProperties() : this.getNewProperties()).get(string2);
                    stringArray[n++] = string2;
                    stringArray[n++] = cDBText.getText();
                }
                this.getDBManager().getDBType().setClob(connection, this.getDbTableName(), string + "=" + this.getId(), string, stringArray);
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(1, I18NMessage.get(BaseObj.class, "BaseObj.label31", "\u66f4\u65b0CLOB\u5b57\u6bb5\u503c\u65f6\u51fa\u9519(") + this.getClass().getName() + ".updateClobFields)", cMyException);
        }
    }

    private void updClob(Connection connection, boolean bl) throws WCMException {
        String string = this.getIdFieldName();
        try {
            Hashtable hashtable;
            DBType dBType = this.getDBManager().getDBType();
            Hashtable hashtable2 = hashtable = bl ? this.getProperties() : this.getNewProperties();
            if (this.nUpdateClobCount == 1) {
                CDBText cDBText = (CDBText)hashtable.get(this.sClobFields_toUpdate);
                if (cDBText == null) {
                    return;
                }
                dBType.setClob(connection, this.getDbTableName(), string, this.id, this.sClobFields_toUpdate, cDBText.getText());
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.sClobFields_toUpdate, ",");
                String[] stringArray = new String[this.nUpdateClobCount * 2];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = (String)stringTokenizer.nextElement();
                    CDBText cDBText = (CDBText)hashtable.get(string2);
                    stringArray[n++] = string2;
                    stringArray[n++] = cDBText.getText();
                }
                dBType.setClob(connection, this.getDbTableName(), string, this.id, stringArray);
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(1, I18NMessage.get(BaseObj.class, "BaseObj.label31", "\u66f4\u65b0CLOB\u5b57\u6bb5\u503c\u65f6\u51fa\u9519(") + this.getClass().getName() + ".updateClobFields)", cMyException);
        }
    }

    private synchronized String createUpdateSQL() throws WCMException {
        boolean bl = true;
        FieldInfo fieldInfo = null;
        String string = this.getDbTableName();
        this.sClobFields_toUpdate = null;
        this.nUpdateClobCount = 0;
        String string2 = "UPDATE " + string + " SET  ";
        Enumeration enumeration = this.getNewProperties().keys();
        block4: while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            fieldInfo = this.getDBManager().getFieldInfo(string, string3);
            if (fieldInfo == null) {
                s_logger.warn((Object)("The field[" + string + "." + string3 + "] not exists! Ignore to update!"));
                continue;
            }
            if (bl) {
                bl = false;
            } else {
                string2 = string2 + ",";
            }
            switch (fieldInfo.getDataType().getType()) {
                case 2005: {
                    this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? string3 : this.sClobFields_toUpdate + "," + string3;
                    ++this.nUpdateClobCount;
                    int n = this.getDBManager().getDBTypeAsInt();
                    if (n == 6 || n == 3 || n == 5) {
                        string2 = string2 + string3 + "=clob('')";
                        continue block4;
                    }
                    if (n == 7) {
                        string2 = string2 + string3 + "=' '";
                        continue block4;
                    }
                    string2 = string2 + string3 + "=empty_clob()";
                    continue block4;
                }
                case -1: {
                    int n = this.getDBManager().getDBTypeAsInt();
                    if (n == 3 || n == 5 || n == 7) {
                        if (n == 7) {
                            string2 = string2 + string3 + "=' '";
                        }
                        string2 = string2 + string3 + "=clob('')";
                        continue block4;
                    }
                    string2 = string2 + string3 + "=?";
                    continue block4;
                }
            }
            string2 = string2 + string3 + "=?";
        }
        if (bl) {
            return null;
        }
        string2 = string2 + " where " + this.getIdFieldName() + "=?";
        return string2;
    }

    /*
     * Loose catch block
     */
    public boolean reload() throws WCMException {
        boolean bl;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block27: {
            block25: {
                boolean bl2;
                block26: {
                    if (!this.isValidInstance()) {
                        return false;
                    }
                    connection = null;
                    statement = null;
                    resultSet = null;
                    String string = "select * from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=" + this.getId();
                    connection = this.getDBManager().getConnection();
                    statement = connection.createStatement();
                    statement.setMaxRows(1);
                    resultSet = statement.executeQuery(string);
                    if (resultSet.next()) break block25;
                    bl2 = false;
                    if (resultSet == null) break block26;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                return bl2;
            }
            this.readFromRs(resultSet, null);
            bl = true;
            if (resultSet == null) break block27;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            this.getDBManager().freeConnection(connection);
        }
        return bl;
        catch (Exception exception) {
            try {
                throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label32", "\u91cd\u65b0\u88c5\u8f7d\u5bf9\u8c61\u6570\u636e\u5931\u8d25(") + this.getClass().getName() + ".reload)", exception);
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public int delete() throws WCMException {
        ObjectLCMonitorServer objectLCMonitorServer = ObjectLCMonitorServer.getMonitorServer();
        int n = 3;
        if (this.isEnableListener() && objectLCMonitorServer.isDoNotify(n, this)) {
            objectLCMonitorServer.notifyOnDelObj(this, n);
        }
        this.deleteOthersBeforeDelete();
        Connection connection = null;
        Statement statement = null;
        int n2 = 0;
        if (!this.isValidInstance()) {
            return 0;
        }
        try {
            connection = this.getDBManager().getConnection();
            String string = "delete from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=" + this.id;
            statement = connection.createStatement();
            n2 = statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label33", "\u4ece\u6570\u636e\u5e93\u4e2d\u5220\u9664\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".delete" + ")", sQLException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label33", "\u4ece\u6570\u636e\u5e93\u4e2d\u5220\u9664\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".delete" + ")", exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
        }
        n = 4;
        boolean bl = this.isCached();
        if (bl) {
            BaseObj.getCachedPOMgr().notifyOnDelObj(this, n);
        }
        if (this.isEnableListener() && objectLCMonitorServer.isDoNotify(n, this)) {
            objectLCMonitorServer.notifyOnDelObj(this, n);
        }
        try {
            IClusterMsgCenter iClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            iClusterMsgCenter.send(this, 3);
        }
        catch (Exception exception) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", exception);
        }
        return n2;
    }

    protected void deleteOthersBeforeDelete() {
    }

    protected synchronized int getNextId() throws WCMException {
        Connection connection = null;
        try {
            connection = this.getDBManager().getConnection();
            int n = this.getNextId(connection);
            return n;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label34", "\u83b7\u53d6\u4e0b\u4e00\u4e2a\u53ef\u7528\u7684ID\u503c\u5931\u8d25(") + this.getClass().getName() + ".getNextId)", exception);
        }
        finally {
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
        }
    }

    protected synchronized int getNextId(Connection connection) throws WCMException {
        return this.getNextId(connection, this.getDbTableName(), this.getIdFieldName());
    }

    protected synchronized int getNextId(Connection connection, String string, String string2) throws WCMException {
        if (this.id <= 0) {
            int n = this.getDBManager().getDBIdManager().getNextId(string, string2, connection, true);
            if (n <= 0) {
                throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label35", "\u83b7\u53d6\u7684ID\u503c\u65e0\u6548\uff1a") + n + "(" + this.getClass().getName() + ".getNextId)");
            }
            this.id = n;
        }
        return this.id;
    }

    public boolean setProperty(String string, double d) throws WCMException {
        return this.setProperty(string, new Double(d));
    }

    public double getPropertyAsDouble(String string, double d) {
        Object object = this.getProperty(string);
        return this.isNullValue(object) ? d : (Double)object;
    }

    public boolean isChangeProperty(String string) {
        if (this.m_hNewProperties == null || this.m_hNewProperties.isEmpty()) {
            return false;
        }
        Object v = this.m_hNewProperties.get(string = string.toUpperCase());
        if (v == null) {
            return false;
        }
        Object v2 = this.m_hProperties.get(string);
        return !v.equals(v2);
    }

    public void setLoadText(boolean bl) {
        this.bIsLoadText = bl;
    }

    public void save() throws WCMException {
        if (this.isAddMode()) {
            this.insert();
        } else {
            this.update();
        }
    }

    public static BaseObj createNewInstance(Class clazz) throws WCMException {
        if (clazz == null) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label36", "\u4f20\u5165\u7684Class\u5bf9\u8c61\u6709\u8bef\uff01"));
        }
        try {
            return (BaseObj)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(BaseObj.class, "BaseObj.label37", "\u4ea7\u751fClass[") + clazz.getName() + I18NMessage.get(BaseObj.class, "BaseObj.label38", "]\u5b9e\u4f8b\u5931\u8d25\uff01"), exception);
        }
    }

    public static BaseObj createNewInstance(String string) throws WCMException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label39", "\u4ea7\u751f[") + string + I18NMessage.get(BaseObj.class, "BaseObj.label40", "]Class\u5931\u8d25\uff01"), exception);
        }
        return BaseObj.createNewInstance(clazz);
    }

    public void setNextId() throws WCMException {
        this.getNextId();
    }

    public void releaseProperty(String string) throws WCMException {
        try {
            if (this.getProperties() == null || this.isCached()) {
                return;
            }
            Object object = this.getProperty(string);
            if (object == null) {
                return;
            }
            if (object instanceof CDBText) {
                object = null;
                this.getProperties().put(string.toUpperCase(), new CDBText(this.getDBManager().getDBTypeAsInt()));
            } else {
                this.getProperties().remove(string.toUpperCase());
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label41", "\u6e05\u7a7a\u5c5e\u6027\u5931\u8d25(") + this.getClass().getName() + ".releaseProperty)", exception);
        }
    }

    protected static ICachedPOMgr getCachedPOMgr() throws WCMException {
        ICachedPOMgr iCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (iCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        return iCachedPOMgr;
    }

    public int getNewPropertyAsInt(String string, int n) {
        Object object = this.getNewProperty(string);
        return object == null ? n : ((Number)object).intValue();
    }

    public String getNewPropertyAsString(String string) {
        Object object = this.getNewProperty(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    protected DBManager getDBManager() {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new Error(I18NMessage.get(BaseObj.class, "BaseObj.label42", "\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u5e38\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    protected boolean loadFromDB() throws WCMException {
        return this.loadFromDB("*");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadFromDB(String string) throws WCMException {
        boolean bl;
        String string2;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block29: {
            block27: {
                boolean bl2;
                block28: {
                    String string3;
                    if (this.getId() <= 0) {
                        throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label43", "\u6ca1\u6709\u8bbe\u7f6eID\uff01"));
                    }
                    String string4 = string3 = string == null ? "*" : string.trim();
                    if (string3.length() <= 0) {
                        string3 = "*";
                    }
                    connection = null;
                    statement = null;
                    resultSet = null;
                    ResultSetMetaData resultSetMetaData = null;
                    string2 = "";
                    string2 = "select " + string3 + " from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=?";
                    connection = this.getDBManager().getConnection();
                    statement = connection.prepareStatement(string2);
                    statement.setInt(1, this.id);
                    statement.setMaxRows(1);
                    resultSet = statement.executeQuery();
                    if (!resultSet.next()) break block27;
                    resultSetMetaData = resultSet.getMetaData();
                    this.readFromRs(resultSet, resultSetMetaData);
                    bl2 = true;
                    if (resultSet == null) break block28;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                return bl2;
            }
            bl = false;
            if (resultSet == null) break block29;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            this.getDBManager().freeConnection(connection);
        }
        return bl;
        catch (SQLException sQLException) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label44", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25(") + this.getClass().getName() + ".loadFromDB)\uff1aSQL=" + string2, sQLException);
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label44", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25(") + this.getClass().getName() + ".loadFromDB)\uff1aSQL=" + string2, exception);
                }
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public Hashtable getProperties() {
        return this.getProperties(false);
    }

    protected Hashtable getProperties(boolean bl) {
        if (this.m_hProperties == null && bl) {
            this.m_hProperties = new Hashtable();
        }
        return this.m_hProperties;
    }

    public void setNewProperties(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.getNewProperties(true).putAll(hashtable);
    }

    public void setId(int n) {
        this.id = n;
    }

    public synchronized boolean loadById(int n, String string) throws WCMException {
        return this.loadById(n, string, false);
    }

    public synchronized boolean loadById(int n, String string, boolean bl) throws WCMException {
        this.id = n;
        this.bAddMode = false;
        this.m_bLoadNewPropertyById = bl;
        boolean bl2 = this.loadFromDB(string);
        this.m_bLoadNewPropertyById = false;
        return bl2;
    }

    public static BaseObj findById(int n, int n2) throws WCMException {
        Class clazz = ObjectTypesFinder.findObjectClassByType(n);
        if (clazz == null) {
            throw new WCMException(I18NMessage.get(BaseObj.class, "BaseObj.label45", "\u6307\u5b9a\u7c7b\u578b[") + n + I18NMessage.get(BaseObj.class, "BaseObj.label46", "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        return BaseObj.findById(clazz, n2);
    }

    public static BaseObj findById(Class clazz, int n) throws WCMException {
        if (n <= 0 || clazz == null) {
            return null;
        }
        if (BaseObj.getCachedPOMgr().isCached(clazz)) {
            return BaseObj.getCachedPOMgr().getObjFromBuffer(clazz, n);
        }
        BaseObj baseObj = null;
        try {
            baseObj = (BaseObj)clazz.newInstance();
        }
        catch (Exception exception) {
            s_logger.error((Object)(I18NMessage.get(BaseObj.class, "BaseObj.label47", "\u6307\u5b9a\u7684Class[") + clazz + I18NMessage.get(BaseObj.class, "BaseObj.label48", "]\u4e0d\u662fBaseObj\u7684\u5b50\u7c7b\uff01")), (Throwable)exception);
            return null;
        }
        baseObj.id = n;
        if (baseObj.loadFromDB()) {
            return baseObj;
        }
        return null;
    }

    public static BaseObj findByKey(Class clazz, Object object) throws WCMException {
        Integer n = (Integer)object;
        if (BaseObj.getCachedPOMgr().isCached(clazz)) {
            return BaseObj.getCachedPOMgr().getObjFromBuffer(clazz, object);
        }
        return BaseObj.findById(clazz, (int)n);
    }
}

