/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.util.CMyDOM4jHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractXmlToObjConverter {
    private Map m_mTagClassMap = null;
    private static final String PROPERTIES_ELEMENT = "PROPERTIES";
    private int m_nImportType = 1;
    private String m_sXmlEncoding = "UTF-8";
    private Map m_mObjIdMapping = new HashMap();

    public AbstractXmlToObjConverter(int n) {
        this.m_nImportType = n;
    }

    public void registPersistentObj(String string, Class clazz) {
        if (this.m_mTagClassMap == null) {
            this.m_mTagClassMap = new HashMap();
        }
        this.m_mTagClassMap.put(string, clazz);
    }

    public XmlObject[] convertXml(String string, String string2, String string3) throws WCMException {
        Element element = CMyDOM4jHelper.buildXmlFile(string, string2);
        if (element.element(PROPERTIES_ELEMENT) == null) {
            return this.convertToObjs(element, string3);
        }
        return new XmlObject[]{this.convertToObj(element, string3)};
    }

    private XmlObject[] convertToObjs(Element element, String string) throws WCMException {
        int n = element.nodeCount();
        XmlObject[] xmlObjectArray = new XmlObject[]{};
        Element element2 = null;
        for (int i = 0; i < n; ++i) {
            element2 = this.findChildElement(element, i);
            if (element2 == null) continue;
            xmlObjectArray = this.addNewXMLObject(xmlObjectArray, this.fromXmlElement(element2, string));
        }
        return xmlObjectArray;
    }

    private XmlObject[] addNewXMLObject(XmlObject[] xmlObjectArray, XmlObject xmlObject) {
        int n = xmlObjectArray.length;
        XmlObject[] xmlObjectArray2 = new XmlObject[n + 1];
        if (n > 0) {
            System.arraycopy(xmlObjectArray, 0, xmlObjectArray2, 0, n);
        }
        xmlObjectArray2[n] = xmlObject;
        return xmlObjectArray2;
    }

    private XmlObject convertToObj(Element element, String string) throws WCMException {
        return this.fromXmlElement(element, string);
    }

    private XmlObject fromXmlElement(Element element, String string) throws WCMException {
        String string2 = element.getName();
        Element element2 = element.element(PROPERTIES_ELEMENT);
        if (element2 == null) {
            throw new WCMException(150, I18NMessage.get(AbstractXmlToObjConverter.class, "AbstractXmlToObjConverter.label5", "\u65e0\u6548\u7684XML\u6587\u4ef6\u683c\u5f0f,\u6216\u8be5XML\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u63cf\u8ff0WCM\u5bf9\u8c61\u7684\u6587\u4ef6!"));
        }
        XmlObject xmlObject = new XmlObject();
        Class clazz = this.getBaseObjClass(string2);
        if (clazz != null) {
            xmlObject.setCurrentObj(this.convert(element.element(PROPERTIES_ELEMENT), string, clazz));
        }
        Element element3 = null;
        int n = element.nodeCount();
        for (int i = 1; i < n; ++i) {
            element3 = this.findChildElement(element, i);
            if (element3 == null) continue;
            xmlObject.addChild(element3.getName(), this.fromChildren(element3));
        }
        return xmlObject;
    }

    private XmlObject[] fromChildren(Element element) throws WCMException {
        XmlObject[] xmlObjectArray = new XmlObject[]{};
        Element element2 = null;
        int n = element.nodeCount();
        for (int i = 0; i < n; ++i) {
            element2 = this.findChildElement(element, i);
            if (element2 == null) continue;
            xmlObjectArray = this.addNewXMLObject(xmlObjectArray, this.fromXmlElement(element2, null));
        }
        return xmlObjectArray;
    }

    private Class getBaseObjClass(String string) throws WCMException {
        if (this.m_mTagClassMap == null) {
            throw new WCMException(150, "finish register first!");
        }
        return (Class)this.m_mTagClassMap.get(string);
    }

    private BaseObj convert(Element element, String string, Class clazz) throws WCMException {
        Object object;
        boolean bl;
        BaseObj baseObj = BaseObj.createNewInstance(clazz);
        String string2 = null;
        int n = 0;
        Element element2 = element.element(baseObj.getIdFieldName());
        if (element2 != null && (string2 = element2.getText()) != null) {
            n = Integer.parseInt(string2);
        }
        if (n > 0) {
            switch (this.m_nImportType) {
                case 2: 
                case 3: {
                    baseObj = BaseObj.findById(clazz, n);
                    if (baseObj != null) break;
                    throw new WCMException(I18NMessage.get(AbstractXmlToObjConverter.class, "AbstractXmlToObjConverter.label6", "\u6307\u5b9a\u7684\u5bf9\u8c61[") + n + I18NMessage.get(AbstractXmlToObjConverter.class, "AbstractXmlToObjConverter.label7", "]\u6ca1\u6709\u627e\u5230\uff01"));
                }
            }
            this.m_mObjIdMapping.put(baseObj, new Integer(n));
        }
        String string3 = null;
        Map map = this.processSpecialProperties((Element)element.clone());
        boolean bl2 = bl = map.size() <= 0;
        if (string != null && string.length() > 0) {
            object = new StringTokenizer(string, ",");
            while (object.hasMoreElements()) {
                string3 = (String)object.nextElement();
                element2 = element.element(string3);
                if (element2 == null || element2.nodeCount() < 1 || !bl && map.containsKey(string3.toUpperCase())) continue;
                string2 = element2.getText();
                this.setProperty(baseObj, string3, string2);
            }
        } else {
            int n2 = element.nodeCount();
            for (int i = 0; i < n2; ++i) {
                element2 = this.findChildElement(element, i, false);
                if (element2 == null) continue;
                string3 = element2.getName();
                if (!bl && map.containsKey(string3.toUpperCase())) continue;
                string2 = element2.getText();
                this.setProperty(baseObj, string3, string2);
            }
        }
        if (!bl) {
            object = map.keySet().iterator();
            String string4 = null;
            Object object2 = null;
            while (object.hasNext()) {
                string4 = (String)object.next();
                object2 = map.get(string4);
                if (object2 == null) continue;
                this.setProperty(baseObj, string4, object2.toString());
            }
        }
        return baseObj;
    }

    protected void setProperty(BaseObj baseObj, String string, String string2) throws WCMException {
        block2: {
            try {
                baseObj.setPropertyWithString(string, string2);
            }
            catch (WCMException wCMException) {
                if (wCMException.getErrNo() == 1101) break block2;
                throw wCMException;
            }
        }
    }

    public String getXmlEncoding() {
        return this.m_sXmlEncoding;
    }

    public void setXmlEncoding(String string) {
        this.m_sXmlEncoding = string;
    }

    public Map getObjIdMapping() {
        return this.m_mObjIdMapping;
    }

    protected abstract Map processSpecialProperties(Element var1) throws WCMException;

    private Element findChildElement(Element element, int n) {
        return this.findChildElement(element, n, true);
    }

    private Element findChildElement(Element element, int n, boolean bl) {
        Node node = element.node(n);
        if (!(node instanceof Element)) {
            return null;
        }
        if (bl && node.getName().toUpperCase().equals(PROPERTIES_ELEMENT)) {
            return null;
        }
        return (Element)node;
    }
}

