/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra;

import com.trs.infra.I18NMessage;
import com.trs.infra.IServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyErrors;
import com.trs.infra.util.CMyException;
import org.apache.log4j.Logger;

public abstract class BaseServer
implements IServer {
    public static final String APP_VERSION = "5.1";
    public String APP_BUILD = "1070";
    public String DB_BUILD = "1070";
    public String APP_BUILD_TIME = "2005-02-23";
    private static final Logger logger = Logger.getLogger((String)BaseServer.class.getName());
    protected boolean m_bIsStarted = false;
    protected boolean m_bIsStarting = false;
    protected CMyErrors errors = new CMyErrors();
    protected String m_sAppName = null;

    protected void addError(String string) {
        this.errors.add(string);
    }

    protected void addError(CMyErrors cMyErrors) {
        this.errors.add(cMyErrors);
    }

    protected void addError(String string, Exception exception) {
        this.errors.add(string, exception);
    }

    protected void addError(Exception exception) {
        this.errors.add(exception);
    }

    public CMyErrors getErrors() {
        return this.errors;
    }

    public boolean isStarted() {
        return this.m_bIsStarted;
    }

    public boolean isStarting() {
        return this.m_bIsStarting;
    }

    protected void setStarting(boolean bl) {
        this.m_bIsStarting = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startup() {
        if (this.isStarted()) {
            logger.info((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label1", "]\u5df2\u7ecf\u542f\u52a8\u4e86!")));
            return true;
        }
        if (this.isStarting()) {
            logger.info((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label2", "]\u6b63\u5728\u542f\u52a8...")));
            return false;
        }
        BaseServer baseServer = this;
        synchronized (baseServer) {
            block10: {
                boolean bl;
                if (this.isStarted()) {
                    return true;
                }
                this.setStarting(true);
                try {
                    if (this.doStart()) break block10;
                    bl = false;
                    this.setStarting(false);
                }
                catch (Throwable throwable) {
                    try {
                        this.addError(CMyException.getStackTraceText(throwable));
                        logger.error((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label3", "]\u542f\u52a8\u5931\u8d25!")), throwable);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        this.setStarting(false);
                    }
                }
                return bl;
            }
            this.setStarting(false);
            this.setStarted(true);
            return true;
        }
    }

    public synchronized void shutdown() {
        if (!this.isStarted()) {
            return;
        }
        this.doShutdown();
        this.setStarted(false);
        logger.info((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label4", "]\u5173\u95ed!")));
    }

    protected void setStarted(boolean bl) {
        this.m_bIsStarted = bl;
    }

    public synchronized boolean restart() {
        if (!this.isStarted()) {
            return false;
        }
        this.shutdown();
        return this.startup();
    }

    public String getServerName() {
        if (this.m_sAppName == null) {
            return this.getClass().getName();
        }
        return this.m_sAppName;
    }

    public void setServerName(String string) {
        this.m_sAppName = string;
    }

    public String getServerBuild() {
        return this.APP_BUILD;
    }

    public String getBuildTime() {
        return this.APP_BUILD_TIME;
    }

    public String getDbBuild() {
        return this.DB_BUILD;
    }

    public String getVersion() {
        return APP_VERSION;
    }

    protected abstract void doShutdown();

    protected abstract boolean doStart() throws WCMException;
}

