/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.web;

import com.trs.components.web.IFieldHTMLParser;
import com.trs.components.web.IPropertiesBuilder;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseFieldHTMLParser
implements IFieldHTMLParser {
    private Map templatesCache = null;

    public abstract String getTemplatePath() throws WCMException;

    public String getTemplateEncoding(String string) {
        return "GBK";
    }

    public String getTemplateKey(String string) {
        return CMyFile.extractMainFileName(string).toUpperCase();
    }

    private void loadTemplates() throws CMyException {
        String string = ConfigServer.getServer().getSysConfigValue("NotCache4ModifyDocumentProperties", "false");
        if (this.templatesCache != null && "false".equalsIgnoreCase(string)) {
            return;
        }
        this.templatesCache = new HashMap();
        File file = new File(this.getTemplatePath());
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getAbsolutePath();
            String string3 = this.getTemplateKey(string2);
            String string4 = CMyFile.readFile(string2, this.getTemplateEncoding(string2));
            this.templatesCache.put(string3, string4);
        }
    }

    public String getTemplate(String string) throws CMyException {
        this.loadTemplates();
        String string2 = (String)this.templatesCache.get(string.toUpperCase());
        if (string2 == null) {
            string2 = (String)this.templatesCache.get("default");
        }
        return string2;
    }

    public String parse(String string, IPropertiesBuilder iPropertiesBuilder) throws CMyException {
        String string2 = this.getTemplate(string);
        return CMyString.parsePageVariables(string2, iPropertiesBuilder.build());
    }
}

