/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.chart;

import com.trs.components.wcm.stat.StatFieldMap;
import com.trs.components.wcm.stat.StatFieldMaps;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.util.CMyString;
import de.laures.cewolf.DatasetProducer;
import java.util.Date;
import java.util.Map;
import org.jfree.data.general.DefaultPieDataset;

public final class PieChartProducer
implements DatasetProducer {
    private static final String PRODUCER_ID = "PicChartProducer";
    public static final String PARAM_UNIQUENAME = "UniqueName";
    public static final String PARAM_COMPAREDFIELD = "ComparedField";
    public static final String PARAM_VIEWID = "ViewId";
    private transient CMyResultSets statResults = null;
    private transient StatFieldMaps statFieldMaps = null;

    public Object produceDataset(Map map) {
        String string = (String)map.get(PARAM_UNIQUENAME);
        String string2 = (String)map.get(PARAM_COMPAREDFIELD);
        return this.getDataSet(string, string2);
    }

    private DefaultPieDataset getDataSet(String string, String string2) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        CMyResultSets cMyResultSets = this.getStatResults();
        if (cMyResultSets == null || cMyResultSets.size() == 0) {
            return defaultPieDataset;
        }
        CMyResultSet cMyResultSet = null;
        if (string == null) {
            StatFieldMaps statFieldMaps = this.getStatFieldMaps();
            String[] stringArray = new String[statFieldMaps.size()];
            String[] stringArray2 = new String[stringArray.length];
            String[] stringArray3 = new String[stringArray2.length];
            for (int i = 0; i < statFieldMaps.size(); ++i) {
                StatFieldMap statFieldMap = (StatFieldMap)statFieldMaps.getAt(i);
                stringArray[i] = statFieldMap.getFieldName();
                stringArray2[i] = statFieldMap.getFieldDesc();
                stringArray3[i] = statFieldMap.getFieldType();
            }
            cMyResultSet = (CMyResultSet)cMyResultSets.getAt(0);
            Object object = null;
            for (int i = 0; i < stringArray.length; ++i) {
                object = cMyResultSet.getProperty(stringArray[i]);
                if (!(object instanceof Number)) continue;
                defaultPieDataset.setValue((Comparable)((Object)stringArray2[i]), (double)((Number)object).intValue());
            }
            return defaultPieDataset;
        }
        for (int i = 0; i < cMyResultSets.size(); ++i) {
            cMyResultSet = (CMyResultSet)cMyResultSets.getAt(i);
            int n = cMyResultSet.getPropertyAsInt(string2, 0);
            String string3 = this.makeUniqueName(cMyResultSet, string);
            Number number = defaultPieDataset.getValue((Comparable)((Object)string3));
            if (number == null) {
                defaultPieDataset.setValue((Comparable)((Object)string3), (double)n);
                continue;
            }
            defaultPieDataset.setValue((Comparable)((Object)string3), (double)(n + number.intValue()));
        }
        return defaultPieDataset;
    }

    private String makeUniqueName(CMyResultSet cMyResultSet, String string) {
        if (CMyString.isEmpty(string)) {
            return PARAM_UNIQUENAME;
        }
        String[] stringArray = CMyString.split(string, ",");
        String string2 = cMyResultSet.getPropertyAsString(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + ":" + cMyResultSet.getPropertyAsString(stringArray[i]);
        }
        return string2;
    }

    public boolean hasExpired(Map map, Date date) {
        return false;
    }

    public String getProducerId() {
        return PRODUCER_ID;
    }

    public final CMyResultSets getStatResults() {
        return this.statResults;
    }

    public final void setStatResults(CMyResultSets cMyResultSets) {
        this.statResults = cMyResultSets;
    }

    public final StatFieldMaps getStatFieldMaps() {
        return this.statFieldMaps;
    }

    public final void setStatFieldMaps(StatFieldMaps statFieldMaps) {
        this.statFieldMaps = statFieldMaps;
    }
}

