/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.recent;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.recent.Recent;
import com.trs.components.wcm.recent.Recents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class RecentMgr {
    public boolean add(int n, int n2) throws WCMException {
        CMSObj cMSObj = this.getWCMObj(n, n2);
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label1", "\u6ca1\u6709\u627e\u5230\u5f53\u524d\u5bf9\u8c61\uff0c\u65e0\u6cd5\u8bb0\u5f55\u5230\u6700\u8fd1\u8bbf\u95ee\u7684\u5bf9\u8c61\u8bb0\u5f55\u4e2d\uff01"));
        }
        Recent recent = this.prepareAdd(cMSObj);
        recent = this.save(recent);
        return true;
    }

    private CMSObj getWCMObj(int n, int n2) throws WCMException {
        switch (n) {
            case 103: {
                return WebSite.findById(n2);
            }
            case 101: {
                return Channel.findById(n2);
            }
            case 605: {
                return Document.findById(n2);
            }
            case 102: {
                return Template.findById(n2);
            }
            case 614: {
                return ChnlDoc.findById(n2);
            }
        }
        throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label2", "\u4f20\u5165\u7684\u5bf9\u8c61\u7c7b\u578b[") + n + I18NMessage.get(RecentMgr.class, "RecentMgr.label3", "]\u4e0d\u652f\u6301\uff01"));
    }

    private Recent prepareAdd(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            return null;
        }
        Recents recents = this.getRecents(cMSObj.getWCMType());
        Recent recent = null;
        if (recents == null) {
            recent = new Recent();
            recent.setObj(cMSObj);
            return recent;
        }
        if (recents.indexOf(this.getRecent(cMSObj)) >= 0) {
            recent = this.getRecent(cMSObj);
            recent.canEdit(this.getLoginUser());
            recent.setProperty("CRTIME", CMyDateTime.now());
            return recent;
        }
        if (recents.size() >= Recent.getMaxNum()) {
            recent = (Recent)recents.getAt(recents.size() - 1);
            if (recent == null) {
                throw new WCMException(20, I18NMessage.get(RecentMgr.class, "RecentMgr.label4", "\u4ece\u96c6\u5408\u4e2d\u53d6\u5f97\u6700\u8fd1\u8bbf\u95ee\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
            }
            recent.canEdit(this.getLoginUser());
            recent.setObj(cMSObj);
            recent.setProperty("CRTIME", CMyDateTime.now());
            return recent;
        }
        recent = new Recent();
        recent.setObj(cMSObj);
        return recent;
    }

    private Recents getRecents(int n) throws WCMException {
        if (n < 0) {
            return null;
        }
        String string = "CrUser='" + this.getLoginUserNameForSql() + "' AND OBJTYPE=" + n;
        WCMFilter wCMFilter = new WCMFilter("", string, "CrTime Desc");
        return Recents.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    private Recent save(Recent recent) throws WCMException {
        if (recent == null) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label5", "\u6700\u8fd1\u8bbf\u95ee\u7684\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        recent.save(this.getLoginUser());
        return recent;
    }

    private Recent getRecent(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label6", "\u5f53\u524d\u8bbf\u95ee\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        String string = "CrUser='" + this.getLoginUserNameForSql() + "' AND OBJTYPE=" + cMSObj.getWCMType() + " AND OBJID=" + cMSObj.getId();
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        Recents recents = Recents.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (recents == null || recents.isEmpty()) {
            return null;
        }
        return (Recent)recents.getAt(0);
    }

    public String getIds(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label7", "\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548\uff0c\u65e0\u6cd5\u5f97\u5230\u6700\u8fd1\u8bbf\u95ee\u5217\u8868\uff01"));
        }
        Recents recents = this.getRecents(n);
        if (recents == null || recents.isEmpty()) {
            return null;
        }
        return recents.getIdListAsString();
    }

    public Documents getDocuments(WCMFilter wCMFilter, boolean bl) throws WCMException {
        String string = "WCMDOCUMENT, WCMRECENT";
        String string2 = "WCMDOCUMENT.DOCID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=605 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        if (!bl) {
            string2 = string2 + " AND WCMDOCUMENT.DOCSTATUS>0";
        }
        String string3 = "WCMRECENT.CRTIME DESC";
        WCMFilter wCMFilter2 = new WCMFilter(string, string2, string3);
        wCMFilter2.mergeWith(wCMFilter);
        return Documents.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public Channels getChannels(WCMFilter wCMFilter, boolean bl) throws WCMException {
        String string = "WCMCHANNEL, WCMRECENT";
        String string2 = "WCMCHANNEL.CHANNELID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=101 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        if (!bl) {
            string2 = string2 + " AND WCMCHANNEL.STATUS=0";
        }
        String string3 = "WCMRECENT.CRTIME DESC";
        WCMFilter wCMFilter2 = new WCMFilter(string, string2, string3);
        wCMFilter2.mergeWith(wCMFilter);
        return Channels.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public Templates getTemplates(WCMFilter wCMFilter) throws WCMException {
        String string = "WCMTEMPLATE, WCMRECENT";
        String string2 = "WCMTEMPLATE.TEMPID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=102 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        String string3 = "WCMRECENT.CRTIME DESC";
        WCMFilter wCMFilter2 = new WCMFilter(string, string2, string3);
        wCMFilter2.mergeWith(wCMFilter);
        return Templates.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public WebSites getWebSites(WCMFilter wCMFilter) throws WCMException {
        String string = "WCMWEBSITE, WCMRECENT";
        String string2 = "WCMWEBSITE.SITEID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=103 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        String string3 = "WCMRECENT.CRTIME DESC";
        WCMFilter wCMFilter2 = new WCMFilter(string, string2, string3);
        wCMFilter2.mergeWith(wCMFilter);
        return WebSites.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public ChnlDocs getChnlDocs(WCMFilter wCMFilter, boolean bl) throws WCMException {
        String string = "WCMCHNLDOC, WCMRECENT";
        String string2 = "WCMCHNLDOC.RECID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=614 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        if (!bl) {
            string2 = string2 + " AND (WCMCHNLDOC.DOCSTATUS>0 AND WCMCHNLDOC.CHNLID>0)";
        }
        String string3 = "WCMRECENT.CRTIME DESC";
        WCMFilter wCMFilter2 = new WCMFilter(string, string2, string3);
        wCMFilter2.mergeWith(wCMFilter);
        return ChnlDocs.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserNameForSql() {
        return CMyString.filterForSQL(this.getLoginUser().getName());
    }
}

