/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import org.apache.log4j.Logger;

public class WCMContentPublishConfig {
    private static Logger logger = Logger.getLogger(WCMContentPublishConfig.class);
    private User m_oLoginuser = null;
    private IPublishContent m_oContent = null;
    private int m_nDetailTemplateId = 0;
    private Template m_oDetailTemplate = null;
    private TemplateEmployMgr m_oTemplateEmployMgr = null;
    private boolean m_bInitTemplate = false;
    private Schedule m_oSchedule = null;
    private boolean m_bScheduleInited = false;

    public WCMContentPublishConfig(User user, IPublishContent iPublishContent) {
        this.m_oLoginuser = user;
        this.m_oContent = iPublishContent;
        this.init();
    }

    private void init() {
        this.m_oTemplateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    }

    public String getURL() throws WCMException {
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        try {
            return publishPathCompass.getHttpUrl(this.m_oContent, 0);
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
            logger.error((Object)I18NMessage.get(WCMContentPublishConfig.class, "WCMContentPublishConfig.label1", "\u6784\u9020\u53d1\u5e03!"), (Throwable)wCMDatainvalidException);
            return "";
        }
    }

    public Template getDetailTemplate() throws WCMException {
        if (!this.m_bInitTemplate) {
            this.initTemplateInfo();
        }
        return this.m_oDetailTemplate;
    }

    public int getDetailTemplateId() throws WCMException {
        if (!this.m_bInitTemplate) {
            this.initTemplateInfo();
        }
        return this.m_nDetailTemplateId;
    }

    public void setDetialTemplate(int n) throws WCMException {
        this.m_oTemplateEmployMgr.setDetailTemplate(this.m_oContent, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulePublish(CMyDateTime cMyDateTime) throws WCMException {
        this.initSchedule();
        if (this.m_oSchedule == null) {
            if (cMyDateTime == null || cMyDateTime.isNull()) {
                return;
            }
            Schedule schedule = new Schedule();
            schedule.setWorkerType(4);
            schedule.setExeTime(cMyDateTime);
            schedule.setSender(this.m_oContent.getSubstance());
            schedule.setMode(3);
            String string = I18NMessage.get(WCMContentPublishConfig.class, "WCMContentPublishConfig.label2", "\u5b9a\u65f6\u53d1\u5e03[") + this.m_oContent.getInfo() + "]";
            schedule.setName(string);
            schedule.setDesc(string);
            schedule.insert(this.m_oLoginuser);
        } else if (cMyDateTime == null || cMyDateTime.isNull()) {
            this.m_oSchedule.delete(this.m_oLoginuser);
        } else {
            this.m_oSchedule.validCanEditAndLock(this.m_oLoginuser);
            try {
                this.m_oSchedule.setExeTime(cMyDateTime);
                this.m_oSchedule.update(this.m_oLoginuser);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.m_oSchedule.cancelUpdate(this.m_oLoginuser);
                throw throwable;
            }
            this.m_oSchedule.cancelUpdate(this.m_oLoginuser);
            {
            }
        }
    }

    private void initTemplateInfo() throws WCMException {
        this.m_oDetailTemplate = this.m_oTemplateEmployMgr.getDetailTemplate(this.m_oContent);
        if (this.m_oDetailTemplate != null) {
            this.m_nDetailTemplateId = this.m_oDetailTemplate.getId();
        }
        this.m_bInitTemplate = true;
    }

    private void initSchedule() throws WCMException {
        if (this.m_bScheduleInited) {
            return;
        }
        this.m_oSchedule = Schedule.findBySender(4, this.m_oContent.getSubstance());
        this.m_bScheduleInited = true;
    }

    public String getScheduleTime() throws WCMException {
        this.initSchedule();
        if (this.m_oSchedule == null) {
            return "";
        }
        return this.m_oSchedule.getExeTime().toString();
    }

    public Schedule getSchedule() throws WCMException {
        this.initSchedule();
        return this.m_oSchedule;
    }

    public boolean isScheduled() throws WCMException {
        return this.getSchedule() != null;
    }
}

