/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.logger;

import com.trs.cms.logger.LogInfo;
import com.trs.cms.logger.ObjLoggerBase;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.infra.persistent.BaseObj;
import java.util.Map;

public class TemplateEmployLogger
extends ObjLoggerBase {
    private static final String KEY = "TEMPLATEID";

    public int getLogObjType() {
        return 953;
    }

    protected Map getMajorKeys() {
        return null;
    }

    protected String getObjName(BaseObj baseObj) {
        StringBuffer stringBuffer = new StringBuffer(64);
        TemplateEmploy templateEmploy = (TemplateEmploy)baseObj;
        if (templateEmploy.getTemplateType() == 2) {
            stringBuffer.append("\u7ec6\u89c8\u6a21\u677f\u914d\u7f6e");
        } else if (templateEmploy.isDefault() || templateEmploy.getNewPropertyAsInt("ISDEFAULT", 0) == 1) {
            stringBuffer.append("\u9996\u9875\u6a21\u677f\u914d\u7f6e");
        } else {
            stringBuffer.append("\u5176\u5b83\u6982\u89c8\u914d\u7f6e");
        }
        stringBuffer.append("[TemplateId=").append(templateEmploy.getTemplateId()).append("]");
        return stringBuffer.toString();
    }

    public LogInfo makeLogOnAdd(BaseObj baseObj) {
        String string = this.getObjName(baseObj);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("\u65b0\u5efa");
        this.appendEmployerInfo(stringBuffer, baseObj);
        stringBuffer.append(string);
        stringBuffer.append(", \u914d\u7f6e\u7684\u6a21\u677f\u662f");
        int n = baseObj.getPropertyAsInt(KEY, 0);
        try {
            stringBuffer.append(Template.findById(n));
        }
        catch (Exception exception) {
            stringBuffer.append("ID=").append(n);
        }
        return new LogInfo(this.getAddOpType(baseObj), string, stringBuffer.toString());
    }

    private void appendEmployerInfo(StringBuffer stringBuffer, BaseObj baseObj) {
        TemplateEmploy templateEmploy = (TemplateEmploy)baseObj;
        try {
            stringBuffer.append(templateEmploy.getEmployer().getInfo());
        }
        catch (Exception exception) {
            stringBuffer.append("EmployerType=");
            stringBuffer.append(templateEmploy.getEmployerType());
            stringBuffer.append(", EmployerId=");
            stringBuffer.append(templateEmploy.getEmployerId());
        }
        stringBuffer.append("\u7684");
    }

    public LogInfo makeLogOnDel(BaseObj baseObj) {
        String string = this.getObjName(baseObj);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("\u5220\u9664");
        this.appendEmployerInfo(stringBuffer, baseObj);
        stringBuffer.append(string);
        stringBuffer.append(", \u914d\u7f6e\u7684\u6a21\u677f\u662f");
        int n = baseObj.getPropertyAsInt(KEY, 0);
        try {
            stringBuffer.append(Template.findById(n));
        }
        catch (Exception exception) {
            stringBuffer.append("ID=").append(n);
        }
        return new LogInfo(this.getDeleteOpType(baseObj), string, stringBuffer.toString());
    }

    public LogInfo makeLogOnModify(BaseObj baseObj) {
        if (!baseObj.isChangeProperty(KEY)) {
            return null;
        }
        String string = this.getObjName(baseObj);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("\u4fee\u6539");
        this.appendEmployerInfo(stringBuffer, baseObj);
        stringBuffer.append("\u6a21\u677f: ");
        int n = baseObj.getPropertyAsInt(KEY, 0);
        int n2 = baseObj.getNewPropertyAsInt(KEY, 0);
        try {
            stringBuffer.append(Template.findById(n));
            stringBuffer.append(" --> ");
            stringBuffer.append(Template.findById(n2));
        }
        catch (Exception exception) {
            stringBuffer.append(n).append(" --> ").append(n2);
        }
        return new LogInfo(this.getModifyOpType(baseObj), string, stringBuffer.toString());
    }
}

