/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.XmlDocWithDom4j;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class EPressXPlusImporter {
    private static final int IMAGE_HEIGHT = 486;
    private static final int IMAGE_WIDTH = 338;
    private static final Map DEFAULT_TAGS = new HashMap(6);
    private static Logger s_logger = Logger.getLogger(EPressXPlusImporter.class);
    private DocumentMgr m_documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromXPlus(String string, String string2, Channel channel) throws Exception {
        String string3;
        String string4 = this.mapFile(string);
        String string5 = CMyFile.extractFilePath(string4);
        string5 = string5 + "temp" + CMyFile.extractMainFileName(string4);
        string5 = string5 + File.separator;
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string4, string5);
        try {
            try {
                cMyUnZipFile.addFileExtFilters("xml");
                cMyUnZipFile.doUnZipAnd();
            }
            catch (CMyException cMyException) {
                throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", cMyException);
            }
            string3 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            CMyFile.deleteFile(string4);
            throw throwable;
        }
        CMyFile.deleteFile(string4);
        Map map = this.parseTcf(string2);
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        try {
            string3 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = (String)arrayList.get(i);
                this.addDocument(string3, map, channel);
            }
            Object var12_14 = null;
            arrayList.clear();
            cMyUnZipFile = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            arrayList.clear();
            cMyUnZipFile = null;
            CMyFile.deleteDir(string5);
            throw throwable;
        }
        CMyFile.deleteDir(string5);
    }

    private void addDocument(String string, Map map, Channel channel) throws Exception {
        Document document = XmlDocWithDom4j.parse(string);
        String string2 = CMyFile.extractFilePath(string);
        List list = document.selectNodes("/PageInfoFile/ArticleList/Article");
        Element element = (Element)document.selectSingleNode("/PageInfoFile/PageInfo");
        String string3 = element.attributeValue("PageNo");
        String string4 = (String)map.get("PageNo");
        String string5 = element.attributeValue("PageName");
        String string6 = (String)map.get("PageName");
        double d = Double.parseDouble(element.attributeValue("Width"));
        double d2 = Double.parseDouble(element.attributeValue("Height"));
        double d3 = 338.0 / d;
        double d4 = 486.0 / d2;
        String string7 = CMyFile.extractMainFileName(string);
        Element element2 = null;
        com.trs.components.wcm.content.persistent.Document document2 = null;
        int n = channel.getId();
        int n2 = 1;
        String string8 = null;
        String string9 = null;
        int n3 = list.size();
        for (int i = n3 - 1; i >= 0; --i) {
            element2 = (Element)list.get(i);
            document2 = new com.trs.components.wcm.content.persistent.Document();
            document2.setChannel(n);
            document2.setStatus(n2);
            document2.setType(20);
            this.copyProps(document2, element2, map);
            this.processDocSource(document2);
            document2.setPropertyWithString(string4, string3);
            document2.setPropertyWithString(string6, string5);
            document2.setPropertyWithString("PDF", string7 + ".pdf");
            document2.setPropertyWithString("PICSRC", string7 + ".gif");
            document2.setReleaseTime(CMyDateTime.now());
            this.processMapCoords(document2, element2, d3, d4);
            string8 = document2.getContent();
            string8 = CMyString.isEmpty(string8) ? "\u65e0\u5185\u5bb9" : "<p class='trsp-indent'>" + string8.replaceAll("\n", "\n</p><p class='trsp-indent'>");
            document2.setHtmlContent(string8);
            string9 = document2.getTitle();
            if (CMyString.isEmpty(string9)) {
                document2.setTitle("\u65e0\u6807\u9898");
            }
            document2 = this.m_documentMgr.save(document2);
            this.processAppendix(document2, element2, string2);
        }
    }

    private void processMapCoords(com.trs.components.wcm.content.persistent.Document document, Element element, double d, double d2) throws WCMException {
        List list = element.selectNodes("PointList/Point");
        StringBuffer stringBuffer = new StringBuffer(128);
        Element element2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            element2 = (Element)list.get(i);
            n = Integer.parseInt(element2.attributeValue("X"));
            stringBuffer.append((int)((double)n * d));
            stringBuffer.append(",");
            n2 = Integer.parseInt(element2.attributeValue("Y"));
            stringBuffer.append((int)((double)n2 * d2));
            stringBuffer.append(",");
        }
        document.setPropertyWithString("MAPCOORDS", stringBuffer.substring(0, stringBuffer.length() - 1));
    }

    private void processAppendix(com.trs.components.wcm.content.persistent.Document document, Element element, String string) throws Exception {
        List list = element.selectNodes("ImageList/Image");
        if (list != null && list.size() > 0) {
            User user = ContextHelper.getLoginUser();
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = "W0";
            int n = document.getId();
            String string3 = CMyString.setStrEndWith(string, File.separatorChar);
            string3 = string3 + "images" + File.separator;
            Element element2 = null;
            Appendix appendix = null;
            String string4 = null;
            String string5 = null;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                element2 = (Element)list.get(i);
                string4 = element2.attributeValue("Name");
                appendix = new Appendix();
                appendix.setDocId(n);
                appendix.setAlt(string4);
                appendix.setSrcFile(string4);
                string5 = element2.getText();
                string5 = CMyString.isEmpty(string5) ? string4 : string5.trim();
                appendix.setDesc(string5);
                appendix.setSerialNo(i + 1);
                try {
                    string4 = filesMan.moveFile(string3 + string4, string2, false);
                    appendix.setFile(string4);
                }
                catch (Exception exception) {
                    s_logger.warn((Object)("missing file:" + string3 + string4), (Throwable)exception);
                    continue;
                }
                appendix.setFileExt(CMyFile.extractFileExt(string4));
                appendix.setFlag(20);
                appendix.setUsedByVersion(document.getVersion(), true);
                appendix.setAuthor(element2.attributeValue("Author"));
                appendix.insert(user);
            }
        }
    }

    private void copyProps(com.trs.components.wcm.content.persistent.Document document, Element element, Map map) throws Exception {
        Iterator iterator = map.keySet().iterator();
        String string = null;
        String string2 = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = element.elementText(string);
            if (CMyString.isEmpty(string2)) continue;
            document.setPropertyWithString((String)map.get(string), string2.trim());
        }
    }

    private com.trs.components.wcm.content.persistent.Document processDocSource(com.trs.components.wcm.content.persistent.Document document) throws WCMException {
        String string = document.getPropertyAsString("DOCSOURCE");
        if (CMyString.isEmpty(string)) {
            return document;
        }
        WCMFilter wCMFilter = new WCMFilter("", "SRCNAME=?", "");
        wCMFilter.addSearchValues(0, string);
        wCMFilter.setMaxRowNumber(1);
        Sources sources = new Sources(null);
        sources.open(wCMFilter);
        Source source = null;
        if (sources.isEmpty()) {
            source = new Source();
            source.setName(string);
            source.insert(User.getSystem());
        } else {
            source = (Source)sources.getAt(0);
        }
        document.setSource(source);
        return document;
    }

    private String mapFile(String string) throws WCMException {
        if (!CMyFile.fileExists(string)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.mapFilePath(string, 0);
            return string2 + string;
        }
        return string;
    }

    private String mapTcfFile(String string) {
        if (!CMyString.isEmpty(string) && CMyFile.fileExists(string)) {
            return string;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getPathConfigValue("DS", 0);
        string2 = CMyString.setStrEndWith(string2, File.separatorChar);
        string2 = string2 + "importresource" + File.separator;
        if (CMyString.isEmpty(string)) {
            string2 = string2 + "xplus.tcf";
            return string2;
        }
        User user = ContextHelper.getLoginUser();
        string2 = string2 + user.getName() + user.getId() + File.separator + string;
        return string2;
    }

    private Map parseTcf(String string) throws Exception {
        if (CMyString.isEmpty(string) && DEFAULT_TAGS.size() > 0) {
            return DEFAULT_TAGS;
        }
        String string2 = this.mapTcfFile(string);
        Document document = XmlDocWithDom4j.parse(string2);
        List list = document.selectSingleNode("custom-setings").selectNodes("ref");
        HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
        Iterator iterator = list.iterator();
        Element element = null;
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (element == null) continue;
            hashMap.put(element.attributeValue("tag-name"), element.attributeValue("tag-value"));
        }
        list.clear();
        if (DEFAULT_TAGS.size() == 0) {
            DEFAULT_TAGS.putAll(hashMap);
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "e:\\1.xml";
            Document document = XmlDocWithDom4j.parse(string);
            Element element = (Element)document.selectNodes("/PageInfoFile/ArticleList/Article").get(0);
            String string2 = element.selectSingleNode("Content").getText();
            System.out.println(string2);
            System.out.println();
            System.out.println(string2.trim().replaceAll("\n", "\n<p>"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

