/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.epress.EpressFolderWrapper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;

public class EPressHistoryGenerator {
    private Channel m_oChannel = null;
    private boolean m_zPubAction = true;

    public EPressHistoryGenerator(Channel channel) {
        this(channel, true);
    }

    public EPressHistoryGenerator(Channel channel, boolean bl) {
        this.m_oChannel = channel;
        this.m_zPubAction = bl;
    }

    public void generate() throws WCMException {
        this.generate(CMyDateTime.now());
    }

    public void generate(CMyDateTime cMyDateTime) throws WCMException {
        if (this.m_oChannel == null) {
            throw new WCMException(20, "\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053,\u4e0d\u80fd\u4ea7\u751f\u5386\u53f2\u6570\u636e!");
        }
        ContextHelper.initContext(User.getSystem());
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        if (!iPublishFolder.canDoOutlinePageTask()) {
            return;
        }
        EpressFolderWrapper epressFolderWrapper = new EpressFolderWrapper(iPublishFolder, cMyDateTime);
        PublishTask publishTask = null;
        if (this.m_zPubAction) {
            publishTask = new PublishTask();
        }
        PublishTaskContext publishTaskContext = new PublishTaskContext(publishTask, epressFolderWrapper);
        PublishPageContext publishPageContext = new PublishPageContext(epressFolderWrapper, publishTaskContext);
        if (cMyDateTime != null) {
            publishPageContext.setExtraAttribute("HISTORYDATE", cMyDateTime.toString());
        }
        PageGenerator.generateOutlines(publishPageContext);
    }

    public static void main(String[] stringArray) {
        try {
            Channel channel = Channel.findById(510);
            EPressHistoryGenerator ePressHistoryGenerator = new EPressHistoryGenerator(channel);
            CMyDateTime cMyDateTime = CMyDateTime.now();
            cMyDateTime.setDateWithString("2007-03-04", 0);
            ePressHistoryGenerator.generate(cMyDateTime);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

