/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Right;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RightLCListenerForSynSiteMember
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    private static Logger logger = Logger.getLogger(RightLCListenerForSynSiteMember.class);
    private SiteMemberMgr m_oSiteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        Right right = (Right)baseObj;
        if (right.getValueAsLong() <= 0L || right.getObjType() != 101 && right.getObjType() != 103) {
            return;
        }
        this.addSiteMemberIfNecessary(right);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        long l;
        if (!(baseObj instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        Right right = (Right)baseObj;
        if (!right.isChangeProperty("RIGHTVALUE") || right.getObjType() != 101 && right.getObjType() != 103) {
            return;
        }
        Object object = right.getNewProperty("RIGHTVALUE");
        long l2 = l = object == null ? 0L : ((Number)object).longValue();
        if (right.getValueAsLong() <= 0L && l > 0L) {
            this.addSiteMemberIfNecessary(right);
            return;
        }
        if (right.getValueAsLong() > 0L && l <= 0L) {
            this.deleteSiteMemberIfNecessary(right);
            return;
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        Right right = (Right)baseObj;
        if (right.getValueAsLong() <= 0L || right.getObjType() != 101 && right.getObjType() != 103) {
            return;
        }
        this.deleteSiteMemberIfNecessary(right);
    }

    private void addSiteMemberIfNecessary(Right right) throws WCMException {
        int n = this.getSiteId(right);
        if (n > 0) {
            this.m_oSiteMemberMgr.addSiteMember(n, right.getOperatorType(), right.getOperatorId());
        }
    }

    private void deleteSiteMemberIfNecessary(Right right) throws WCMException {
        int n = this.getSiteId(right);
        if (this.isHasRightOnSite(right.getId(), right.getOperatorType(), right.getOperatorId(), n)) {
            return;
        }
        this.m_oSiteMemberMgr.removeSiteMember(n, right.getOperatorType(), right.getOperatorId());
    }

    private int getSiteId(Right right) throws WCMException {
        int n = right.getObjId();
        if (101 == right.getObjType()) {
            Channel channel = Channel.findById(n);
            n = channel != null ? channel.getSiteId() : 0;
        }
        return n;
    }

    /*
     * Loose catch block
     */
    private boolean isHasRightOnSite(int n, int n2, int n3, int n4) throws WCMException {
        block24: {
            Exception exception422;
            String string;
            ResultSet resultSet;
            block23: {
                DBManager dBManager;
                PreparedStatement preparedStatement;
                Connection connection;
                block20: {
                    Exception exception2222;
                    boolean bl;
                    block21: {
                        connection = null;
                        preparedStatement = null;
                        resultSet = null;
                        dBManager = DBManager.getDBManager();
                        string = "select RightId from WCMRight where RightId <>? and RightValue>0 and OprType=? and OprId=? and ( (ObjType=103 and ObjId=?) or (ObjType=101 and exists(select ChannelId from WCMChannel where SiteId=? and  WCMRight.ObjId=ChannelId) ) )";
                        connection = dBManager.getConnection();
                        preparedStatement = connection.prepareStatement(string);
                        preparedStatement.setMaxRows(1);
                        preparedStatement.setInt(1, n);
                        preparedStatement.setInt(2, n2);
                        preparedStatement.setInt(3, n3);
                        preparedStatement.setInt(4, n4);
                        preparedStatement.setInt(5, n4);
                        resultSet = preparedStatement.executeQuery();
                        if (!resultSet.next()) break block20;
                        bl = true;
                        Object var12_13 = null;
                        if (connection != null) {
                            dBManager.freeConnection(connection);
                        }
                        if (preparedStatement == null) break block21;
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                try {
                    Object var12_14 = null;
                    if (connection != null) {
                        dBManager.freeConnection(connection);
                    }
                    if (preparedStatement == null) break block23;
                }
                catch (Throwable throwable) {
                    Exception exception3222;
                    Object var12_15 = null;
                    if (connection != null) {
                        dBManager.freeConnection(connection);
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception3222) {
                            // empty catch block
                        }
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception3222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    preparedStatement.close();
                }
                catch (Exception exception422) {
                    // empty catch block
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception422) {}
            }
            break block24;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label4", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, sQLException);
                }
                catch (Exception exception5) {
                    throw new WCMException(I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label4", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, exception5);
                }
            }
        }
        return false;
    }
}

