/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Relation;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import java.util.ArrayList;
import java.util.List;

public class RelationMgr {
    public void saveRelations(Document document, List list) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label1", "\u6587\u6863\u4e3a\u7a7a\uff01"));
        }
        if (list == null) {
            return;
        }
        this.deleteUnuseRelations(this.makeUseingIds(document, list), document);
        if (list.isEmpty()) {
            return;
        }
        if (document.getId() == 0) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label2", "\u6587\u6863ID\u65e0\u6548\uff01"));
        }
        Relation relation = null;
        for (int i = 1; i <= list.size(); ++i) {
            relation = (Relation)list.get(i - 1);
            if (relation == null) continue;
            if (relation.isAddMode()) {
                relation.setDocId(document.getId());
                relation.insert(ContextHelper.getLoginUser());
                continue;
            }
            relation.update(ContextHelper.getLoginUser());
        }
    }

    public Relations getRelations(Document document) throws WCMException {
        return this.getRelations(document, null);
    }

    public Relations getRelations(Document document, WCMFilter wCMFilter) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label3", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u5176\u76f8\u5173\u5bf9\u8c61\u96c6\u5408!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "DocId=" + document.getDocId(), "SERN");
        wCMFilter2.mergeWith(wCMFilter);
        try {
            Relations relations = new Relations(ContextHelper.getLoginUser());
            relations.open(wCMFilter2);
            return relations;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(RelationMgr.class, "RelationMgr.label4", "\u83b7\u53d6\u6587\u6863\u7684\u76f8\u5173\u5bf9\u8c61\u96c6\u5408\u5931\u8d25!"), wCMException);
        }
    }

    public List copyRelationListByObj(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label5", "\u67e5\u8be2\u9644\u4ef6\u65f6\uff0c\u5bbf\u4e3b\u5bf9\u8c61\uff08\u6587\u6863\uff09\u4e3a\u7a7a\uff01"));
        }
        Relations relations = Relations.findRelationsByObj(baseObj);
        ArrayList<BaseObj> arrayList = new ArrayList<BaseObj>();
        if (relations == null || relations.isEmpty()) {
            return arrayList;
        }
        for (int i = 0; i < relations.size(); ++i) {
            arrayList.add(relations.getAt(i).cloneToNewObj());
        }
        return arrayList;
    }

    public void copyRelations(Document document, Document document2) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label6", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u5176\u76f8\u5173\u6587\u6863\uff01"));
        }
        if (document2 == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label7", "\u76ee\u6807\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u76f8\u5173\u6587\u6863\uff01"));
        }
        this.saveRelations(document2, this.copyRelationListByObj(document));
    }

    private String makeUseingIds(Document document, List list) throws WCMException {
        if (list == null) {
            return null;
        }
        if (document == null) {
            throw new WCMException(20, I18NMessage.get(RelationMgr.class, "RelationMgr.label8", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u76f8\u5173\u6587\u6863\uff01"));
        }
        String string = "0";
        Relation relation = new Relation();
        for (int i = 0; i < list.size(); ++i) {
            relation = (Relation)list.get(i);
            if (relation == null) continue;
            string = string + "," + relation.getId();
        }
        return string;
    }

    public void deleteUnuseRelations(String string, Document document) throws WCMException {
        if (document == null || string == null || string.length() <= 0) {
            return;
        }
        String string2 = "DOCID=?";
        if (!"0".equals(string)) {
            string2 = string2 + " and RELATIONID not in (" + string + ")";
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "", "");
        wCMFilter.addSearchValues(document.getId());
        Relations relations = new Relations(ContextHelper.getLoginUser());
        relations.open(wCMFilter);
        if (!relations.isEmpty()) {
            relations.removeAll(true);
        }
    }

    public Relations getRelations(WCMFilter wCMFilter) throws WCMException {
        if (wCMFilter == null) {
            throw new WCMException(20, I18NMessage.get(RelationMgr.class, "RelationMgr.label9", "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        return Relations.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public void deleteRelations(Document document) throws WCMException {
        this.getRelations(document).removeAll();
    }
}

