/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.engine.FlowContext;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.domain.IDocKeywordMgr;
import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.components.wcm.publish.logo.Logos;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.TableInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DocumentMgr {
    private static Logger m_oLogger = Logger.getLogger(DocumentMgr.class);
    private static final String CONFIG_COPY_TITLE_PREFIX = "DOC_COPY_TITLE_PRE";
    private IDocKeywordMgr m_oDocKeywordMgr = (IDocKeywordMgr)DreamFactory.createObjectById("IDocKeywordMgr");
    private IDocumentsTimeRangeMgr m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;
    public static final int POSITION_AFTER_NEW = -1;

    private void delete(ChnlDoc chnlDoc, boolean bl) throws WCMException {
        if (chnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label1", "\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (bl) {
            chnlDoc.delete(this.getLoginUser());
        } else if (chnlDoc.canEdit(this.getLoginUser())) {
            chnlDoc.setDeleted(true);
            chnlDoc.setOperUser(this.getLoginUser());
            chnlDoc.setOperTime();
            chnlDoc.update(this.getLoginUser());
        }
    }

    private void delete(Document document, boolean bl) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label1", "\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (bl) {
            document.delete(this.getLoginUser());
        } else if (document.canEdit(this.getLoginUser())) {
            document.setDeleted(true);
            document.update(this.getLoginUser());
        }
    }

    private ChnlDoc moveTo(ChnlDoc chnlDoc, Channel channel) throws WCMException {
        User user = this.getLoginUser();
        if (!chnlDoc.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label2", "\u5bf9\u8c61\u5df2\u88ab[") + chnlDoc.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label3", "]\u9501\u5b9a\uff01"));
        }
        String string = "SELECT MAX(DocOrder) FROM WCMCHNLDOC WHERE ChnlId=" + channel.getId();
        int n = this.getDBManager().sqlExecuteIntQuery(string);
        chnlDoc.setDocOrder(n + 1);
        chnlDoc.setDocOrderPri(ChnlDoc.NOT_ON_TOP);
        chnlDoc.setChannelId(channel.getId());
        chnlDoc.setInvalidTime(null);
        chnlDoc.save(user);
        return chnlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Document document, Channel channel, boolean bl) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label4", "\u6587\u6863\u65e0\u6548\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Channel channel2 = channel;
        if (channel2 == null) {
            channel2 = document.getChannel();
        }
        if (channel2 == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label5", "\u9891\u9053\u65e0\u6548\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        boolean bl2 = document.getChannelId() == channel2.getId();
        User user = this.getLoginUser();
        if (bl2 && document.isLocked()) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label6", "\u6587\u6863[") + document.getTitle() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label7", "]\u5df2\u88ab[") + document.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label8", "]\u9501\u5b9a,\u65e0\u6cd5\u5220\u9664!"));
        }
        try {
            if (bl && bl2) {
                if (channel2.getId() == 0) {
                    this.delete(document, bl);
                } else {
                    this.getChnlDocs(document.getId(), 0, null).removeAll(true);
                }
            } else if (channel2.getId() == 0) {
                this.delete(document, bl);
            } else {
                ChnlDoc chnlDoc = this.findChnlDoc(document, channel2);
                if (chnlDoc == null) {
                    throw new WCMException(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label9", "\u6ca1\u6709\u627e\u5230\u9884\u5220\u9664\u7684\u9891\u9053\u6587\u6863!") + channel2 + ":" + document);
                }
                this.delete(chnlDoc, bl);
            }
        }
        finally {
            if (bl2 && document.isLocked() && document.getLocker().lockUserIs(user)) {
                document.unlock();
            }
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private boolean isDocumentLink(Document document, Channel channel) throws WCMException {
        if (document == null) {
            throw new WCMException(20, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label10", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u8f6c\u53d1\uff01"));
        }
        if (channel == null || channel.getId() == 0) {
            return false;
        }
        return document.getChannelId() != channel.getId();
    }

    public ChnlDoc findChnlDoc(Document document, Channel channel) throws WCMException {
        return ChnlDoc.findByDocAndChnl(document, channel);
    }

    ChnlDoc createChnlDocWithEntity(Document document, Channel channel, boolean bl) throws WCMException {
        int n;
        int n2;
        ChnlDoc chnlDoc = new ChnlDoc();
        chnlDoc.setDocId(document.getId());
        int n3 = document.getChannelId();
        int n4 = 1;
        if (channel != null && n3 != channel.getId()) {
            n2 = channel.getType();
            n4 = bl || n2 == 2 || n2 == 1 ? 2 : 3;
            n3 = channel.getId();
        }
        chnlDoc.setModal(n4);
        chnlDoc.setChannelId(n3);
        chnlDoc.setStatusId(document.getStatusId());
        if (n4 != 1) {
            WCMPubStatusConfig wCMPubStatusConfig = WCMPubStatusConfig.findOf(103, Channel.findById(n3).getSiteId());
            int n5 = 2;
            if (wCMPubStatusConfig != null && (n = wCMPubStatusConfig.getStatusIdAfterModify()) != 0) {
                n5 = n;
            }
            chnlDoc.setStatusId(n5);
        }
        n2 = 0;
        if (channel != null) {
            n2 = channel.getSiteId();
        }
        chnlDoc.setSiteId(n2);
        String string = "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE ChnlId=" + n3;
        n = this.getDBManager().sqlExecuteIntQuery(string);
        chnlDoc.setDocOrder(++n);
        if (!Document.SYNCHRONIZE_PROPERTIES_TO_CHNLDOC) {
            return chnlDoc;
        }
        String string2 = null;
        for (int i = 0; i < Document.SYNCHRONIZED_FIELDS.length; ++i) {
            string2 = Document.SYNCHRONIZED_FIELDS[i];
            chnlDoc.setProperty(string2, document.getProperty(string2));
        }
        return chnlDoc;
    }

    private Report transmitTo(Document document, Channel channel, boolean bl) throws WCMException {
        return this.transmitTo(document, channel, bl, "false");
    }

    private Report transmitTo(Document document, Channel channel, boolean bl, String string) throws WCMException {
        String string2 = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label105", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string2 = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label106", "\u56fe\u7247");
        }
        if (document == null) {
            throw new WCMException(20, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label11", "{0}\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{string2}));
        }
        if (channel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label12", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        if (channel.getStatus() < 0) {
            return null;
        }
        if (document.getStatusId() == 1028) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label121", "{1}[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{document.getTitle(), string2}));
        }
        Report report = null;
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc != null) {
            report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label101", "{0}\u5f15\u7528{5}[{1}][ID={2}]\u5230\u680f\u76ee[{3}][ID={4}]\u5931\u8d25\uff01"), new String[]{bl ? I18NMessage.get(DocumentMgr.class, "DocumentMgr.label13", "\u94fe\u63a5") : I18NMessage.get(DocumentMgr.class, "DocumentMgr.label14", "\u955c\u50cf"), document.getTitle(), String.valueOf(document.getId()), channel.getDispDesc(), String.valueOf(channel.getId()), string2}));
            report.setRportDetail(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label18", "\u7531\u4e8e\u5f15\u7528\u5728") + (chnlDoc.isDeleted() ? I18NMessage.get(DocumentMgr.class, "DocumentMgr.label19", "\u5e9f\u7a3f\u7bb1") : I18NMessage.get(DocumentMgr.class, "DocumentMgr.label20", "\u76ee\u6807\u680f\u76ee")) + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label21", "\u4e2d\u5df2\u7ecf\u5b58\u5728\uff01"));
            report.setType(5);
            return report;
        }
        ChnlDoc chnlDoc2 = this.createChnlDocWithEntity(document, channel, bl);
        chnlDoc2.save(this.getLoginUser());
        report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label102", "{0}\u5f15\u7528{5}[{1}][ID={2}]\u5230\u680f\u76ee[{3}][ID={4}]\u6210\u529f\uff01"), new String[]{bl ? I18NMessage.get(DocumentMgr.class, "DocumentMgr.label13", "\u94fe\u63a5") : I18NMessage.get(DocumentMgr.class, "DocumentMgr.label14", "\u955c\u50cf"), document.getTitle(), String.valueOf(document.getId()), channel.getDispDesc(), String.valueOf(channel.getId()), string2}));
        return report;
    }

    public Status getDocStatus(Document document, int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", "DocId=" + document.getId() + " and ChnlId=" + n, "");
        wCMFilter.setMaxRowNumber(1);
        try {
            ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(this.getLoginUser(), wCMFilter);
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(0);
            return chnlDoc.getStatus();
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label23", "\u83b7\u53d6\u6587\u6863\u7684ChnlDoc\u5931\u8d25!"));
        }
    }

    public void changeStatus(Document document, Channel channel, Status status) throws WCMException {
        if (status == null) {
            throw new WCMException(10, "New status required!");
        }
        this.changeStatus(document, channel, status.getId());
    }

    public void changeStatus(Document document, Channel channel, int n) throws WCMException {
        if (document == null || channel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label24", "\u6587\u6863\u3001\u9891\u9053\u6216\u8005\u72b6\u6001\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\u6587\u6863\u72b6\u6001\uff01"));
        }
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        this.changeStatus(n, chnlDoc);
    }

    public void changeStatus(int n, ChnlDoc chnlDoc) throws WCMException {
        if (chnlDoc == null) {
            return;
        }
        if (chnlDoc.getStatusId() == n) {
            return;
        }
        User user = this.getLoginUser();
        if (chnlDoc.canEdit(user)) {
            boolean bl;
            boolean bl2 = bl = 10 == chnlDoc.getStatusId();
            if (bl) {
                chnlDoc.setDocPubTime(new CMyDateTime());
            }
            chnlDoc.setStatusId(n);
            chnlDoc.save(user);
        }
        if (chnlDoc.isEntity() && chnlDoc.getStatusId() == 10) {
            DBManager dBManager = this.getDBManager();
            String string = "update WCMDocument set DOCPUBTIME=NULL where DocId=" + chnlDoc.getDocId();
            dBManager.sqlExecuteUpdate(string);
        }
    }

    public Documents getAllDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label25", "\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\u6216\u9891\u9053"));
        }
        WCMFilter wCMFilter2 = this.getFilterForDocuments(baseChannel, wCMFilter);
        try {
            return Documents.openWCMObjs(this.getLoginUser(), wCMFilter2);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)"failed to get documents.", (Throwable)wCMException);
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label26", "\u83b7\u53d6\u9891\u9053\u7684\u6587\u6863\u96c6\u5408\u5931\u8d25"), wCMException);
        }
    }

    public Documents getDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        Object object;
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label27", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61"));
        }
        boolean bl = false;
        if (wCMFilter != null && (wCMFilter.getOrder() != null && wCMFilter.getOrder().length() > 0 || wCMFilter.getWhere() != null && wCMFilter.getWhere().length() > 0)) {
            bl = wCMFilter.getWhere() == null || wCMFilter.getWhere().length() <= 0 ? (object = wCMFilter.getOrder()) != null && ((String)object).trim().length() > 0 && ((String)object).toUpperCase().indexOf("DOCTITLE") > 0 : true;
        } else if (!baseChannel.isSite()) {
            object = (Channel)baseChannel;
            String string = ((Channel)object).getOrderBy();
            bl = string != null && string.trim().length() > 0 && string.toUpperCase().indexOf("DOCTITLE") > 0;
        }
        object = null;
        if (baseChannel.isSite()) {
            object = new WCMFilter("", "WCMDOCUMENT.DocStatus>0 and DocChannel>0", "");
        } else {
            if (!bl && Document.DOCUMENTS_GET_OPTIMIZE) {
                return DocumentsGetHelper.getDocuments((Channel)baseChannel, wCMFilter);
            }
            object = new WCMFilter("", "WCMCHNLDOC.DocStatus>0 and WCMCHNLDOC.DocChannel>0 and WCMDocument.DocStatus>0", "");
        }
        ((WCMFilter)object).mergeWith(wCMFilter);
        return this.getAllDocuments(baseChannel, (WCMFilter)object);
    }

    public Documents getRecycleDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = null;
        wCMFilter2 = baseChannel.isSite() ? new WCMFilter("", "WCMDocument.DOCSTATUS<0", "") : new WCMFilter("", "(WCMCHNLDOC.DOCSTATUS<0  OR WCMCHNLDOC.Modal<0)", "");
        wCMFilter2.mergeWith(wCMFilter);
        return this.getAllDocuments(baseChannel, wCMFilter2);
    }

    public WCMFilter getFilterForDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        if (baseChannel.isSite()) {
            return this.makeFilterForSite((WebSite)baseChannel, wCMFilter);
        }
        return this.makeFilterForChannel((Channel)baseChannel, wCMFilter);
    }

    private WCMFilter makeFilterForSite(WebSite webSite, WCMFilter wCMFilter) {
        String string = "EXISTS(SELECT  CHANNELID FROM WCMCHANNEL where SiteId=? and Status=0 and CHANNELID=WCMDOCUMENT.DOCCHANNEL)";
        String string2 = webSite.getOrderBy();
        if (string2 == null) {
            string2 = "DocId DESC";
        }
        WCMFilter wCMFilter2 = new WCMFilter("", string, string2);
        wCMFilter2.addSearchValues(0, webSite.getId());
        CMyDateTime cMyDateTime = this.m_oTimeRangeMgr.getStartDateTime(webSite.getId(), 103);
        if (cMyDateTime != null) {
            string = string + " and CrTime >= ?";
            wCMFilter2.setWhere(string);
            wCMFilter2.addSearchValues(1, cMyDateTime);
        }
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    private WCMFilter makeFilterForChannel(Channel channel, WCMFilter wCMFilter) throws WCMException {
        CMyDateTime cMyDateTime;
        String string;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = channel.getQuery();
        boolean bl2 = bl = !channel.isOnlySearch();
        if (bl) {
            stringBuffer.append("WCMCHNLDOC").append(".CHNLID=?");
            stringBuffer.append(" AND ");
        }
        stringBuffer.append("WCMCHNLDOC").append(".DOCID=");
        stringBuffer.append("WCMDOCUMENT").append(".DOCID");
        if (!CMyString.isEmpty(string2)) {
            stringBuffer.append(" AND (").append(string2).append(')');
        }
        if (channel.isOnlySearch()) {
            stringBuffer.append(" AND (").append("WCMCHNLDOC").append(".MODAL=").append(1).append(')');
        }
        String string3 = stringBuffer.toString();
        stringBuffer.setLength(0);
        String string4 = string3.toUpperCase();
        if (string4.indexOf("SRCCHNLID=0") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "SRCCHNLID=0", "MODAL=1");
        }
        if (string4.indexOf("WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID", "1=1");
        }
        if (((string = channel.getOrderBy()) == null || string.trim().length() == 0) && (string = channel.getSite().getOrderBy()) == null) {
            string = "";
        }
        IMetaViewEmployerMgr iMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        MetaView metaView = iMetaViewEmployerMgr.getViewOfEmployer(channel);
        WCMFilter wCMFilter2 = null;
        wCMFilter2 = metaView != null ? new WCMFilter("WCMChnlDoc," + metaView.getTrueTableName(), string3, string) : new WCMFilter("", string3, string);
        int n = 0;
        if (bl) {
            wCMFilter2.addSearchValues(n++, channel.getId());
        }
        if ((cMyDateTime = this.m_oTimeRangeMgr.getStartDateTime(channel.getId())) != null) {
            if (string3.length() > 0) {
                string3 = string3 + " and ";
            }
            string3 = string3 + "DocRelTime >= ?";
            wCMFilter2.setWhere(string3);
            wCMFilter2.addSearchValues(n, cMyDateTime);
        }
        wCMFilter2.mergeWith(wCMFilter);
        return this.analyseFilterForChannel(wCMFilter2);
    }

    private WCMFilter analyseFilterForChannel(WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter(wCMFilter);
        String string = wCMFilter.getSelect();
        String string2 = wCMFilter.getFrom();
        String string3 = wCMFilter.getWhere();
        String string4 = wCMFilter.getOrder();
        try {
            string = this.filterSelectForChannel(string);
            wCMFilter2.setSelect(string);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label28", "\u91cd\u6574Select\u8bed\u53e5\u5931\u8d25\uff01"), exception);
        }
        string2 = this.filterFromForChannel(string2);
        wCMFilter2.setFrom(string2);
        try {
            string3 = this.filterWhereForChannel(string3);
            wCMFilter2.setWhere(string3);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label29", "\u91cd\u6574where\u8bed\u53e5\u5931\u8d25\uff01"), exception);
        }
        try {
            string4 = this.filterOrderForChannel(string4);
            wCMFilter2.setOrder(string4);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label30", "\u91cd\u6574Order\u8bed\u53e5\u5931\u8d25\uff01"), exception);
        }
        return wCMFilter2;
    }

    private String filterSelectForChannel(String string) throws Exception {
        DBManager dBManager = DBManager.getDBManager();
        TableInfo tableInfo = dBManager.getTableInfo("WCMDOCUMENT");
        if (tableInfo == null) {
            return "*";
        }
        TableInfo tableInfo2 = dBManager.getTableInfo("WCMCHNLDOC");
        if (tableInfo2 == null) {
            return "*";
        }
        String string2 = string;
        if (string2 != null && string2.length() > 0) {
            Enumeration enumeration = tableInfo2.getFieldNames();
            String string3 = "";
            do {
                string3 = (String)enumeration.nextElement();
                string2 = this.filterExpression(string2, string3, "WCMDOCUMENT");
            } while (enumeration.hasMoreElements());
        }
        return string2;
    }

    private String filterFromForChannel(String string) {
        if (string == null || string.length() <= 0) {
            return "WCMCHNLDOC,WCMDOCUMENT";
        }
        String string2 = string.toUpperCase();
        boolean bl = false;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        do {
            String string3;
            String string4;
            if ((string4 = (string3 = (String)stringTokenizer.nextElement()).trim().toUpperCase()).equals("WCMCHNLDOC")) {
                bl = true;
                continue;
            }
            if (!string4.equals("WCMDOCUMENT")) continue;
            bl2 = true;
        } while (stringTokenizer.hasMoreElements());
        if (!bl) {
            string2 = string2 + ",WCMCHNLDOC";
        }
        if (!bl2) {
            string2 = string2 + ",WCMDOCUMENT";
        }
        return string2;
    }

    private String filterWhereForChannel(String string) throws Exception {
        if (string == null || string.trim().length() <= 0) {
            return "";
        }
        DBManager dBManager = DBManager.getDBManager();
        TableInfo tableInfo = dBManager.getTableInfo("WCMDOCUMENT");
        if (tableInfo == null) {
            return string;
        }
        TableInfo tableInfo2 = dBManager.getTableInfo("WCMCHNLDOC");
        if (tableInfo2 == null) {
            return string;
        }
        String string2 = string;
        Enumeration enumeration = tableInfo2.getFieldNames();
        String string3 = "";
        do {
            string3 = (String)enumeration.nextElement();
            string2 = this.filterExpression(string2, string3, "WCMCHNLDOC");
        } while (enumeration.hasMoreElements());
        return string2;
    }

    private String filterOrderForChannel(String string) throws Exception {
        String string2 = "";
        DBManager dBManager = DBManager.getDBManager();
        if (ChnlDoc.IS_ORDER_BY_PRI) {
            string2 = "WCMCHNLDOC.DOCORDERPRI desc,";
        }
        string2 = string2 + "WCMCHNLDOC.DOCORDER desc ";
        if (string == null || string.length() == 0) {
            return string2;
        }
        TableInfo tableInfo = dBManager.getTableInfo("WCMDOCUMENT");
        if (tableInfo == null) {
            return string2;
        }
        TableInfo tableInfo2 = dBManager.getTableInfo("WCMCHNLDOC");
        if (tableInfo2 == null) {
            return string2;
        }
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = -1;
        do {
            String string4 = (String)stringTokenizer.nextElement();
            string4 = string4.trim();
            ++n;
            int n2 = string4.indexOf(" ");
            String string5 = "";
            String string6 = "";
            if (n2 < 0) {
                string5 = string4;
                string6 = "asc";
            } else {
                string5 = string4.substring(0, n2).toUpperCase();
                string6 = string4.substring(n2).toUpperCase();
            }
            int n3 = string5.indexOf(".");
            if (n3 >= 0) {
                if (n > 0) {
                    string3 = string3 + "," + string5 + " " + string6;
                    continue;
                }
                string3 = string5 + " " + string6;
                continue;
            }
            if (tableInfo.getFieldInfo(string5) != null) {
                string5 = "WCMDOCUMENT." + string5;
            } else if (tableInfo2.getFieldInfo(string5) != null) {
                string5 = "WCMCHNLDOC." + string5;
            } else {
                Exception exception = new Exception(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label31", "\u5b57\u6bb5\u4e0d\u5b58\u5728!"));
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label32", "\u6307\u5b9a\u7684\u6392\u5e8f\u5b57\u6bb5[") + string5 + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label33", "]\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!"), exception);
            }
            string3 = n > 0 ? string3 + "," + string5 + " " + string6 : string5 + " " + string6;
        } while (stringTokenizer.hasMoreElements());
        return string3;
    }

    private String filterExpression(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        String string4 = string;
        String string5 = string2.toUpperCase();
        int n = string5.length();
        int n2 = 0;
        do {
            char c;
            int n3;
            String string6;
            if ((n2 = (string6 = string4.toUpperCase()).indexOf(string5, n2)) < 0) {
                return string4;
            }
            if (n2 > 0) {
                n3 = string6.charAt(n2 - 1);
                if (n3 >= 65 && n3 <= 90) continue;
                if (n3 == 46) {
                    n2 += n;
                    continue;
                }
            }
            if ((n3 = n2 + n) < string6.length() && (c = string6.charAt(n3)) >= 'A' && c <= 'Z') {
                n2 += n;
                continue;
            }
            String string7 = string3 + "." + string5;
            string4 = string4.substring(0, n2) + string7 + string4.substring(n3);
            n2 += string7.length();
        } while (n2 >= 0 && n2 < string4.length());
        return string4;
    }

    public int getMaxToppedNum() {
        try {
            ConfigServer configServer = ConfigServer.getServer();
            String string = configServer.getSysConfigValue("PRI_DOCS_SIZE", "");
            if ("".equals(string)) {
                return ChnlDoc.PRI_DOCS_SIZE;
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return ChnlDoc.PRI_DOCS_SIZE;
        }
    }

    public boolean isTopEnabled() {
        try {
            ConfigServer configServer = ConfigServer.getServer();
            String string = configServer.getSysConfigValue("IS_ORDER_BY_PRI", "");
            if ("".equals(string)) {
                return ChnlDoc.IS_ORDER_BY_PRI;
            }
            return Boolean.getBoolean(string);
        }
        catch (Exception exception) {
            return ChnlDoc.IS_ORDER_BY_PRI;
        }
    }

    public Documents getToppedDocuments(Channel channel, WCMFilter wCMFilter) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label34", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u4e0b\u7684\u7f6e\u9876\u6587\u6863\u96c6\u5408!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "WCMCHNLDOC.DOCORDERPRI>0", "");
        return this.getDocuments(channel, wCMFilter2.mergeWith(wCMFilter));
    }

    public boolean isDocumentTopped(Document document, Channel channel) throws WCMException {
        if (channel == null || document == null) {
            return false;
        }
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc == null) {
            return false;
        }
        return chnlDoc.getPropertyAsInt("DOCORDERPRI", 0) > 0;
    }

    public void setTopDocument(Channel channel, Document document, int n, CMyDateTime cMyDateTime) throws WCMException {
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc == null) {
            return;
        }
        if (channel == null || document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label35", "\u4f20\u5165\u7684\u6587\u6863\u548c\u9891\u9053\u53c2\u6570\u65e0\u6548\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u7f6e\u9876\u6807\u5fd7!"));
        }
        if (n > this.getMaxToppedNum()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label36", "\u5bf9\u4e0d\u8d77, \u6587\u6863\u7f6e\u9876\u7684\u4f4d\u7f6e\u65e0\u6548\uff0c\u65e0\u6cd5\u7ee7\u7eed!"));
        }
        if (document.isDraft()) {
            return;
        }
        if (n == ChnlDoc.NOT_ON_TOP) {
            this.removeToppedDocument(channel, document);
            return;
        }
        if (n < 1) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label36", "\u5bf9\u4e0d\u8d77, \u6587\u6863\u7f6e\u9876\u7684\u4f4d\u7f6e\u65e0\u6548\uff0c\u65e0\u6cd5\u7ee7\u7eed!"));
        }
        if (n == ChnlDoc.NOT_ON_TOP && chnlDoc.getDocOrderPri() != ChnlDoc.NOT_ON_TOP) {
            return;
        }
        if (chnlDoc.getDocOrderPri() != n) {
            this.moveTopped(chnlDoc, n);
        }
        if (chnlDoc.getInvalidTime() == null && cMyDateTime == null) {
            return;
        }
        User user = this.getLoginUser();
        if (cMyDateTime == null) {
            if (!chnlDoc.canEdit(user)) {
                throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label37", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5176\u7f6e\u9876!"));
            }
            chnlDoc.removeProperty("INVALIDTIME");
            chnlDoc.save(user);
            return;
        }
        if (!chnlDoc.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label37", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5176\u7f6e\u9876!"));
        }
        chnlDoc.setDocOrderPri(n);
        chnlDoc.setInvalidTime(cMyDateTime);
        chnlDoc.save(user);
    }

    public void setTopedDocument(Document document, Channel channel, int n, CMyDateTime cMyDateTime) throws WCMException {
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc == null) {
            return;
        }
        if (!chnlDoc.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label38", "\u5bf9\u4e0d\u8d77,\u6587\u6863\u5df2\u88ab") + chnlDoc.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label39", "\u9501\u5b9a!"));
        }
        chnlDoc.setDocTopPriOrder(n);
        chnlDoc.setInvalidTime(cMyDateTime);
        chnlDoc.save(this.getLoginUser());
    }

    public void removeToppedDocument(Channel channel, Document document) throws WCMException {
        if (channel == null || document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label35", "\u4f20\u5165\u7684\u6587\u6863\u548c\u9891\u9053\u53c2\u6570\u65e0\u6548\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u7f6e\u9876\u6807\u5fd7!"));
        }
        if (document.isDraft()) {
            return;
        }
        if (!this.isDocumentTopped(document, channel)) {
            return;
        }
        User user = this.getLoginUser();
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label40", "\u627e\u4e0d\u5230\u9891\u9053\u4e0b\u5bf9\u5e94\u7684\u6587\u6863\uff0c\u65e0\u6cd5\u7f6e\u9876!"));
        }
        if (!chnlDoc.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label41", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u53d6\u6d88\u5176\u7f6e\u9876\u8bbe\u7f6e!"));
        }
        chnlDoc.setDocOrderPri(ChnlDoc.NOT_ON_TOP);
        chnlDoc.removeProperty("INVALIDTIME");
        chnlDoc.save(user);
    }

    private void moveTopped(ChnlDoc chnlDoc, int n) throws WCMException {
        if (chnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label42", "\u9891\u9053\u6587\u6863\u65e0\u6548\uff0c\u65e0\u6cd5\u79fb\u52a8\u5176\u7f6e\u9876\u987a\u5e8f!"));
        }
        if (n < 1 || n > ChnlDoc.PRI_DOCS_SIZE) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label43", "\u5bf9\u4e0d\u8d77, \u6587\u6863\u65b0\u7684\u7f6e\u9876\u4f4d\u7f6e\u65e0\u6548\uff0c\u65e0\u6cd5\u7ee7\u7eed!"));
        }
        if (chnlDoc.getDocOrderPri() == n) {
            return;
        }
        User user = this.getLoginUser();
        ChnlDoc chnlDoc2 = this.findChnlDoc(chnlDoc.getChannel(), n);
        if (chnlDoc2 != null) {
            this.moveTopped(chnlDoc2, n + 1);
        }
        if (!chnlDoc.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label44", "\u5bf9\u4e0d\u8d77\uff0c\u9891\u9053\u4e0b\u7684\u6587\u6863\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u79fb\u52a8\u5176\u7f6e\u9876\u5c5e\u6027!"));
        }
        chnlDoc.setDocOrderPri(n);
        chnlDoc.save(user);
    }

    private ChnlDoc findChnlDoc(Channel channel, int n) throws WCMException {
        if (channel == null) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter("", "ChnlId=" + channel.getId() + " and DocOrderPri=" + (this.getMaxToppedNum() + 1 - n), "");
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (chnlDocs == null || chnlDocs.isEmpty()) {
            return null;
        }
        return (ChnlDoc)chnlDocs.getAt(0);
    }

    public int getTopPosition(Channel channel, Document document) throws WCMException {
        if (channel == null || document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label45", "\u9891\u9053\u6216\u8005\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u7f6e\u9876\u987a\u5e8f!"));
        }
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label46", "\u9891\u9053\u6587\u6863\u6ca1\u6709\u627e\u5230\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u7f6e\u9876\u987a\u5e8f\uff01"));
        }
        return chnlDoc.getDocOrderPri();
    }

    public Document save(Document document) throws WCMException {
        ChnlDoc chnlDoc;
        Object object;
        boolean bl;
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label47", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (document.isDoMove()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label48", "\u79fb\u52a8\u6587\u6863\u5230\u53e6\u4e00\u4e2a\u9891\u9053\u8bf7\u901a\u8fc7\u79fb\u52a8\u64cd\u4f5c\u8fdb\u884c\uff0c\u65e0\u6cd5\u901a\u8fc7\u76f4\u63a5\u4fee\u6539\u6587\u6863\u5c5e\u6027\u5b8c\u6210\uff01"));
        }
        if (document.isDoDelete()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label49", "\u5220\u9664\u6587\u6863\u5230\u56de\u6536\u7ad9\u8bf7\u901a\u8fc7\u5220\u9664\u64cd\u4f5c\u8fdb\u884c\uff0c\u65e0\u6cd5\u901a\u8fc7\u76f4\u63a5\u4fee\u6539\u6587\u6863\u5c5e\u6027\u5b8c\u6210\uff01"));
        }
        if (document.isDoRecover()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label50", "\u4ece\u56de\u6536\u7ad9\u4e2d\u6062\u590d\u6587\u6863\u8bf7\u901a\u8fc7\u6062\u590d\u64cd\u4f5c\u8fdb\u884c\uff0c\u65e0\u6cd5\u901a\u8fc7\u76f4\u63a5\u4fee\u6539\u6587\u6863\u5c5e\u6027\u5b8c\u6210\uff01"));
        }
        boolean bl2 = document.isAddMode();
        boolean bl3 = document.isDraft();
        boolean bl4 = bl = !bl2 && document.isChangeProperty("DOCSTATUS");
        if (!bl && 1 == document.getStatusId() && !bl2) {
            document.setStatus(2);
            bl = true;
        }
        if (bl2 && 40 == document.getType()) {
            object = document.getPropertyAsString("DOCFILENAME");
            FilesMan filesMan = FilesMan.getFilesMan();
            String string = filesMan.copyWCMFile((String)object, "P0");
            document.setProperty("DOCFILENAME", CMyFile.extractFileName(string));
            try {
                if (((String)object).indexOf("U0") == 0) {
                    filesMan.deleteFile((String)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (document.isChangeProperty("DOCTYPE")) {
            this.clearOldContent(document);
        }
        object = this.getLoginUser();
        document.setPropertyWithString("OperUser", ((User)object).getName());
        document.setProperty("OperTime", CMyDateTime.now());
        boolean bl5 = document.hasImgInDocContent();
        int n = document.getAttachPic();
        if (n == 1) {
            if (bl5) {
                document.setAttachPic(3);
            }
        } else if (bl5) {
            document.setAttachPic(2);
        } else {
            document.setAttachPic(0);
        }
        document.save((User)object);
        if (bl3) {
            return document;
        }
        if (bl2) {
            if (document.getDbTableName().equals("WCMDOCUMENT")) {
                String string;
                ChnlDoc chnlDoc2 = this.createChnlDocWithEntity(document, null, false);
                String string2 = document.getPropertyAsString("CrTime");
                if (string2 != null) {
                    chnlDoc2.setPropertyWithString("CrTime", string2);
                }
                if ((string = document.getPropertyAsString("CrUser")) != null) {
                    chnlDoc2.setPropertyWithString("CrUser", string);
                }
                chnlDoc2.setPropertyWithString("OperUser", ((User)object).getName());
                chnlDoc2.setProperty("OperTime", CMyDateTime.now());
                chnlDoc2.save(this.getLoginUser());
            }
            return document;
        }
        if (bl) {
            chnlDoc = this.findChnlDoc(document, document.getChannel());
            if (!chnlDoc.canEdit(this.getLoginUser())) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label51", "\u4fdd\u5b58\u6587\u6863\u65f6,\u7531\u4e8eChnlDoc\u88ab") + chnlDoc.getLockerUser() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label52", "\u9501\u5b9a,\u65e0\u6cd5\u540c\u6b65\u5176\u5c5e\u6027"));
            }
            chnlDoc.setStatusId(document.getStatusId());
            chnlDoc.save(this.getLoginUser());
        }
        if (!bl && !bl2) {
            chnlDoc = this.findChnlDoc(document, document.getChannel());
            chnlDoc.setPropertyWithString("OperUser", ((User)object).getName());
            chnlDoc.setProperty("OperTime", CMyDateTime.now());
            chnlDoc.save(this.getLoginUser());
        }
        return document;
    }

    private void clearOldContent(Document document) throws WCMException {
        int n = document.getType();
        int n2 = document.getNewPropertyAsInt("DOCTYPE", 20);
        switch (n) {
            case 20: {
                List list;
                if (this.unUsedByDocBak(document.getId(), 20) && (list = document.getHTMLWCMFiles()) != null) {
                    String string = null;
                    for (int i = 0; i < list.size(); ++i) {
                        string = (String)list.get(i);
                        if (string == null || string.trim().length() <= 0) continue;
                        try {
                            FilesMan.getFilesMan().deleteFile(string);
                            continue;
                        }
                        catch (Exception exception) {
                            if (!m_oLogger.isDebugEnabled()) continue;
                            m_oLogger.debug((Object)(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label53", "\u5220\u9664\u6587\u6863\u5305\u542b\u7684HTML\u6587\u4ef6[") + string + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label54", "]\u65f6\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)exception);
                        }
                    }
                }
                document.setPropertyWithString("DOCHTMLCON", "");
                if (n2 == 10) break;
                document.setPropertyWithString("DOCCONTENT", "");
                break;
            }
            case 10: {
                document.setPropertyWithString("DOCCONTENT", "");
                if (n2 == 20) break;
                document.setPropertyWithString("DOCHTMLCON", "");
                break;
            }
            case 30: {
                document.setPropertyWithString("DOCLINK", "");
                break;
            }
            case 40: {
                FilesMan filesMan;
                String string = document.getPropertyAsString("DOCFILENAME");
                if (string != null && string.trim().length() > 0 && (filesMan = FilesMan.getFilesMan()).fileExists(string) && this.unUsed(document.getId(), string)) {
                    filesMan.deleteFile(string);
                }
                document.setPropertyWithString("DOCFILENAME", "");
            }
        }
    }

    private boolean unUsed(int n, String string) throws WCMException {
        String string2 = "SELECT COUNT(DocBakId) FROM WCMDOCBAK WHERE DocId=" + n + " AND DocFileName='" + string + "'";
        return DBManager.getDBManager().sqlExecuteIntQuery(string2) == 0;
    }

    private boolean unUsedByDocBak(int n, int n2) throws WCMException {
        String string = "SELECT COUNT(DocBakId) FROM WCMDOCBAK WHERE DocId=" + n + " AND DocType=" + n2;
        return DBManager.getDBManager().sqlExecuteIntQuery(string) == 0;
    }

    public Document copyDocument(Document document, Channel channel, Channel channel2) throws WCMException {
        Channel channel3;
        User user = this.getLoginUser();
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label55", "\u539f\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u6587\u6863\uff01"));
        }
        if (channel2 == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label56", "\u76ee\u6807\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u6587\u6863\uff01"));
        }
        Channel channel4 = channel3 = channel == null ? document.getChannel() : channel;
        if (document.isDraft()) {
            channel3 = Channel.DRAFT_CHANNEL;
        }
        if (channel3 == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label57", "\u539f\u59cb\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u6587\u6863\uff01"));
        }
        if (document.getStatusId() == 1028) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label122", "\u6587\u6863[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u590d\u5236\uff01"), new String[]{document.getTitle()}));
        }
        if (!this.isDocumentLink(document, channel3)) {
            int n;
            int n2;
            Object object;
            if (channel2.getType() != channel3.getType()) {
                throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label111", "\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u4e0d\u540c\u7c7b\u578b\u4e4b\u95f4\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u590d\u5236\u6570\u636e\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId())}));
            }
            if (channel3.getType() == 13) {
                String string = channel3.getId() + "," + channel2.getId();
                object = "select count(distinct InfoViewId) from WCMInfoViewEmploy where EmployerType=101 and EmployerID in(" + string + ")";
                int n3 = DBManager.getDBManager().sqlExecuteIntQuery((String)object);
                if (n3 > 1) {
                    throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label112", "\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u8868\u5355\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u590d\u5236\u6570\u636e\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId())}));
                }
            }
            if ((n2 = document.getPropertyAsInt("DocKind", 0)) != 0) {
                int n4 = channel2.getId();
                String string = "select count(distinct ViewId) from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ChannelId=" + n4 + " and XWCMMetaViewEmployer.ViewId=" + n2;
                int n5 = DBManager.getDBManager().sqlExecuteIntQuery(string);
                if (n5 <= 0) {
                    throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label114", "\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u89c6\u56fe\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u590d\u5236\u6570\u636e\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId())}));
                }
            }
            object = (Document)document.cloneToNewWCMObj();
            ((Document)object).setChannel(channel2);
            ((Document)object).setTitle(this.getDoctitleWhenCopy(((Document)object).getTitle()));
            ((Document)object).setStatus(1);
            String string = ConfigServer.getServer().getSysConfigValue("CHANGENAME", "false");
            if ("true".equalsIgnoreCase(string)) {
                ((CMSObj)object).setCrUser(user.getName());
            }
            ((Document)object).setOutUpId(document.getId());
            ((BaseObj)object).setProperty("DOCFIRSTPUBTIME", null);
            object = this.save((Document)object);
            Logos logos = Logos.findOf(user, 605, document.getDocId(), null);
            int n6 = logos.size();
            for (n = 0; n < n6; ++n) {
                Logo logo = (Logo)logos.getAt(n);
                if (logo == null) continue;
                Logo logo2 = (Logo)logo.cloneToNewObj();
                logo2.removeProperty("CRTIME");
                logo2.setHostId(((BaseObj)object).getId());
                logo2.save(user);
            }
            n = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false")) ? 1 : 0;
            if (n != 0) {
                this.startInFlow((Document)object);
            }
            return object;
        }
        if (ChnlDoc.findByDocAndChnl(document, channel2) != null) {
            return null;
        }
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel3);
        ChnlDoc chnlDoc2 = (ChnlDoc)chnlDoc.cloneToNewObj();
        chnlDoc2.setChannelId(channel2.getId());
        chnlDoc2.save(this.getLoginUser());
        return document;
    }

    private void startInFlow(Document document) throws WCMException {
        IFlowServer iFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(document);
        FlowContext flowContext = null;
        if (iFlowContent.getOwnerFlow() == null) {
            return;
        }
        flowContext = new FlowContext(ContextHelper.getLoginUser(), iFlowContent);
        flowContext.setPostDesc(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label58", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
        iFlowServer.submitTo(flowContext);
    }

    public Channels getQutoedChannels(Document document, int n, String string) throws WCMException {
        return this.getQutoedChannels(document, n, string, false);
    }

    public Channels getQutoedChannels(Document document, int n, String string, boolean bl) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label59", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u83b7\u53d6\u5b58\u5728\u8be5\u6587\u6863\u955c\u50cf\u7684\u6240\u6709\u9891\u9053\u5931\u8d25"));
        }
        if (document.isDraft()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("DocId=").append(document.getId());
        stringBuffer.append(" AND ChnlId>0");
        if (!bl) {
            stringBuffer.append(" AND DocStatus>0");
        }
        stringBuffer.append(" AND (ChnlId>");
        stringBuffer.append(document.getChannelId());
        stringBuffer.append(" OR ChnlId<");
        stringBuffer.append(document.getChannelId()).append(")");
        if (n != 0) {
            stringBuffer.append(" AND Modal=").append(n);
        }
        if (!CMyString.isEmpty(string)) {
            stringBuffer.append(" AND (").append(string).append(")");
        }
        Channels channels = new Channels(this.getLoginUser());
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", stringBuffer.toString(), "", "ChnlId as ChannelId");
        channels.open(wCMFilter);
        return channels;
    }

    public Channels getChannels(Document document, int n, String string) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label59", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u83b7\u53d6\u5b58\u5728\u8be5\u6587\u6863\u955c\u50cf\u7684\u6240\u6709\u9891\u9053\u5931\u8d25"));
        }
        if (document.isDraft()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("DocId=?  AND ChnlId>0 AND DocStatus>0 ");
        if (n != 0) {
            stringBuffer.append(" AND Modal=?");
        }
        if (!CMyString.isEmpty(string)) {
            stringBuffer.append(" AND (").append(string).append(")");
        }
        Channels channels = new Channels(this.getLoginUser());
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", stringBuffer.toString(), "", "ChnlId as ChannelId");
        wCMFilter.addSearchValues(document.getId());
        if (n != 0) {
            wCMFilter.addSearchValues(n);
        }
        channels.open(wCMFilter);
        return channels;
    }

    public Report moveTo(Document document, Channel channel, Channel channel2) throws WCMException {
        return this.moveTo(document, channel, channel2, "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report moveTo(Document document, Channel channel, Channel channel2, String string) throws WCMException {
        Channel channel3;
        String string2 = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label105", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string2 = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label106", "\u56fe\u7247");
        }
        if (document == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label108", "{0}\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"), new String[]{string2}));
        }
        Channel channel4 = channel3 = channel == null ? document.getChannel() : channel;
        if (document.isDraft()) {
            channel3 = Channel.DRAFT_CHANNEL;
        }
        if (channel3 == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label107", "\u539f\u59cb\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8{0}\uff01"), new String[]{string2}));
        }
        Report report = null;
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(document, channel2);
        if (chnlDoc != null && chnlDoc.getChannelId() == channel2.getId()) {
            report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label96", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId()), string2}));
            report.setRportDetail(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label104", "\u56e0\u4e3a\u5df2\u7ecf\u5728\u76ee\u6807\u680f\u76ee\u4e2d\u5b58\u5728\uff01"));
            report.setType(5);
            return report;
        }
        if (channel3 == Channel.DRAFT_CHANNEL) {
            ChnlDoc chnlDoc2 = this.createChnlDocWithEntity(document, channel2, false);
            chnlDoc2.setModal(1);
            chnlDoc2.save(this.getLoginUser());
            report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label97", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u6210\u529f\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId()), string2}));
            report.setType(3);
            return report;
        }
        if (document.getStatusId() == 1028) {
            report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label120", "{1}[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"), new String[]{document.getTitle(), string2}));
            report.setType(5);
            return report;
        }
        ChnlDoc chnlDoc3 = this.findChnlDoc(document, channel3);
        if (chnlDoc3.isEntity()) {
            int n;
            Object object;
            if (channel2.getType() != channel3.getType()) {
                report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label98", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u4e0d\u540c\u7c7b\u578b\u4e4b\u95f4\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u79fb\u52a8\u6570\u636e\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId()), string2}));
                report.setType(5);
                return report;
            }
            if (channel3.getType() == 13) {
                String string3 = channel3.getId() + "," + channel2.getId();
                object = "select count(distinct InfoViewId) from WCMInfoViewEmploy where EmployerType=101 and EmployerID in(" + string3 + ")";
                int n2 = DBManager.getDBManager().sqlExecuteIntQuery((String)object);
                if (n2 > 1) {
                    report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label110", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u8868\u5355\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u79fb\u52a8\u6570\u636e\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId()), string2}));
                    report.setType(5);
                    return report;
                }
            }
            if ((n = chnlDoc3.getPropertyAsInt("DocKind", 0)) != 0) {
                int n3 = channel2.getId();
                String string4 = "select count(distinct ViewId) from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ChannelId=" + n3 + " and XWCMMetaViewEmployer.ViewId=" + n;
                int n4 = DBManager.getDBManager().sqlExecuteIntQuery(string4);
                if (n4 <= 0) {
                    report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label113", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25\uff01\u56e0\u4e3a\u914d\u7f6e\u4e86\u4e0d\u540c\u89c6\u56fe\u7684\u680f\u76ee\u4e0d\u5141\u8bb8\u79fb\u52a8\u6570\u636e\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId()), string2}));
                    report.setType(5);
                    return report;
                }
            }
            if (!document.canEdit((User)(object = this.getLoginUser()))) {
                report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label99", "\u79fb\u52a8{4}[{0}]\u5230\u680f\u76ee[{1}][ID={3}]\u5931\u8d25\uff01\u56e0\u4e3a{4}\u88ab{2}\u9501\u5b9a\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), document.getLockerUserName(), String.valueOf(channel2.getId()), string2}));
                report.setType(5);
                return report;
            }
            try {
                this.moveTo(chnlDoc3, channel2);
            }
            finally {
                document.unlock();
            }
        } else {
            this.moveTo(chnlDoc3, channel2);
        }
        report = new Report(CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label97", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u6210\u529f\uff01"), new String[]{document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId()), string2}));
        report.setType(3);
        return report;
    }

    public void restore(Document document, Channel channel) throws WCMException {
        Channel channel2;
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label66", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u4e0d\u80fd\u8fdb\u884c\u6062\u590d\u64cd\u4f5c!"));
        }
        Channel channel3 = channel2 = channel == null ? document.getChannel() : channel;
        if (document.isDraft()) {
            channel2 = Channel.DRAFT_CHANNEL;
        }
        if (channel2 == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label67", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6062\u590d\u6587\u6863\uff01"));
        }
        if (channel2.getId() == 0) {
            if (document.canEdit(this.getLoginUser())) {
                document.setDeleted(false);
                document.update(this.getLoginUser());
            }
        } else {
            this.restore(this.findChnlDoc(document, channel2));
        }
    }

    public void restore(ChnlDoc chnlDoc) throws WCMException {
        if (chnlDoc == null) {
            throw new WCMException(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label68", "\u65e0\u6cd5\u627e\u5230\u9891\u9053\u6587\u6863\uff0c\u4e0d\u80fd\u8fdb\u884c\u6062\u590d\u64cd\u4f5c\uff01"));
        }
        if (!chnlDoc.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label69", "\u5f53\u524d\u6587\u6863\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u6062\u590d\uff01"));
        }
        chnlDoc.setDeleted(false);
        chnlDoc.setOperUser(this.getLoginUser());
        chnlDoc.setOperTime();
        chnlDoc.update(this.getLoginUser());
    }

    public void restoreAll(User user, BaseChannel baseChannel) throws WCMException {
        String string;
        boolean bl = true;
        if (baseChannel.isSite()) {
            bl = false;
            string = "(DocStatus<0 or Modal<0) and exists( select c.ChannelId from WCMChannel c   Where c.Status>=0 and c.SiteId=? and WCMChnlDoc.ChnlId=c.ChannelId)";
        } else {
            string = "ChnlId=? and (DocStatus<0 or Modal<0)";
        }
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", string, "");
        wCMFilter.addSearchValues(baseChannel.getId());
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(null, wCMFilter);
        int n = chnlDocs.size();
        for (int i = 0; i < n; ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || !chnlDoc.isDeleted() || (bl ? DocumentAuthServer.isDefineRightOnDocument(chnlDoc.getDocId()) && !DocumentAuthServer.hasRight(user, chnlDoc, 33) : !DocumentAuthServer.hasRight(user, chnlDoc, 33))) continue;
            this.restore(chnlDoc);
        }
    }

    public void clearAll(User user, BaseChannel baseChannel) throws WCMException {
        String string;
        boolean bl = true;
        if (baseChannel.isSite()) {
            bl = false;
            string = "(DocStatus<0 or Modal<0) and exists( select c.ChannelId from WCMChannel c   Where c.Status>=0 and c.SiteId=? and WCMChnlDoc.ChnlId=c.ChannelId)";
        } else {
            string = "ChnlId=? and (DocStatus<0 or Modal<0)";
        }
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", string, "");
        wCMFilter.addSearchValues(baseChannel.getId());
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(null, wCMFilter);
        int n = chnlDocs.size();
        for (int i = 0; i < n; ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (!bl ? !DocumentAuthServer.hasRight(user, chnlDoc, 33) : DocumentAuthServer.isDefineRightOnDocument(chnlDoc.getDocId()) && !DocumentAuthServer.hasRight(user, chnlDoc, 33))) continue;
            if (chnlDoc.isEntity()) {
                this.getChnlDocs(chnlDoc.getDocId(), 0, null).removeAll(true);
            }
            try {
                this.delete(chnlDoc, true);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Report quoteTo(Document document, Channel channel) throws WCMException {
        return this.quoteTo(document, channel, "false");
    }

    public Report quoteTo(Document document, Channel channel, String string) throws WCMException {
        String string2 = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label105", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string2 = I18NMessage.get(DocumentMgr.class, "DocumentMgr.label106", "\u56fe\u7247");
        }
        if (document == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label70", "{0}\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{string2}));
        }
        if (document.getChannel() == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label71", "{0}\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u9891\u9053\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"), new String[]{string2}));
        }
        if (document.isDraft()) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label72", "\u65e0\u6cd5\u4ece\u8349\u7a3f\u7bb1\u4e2d\u8f6c\u53d1{0}\uff01"), new String[]{string2}));
        }
        return this.transmitTo(document, channel, true, string);
    }

    public Report mirrorTo(Document document, Channel channel) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label70", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        if (document.getChannel() == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label71", "\u6587\u6863\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u9891\u9053\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        if (document.isDraft()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label72", "\u65e0\u6cd5\u4ece\u8349\u7a3f\u7bb1\u4e2d\u8f6c\u53d1\u6587\u6863\uff01"));
        }
        return this.transmitTo(document, channel, false);
    }

    public Documents getRelatedDocuments(Document document, int n, WCMFilter wCMFilter) throws WCMException {
        return this.getRelatedDocuments(document, n, wCMFilter, true, false);
    }

    public Documents getRelatedDocuments(Document document, int n, WCMFilter wCMFilter, boolean bl, boolean bl2) throws WCMException {
        return this.getRelatedDocuments(document, n, wCMFilter, bl, bl2, null);
    }

    private Documents getRelatedDocuments(Document document, int n, WCMFilter wCMFilter, boolean bl, boolean bl2, ArrayList arrayList) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label73", "\u5f53\u524d\u6587\u6863\u4e3a\u7a7a,\u65e0\u6cd5\u53d6\u5230\u4e0e\u5b83\u76f8\u5173\u7684\u6587\u6863!"));
        }
        WCMFilter wCMFilter2 = null;
        switch (n) {
            case 0: {
                return this.getAllRelatedDocuments(document, wCMFilter, bl, bl2);
            }
            case 30: {
                wCMFilter2 = this.constructRelationFilter(document, wCMFilter, bl2);
                break;
            }
            case 10: 
            case 20: {
                int[] nArray = new int[]{10};
                boolean bl3 = false;
                int n2 = 100;
                String string = "";
                if (wCMFilter != null) {
                    string = wCMFilter.getSelect();
                    n2 = wCMFilter.getMaxRowNumber();
                    String string2 = wCMFilter.getWhere().toUpperCase();
                    if (string2.indexOf("DOCSTATUS") >= 0 && string2.indexOf(String.valueOf(10)) > 0) {
                        bl3 = true;
                    }
                }
                return this.m_oDocKeywordMgr.getRelatedDocumentsByKeywords(document, n2, string, (int[])(bl3 ? nArray : null), bl2, arrayList);
            }
            default: {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label74", "\u65e0\u6548\u7684\u76f8\u5173\u6587\u6863\u83b7\u53d6\u65b9\u5f0f!"));
            }
        }
        try {
            return Documents.openWCMObjs(this.getLoginUser(), wCMFilter2);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label75", "\u83b7\u53d6\u4e0e\u5f53\u524d\u6587\u6863\u76f8\u5173\u7684\u6587\u6863\u96c6\u5408\u5931\u8d25!"), wCMException);
        }
    }

    private Documents getAllRelatedDocuments(Document document, WCMFilter wCMFilter, boolean bl, boolean bl2) throws WCMException {
        int n;
        Documents documents = null;
        Documents documents2 = null;
        int n2 = n = wCMFilter == null || wCMFilter.getMaxRowNumber() <= 0 ? 30 : wCMFilter.getMaxRowNumber();
        documents = this.getRelatedDocuments(document, 30, wCMFilter, bl, bl2);
        documents.setMaxBufferSize(documents.size());
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i = documents.size() - 1; i >= 0; --i) {
            Document document2 = (Document)documents.getAt(i);
            if (document2 == null) {
                documents.removeAt(i, false);
                continue;
            }
            String string = document2.getTitle();
            if (arrayList.contains(string)) {
                documents.removeAt(i, false);
                continue;
            }
            arrayList.add(string);
        }
        if (documents.size() >= n2) {
            return documents;
        }
        n2 = n - documents.size();
        if (wCMFilter != null) {
            wCMFilter.setMaxRowNumber(n2);
        }
        documents2 = this.getRelatedDocuments(document, 10, wCMFilter, bl, bl2, arrayList);
        documents.addWith(documents2);
        return documents;
    }

    private WCMFilter constructRelationFilter(Document document, WCMFilter wCMFilter, boolean bl) throws WCMException {
        Channel channel = document.getChannel();
        int n = channel.getSiteId();
        String string = "WCMDocument,WCMRelation";
        String string2 = "WCMRelation.SERN";
        String string3 = "(WCMRelation.DocId=?) and (WCMDocument.DocId=WCMRelation.RelDocId) and (WCMDocument.DocStatus>0) AND (WCMDocument.DocChannel>0)";
        if (!bl) {
            string3 = string3 + "and exists(select 1 from WCMChannel where WCMChannel.Siteid=? and WCMChannel.Channelid=WCMDocument.DocChannel)";
        }
        WCMFilter wCMFilter2 = new WCMFilter(string, string3, string2);
        wCMFilter2.addSearchValues(document.getId());
        if (!bl) {
            wCMFilter2.addSearchValues(n);
        }
        if (wCMFilter != null) {
            String string4 = wCMFilter.getSelect();
            string4 = this.filterSelectForRelations(string4);
            wCMFilter.setSelect(string4);
        }
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    private String filterSelectForRelations(String string) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string.trim().toUpperCase();
            int n = 0;
            n = string2.indexOf("DOCID", n);
            while (n >= 0) {
                if (n == 0 || n > 0 && string2.charAt(n - 1) != '.') {
                    string2 = string2.substring(0, n) + "WCMDocument." + string2.substring(n);
                }
                n = string2.indexOf("DOCID", n + 18);
            }
        }
        return string2;
    }

    private DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label76", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label77", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    public CMyDateTime getDocumentTopTime(Document document, Channel channel) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label78", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u7f6e\u9876\u622a\u6b62\u65f6\u95f4\uff01"));
        }
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label79", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u4e0b\u6587\u6863\u7684\u7f6e\u9876\u622a\u6b62\u65f6\u95f4\uff01"));
        }
        if (!this.isDocumentTopped(document, channel)) {
            return null;
        }
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc.getInvalidTime() == null || chnlDoc.getInvalidTime().isNull()) {
            return null;
        }
        return chnlDoc.getInvalidTime();
    }

    private ChnlDocs getChnlDocs(int n, int n2, WCMFilter wCMFilter) throws WCMException {
        ChnlDocs chnlDocs = new ChnlDocs(this.getLoginUser());
        WCMFilter wCMFilter2 = new WCMFilter();
        wCMFilter2.addSearchValues(n);
        String string = "DOCID=?";
        if (n2 != 0) {
            string = string + " and MODAL=?";
            wCMFilter2.addSearchValues(n2);
        }
        wCMFilter2.setWhere(string);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        chnlDocs.open(wCMFilter2);
        return chnlDocs;
    }

    public void deleteDocQuotes(Document document, String string) throws WCMException {
        this.addQuoteType(document, string, 5);
    }

    public void deleteDocMirrors(Document document, String string) throws WCMException {
        this.addQuoteType(document, string, 3);
    }

    private void addQuoteType(Document document, String string, int n) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label80", "\u6587\u6863\u4e3a\u7a7a\uff0c\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        String string2 = "";
        if (string != null && string.trim().length() != 0) {
            string2 = "CHNLID NOT IN(" + string + ")";
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        ChnlDocs chnlDocs = this.getChnlDocs(document.getId(), n, wCMFilter);
        chnlDocs.removeAll(true);
    }

    private String getDoctitleWhenCopy(String string) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        return this.getCopyPrefix() + string;
    }

    private String getCopyPrefix() {
        String string = "";
        try {
            string = ConfigServer.getServer().getSysConfigValue(CONFIG_COPY_TITLE_PREFIX, "");
        }
        catch (Exception exception) {
            m_oLogger.debug((Object)I18NMessage.get(DocumentMgr.class, "DocumentMgr.label81", "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u6587\u6863\u590d\u5236\u65f6\u9700\u8981\u589e\u52a0\u7684\u524d\u7f00\u9879\u76ee\u5931\u8d25\uff01"));
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDocumentInChannel(Document document, Document document2, Channel channel, int n) throws WCMException {
        if (channel == null || channel.isOnlySearch()) {
            return;
        }
        Object object = channel.getDocOrderLock();
        synchronized (object) {
            ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
            ChnlDoc chnlDoc2 = this.findChnlDoc(document2, channel);
            if (chnlDoc == null || chnlDoc2 == null) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label82", "\u65e0\u6cd5\u627e\u5230\u9891\u9053\u4e0b\u7684\u6587\u6863\uff01"));
            }
            if (chnlDoc.isTopped()) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label83", "\u8fd9\u7bc7\u6587\u6863\u662f\u7f6e\u9876\u6587\u6863\uff0c\u60a8\u4e0d\u80fd\u8fd9\u6837\u5bf9\u5176\u8c03\u6574\u987a\u5e8f\uff0c\u8bf7\u901a\u8fc7\u6539\u53d8\u7f6e\u9876\u987a\u5e8f\u5b8c\u6210\u8fd9\u6837\u7684\u64cd\u4f5c\uff01"));
            }
            if (chnlDoc2.isTopped()) {
                throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label109", "\u60a8\u65e0\u6cd5\u5c06\u8fd9\u7bc7\u6587\u6863\u4e0e\u7f6e\u9876\u6587\u6863\u8c03\u6574\u987a\u5e8f\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u4f4d\u7f6e\uff01"));
            }
            int n2 = chnlDoc.getDocOrder();
            int n3 = chnlDoc2.getDocOrder();
            if (chnlDoc.equals(chnlDoc2) || n2 == n3) {
                return;
            }
            int n4 = n2;
            int n5 = n2 - n3;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            switch (n) {
                case 1: {
                    if (n5 == 1) {
                        return;
                    }
                    if (n5 > 0) {
                        n6 = n3 + 1;
                        n7 = n2 - 1;
                        n4 = n6;
                        n8 = 1;
                        break;
                    }
                    if (n5 >= 0) break;
                    n6 = n2 + 1;
                    n4 = n7 = n3;
                    n8 = -1;
                    break;
                }
                case 0: {
                    if (n5 == -1) {
                        return;
                    }
                    if (n5 > 0) {
                        n6 = n3;
                        n7 = n2 - 1;
                        n4 = n6;
                        n8 = 1;
                        break;
                    }
                    if (n5 >= 0) break;
                    n6 = n2 + 1;
                    n4 = n7 = n3 - 1;
                    n8 = -1;
                }
            }
            String string = "UPDATE WCMChnlDoc SET DocOrder = DocOrder+(" + n8 + ") WHERE " + "DocOrder>=? AND DocOrder <=? and ChnlId=?";
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{string}, new int[]{n6, n7, channel.getId()});
            chnlDoc.canEdit(this.getLoginUser());
            chnlDoc.setDocOrder(n4);
            chnlDoc.save(this.getLoginUser());
        }
    }

    public void moveDocumentInChannel(Document document, Document document2, Channel channel) throws WCMException {
        this.moveDocumentInChannel(document, document2, channel, 1);
    }

    public ChnlDoc getPreviousChnlDoc(ChnlDoc chnlDoc, boolean bl) throws WCMException {
        if (chnlDoc == null) {
            return null;
        }
        String string = "";
        string = bl ? "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER>" + chnlDoc.getDocOrder() + " AND CHNLID=" + chnlDoc.getChannelId() : "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER>" + chnlDoc.getDocOrder() + " AND CHNLID=" + chnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int n = DBManager.getDBManager().sqlExecuteIntQuery(string);
        if (n == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(chnlDoc.getChannel(), n);
    }

    public ChnlDoc getNextChnlDoc(ChnlDoc chnlDoc, boolean bl) throws WCMException {
        if (chnlDoc == null) {
            return null;
        }
        String string = "";
        string = bl ? "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER<" + chnlDoc.getDocOrder() + " AND CHNLID=" + chnlDoc.getChannelId() : "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE DOCORDER<" + chnlDoc.getDocOrder() + " AND CHNLID=" + chnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int n = DBManager.getDBManager().sqlExecuteIntQuery(string);
        if (n == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(chnlDoc.getChannel(), n);
    }

    public ChnlDoc getFirstChnlDoc(ChnlDoc chnlDoc, boolean bl) throws WCMException {
        if (chnlDoc == null) {
            return null;
        }
        String string = "";
        string = bl ? "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + chnlDoc.getChannelId() : "SELECT MAX(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + chnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int n = DBManager.getDBManager().sqlExecuteIntQuery(string);
        if (n == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(chnlDoc.getChannel(), n);
    }

    public ChnlDoc getLastChnlDoc(ChnlDoc chnlDoc, boolean bl) throws WCMException {
        if (chnlDoc == null) {
            return null;
        }
        String string = "";
        string = bl ? "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + chnlDoc.getChannelId() : "SELECT MIN(DOCORDER) FROM WCMCHNLDOC WHERE CHNLID=" + chnlDoc.getChannelId() + " AND DOCORDERPRI=" + ChnlDoc.NOT_ON_TOP;
        int n = DBManager.getDBManager().sqlExecuteIntQuery(string);
        if (n == 0) {
            return null;
        }
        return this.getChnlDocByDocOrder(chnlDoc.getChannel(), n);
    }

    private ChnlDoc getChnlDocByDocOrder(Channel channel, int n) throws WCMException {
        if (channel == null) {
            return null;
        }
        String string = "DOCORDER=" + n + " AND CHNLID=" + channel.getId();
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (chnlDocs == null || chnlDocs.isEmpty()) {
            return null;
        }
        return (ChnlDoc)chnlDocs.getAt(0);
    }

    private boolean hasRight(User user, BaseChannel baseChannel, Document document, int n) throws WCMException {
        return DocumentAuthServer.hasRight(user, baseChannel, document, n);
    }

    public Reports moveAllDocumentsToChannel(Channel channel, Channel channel2) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "DocChannel=? and DocStatus>0", "");
        wCMFilter.addSearchValues(channel.getId());
        ViewDocuments viewDocuments = new ViewDocuments(this.getLoginUser(), 1, 1);
        viewDocuments.setPageSize(-1);
        viewDocuments.open(channel, wCMFilter);
        return this.moveDocumentsToChannel(viewDocuments, channel, channel2);
    }

    public Reports moveDocumentsToChannel(ViewDocuments viewDocuments, Channel channel, Channel channel2) throws WCMException {
        ViewDocument viewDocument;
        int n;
        User user = this.getLoginUser();
        if (channel == null || channel2 == null) {
            Reports reports = new Reports(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label84", "\u79fb\u52a8\u6240\u6709\u6587\u6863\uff01"));
            reports.addFailedReport(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label85", "\u6307\u5b9a\u680f\u76ee\u4e0d\u5b58\u5728\uff01"), null);
            return reports;
        }
        String string = CMyString.format(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label87", "\u4ece\u680f\u76ee\u3010{0}\u3011\u79fb\u52a8\u6240\u6709\u6587\u6863\u5230\u3010{1}\u3011"), new String[]{channel.getDispDesc(), channel2.getDispDesc()});
        Reports reports = new Reports(string);
        viewDocuments.setMaxBufferSize(viewDocuments.size());
        for (n = viewDocuments.size() - 1; n >= 0; --n) {
            viewDocument = (ViewDocument)viewDocuments.getAt(n);
            if (viewDocument != null) continue;
            reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label33", "\u79fb\u52a8\u5931\u8d25:\u6587\u6863[ID={0}]\u6ca1\u6709\u627e\u5230!"), new int[]{viewDocuments.getIdAt(n)}), null);
            viewDocuments.removeAt(n, false);
        }
        if (viewDocuments.size() <= 0) {
            reports.addSucessedReport(I18NMessage.get(DocumentMgr.class, "DocumentMgr.label60", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"));
            return reports;
        }
        for (n = viewDocuments.size() - 1; n >= 0; --n) {
            viewDocument = (ViewDocument)viewDocuments.getAt(n);
            if (viewDocument == null) continue;
            Document document = Document.findById(viewDocument.getDocId());
            try {
                reports.addReport(this.moveTo(document, channel, channel2));
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label102", "\u4ece\u680f\u76ee[{0}\u79fb\u52a8\u6587\u6863[{1}]\u5230\u680f\u76ee[{2}]\u5931\u8d25."), new String[]{channel.getDispDesc(), document.getTitle(), channel2.getDispDesc()}), throwable);
            }
        }
        return reports;
    }

    public void setTopDocument(Channel channel, Document document, Document document2, int n, CMyDateTime cMyDateTime) throws WCMException {
        if (channel == null || channel.isOnlySearch()) {
            return;
        }
        User user = this.getLoginUser();
        ChnlDoc chnlDoc = this.findChnlDoc(document, channel);
        if (chnlDoc == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label91", "\u65e0\u6cd5\u627e\u5230\u9891\u9053[") + channel + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label92", "]\u4e0b\u7684\u6587\u6863[") + document + "]\uff01");
        }
        if (document2 == null) {
            chnlDoc.validCanEditAndLock(user);
            if (!chnlDoc.isTopped()) {
                chnlDoc.setProperty("DOCORDERPRI", this.getMaxDocOrderPri(channel));
            }
            if (cMyDateTime != null && !cMyDateTime.isNull()) {
                chnlDoc.setInvalidTime(cMyDateTime);
            } else if (cMyDateTime == null) {
                chnlDoc.setInvalidTime(null);
            }
            chnlDoc.save(user);
            return;
        }
        ChnlDoc chnlDoc2 = this.findChnlDoc(document2, channel);
        if (chnlDoc2 == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label91", "\u65e0\u6cd5\u627e\u5230\u9891\u9053[") + channel + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label92", "]\u4e0b\u7684\u6587\u6863[") + document2 + "]\uff01");
        }
        if (!chnlDoc2.isTopped()) {
            throw new WCMException(1101, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label93", "\u76ee\u6807\u9891\u9053\u6ca1\u6709\u7f6e\u9876\uff0c\u4f20\u5165\u7684TargetDocument[Id=") + chnlDoc2.getDocId() + I18NMessage.get(DocumentMgr.class, "DocumentMgr.label94", "]\u6709\u8bef\uff01"));
        }
        int n2 = chnlDoc.getDocOrderPri(true);
        int n3 = chnlDoc2.getDocOrderPri(true);
        int n4 = n2;
        int n5 = n2 - n3;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (!chnlDoc.isTopped()) {
            n6 = n3 + n;
            n7 = this.getMaxDocOrderPri(channel);
            n4 = n6;
            n8 = 1;
        } else {
            switch (n) {
                case 1: {
                    if (n5 == 1) break;
                    if (n5 > 0) {
                        n6 = n3 + 1;
                        n7 = n2 - 1;
                        n4 = n6;
                        n8 = 1;
                        break;
                    }
                    if (n5 >= 0) break;
                    n6 = n2 + 1;
                    n4 = n7 = n3;
                    n8 = -1;
                    break;
                }
                case 0: {
                    if (n5 == -1) break;
                    if (n5 > 0) {
                        n6 = n3;
                        n7 = n2 - 1;
                        n4 = n6;
                        n8 = 1;
                        break;
                    }
                    if (n5 >= 0) break;
                    n6 = n2 + 1;
                    n4 = n7 = n3 - 1;
                    n8 = -1;
                }
            }
        }
        if (n4 != n2) {
            String string = "UPDATE WCMChnlDoc SET DocOrderPri = DocOrderPri+(" + n8 + ") WHERE " + "DocOrderPri>=? AND DocOrderPri <=? and ChnlId=? and DocOrderPri>0";
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{string}, new int[]{n6, n7, channel.getId()});
            chnlDoc.setProperty("DOCORDERPRI", n4);
        }
        chnlDoc.canEdit(user);
        if (cMyDateTime != null && !cMyDateTime.isNull()) {
            chnlDoc.setInvalidTime(cMyDateTime);
        } else if (cMyDateTime == null) {
            chnlDoc.setInvalidTime(null);
        }
        chnlDoc.save(user);
    }

    private int getMaxDocOrderPri(Channel channel) throws WCMException {
        int n = DBManager.getDBManager().sqlExecuteIntQuery("select max(DocOrderPri) from WCMChnlDoc where ChnlId=? and DocOrderPri>0", new int[]{channel.getId()});
        return n > 0 ? n : 1;
    }

    private int getMaxDocOrder(Channel channel) throws WCMException {
        int n = DBManager.getDBManager().sqlExecuteIntQuery("select max(DocOrder) from WCMChnlDoc where ChnlId=?", new int[]{channel.getId()});
        return n > 0 ? n : 0;
    }

    public void deleteDocQuotesInDelChnlIds(Document document, String string) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label80", "\u6587\u6863\u4e3a\u7a7a\uff0c\uff0c\u65e0\u6cd5\u8f6c\u53d1\uff01"));
        }
        String string2 = "";
        if (string != null && string.trim().length() != 0) {
            string2 = "CHNLID IN(" + string + ")";
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        ChnlDocs chnlDocs = this.getChnlDocs(document.getId(), 2, wCMFilter);
        chnlDocs.removeAll(true);
        chnlDocs = this.getChnlDocs(document.getId(), 3, wCMFilter);
        chnlDocs.removeAll(true);
    }
}

