/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocBakMgr;
import com.trs.components.wcm.content.persistent.AutoBakConfig;
import com.trs.components.wcm.content.persistent.AutoBakConfigs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class AutoDocBakMgr {
    private static Logger m_oLogger = Logger.getLogger(AutoDocBakMgr.class);

    private User getLoginUser() throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            throw new WCMException(1001, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label1", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        return user;
    }

    private void assertNotNull(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label2", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    private boolean isValidForAutoBak(Document document, int n) throws WCMException {
        this.assertNotNull(document);
        Channel channel = document.getChannel();
        if (channel == null) {
            return false;
        }
        int n2 = channel.getSiteId();
        AutoBakConfig autoBakConfig = this.getAutoSaveConfig(WebSite.findById(n2));
        if (!this.isValidOperType(autoBakConfig, n)) {
            return false;
        }
        Status status = document.getStatus();
        return autoBakConfig.getCanSavedDocStatus(this.getLoginUser()).indexOf(status) >= 0;
    }

    private boolean isValidOperType(AutoBakConfig autoBakConfig, int n) {
        if (autoBakConfig == null) {
            return false;
        }
        String string = autoBakConfig.getOperTypes();
        if (string == null) {
            string = "";
        }
        return string.indexOf(String.valueOf(n)) >= 0;
    }

    private boolean isValid(Document document) throws WCMException {
        this.assertNotNull(document);
        if (document.isChangeProperty("DOCVERSION")) {
            return false;
        }
        int n = 10;
        return this.isValidForAutoBak(document, n);
    }

    private DocBakMgr getDocBakMgr() throws WCMException {
        DocBakMgr docBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
        if (docBakMgr == null) {
            throw new WCMException(10, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label3", "DocBakMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u7684\u4e0d\u6b63\u786e\uff01"));
        }
        return docBakMgr;
    }

    public void autoBakDocument(Document document, int n) throws WCMException {
        if (this.isValid(document, n)) {
            this.getDocBakMgr().bakupDocument(document);
        }
    }

    private boolean isValid(Document document, int n) throws WCMException {
        this.assertNotNull(document);
        if (document.isChangeProperty("DOCVERSION")) {
            return false;
        }
        return this.isValidForAutoBak(document, n);
    }

    public void autoBakDocument(Document document) throws WCMException {
        if (!this.isValid(document)) {
            return;
        }
        DocBakMgr docBakMgr = this.getDocBakMgr();
        docBakMgr.bakupDocument(document);
    }

    public AutoBakConfig save(AutoBakConfig autoBakConfig) throws WCMException {
        this.assertNotNull(autoBakConfig);
        autoBakConfig.save(this.getLoginUser());
        return autoBakConfig;
    }

    public AutoBakConfig getAutoSaveConfig(WebSite webSite) throws WCMException {
        this.assertNotNull(webSite);
        WCMFilter wCMFilter = new WCMFilter("", "SiteId=" + webSite.getId(), "AUTOBAKCONFIGID desc");
        AutoBakConfigs autoBakConfigs = null;
        try {
            autoBakConfigs = AutoBakConfigs.openWCMObjs(this.getLoginUser(), wCMFilter);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)wCMException.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label4", "\u83b7\u53d6\u7ad9\u70b9\u7684\u6587\u6863\u81ea\u52a8\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!"), wCMException);
        }
        return autoBakConfigs == null || autoBakConfigs.isEmpty() ? null : (AutoBakConfig)autoBakConfigs.getAt(0);
    }

    public void removeConfig(WebSite webSite) throws WCMException {
        this.assertNotNull(webSite);
        AutoBakConfig autoBakConfig = this.getAutoSaveConfig(webSite);
        if (autoBakConfig == null) {
            return;
        }
        autoBakConfig.delete(this.getLoginUser());
    }
}

