/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.infoview.db.InfoviewXMLDataUpdator;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AppendixMgr {
    private static Logger s_oLogger = Logger.getLogger((String)AppendixMgr.class.getName());

    public void saveAppendixes(Document document, List list) throws WCMException {
        int n;
        if (list == null) {
            return;
        }
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label1", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406\u9644\u4ef6\uff01"));
        }
        Appendixes appendixes = this.getUnusedAppendixes(document, list);
        for (n = 0; n < appendixes.size(); ++n) {
            this.deleteAppendixFromDocument(document, (Appendix)appendixes.getAt(n));
        }
        for (n = 0; n < list.size(); ++n) {
            this.saveAppendix(document, (Appendix)list.get(n));
        }
    }

    void saveAppendix(Document document, Appendix appendix) throws WCMException {
        if (appendix == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label2", "\u9644\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (appendix.isAddMode()) {
            this.addAppendix(document, appendix);
        } else {
            this.editAppendix(document, appendix);
        }
    }

    public void addAppendix(Document document, Appendix appendix) throws WCMException {
        if (document.getId() == 0) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label3", "\u6587\u6863ID\u4e3a0\uff0c\u65e0\u6cd5\u6dfb\u52a0\u9644\u4ef6\uff01"));
        }
        appendix.setDocId(document.getId());
        String string = appendix.getFile();
        if (string == null) {
            s_oLogger.debug((Object)I18NMessage.get(AppendixMgr.class, "AppendixMgr.label4", "\u4fdd\u5b58\u9644\u4ef6\u65f6\uff0c\u9047\u5230\u65e0\u6548\u7684\u9644\u4ef6\u6587\u4ef6\uff0c\u8df3\u8fc7\u8be5\u9644\u4ef6"));
            return;
        }
        int n = appendix.getFlag();
        s_oLogger.debug((Object)string);
        if (n != 40 && string.indexOf(47) < 0) {
            string = this.moveAppendixFile(string, 10 == n);
            appendix.setFileExt(CMyFile.extractFileExt(string));
            appendix.setFile(CMyFile.extractFileName(string));
        }
        appendix.setUsedByVersion(document.getVersion(), true);
        appendix.insert(ContextHelper.getLoginUser());
    }

    public void editAppendix(Document document, Appendix appendix) throws WCMException {
        if (!appendix.canEdit(ContextHelper.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label5", "\u9644\u4ef6\u5bf9\u8c61\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (appendix.getDocId() == document.getDocId()) {
            int n = document.isChangeProperty("DOCVERSION") ? document.getNewPropertyAsInt("DOCVERSION", 0) : document.getVersion();
            appendix.setUsedByVersion(n, true);
            appendix.update(ContextHelper.getLoginUser());
        } else {
            Appendix appendix2 = new Appendix();
            appendix2.setProperties(appendix.getAllProperty());
            appendix2.setDocId(document.getDocId());
            FilesMan filesMan = FilesMan.getFilesMan();
            String string = appendix2.getFile();
            if (filesMan.fileExists(string)) {
                String string2 = filesMan.mapFilePath(string, 0);
                CMyString.setStrEndWith(string2, File.separatorChar);
                String string3 = filesMan.copyFile(string2 + string, filesMan.getFileFlag(string), false);
                appendix2.setFile(string3);
                appendix2.setUsedByVersion(document.getVersion(), true);
            }
            appendix2.insert();
        }
    }

    private String moveAppendixFile(String string, boolean bl) {
        boolean bl2;
        FilesMan filesMan = FilesMan.getFilesMan();
        if (filesMan.getFileFlag(string) == "") {
            s_oLogger.error((Object)(I18NMessage.get(AppendixMgr.class, "AppendixMgr.label6", "\u627e\u4e0d\u5230\u6587\u4ef6\u5bf9\u5e94\u7684FileFlag\uff0c\u672a\u77e5\u6587\u4ef6\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01") + string));
            return null;
        }
        String string2 = string;
        String string3 = filesMan.getFileFlag(string);
        boolean bl3 = bl2 = string3 != "W0" && string3 != "P0";
        if (bl2) {
            try {
                string2 = bl ? filesMan.moveWCMFile(string, "P0", false) : filesMan.moveWCMFile(string, "W0", false);
            }
            catch (Exception exception) {
                s_oLogger.error((Object)(I18NMessage.get(AppendixMgr.class, "AppendixMgr.label7", "\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff01") + string), (Throwable)exception);
            }
        }
        return string2;
    }

    public Appendixes getAppendixes(WCMFilter wCMFilter) throws WCMException {
        if (wCMFilter == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label8", "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        return Appendixes.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Appendix getAppendixById(int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMAPPENDIX", "WCMAPPENDIX.APPENDIXID=" + n, "", "");
        Appendixes appendixes = new Appendixes(ContextHelper.getLoginUser());
        appendixes.open(wCMFilter);
        if (appendixes == null || appendixes.size() == 0) {
            return null;
        }
        return (Appendix)appendixes.getAt(0);
    }

    void deleteAppendixFromDocument(Document document, Appendix appendix) throws WCMException {
        if (document == null || appendix == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label9", "\u6587\u6863\u6216\u9644\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\u9644\u4ef6\uff01"));
        }
        CMyBitsValue cMyBitsValue = appendix.getUsedVersions();
        cMyBitsValue.setBit(document.getVersion(), false);
        if (cMyBitsValue.getValue() == 0L) {
            appendix.delete(ContextHelper.getLoginUser());
            return;
        }
        if (!appendix.canEdit(ContextHelper.getLoginUser())) {
            return;
        }
        appendix.setUsedVersions(cMyBitsValue.getValue());
        appendix.update(ContextHelper.getLoginUser());
    }

    public void copyAppendixes(Document document, Document document2) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label10", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u5176\u9644\u4ef6\uff01"));
        }
        if (document2 == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label11", "\u76ee\u6807\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u9644\u4ef6\uff01"));
        }
        Appendixes appendixes = Appendixes.findAppendixesByObj(document);
        if (document.getAttachPic() > 0) {
            document2.canEdit(ContextHelper.getLoginUser());
            document2.setAttachPic(document.getAttachPic());
            document2.save();
        }
        int n = document.getVersion();
        int n2 = document2.getPropertyAsInt("DocFlag", 0);
        InfoviewXMLDataUpdator infoviewXMLDataUpdator = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (n2 > 0) {
            infoviewXMLDataUpdator = new InfoviewXMLDataUpdator(document2.getContent());
        }
        for (int i = 0; i < appendixes.size(); ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || !appendix.isUsedByVersion(n)) continue;
            Appendix appendix2 = (Appendix)appendix.cloneToNewWCMObj();
            appendix2.setDocId(document2.getId());
            appendix2.setUsedVersions(1L);
            appendix2.insert(ContextHelper.getLoginUser());
            if (infoviewXMLDataUpdator == null) continue;
            String string = appendix2.getRelatedColumn();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, "0");
            } else {
                hashMap.put(string, String.valueOf(Integer.parseInt((String)hashMap.get(string)) + 1));
            }
            int n3 = Integer.parseInt((String)hashMap.get(string));
            if (infoviewXMLDataUpdator.getAppenDixFieldSize(string) < n3) continue;
            infoviewXMLDataUpdator.setAppendixField(string, appendix2.getFile(), n3);
        }
        if (n2 > 0 && infoviewXMLDataUpdator != null) {
            String string = infoviewXMLDataUpdator.update(null);
            document2.canEdit(ContextHelper.getLoginUser());
            document2.setContent(string);
            document2.save(ContextHelper.getLoginUser());
        }
    }

    public Appendixes getAppendixes(Document document, int n) throws WCMException {
        return this.getAppendixes(document, n, null);
    }

    public Appendixes getAppendixes(Document document, int n, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        String string = "";
        if (n == 50) {
            string = string + "AppFlag<>?";
            wCMFilter2.addSearchValues(0, 30);
        } else if (n != -1) {
            string = string + "AppFlag=?";
            wCMFilter2.addSearchValues(0, n);
        }
        wCMFilter2.setWhere(string);
        wCMFilter2.mergeWith(wCMFilter);
        return this.getAppendixes(document, wCMFilter2);
    }

    public Appendixes getAppendixes(Document document, WCMFilter wCMFilter) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label12", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u9644\u4ef6"));
        }
        String string = "AppDocId=?";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "APPSERN");
        int n = document.getDocId();
        if (n == 0) {
            return null;
        }
        wCMFilter2.addSearchValues(0, document.getDocId());
        wCMFilter2.mergeWith(wCMFilter);
        Appendixes appendixes = Appendixes.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
        try {
            int n2 = document.getVersion();
            for (int i = appendixes.size() - 1; i >= 0; --i) {
                Appendix appendix = (Appendix)appendixes.getAt(i);
                if (appendix != null && appendix.isUsedByVersion(n2)) continue;
                appendixes.removeAt(i, false);
            }
        }
        catch (WCMException wCMException) {
            s_oLogger.debug((Object)wCMException.getMessage());
            appendixes.clear();
            throw new WCMException(1100, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label13", "\u83b7\u53d6\u5f53\u524d\u6587\u6863\u4f7f\u7528\u7684\u9644\u4ef6\u96c6\u5408\u5931\u8d25!"), wCMException);
        }
        return appendixes;
    }

    private Appendixes getUnusedAppendixes(Document document, List list) throws WCMException {
        if (list == null) {
            return null;
        }
        if (document == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label14", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u9644\u4ef6\uff01"));
        }
        if (list.size() == 0) {
            return this.getAppendixes(document, -1);
        }
        String string = "0";
        Appendix appendix = new Appendix();
        for (int i = 0; i < list.size(); ++i) {
            appendix = (Appendix)list.get(i);
            if (appendix == null) continue;
            string = string + "," + appendix.getId();
        }
        String string2 = "AppFlag <> 30 and  APPENDIXID not in (" + string + ") AND APPDOCID=" + document.getId();
        WCMFilter wCMFilter = new WCMFilter("", string2, "", "");
        return this.getAppendixes(wCMFilter);
    }

    public void deleteUnuseAppendixes(Document document, String string, int n) throws WCMException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (document == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label14", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u9644\u4ef6\uff01"));
        }
        String string2 = "APPDOCID=? and APPFLAG =?";
        if (!"0".equals(string)) {
            string2 = string2 + " and APPENDIXID not in (" + string + ")";
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "", "");
        wCMFilter.addSearchValues(document.getDocId());
        wCMFilter.addSearchValues(n);
        Appendixes appendixes = new Appendixes(ContextHelper.getLoginUser());
        appendixes.open(wCMFilter);
        int n2 = appendixes.size();
        for (int i = 0; i < n2; ++i) {
            this.deleteAppendixFromDocument(document, (Appendix)appendixes.getAt(i));
        }
    }
}

