/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.IUserLoginInfoMgr;
import com.trs.components.stat.UserLoginInfo;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class UserLoginInfoServiceProvider
implements IGlueServiceProvider {
    private IUserLoginInfoMgr m_oUserLoginInfoMgr = (IUserLoginInfoMgr)DreamFactory.createObjectById("IUserLoginInfoMgr");

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        WCMFilter wCMFilter2 = null;
        if (!CMyString.isEmpty(methodContext.getValue("userName"))) {
            wCMFilter2 = this.m_oUserLoginInfoMgr.getSearchUserName(methodContext.getValue("userName"));
        } else if (!CMyString.isEmpty(methodContext.getValue("groupName"))) {
            wCMFilter2 = this.m_oUserLoginInfoMgr.getSearchGroupName(methodContext.getValue("groupName"));
        }
        wCMFilter.mergeWith(wCMFilter2);
        if (user.isAdministrator()) {
            return this.m_oUserLoginInfoMgr.query(user, wCMFilter);
        }
        UserMgr userMgr = (UserMgr)DreamFactory.createObjectById("UserMgr");
        if (userMgr.isAdminOfGroup(user)) {
            WCMFilter wCMFilter3 = this.m_oUserLoginInfoMgr.getUsersForGrpAdmin(user);
            wCMFilter.mergeWith(wCMFilter3);
            return this.m_oUserLoginInfoMgr.query(user, wCMFilter);
        }
        WCMFilter wCMFilter4 = this.m_oUserLoginInfoMgr.getCurrUser(user);
        wCMFilter.mergeWith(wCMFilter4);
        return this.m_oUserLoginInfoMgr.query(user, wCMFilter);
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        UserLoginInfo userLoginInfo = UserLoginInfo.createNewInstance();
        userLoginInfo.setUserId(user.getId());
        userLoginInfo.setLoginTime(user.getLoginTime());
        userLoginInfo.setIpAddress(user.getLoginIP());
        this.m_oUserLoginInfoMgr.save(userLoginInfo, user);
        return userLoginInfo.getId();
    }

    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

