/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.components.stat.IBonusCalculator;
import com.trs.components.stat.IStatResult;
import com.trs.components.stat.StatAnalysisTool;
import com.trs.components.stat.StatBonusResultForUser;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class StatBonusDataForUser {
    private static Logger logger = Logger.getLogger(StatBonusDataForUser.class);
    private String[] m_pSQL = null;
    private ArrayList m_arUserNames = null;
    private ArrayList m_arDocIds = null;

    public StatBonusDataForUser(String string) {
        this.m_pSQL = new String[1];
        this.m_pSQL[0] = string;
    }

    public StatBonusDataForUser(String[] stringArray) {
        this.m_pSQL = stringArray;
    }

    public StatBonusResultForUser stat(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws Exception {
        return this.stat(cMyDateTime, cMyDateTime2, 1, true);
    }

    public StatBonusResultForUser stat(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, int n, boolean bl) throws Exception {
        CMyDateTime cMyDateTime3 = new CMyDateTime();
        cMyDateTime3.setDateTimeWithString(cMyDateTime.toString("yy-MM-01 00:00:00"));
        CMyDateTime cMyDateTime4 = new CMyDateTime();
        cMyDateTime4.setDateTimeWithString(cMyDateTime2.toString("yy-MM-01 00:00:00"));
        if (cMyDateTime4.dateDiff(2, cMyDateTime3) == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        StatBonusResultForUser statBonusResultForUser = new StatBonusResultForUser(2);
        statBonusResultForUser.setResult(this.statIssuedAmountBonus(cMyDateTime3, cMyDateTime4, bl), 0);
        statBonusResultForUser.setResult(this.statHitsBonus(cMyDateTime3, cMyDateTime4, bl), 1);
        statBonusResultForUser.setUserNames(this.m_arUserNames);
        statBonusResultForUser.setDocIds(this.m_arDocIds);
        return statBonusResultForUser;
    }

    private HashMap statIssuedAmountBonus(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, boolean bl) throws Exception {
        HashMap hashMap = this.calculateIssuedAmountBonusByMonth(cMyDateTime, cMyDateTime2, bl);
        if (this.m_arUserNames == null) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.m_arUserNames.size());
        String string = "";
        for (int i = 0; i < this.m_arUserNames.size(); ++i) {
            string = (String)this.m_arUserNames.get(i);
            CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime.clone();
            cMyDateTime3.dateAdd(2, -1);
            float f = 0.0f;
            while (cMyDateTime3.compareTo(cMyDateTime2) < 0L) {
                cMyDateTime3.dateAdd(2, 1);
                Object v = hashMap.get(string + "&" + cMyDateTime3.getDateTimeAsString("yyyy\u5e74MM\u6708"));
                if (v == null) continue;
                f += Float.parseFloat(v.toString().split("&")[0]);
            }
            linkedHashMap.put(string, String.valueOf(f));
        }
        return linkedHashMap;
    }

    public StatBonusResultForUser statIssuedAmountBonusByMonth(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, boolean bl) throws Exception {
        if (cMyDateTime2.dateDiff(2, cMyDateTime) == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        StatBonusResultForUser statBonusResultForUser = new StatBonusResultForUser(1);
        statBonusResultForUser.setResult(this.calculateIssuedAmountBonusByMonth(cMyDateTime, cMyDateTime2, bl), 0);
        return statBonusResultForUser;
    }

    private HashMap calculateIssuedAmountBonusByMonth(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, boolean bl) throws Exception {
        long l = cMyDateTime2.dateDiff(2, cMyDateTime);
        if (l == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime.clone();
        CMyDateTime cMyDateTime4 = (CMyDateTime)cMyDateTime.clone();
        cMyDateTime3.dateAdd(2, -1);
        StatAnalysisTool statAnalysisTool = new StatAnalysisTool(new String[]{this.m_pSQL[0]});
        IStatResult iStatResult = null;
        int n = 0;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(2000);
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        int n2 = 1;
        while ((long)n2 <= l) {
            List list;
            iStatResult = statAnalysisTool.stat(cMyDateTime3.dateAdd(2, 1), cMyDateTime4.dateAdd(2, 1));
            if (iStatResult != null && (list = iStatResult.sort(bl)) != null) {
                float f = 0.0f;
                IBonusCalculator iBonusCalculator = (IBonusCalculator)DreamFactory.createObjectById("IBonusCalculator");
                for (int i = 0; i < list.size(); ++i) {
                    String string = (String)list.get(i);
                    n = iStatResult.getResult(string);
                    if (n == 0) continue;
                    f = iBonusCalculator.caclulateIssuedAmountBonus(n);
                    String string2 = string.toLowerCase() + "&" + cMyDateTime3.getDateTimeAsString("yyyy\u5e74MM\u6708");
                    linkedHashMap.put(string2, f + "&" + n);
                    if (this.m_arUserNames == null) {
                        this.m_arUserNames = new ArrayList(2000);
                    }
                    if (this.m_arUserNames.indexOf(string) >= 0) continue;
                    this.m_arUserNames.add(string);
                }
            }
            ++n2;
        }
        debugTimer.stop();
        logger.debug((Object)("stat use[" + debugTimer.getTime() + "]"));
        debugTimer.start();
        return linkedHashMap;
    }

    private HashMap statHitsBonus(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, boolean bl) throws Exception {
        HashMap hashMap = this.calculateHitsBonusByMonth(cMyDateTime, cMyDateTime2, bl);
        if (this.m_arDocIds == null) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.m_arDocIds.size());
        String string = "";
        for (int i = 0; i < this.m_arDocIds.size(); ++i) {
            string = (String)this.m_arDocIds.get(i);
            CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime.clone();
            cMyDateTime3.dateAdd(2, -1);
            float f = 0.0f;
            while (cMyDateTime3.compareTo(cMyDateTime2) < 0L) {
                cMyDateTime3.dateAdd(2, 1);
                Object v = hashMap.get(string + "&" + cMyDateTime3.getDateTimeAsString("yyyy\u5e74MM\u6708"));
                if (v == null) continue;
                f += Float.parseFloat(v.toString().split("&")[0]);
            }
            linkedHashMap.put(string, String.valueOf(f));
        }
        return linkedHashMap;
    }

    public StatBonusResultForUser statHitsBonusByMonth(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, boolean bl) throws Exception {
        if (cMyDateTime2.dateDiff(2, cMyDateTime) == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        StatBonusResultForUser statBonusResultForUser = new StatBonusResultForUser(1);
        statBonusResultForUser.setResult(this.calculateHitsBonusByMonth(cMyDateTime, cMyDateTime2, bl), 0);
        statBonusResultForUser.setDocIds(this.m_arDocIds);
        return statBonusResultForUser;
    }

    private HashMap calculateHitsBonusByMonth(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, boolean bl) throws Exception {
        long l = cMyDateTime2.dateDiff(2, cMyDateTime);
        if (l == 0L) {
            logger.info((Object)"\u7edf\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u4e00\u4e2a\u6708\uff01");
            return null;
        }
        String string = this.m_pSQL[0];
        if (this.m_pSQL.length >= 2) {
            string = this.m_pSQL[1];
        }
        StatAnalysisTool statAnalysisTool = new StatAnalysisTool(new String[]{string});
        IStatResult iStatResult = null;
        int n = 0;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(2000);
        CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime.clone();
        CMyDateTime cMyDateTime4 = (CMyDateTime)cMyDateTime.clone();
        cMyDateTime3.dateAdd(2, -1);
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        int n2 = 1;
        while ((long)n2 <= l) {
            List list;
            iStatResult = statAnalysisTool.stat(cMyDateTime3.dateAdd(2, 1), cMyDateTime4.dateAdd(2, 1));
            if (iStatResult != null && (list = iStatResult.sort(bl)) != null) {
                float f = 0.0f;
                String string2 = "";
                IBonusCalculator iBonusCalculator = (IBonusCalculator)DreamFactory.createObjectById("IBonusCalculator");
                for (int i = 0; i < list.size(); ++i) {
                    string2 = (String)list.get(i);
                    n = iStatResult.getResult(string2);
                    if (n == 0) continue;
                    f = iBonusCalculator.caclulateHitsBonus(n);
                    String string3 = string2 + "&" + cMyDateTime3.getDateTimeAsString("yyyy\u5e74MM\u6708");
                    linkedHashMap.put(string3, f + "&" + n);
                    if (this.m_arDocIds == null) {
                        this.m_arDocIds = new ArrayList(2000);
                    }
                    if (this.m_arDocIds.indexOf(string2) >= 0) continue;
                    this.m_arDocIds.add(string2);
                }
            }
            ++n2;
        }
        debugTimer.stop();
        logger.debug((Object)("stat use[" + debugTimer.getTime() + "]"));
        return linkedHashMap;
    }
}

