/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DefaultStatHandler;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandler4ChnlDeptChannel
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DefaultStatHandler.class);
    private ChannelMgr m_oChannelMgr = null;
    private IChnlDeptMgr m_oChnlDeptMgr = null;
    private HashMap m_hRelGroupsOfChannel = null;
    private int m_ChannelId = 0;
    private Channels channels;

    public DocStatHandler4ChnlDeptChannel(int n) {
        this.m_ChannelId = n;
        this.m_hRelGroupsOfChannel = new HashMap();
        this.m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        this.m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
    }

    public void visitStart(ResultSet resultSet, int n) throws WCMException {
        super.visitStart(resultSet, n);
        Channel channel = Channel.findById(this.m_ChannelId);
        this.channels = (Channels)this.m_oChannelMgr.getChildren(channel, -1, false, new WCMFilter());
        this.channels.addElement(channel);
    }

    public void visitStatItem(ResultSet resultSet, int n) throws WCMException {
        try {
            int n2 = resultSet.getMetaData().getColumnCount();
            int n3 = resultSet.getInt(n2);
            if (this.channels.indexOf(n3) < 0) {
                return;
            }
            int n4 = resultSet.getInt(1);
            Channel channel = Channel.findById(this.m_ChannelId);
            DebugTimer debugTimer = new DebugTimer();
            debugTimer.start();
            Groups groups = this.makeCurrRelGroups(channel);
            debugTimer.stop();
            logger.debug((Object)("makeCurrRelGroups of Channel-" + this.m_ChannelId + " use[" + debugTimer.getTime() + "]ms"));
            debugTimer.start();
            int n5 = groups.size();
            for (int i = 0; i < n5; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                String string = group.getId() + "";
                String string2 = this.makePrivateKey(string, this.m_ChannelId + "", resultSet);
                int n6 = this.getValue(n, string2);
                int n7 = n4;
                this.setValue(n, string2, n7 += n6);
                this.addMajorObject(string);
            }
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)sQLException);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", sQLException);
        }
    }

    private String makePrivateKey(String string, String string2, ResultSet resultSet) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        String[] stringArray = new String[n - 1];
        stringArray[0] = string;
        stringArray[1] = string2;
        for (int i = 3; i < n; ++i) {
            stringArray[i - 1] = resultSet.getString(i);
        }
        return this.makeKey(stringArray);
    }

    private Groups makeCurrRelGroups(Channel channel) throws WCMException {
        User user = ContextHelper.getLoginUser();
        Groups groups = (Groups)this.m_hRelGroupsOfChannel.get(channel);
        if (groups != null) {
            return groups;
        }
        groups = new Groups(null);
        String string = this.m_oChnlDeptMgr.getDepIdsByChannel(channel).toString();
        string = string.length() <= 2 ? "" : string.substring(1, string.length() - 1);
        groups = Groups.findByIds(user, string.trim());
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group group2 = group; group2 != null; group2 = group2.getParent()) {
                groups.addElement(group2);
            }
        }
        this.m_hRelGroupsOfChannel.put(channel.getKey(), groups);
        return groups;
    }
}

