/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.ChnlDept;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ChnlDeptMgr
implements IChnlDeptMgr {
    private Logger logger = Logger.getLogger(ChnlDeptMgr.class);
    private HashMap m_hChnlDeptCacheByGroup = null;
    private HashMap m_hChnlDeptCacheByChnl = null;

    public List getChnlIdsByDep(Group group) throws WCMException {
        if (group == null) {
            return null;
        }
        this.insureCacheLoaded();
        List list = (List)this.m_hChnlDeptCacheByGroup.get(group);
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            if (string == null) continue;
            String[] stringArray = string.split(",");
            int n2 = Integer.parseInt(stringArray[0]);
            this.addToListIfNeed(n2, arrayList);
            if (Integer.parseInt(stringArray[1]) != 1) continue;
            this.dealWithChildrenChnl(Channel.findById(n2), arrayList);
        }
        return arrayList;
    }

    private void addToListIfNeed(int n, List list) {
        Integer n2 = new Integer(n);
        if (!list.contains(n2)) {
            list.add(n2);
        }
    }

    public String getChnlIdsByDepts(Groups groups) throws WCMException {
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        String string = "";
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            List list;
            Group group = (Group)groups.getAt(i);
            if (group == null || (list = this.getChnlIdsByDep(group)) == null || list.size() == 0) continue;
            string = this.addToString(string, list);
        }
        return string;
    }

    private String addToString(String string, List list) {
        if (list.size() == 0) {
            return string;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i).toString();
            if (CMyString.isEmpty(string2) || ("," + string + ",").indexOf("," + string2 + ",") != -1) continue;
            string = CMyString.isEmpty(string) ? string.concat(string2) : string.concat("," + string2);
        }
        return string;
    }

    private void dealWithChildrenChnl(Channel channel, List list) {
        if (channel == null) {
            return;
        }
        List list2 = null;
        try {
            list2 = channel.getAllChildren(User.getSystem());
        }
        catch (WCMException wCMException) {
            this.logger.error((Object)"\u83b7\u53d6\u680f\u76ee\u7684\u5b50\u680f\u76ee\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)wCMException);
            return;
        }
        if (list2 == null) {
            return;
        }
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)list2.get(i);
            if (channel2 == null) continue;
            int n2 = channel2.getId();
            this.addToListIfNeed(n2, list);
            this.dealWithChildrenChnl(channel2, list);
        }
    }

    public List getDepIdsByChannel(Channel channel) throws WCMException {
        if (channel == null) {
            return null;
        }
        this.insureCacheLoaded();
        List list = (List)this.m_hChnlDeptCacheByChnl.get(channel);
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)list.get(i);
                if (string == null) continue;
                String[] stringArray = string.split(",");
                int n2 = Integer.parseInt(stringArray[0]);
                this.addToListIfNeed(n2, arrayList);
            }
        }
        try {
            for (Channel channel2 = channel.getParent(); channel2 != null; channel2 = channel2.getParent()) {
                this.addGroupIdsIfParentNeed(channel2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"\u83b7\u53d6\u680f\u76ee\u7684\u7236\u680f\u76ee\u5bf9\u5e94\u7684\u7ec4\u7ec7\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38", (Throwable)exception);
        }
        return arrayList;
    }

    private void addGroupIdsIfParentNeed(Channel channel, List list) {
        try {
            this.insureCacheLoaded();
            List list2 = (List)this.m_hChnlDeptCacheByChnl.get(channel);
            if (list2 == null) {
                return;
            }
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray;
                String string = (String)list2.get(i);
                if (string == null || Integer.parseInt((stringArray = string.split(","))[1]) == 0) continue;
                int n2 = Integer.parseInt(stringArray[0]);
                this.addToListIfNeed(n2, list);
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)("\u83b7\u53d6\u680f\u76ee\u3010Id=" + channel.getId() + "\u3011\u7684\u76f8\u5173\u8054\u7684\u7ec4\u7ec7\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)exception);
        }
    }

    public String getDepNamesByChannel(Channel channel, User user) throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("GROUP_STAT_BY_CHANNEL", "false");
        List list = new ArrayList();
        String string2 = "\u65e0";
        if (string.equalsIgnoreCase("false")) {
            string2 = this.getGroupsByUser(user);
            return string2;
        }
        list = this.getDepIdsByChannel(channel);
        Group group = null;
        int n = 0;
        if (list.size() > 0) {
            string2 = "";
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = Integer.parseInt(list.get(i).toString());
                group = Group.findById(n);
                if (group == null) continue;
                string2 = i != n2 - 1 ? string2 + group.getName() + " , " : string2 + group.getName();
            }
        }
        return CMyString.isEmpty(string2) ? "\u65e0" : string2;
    }

    private String getGroupsByUser(User user) {
        if (user == null) {
            return null;
        }
        Groups groups = null;
        try {
            groups = user.getGroups();
        }
        catch (WCMException wCMException) {
            this.logger.error((Object)"\u6839\u636e\u7528\u6237\u83b7\u53d6\u7ec4\u7ec7\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)wCMException);
            return null;
        }
        String string = "\u65e0";
        Group group = null;
        if (groups.size() > 0) {
            string = "";
            int n = groups.size();
            for (int i = 0; i < n; ++i) {
                group = (Group)groups.getAt(i);
                if (group == null) continue;
                string = i != n - 1 ? string + group.getName() + " , " : string + group.getName();
            }
        }
        return CMyString.isEmpty(string) ? "\u65e0" : string;
    }

    public void clear() {
        if (this.m_hChnlDeptCacheByGroup != null) {
            this.m_hChnlDeptCacheByGroup.clear();
            this.m_hChnlDeptCacheByGroup = null;
        }
        if (this.m_hChnlDeptCacheByChnl != null) {
            this.m_hChnlDeptCacheByChnl.clear();
            this.m_hChnlDeptCacheByChnl = null;
        }
    }

    private void insureCacheLoaded() throws WCMException {
        if (this.m_hChnlDeptCacheByGroup == null) {
            this.doStart();
        }
    }

    public boolean init() throws WCMException {
        return this.doStart();
    }

    public boolean reinit() throws WCMException {
        if (this.m_hChnlDeptCacheByGroup != null) {
            this.m_hChnlDeptCacheByGroup.clear();
            this.m_hChnlDeptCacheByGroup = null;
        }
        if (this.m_hChnlDeptCacheByChnl != null) {
            this.m_hChnlDeptCacheByChnl.clear();
            this.m_hChnlDeptCacheByChnl = null;
        }
        return this.doStart();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean doStart() throws WCMException {
        block21: {
            if (this.m_hChnlDeptCacheByGroup != null && this.m_hChnlDeptCacheByChnl != null) {
                return true;
            }
            var1_1 = new HashMap<Group, List<E>>(100);
            var2_2 = new HashMap<Channel, List<E>>(100);
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = DBManager.getDBManager();
            var7_7 = "select ChannelId, GroupId, ContainsChildrenChnl from XWCMCHNLDEPT";
            try {
                try {
                    var3_3 = var6_6.getConnection();
                    var4_4 = var3_3.prepareStatement(var7_7);
                    var4_4.setFetchSize(1000);
                    var5_5 = var4_4.executeQuery();
                    while (var5_5.next()) {
                        var8_8 = var5_5.getInt("GroupId");
                        var9_11 = var5_5.getInt("ChannelId");
                        var10_12 = var5_5.getInt("ContainsChildrenChnl");
                        var11_13 = Group.findById(var8_8);
                        var12_14 = Channel.findById(var9_11);
                        if (var11_13 == null || var12_14 == null) continue;
                        var13_15 = new ArrayList<String>();
                        if (var1_1.containsKey(var11_13)) {
                            var13_15 = (List)var1_1.get(var11_13);
                            var13_15.add(this.makeValue(var9_11, var10_12));
                            var1_1.remove(var11_13);
                        } else {
                            var13_15.add(this.makeValue(var9_11, var10_12));
                        }
                        var1_1.put(var11_13, var13_15);
                        var14_16 = new ArrayList<String>();
                        if (var2_2.containsKey(var12_14)) {
                            var14_16 = (List)var2_2.get(var12_14);
                            var14_16.add(this.makeValue(var8_8, var10_12));
                            var2_2.remove(var12_14);
                        } else {
                            var14_16.add(this.makeValue(var8_8, var10_12));
                        }
                        var2_2.put(var12_14, var14_16);
                    }
                    this.m_hChnlDeptCacheByGroup = var1_1;
                    this.m_hChnlDeptCacheByChnl = var2_2;
                    this.logger.info((Object)"\u521d\u59cb\u5316\u680f\u76ee\u7ec4\u7ec7\u5173\u7cfb\u7f13\u51b2\u5b8c\u6210...");
                    var8_8 = 1;
                    var16_17 = null;
                    if (var3_3 != null) {
                        var6_6.freeConnection(var3_3);
                    }
                    if (var4_4 == null) break block21;
                }
                catch (SQLException var8_9) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + var7_7, var8_9);
                }
                catch (Exception var8_10) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + var7_7, var8_10);
                }
            }
            catch (Throwable var15_21) {
                var16_18 = null;
                if (var3_3 != null) {
                    var6_6.freeConnection(var3_3);
                }
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (Exception var17_20) {
                        // empty catch block
                    }
                }
                if (var5_5 == null) throw var15_21;
                try {
                    var5_5.close();
                    throw var15_21;
                }
                catch (Exception var17_20) {
                    throw var15_21;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 438->448)] { 
lbl82:
            // 1 sources

            var4_4.close();
            break block21;
lbl84:
            // 1 sources

            catch (Exception var17_19) {
                // empty catch block
            }
        }
        if (var5_5 == null) return (boolean)var8_8;
        try {}
        catch (Exception var17_19) {
            // empty catch block
            return (boolean)var8_8;
        }
        var5_5.close();
        return (boolean)var8_8;
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        this.insureCacheLoaded();
        if (baseObj instanceof ChnlDept) {
            this.putToCache((ChnlDept)baseObj);
        }
    }

    private void putToCache(ChnlDept chnlDept) throws WCMException {
        int n = chnlDept.getGroupId();
        int n2 = chnlDept.getChannelId();
        Group group = Group.findById(n);
        Channel channel = Channel.findById(n2);
        if (group == null || channel == null) {
            return;
        }
        List<String> list = new ArrayList<String>();
        if (this.m_hChnlDeptCacheByGroup.containsKey(group)) {
            list = (List)this.m_hChnlDeptCacheByGroup.get(group);
            list.add(this.makeValueOfGroup(chnlDept));
            this.m_hChnlDeptCacheByGroup.remove(group);
        } else {
            list.add(this.makeValueOfGroup(chnlDept));
        }
        this.m_hChnlDeptCacheByGroup.put(group, list);
        List<String> list2 = new ArrayList<String>();
        if (this.m_hChnlDeptCacheByChnl.containsKey(channel)) {
            list2 = (List)this.m_hChnlDeptCacheByChnl.get(channel);
            list2.add(this.makeValueOfChannel(chnlDept));
            this.m_hChnlDeptCacheByChnl.remove(channel);
        } else {
            list2.add(this.makeValueOfChannel(chnlDept));
        }
        this.m_hChnlDeptCacheByChnl.put(channel, list2);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        this.insureCacheLoaded();
        if (baseObj instanceof ChnlDept) {
            this.removeFromCache((ChnlDept)baseObj);
        }
    }

    private void removeFromCache(ChnlDept chnlDept) throws WCMException {
        String string;
        List list;
        String string2;
        int n = chnlDept.getGroupId();
        int n2 = chnlDept.getChannelId();
        Group group = Group.findById(n);
        Channel channel = Channel.findById(n2);
        if (group == null || channel == null) {
            return;
        }
        List list2 = (List)this.m_hChnlDeptCacheByGroup.get(group);
        if (list2.contains(string2 = this.makeValueOfGroup(chnlDept))) {
            list2.remove(string2);
            this.m_hChnlDeptCacheByGroup.remove(group);
            if (list2.size() > 0) {
                this.m_hChnlDeptCacheByGroup.put(group, list2);
            }
        }
        if ((list = (List)this.m_hChnlDeptCacheByChnl.get(channel)).contains(string = this.makeValueOfChannel(chnlDept))) {
            list.remove(string);
            this.m_hChnlDeptCacheByChnl.remove(channel);
            if (list.size() > 0) {
                this.m_hChnlDeptCacheByChnl.put(channel, list);
            }
        }
    }

    private String makeValueOfGroup(ChnlDept chnlDept) {
        return chnlDept.getChannelId() + "," + chnlDept.getPropertyAsInt("ContainsChildrenChnl", 0);
    }

    private String makeValueOfChannel(ChnlDept chnlDept) {
        return chnlDept.getGroupId() + "," + chnlDept.getPropertyAsInt("ContainsChildrenChnl", 0);
    }

    private String makeValue(int n, int n2) {
        return n + "," + n2;
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        CMSObj cMSObj;
        this.insureCacheLoaded();
        if (!(baseObj instanceof ChnlDept)) {
            return;
        }
        ChnlDept chnlDept = (ChnlDept)baseObj;
        int n2 = chnlDept.getNewPropertyAsInt("GroupId", 0);
        int n3 = chnlDept.getGroupId();
        int n4 = chnlDept.getNewPropertyAsInt("ChannelId", 0);
        int n5 = chnlDept.getChannelId();
        int n6 = chnlDept.getNewPropertyAsInt("ContainsChildrenChnl", -1);
        int n7 = chnlDept.getPropertyAsInt("ContainsChildrenChnl", 0);
        this.removeFromCache(chnlDept);
        List<String> list = (ArrayList<String>)this.m_hChnlDeptCacheByGroup.get(Group.findById(n3));
        List<String> list2 = (ArrayList<String>)this.m_hChnlDeptCacheByChnl.get(Channel.findById(n5));
        int n8 = n4 == 0 ? n5 : n4;
        int n9 = n2 == 0 ? n3 : n2;
        int n10 = n6 == -1 ? n7 : n6;
        String string = this.makeValue(n8, n10);
        String string2 = this.makeValue(n9, n10);
        if (n2 == 0) {
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(string);
            this.m_hChnlDeptCacheByGroup.put(Group.findById(n3), list);
        } else {
            cMSObj = Group.findById(n2);
            list = (List)this.m_hChnlDeptCacheByGroup.get(cMSObj);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(string);
            this.m_hChnlDeptCacheByGroup.remove(cMSObj);
            this.m_hChnlDeptCacheByGroup.put(cMSObj, list);
        }
        if (n4 != 0) {
            cMSObj = Channel.findById(n4);
            list2 = (List)this.m_hChnlDeptCacheByChnl.get(cMSObj);
            if (list2 == null) {
                list2 = new ArrayList<String>();
            }
            list2.add(string2);
            this.m_hChnlDeptCacheByChnl.remove(cMSObj);
            this.m_hChnlDeptCacheByChnl.put(cMSObj, list2);
        } else {
            cMSObj = Channel.findById(n5);
            list2 = (List)this.m_hChnlDeptCacheByChnl.get(cMSObj);
            if (list2 == null) {
                list2 = new ArrayList();
            }
            list2.add(string2);
            this.m_hChnlDeptCacheByChnl.put(cMSObj, list2);
        }
    }
}

