/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.HostObjHitsCount;
import com.trs.components.stat.IHitsCountHandler;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChannelHitsCountHandler
implements IHitsCountHandler {
    private Map hostHitsCountMap;
    private String hitsTime;
    private Map specialMap;
    private static Logger logger = Logger.getLogger(ChannelHitsCountHandler.class);

    public void handle(BaseObj baseObj, Map map) throws WCMException {
        Channel channel;
        if (baseObj instanceof Document) {
            channel = ((Document)baseObj).getChannel();
        } else if (baseObj instanceof Channel) {
            channel = (Channel)baseObj;
        } else {
            return;
        }
        this.hitsTime = (String)map.get("hitsTime");
        if (this.hostHitsCountMap == null) {
            this.hostHitsCountMap = new HashMap();
        }
        int n = 0;
        Integer n2 = (Integer)this.hostHitsCountMap.get(channel);
        if (n2 != null) {
            n = n2;
        }
        int n3 = Integer.parseInt((String)map.get("hitsCount"));
        n += n3;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u8ffd\u52a0\u7684\u70b9\u51fb\u91cf\u60c5\u51b5\uff1a\nobj[" + channel + "],all[" + n + "],current[" + n3 + "]"));
        }
        this.hostHitsCountMap.put(channel, new Integer(n));
    }

    public void notifyComplete() {
        if (this.hostHitsCountMap == null) {
            return;
        }
        for (Map.Entry entry : this.hostHitsCountMap.entrySet()) {
            Channel channel = (Channel)entry.getKey();
            Integer n = (Integer)entry.getValue();
            try {
                HostObjHitsCount hostObjHitsCount = new HostObjHitsCount();
                hostObjHitsCount.setHostId(channel.getId());
                hostObjHitsCount.setHostType(101);
                hostObjHitsCount.setObjCrTime(channel.getCrTime());
                hostObjHitsCount.setObjCrUser(channel.getCrUserName());
                hostObjHitsCount.setPropertyWithString("hitsTime", this.hitsTime);
                hostObjHitsCount.setSpecial(this.isSpecial(channel));
                hostObjHitsCount.setHitsCount(n);
                hostObjHitsCount.save();
            }
            catch (Exception exception) {
                logger.error((Object)("\u8bbe\u7f6e\u680f\u76ee\u5bf9\u8c61[" + channel + "]\u7684\u70b9\u51fb\u91cf\u4fe1\u606f\u65f6\u5931\u8d25"), (Throwable)exception);
            }
        }
    }

    private boolean isSpecial(BaseChannel baseChannel) throws WCMException {
        Boolean bl;
        if (this.specialMap == null) {
            this.specialMap = new HashMap();
        }
        if ((bl = (Boolean)this.specialMap.get(baseChannel)) != null) {
            return bl;
        }
        DBManager dBManager = DBManager.getDBManager();
        String string = "select 1 from XWCMSPECIAL where HOSTTYPE = 101 and HOSTID=?";
        int n = dBManager.sqlExecuteIntQuery(string, new int[]{baseChannel.getId()});
        boolean bl2 = n == 1;
        this.specialMap.put(baseChannel, new Boolean(bl2));
        return bl2;
    }
}

