/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.IKeyMaker;
import com.trs.components.stat.IStatHandler;
import com.trs.components.stat.IStatResult;
import com.trs.components.stat.StatResult;
import com.trs.infra.common.WCMException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseStatHandler
implements IStatHandler,
IKeyMaker {
    private static Logger logger = Logger.getLogger(BaseStatHandler.class);
    private static final String KEY_SEPARATOR = "#";
    private List results;
    private List majorObjects;

    public void initState() {
        this.results = new ArrayList();
        this.majorObjects = new ArrayList();
    }

    public IStatResult getResult() {
        return new StatResult(this.majorObjects, this.results, this);
    }

    protected void addMajorObject(Object object) {
        if (!this.majorObjects.contains(object)) {
            this.majorObjects.add(object);
        }
    }

    protected int getValue(int n, String string) {
        int n2 = n - 1;
        if (n2 >= this.results.size()) {
            return 0;
        }
        Map map = (Map)this.results.get(n2);
        if (map == null) {
            return 0;
        }
        Integer n3 = (Integer)map.get(string);
        if (n3 == null) {
            return 0;
        }
        return n3;
    }

    protected void setValue(int n, String string, int n2) {
        int n3 = n - 1;
        if (n3 >= this.results.size()) {
            this.results.add(n3, new HashMap());
        }
        Map map = (Map)this.results.get(n3);
        map.put(string, new Integer(n2));
    }

    protected String makeKey(ResultSet resultSet) throws WCMException {
        try {
            int n = resultSet.getMetaData().getColumnCount();
            StringBuffer stringBuffer = new StringBuffer(n * 5);
            for (int i = 2; i <= n; ++i) {
                stringBuffer.append(resultSet.getString(i)).append(KEY_SEPARATOR);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"\u6784\u9020key\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)sQLException);
            throw new WCMException("\u6784\u9020key\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", sQLException);
        }
    }

    public String makeKey(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 5);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(KEY_SEPARATOR);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String[] makeFields(String string) {
        return string.split(KEY_SEPARATOR);
    }

    public void visitEnd(int n) {
    }

    public void visitStart(ResultSet resultSet, int n) throws WCMException {
        this.results.add(new HashMap());
    }
}

