/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoUtil;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class ClassInfoServiceProviderForGB
implements ISelfDefinedServiceProvider,
IFindByIdServiceProvider {
    private IClassInfoMgr m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");

    public String createClassInfoTreeHTMLOfIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("objectIds");
        StringBuffer stringBuffer = new StringBuffer(4096);
        if (methodContext.getValue("type", 0) == 0) {
            int[] nArray = CMyString.splitToInt(string, ",");
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, 0);
        } else {
            string = this.m_oClassInfoMgr.getPath(ClassInfos.findByIds(user, string));
            int[] nArray = CMyString.splitToInt(string, ",");
            HashMap hashMap = new HashMap(nArray.length);
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, 0);
        }
        return stringBuffer.toString();
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer stringBuffer, int[] nArray, int n) throws WCMException {
        if (n == nArray.length) {
            return;
        }
        ClassInfo classInfo = ClassInfo.findById(nArray[n]);
        if (classInfo == null) {
            return;
        }
        User user = this.getLoginUser();
        ClassInfos classInfos = this.m_oClassInfoMgr.queryChildren(user, classInfo, null);
        if (classInfos.size() <= 0) {
            return;
        }
        ++n;
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            if (n + 1 < nArray.length && classInfo2.getId() == nArray[n]) {
                this.appendOneClassInfoHTML(stringBuffer, classInfo2);
                stringBuffer.append("<ul>");
                this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, n);
                stringBuffer.append("</ul>");
                continue;
            }
            this.makeClassInfoHTML(stringBuffer, classInfo2);
        }
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer stringBuffer, int[] nArray, HashMap hashMap, int n) throws WCMException {
        if (n >= nArray.length) {
            return;
        }
        if (hashMap.get(new Integer(nArray[n])) == Boolean.TRUE) {
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n + 1);
            return;
        }
        hashMap.put(new Integer(nArray[n]), Boolean.TRUE);
        ClassInfo classInfo = ClassInfo.findById(nArray[n]);
        if (classInfo == null) {
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n + 1);
            return;
        }
        User user = this.getLoginUser();
        this.appendOneClassInfoHTML(stringBuffer, classInfo);
        ClassInfos classInfos = this.m_oClassInfoMgr.queryChildren(user, classInfo, null);
        if (classInfos.size() <= 0) {
            return;
        }
        stringBuffer.append("<ul>");
        ++n;
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            if (n < nArray.length && this.isContain(nArray, classInfo2.getId())) {
                this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n);
                continue;
            }
            this.makeClassInfoHTML(stringBuffer, classInfo2);
        }
        stringBuffer.append("</ul>");
        this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n + 1);
    }

    private boolean isContain(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public String createClassInfoTreeHTMLForGB(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ParentId", 0);
        return this.createClassInfoTreeHTML(user, n);
    }

    public String createClassInfoTreeHTML(User user, int n) throws WCMException {
        ClassInfos classInfos = this.queryClassInfos(user, n, null);
        StringBuffer stringBuffer = new StringBuffer(51200);
        this.makeClassInfoHTML(stringBuffer, classInfos);
        return stringBuffer.toString();
    }

    public ClassInfos queryClassInfos(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ParentId", 0);
        return this.queryClassInfos(user, n, methodContext.getExtraWCMFilter());
    }

    public ClassInfos queryClassInfos(User user, int n, WCMFilter wCMFilter) throws WCMException {
        ClassInfo classInfo = null;
        if (n > 0) {
            classInfo = this.findClassInfoById(n);
        }
        return this.m_oClassInfoMgr.queryChildren(user, classInfo, wCMFilter);
    }

    public void deleteClassInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            this.deleteClassInfo(user, n);
        } else {
            this.deleteClassInfo(user, methodContext.getObjectIds());
        }
    }

    public void deleteClassInfo(User user, int n) throws WCMException {
        ClassInfo classInfo = this.findClassInfoById(n);
        this.m_oClassInfoMgr.deleteClassInfo(user, classInfo);
    }

    public void deleteClassInfo(User user, String string) throws WCMException {
        ClassInfos classInfos = ClassInfos.findByIds(user, string);
        if (classInfos == null) {
            throw new WCMException("\u6307\u5b9a\u8282\u70b9\u6ca1\u6709\u627e\u5230\uff01");
        }
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            this.m_oClassInfoMgr.deleteClassInfo(user, classInfo);
        }
    }

    public ClassInfo saveClassInfo(MethodContext methodContext) throws WCMException {
        return this.saveClassInfo(this.getLoginUser(), methodContext.getObjectId(), methodContext.getValue("ParentId", 0), methodContext.getValue("PreviousId", -2), methodContext.getValue("Name"), methodContext.getValue("Desc"));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public ClassInfo saveClassInfo(User user, int n, int n2, int n3, String string, String string2) throws WCMException {
        ClassInfo classInfo = null;
        if (n2 > 0 && (classInfo = ClassInfo.findById(n2)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01[Id=" + n2 + "]");
        }
        ClassInfo classInfo2 = null;
        if (n > 0) {
            classInfo2 = ClassInfo.findById(n);
            if (classInfo2 == null) {
                throw new WCMException("\u6307\u5b9a\u4e3b\u9898\u6ca1\u6709\u627e\u5230\uff01[ID=" + n + "]");
            }
        } else {
            classInfo2 = ClassInfo.createNewInstance();
            classInfo2.setParentId(n2);
            if (classInfo != null) {
                classInfo2.setRootId(classInfo.isRoot() ? classInfo.getId() : classInfo.getRootId());
            } else {
                classInfo2.setRootId(0);
            }
        }
        if (string != null) {
            classInfo2.setName(string);
        }
        if (string2 != null) {
            classInfo2.setDesc(string2);
        }
        if (n3 == -1) {
            classInfo2.setOrder(n3);
        } else if (n3 > 0) {
            int n4 = DBManager.getDBManager().sqlExecuteIntQuery("select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?", new int[]{n3});
            classInfo2.setOrder(n4);
        }
        classInfo2.save(user);
        return classInfo2;
    }

    private void makeClassInfoHTML(StringBuffer stringBuffer, ClassInfos classInfos) throws WCMException {
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            this.makeClassInfoHTML(stringBuffer, (ClassInfo)classInfos.getAt(i));
        }
    }

    private void makeClassInfoHTML(StringBuffer stringBuffer, ClassInfo classInfo) throws WCMException {
        if (classInfo == null) {
            return;
        }
        this.appendOneClassInfoHTML(stringBuffer, classInfo);
        if (classInfo.getParentId() == classInfo.getRootId()) {
            return;
        }
        int n = DBManager.getDBManager().sqlExecuteIntQuery("select CLASSINFOID from XWCMCLASSINFO where ParentId=?", new int[]{classInfo.getId()});
        if (n > 0) {
            stringBuffer.append("<ul></ul>\n");
        }
    }

    private void appendOneClassInfoHTML(StringBuffer stringBuffer, ClassInfo classInfo) {
        stringBuffer.append("<div objectId=");
        stringBuffer.append(classInfo.getId());
        stringBuffer.append(" id=node_");
        stringBuffer.append(classInfo.getId());
        stringBuffer.append(">");
        stringBuffer.append("<a href=#>");
        stringBuffer.append(CMyString.transDisplay(classInfo.getName()));
        stringBuffer.append("</a></div>");
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        ClassInfo classInfo = null;
        classInfo = n == 0 ? ClassInfo.createNewInstance() : this.findClassInfoById(n);
        return classInfo;
    }

    private ClassInfo findClassInfoById(int n) throws WCMException {
        ClassInfo classInfo = ClassInfo.findById(n);
        if (classInfo == null) {
            throw new WCMException(200006, "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=" + n + "]");
        }
        return classInfo;
    }

    public Object exists(MethodContext methodContext) throws WCMException {
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        String string = CMyString.showNull(methodContext.getValue("propertyName"), "CName");
        WCMFilter wCMFilter2 = new WCMFilter("XWCMCLASSINFO", string + "=?", "", "ClassInfoID");
        wCMFilter2.addSearchValues(methodContext.getValue("propertyValue"));
        int n = DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter2.mergeWith(wCMFilter));
        if (n > 0) {
            return ClassInfo.findById(n);
        }
        return null;
    }

    public String getPath(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("objectId", 0);
        if (n == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u5206\u7c7b\u6cd5ID");
        }
        ClassInfo classInfo = ClassInfo.findById(n);
        if (classInfo == null) {
            throw new WCMException(200006, "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=" + n + "]");
        }
        return this.m_oClassInfoMgr.getPath(classInfo);
    }

    public Reports importClassInfos(MethodContext methodContext) throws Exception {
        String string = methodContext.getValue("importFile");
        Reports reports = new Reports("\u4ece\u6587\u4ef6[" + string + "]\u5bfc\u5165\u5206\u7c7b\u6cd5!");
        String string2 = CMyFile.extractFileExt(string);
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            reports.addFailedReport("\u53c2\u6570[ImportFile=" + string + "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d", null);
            return reports;
        }
        string2 = string2.toUpperCase();
        String string3 = this.getAbsoluteFileName(string);
        if (string2.equals("TXT")) {
            this.importFromTXT(string3, reports, methodContext);
        } else if (string2.equals("ZIP")) {
            this.importFromZIP(string3, reports, methodContext);
        } else {
            reports.addFailedReport("\u53c2\u6570[ImportFile=" + string + "]\u540e\u7f00\u4e0d\u6b63\u786e\uff01\u4e0d\u662f.zip\u540e\u7f00\u540d", null);
            return reports;
        }
        return reports;
    }

    private void importFromTXT(String string, Reports reports, MethodContext methodContext) throws Exception {
        boolean bl = methodContext.getValue("ContainCode", true);
        int n = methodContext.getValue("importType", 0);
        ClassInfoUtil classInfoUtil = new ClassInfoUtil();
        String string2 = CMyFile.extractMainFileName(string);
        try {
            boolean bl2 = classInfoUtil.importClassInfos(string2, string, bl, n);
            if (bl2) {
                reports.addSucessedReport("\u6210\u529f\u5bfc\u5165\u5206\u7c7b\u6cd5\uff1a" + string2);
            }
        }
        catch (Exception exception) {
            reports.addFailedReport("\u5bfc\u5165\u5206\u7c7b\u6cd5[" + string2 + "]\u5931\u8d25", exception);
        }
    }

    private void importFromZIP(String string, Reports reports, MethodContext methodContext) {
        String string2 = CMyFile.extractFilePath(string);
        string2 = string2 + "temp" + System.currentTimeMillis() + File.separator;
        try {
            CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string2);
            try {
                cMyUnZipFile.addFileExtFilters("TXT");
                cMyUnZipFile.doUnZipAnd();
                ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
                if (arrayList == null || arrayList.isEmpty()) {
                    return;
                }
                String string3 = null;
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    string3 = (String)arrayList.get(i);
                    this.importFromTXT(string3, reports, methodContext);
                }
            }
            catch (CMyException cMyException) {
                reports.addFailedReport("Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25![File=" + string + ",DstPath=" + string2 + "]", cMyException);
            }
        }
        catch (Exception exception) {
            reports.addFailedReport("\u5bfc\u5165\u5206\u7c7b\u6cd5\u5931\u8d25!", exception);
        }
    }

    private String getAbsoluteFileName(String string) throws WCMException {
        String string2 = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String[] stringArray = new String[]{"U0", "ST"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!FilesMan.isValidFile(string, stringArray[i])) continue;
            string2 = filesMan.mapFilePath(string, 0) + string;
            break;
        }
        if (string2 == null) {
            throw new WCMException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + string + "]");
        }
        if (!CMyFile.fileExists(string2)) {
            throw new WCMException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=" + string2 + "]");
        }
        return string2;
    }
}

