/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Stack;
import org.apache.log4j.Logger;

public class ClassInfoUtil {
    private static Logger logger = Logger.getLogger(ClassInfoUtil.class);
    private int m_nRootId = 0;
    private char m_cSplitChar = (char)9;
    private HashMap m_hClassInfoMap = new HashMap();
    private Stack m_ClassInfoStack = new Stack();

    public boolean importClassInfos(String string, String string2, boolean bl, int n) throws Exception {
        if (bl) {
            return this.importFormFileByCode(string, string2, n);
        }
        return this.importFormFileByName(string, string2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importFormFileByCode(String string, String string2, int n) throws Exception {
        String string4;
        try {
            if (!this.assertClassInfoRoot(string, n)) {
                return false;
            }
            logger.debug((Object)(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label1", "\u5bfc\u5165\u5206\u7c7b\u6811\uff1a[id:") + this.m_nRootId + ",Name:" + string));
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage());
            throw exception;
        }
        File file = new File(string2);
        if (!file.exists()) {
            try {
                string4 = FilesMan.getFilesMan().mapFilePath(string2, 0);
                file = new File(string4 + string2);
                if (!file.exists()) throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
                if (!file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
                }
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
            }
        }
        string4 = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string3;
                fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "GBK"));
                while ((string3 = bufferedReader.readLine()) != null) {
                    Object object;
                    int n2;
                    String[] stringArray;
                    if ((string3 = string3.trim()).length() == 0 || (stringArray = string3.split(String.valueOf(this.m_cSplitChar))).length < 2) continue;
                    int n3 = stringArray[1].lastIndexOf(92);
                    if (n3 >= 0) {
                        stringArray[1] = stringArray[1].substring(n3 + 1);
                    }
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        object = stringArray[n2].trim();
                        System.out.println((String)object);
                    }
                    if (stringArray[0].length() == 0) continue;
                    n2 = this.makeParentId(stringArray[0]);
                    object = new ClassInfo();
                    ((ClassInfo)object).setRootId(this.m_nRootId);
                    ((ClassInfo)object).setParentId(n2);
                    ((ClassInfo)object).setCode(stringArray[0]);
                    ((ClassInfo)object).setName(stringArray[1]);
                    if (stringArray.length > 2) {
                        ((ClassInfo)object).setDesc(stringArray[2]);
                    }
                    ((ClassInfo)object).insert(this.getLoginUser());
                    this.m_hClassInfoMap.put(stringArray[0], ((BaseObj)object).getKey());
                    System.out.println("===========================");
                }
                Object var14_17 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + string2 + "]", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + string2 + "]", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            try {
                if (string4 != null) {
                    ((InputStreamReader)((Object)string4)).close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (string4 != null) {
            ((InputStreamReader)((Object)string4)).close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (fileInputStream == null) return true;
        fileInputStream.close();
        return true;
    }

    private boolean assertClassInfoRoot(String string, int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "CName=? and RootId=0", "");
        wCMFilter.addSearchValues(string);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (!classInfos.isEmpty()) {
            if (n == 0) {
                return false;
            }
            if (n == 1) {
                try {
                    this.m_nRootId = classInfos.getIdAt(0);
                    ClassInfo classInfo = ClassInfo.findById(this.m_nRootId);
                    if (classInfo != null) {
                        classInfo.setProperty("CRUSER", this.getLoginUser().getName());
                        classInfo.setProperty("CRTIME", CMyDateTime.now());
                        classInfo.save(this.getLoginUser());
                    }
                    String string2 = "delete from XWCMClassInfo where RootId=" + this.m_nRootId;
                    DBManager.getDBManager().sqlExecuteUpdate(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return true;
            }
        }
        ClassInfo classInfo = new ClassInfo();
        classInfo.setName(string);
        classInfo.setRootId(0);
        classInfo.insert(this.getLoginUser());
        this.m_nRootId = classInfo.getId();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importFormFileByName(String string, String string2, int n) throws Exception {
        String string4;
        try {
            if (!this.assertClassInfoRoot(string, n)) {
                return false;
            }
            logger.debug((Object)(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label1", "\u5bfc\u5165\u5206\u7c7b\u6811\uff1a[id:") + this.m_nRootId + ",Name:" + string));
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage());
            throw exception;
        }
        File file = new File(string2);
        if (!file.exists()) {
            try {
                string4 = FilesMan.getFilesMan().mapFilePath(string2, 0);
                file = new File(string4 + string2);
                if (!file.exists()) throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
                if (!file.isFile()) {
                    throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
                }
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label2", "\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
            }
        }
        string4 = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string3;
                fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "GBK"));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.trim().length() == 0) continue;
                    int n2 = this.getPosition(string3, this.m_cSplitChar);
                    int n3 = this.makeParentId(n2);
                    String string5 = string3.trim();
                    String[] stringArray = string5.split(this.m_cSplitChar + "+");
                    String string6 = "";
                    String string7 = "";
                    if (stringArray.length > 1) {
                        string7 = stringArray[0];
                        string6 = stringArray[1];
                    } else if (stringArray.length > 0) {
                        string6 = stringArray[0];
                    }
                    ClassInfo classInfo = new ClassInfo();
                    classInfo.setRootId(this.m_nRootId);
                    classInfo.setParentId(n3);
                    classInfo.setCode(string7);
                    classInfo.setName(string6);
                    classInfo.insert(this.getLoginUser());
                    this.m_ClassInfoStack.push(new int[]{n2, classInfo.getId()});
                }
                Object var17_20 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230[File=") + string2 + "]", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new Exception(I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef[File=") + string2 + "]", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            try {
                if (string4 != null) {
                    ((InputStreamReader)((Object)string4)).close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (string4 != null) {
            ((InputStreamReader)((Object)string4)).close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (fileInputStream == null) return true;
        fileInputStream.close();
        return true;
    }

    private int getPosition(String string, char c) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < string.length() && string.charAt(i) == c; ++i) {
            ++n;
        }
        return n;
    }

    private int makeParentId(int n) {
        if (this.m_ClassInfoStack.isEmpty()) {
            return this.m_nRootId;
        }
        int[] nArray = (int[])this.m_ClassInfoStack.peek();
        int n2 = nArray[0];
        while (n <= n2) {
            this.m_ClassInfoStack.pop();
            if (this.m_ClassInfoStack.isEmpty()) {
                return this.m_nRootId;
            }
            nArray = (int[])this.m_ClassInfoStack.peek();
            n2 = nArray[0];
        }
        return nArray[1];
    }

    private int makeParentId(String string) {
        String string2;
        Integer n = null;
        int[] nArray = new int[]{1, 2, 3, 4};
        for (int i = 0; i < nArray.length && string.length() >= nArray[i] && (n = (Integer)this.m_hClassInfoMap.get(string2 = string.substring(0, string.length() - nArray[i]))) == null; ++i) {
        }
        if (n == null) {
            return this.m_nRootId;
        }
        return n;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            user = User.findByName("admin");
        }
        return user;
    }

    public static void main(String[] stringArray) {
        String string = I18NMessage.get(ClassInfoUtil.class, "ClassInfoUtil.label5", "c:\\\u5206\u7c7b\u6cd5\\");
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                File file2 = fileArray[i];
                String string2 = file2.getName();
                int n2 = string2.indexOf(46, n = string2.lastIndexOf(File.separatorChar));
                if (n2 < 0) continue;
                ClassInfoUtil classInfoUtil = new ClassInfoUtil();
                classInfoUtil.importClassInfos(string2.substring(n + 1, n2), file2.getAbsolutePath(), false, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

