/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;

public class DataType
implements Cloneable {
    private String m_sName;
    private String m_sTypeName;
    private String m_sDataName;
    private DataType m_oDataType;
    private String m_sBaseName;
    private DataType m_oBaseType;
    private String m_sRefName;
    private DataType m_oRefType;
    private boolean m_zInnerType;
    private boolean m_zSimpleType;
    private boolean m_zComplexType;
    private ArrayList m_oChildren;
    private String m_sBindName;
    private String m_sNewBindName;
    private String m_sDisplayName;
    private String m_sNillable;
    private int m_iMaxLength;
    private int m_iMinLength;
    private String m_sDisplayFieldType;
    private Element m_oBindElement;

    public static final DataType getInnerType() {
        DataType dataType = new DataType();
        dataType.setInnerType(true);
        return dataType;
    }

    public static final DataType getSimpleType() {
        DataType dataType = new DataType();
        dataType.setSimpleType(true);
        return dataType;
    }

    public static final DataType getComplexType() {
        DataType dataType = new DataType();
        dataType.setComplexType(true);
        return dataType;
    }

    private DataType() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DataType,");
        stringBuffer.append("BindName:").append(this.m_sBindName).append(',');
        stringBuffer.append("NewBindName:").append(this.m_sNewBindName).append(',');
        stringBuffer.append("DisplayName:").append(this.m_sDisplayName).append(',');
        stringBuffer.append("Name:").append(this.m_sName).append(',');
        stringBuffer.append("TypeName:").append(this.m_sTypeName).append(',');
        stringBuffer.append("DataName:").append(this.m_sDataName).append(',');
        stringBuffer.append("DataType:").append(this.m_oDataType).append(',');
        stringBuffer.append("BaseName:").append(this.m_sBaseName).append(',');
        stringBuffer.append("BaseType:").append(this.m_oBaseType).append(',');
        stringBuffer.append("RefName:").append(this.m_sRefName).append(',');
        stringBuffer.append("InnerType:").append(this.m_zInnerType).append(',');
        stringBuffer.append("SimpleType:").append(this.m_zSimpleType).append(',');
        stringBuffer.append("ComplexType:").append(this.m_zComplexType).append(',');
        stringBuffer.append("isInnerType():").append(this.isInnerType());
        stringBuffer.append(",");
        stringBuffer.append("getXSDTypeName():").append(this.getXSDTypeName());
        stringBuffer.append(",");
        stringBuffer.append("isNillable():").append(this.isNillable());
        stringBuffer.append(",");
        stringBuffer.append("isDefaultNotNullType():").append(this.isDefaultNotNullType());
        stringBuffer.append(",");
        stringBuffer.append("m_sNillable:").append(this.m_sNillable);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected DataType cloneOne() {
        try {
            return (DataType)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getXSDTypeName() {
        if (this.m_zInnerType) {
            return this.m_sBaseName;
        }
        if (this.m_zSimpleType && this.m_oDataType != null) {
            return this.m_oDataType.getBaseName();
        }
        return "any";
    }

    public String getTRSTypeName() {
        String string = this.getXSDTypeName();
        if (string == null) {
            return "string";
        }
        if ("integer".equals(string)) {
            return "integer";
        }
        return "string";
    }

    private int getDefaultLength() {
        String string = this.getXSDTypeName();
        String string2 = this.getDisplayFieldType();
        if ("RichText".equalsIgnoreCase(string2)) {
            return 0;
        }
        if ("boolean".equalsIgnoreCase(string)) {
            return 50;
        }
        if ("integer".equalsIgnoreCase(string) || "double".equalsIgnoreCase(string) || "date".equalsIgnoreCase(string) || "datetime".equalsIgnoreCase(string)) {
            return 0;
        }
        int n = DBManager.getDBManager().getDBTypeAsInt();
        if (n == 5 || n == 6 || n == 3 || n == 7) {
            return this.isTextArea() ? 1000 : 300;
        }
        return this.isTextArea() ? 2000 : 500;
    }

    private boolean isTextArea() throws NumberFormatException {
        String string = this.getDisplayFieldType();
        if ("PlainText".equalsIgnoreCase(string)) {
            Element element = this.getBindElement();
            String string2 = CMyString.showNull(element.attributeValue("style"), "");
            String[] stringArray = string2.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                float f;
                String[] stringArray2;
                if (!stringArray[i].trim().toUpperCase().startsWith("HEIGHT") || (stringArray2 = stringArray[i].split(":")).length <= 1 || !((f = Float.parseFloat(string3 = stringArray2[1].replaceAll("[^\\d\\.]", ""))) > 30.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public int getDataTypeAsInt() {
        String string = this.getXSDTypeName();
        if ("integer".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("double".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("boolean".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("date".equalsIgnoreCase(string)) {
            return 91;
        }
        if ("datetime".equalsIgnoreCase(string)) {
            return 93;
        }
        if ("base64Binary".equalsIgnoreCase(string)) {
            return 12;
        }
        String string2 = this.getDisplayFieldType();
        if ("RichText".equalsIgnoreCase(string2)) {
            return 2005;
        }
        return 12;
    }

    private String[] splitPath(String string, String string2) {
        string2 = string2 + ':';
        String[] stringArray = string.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String string3 = stringArray[n2];
            if (string3.startsWith(string2)) {
                stringArray[n2] = string3 = string3.substring(string2.length());
            }
            if (string3.length() <= 0 || ".".equals(string3) || string3.equals(this.m_sName)) {
                --n;
                for (n3 = n2; n3 < n; ++n3) {
                    stringArray[n3] = stringArray[n3 + 1];
                }
                continue;
            }
            if ("..".equals(string3)) {
                if (--n2 < 0) {
                    n2 = 0;
                }
                --n;
                --n;
                for (n3 = n2; n3 < n; ++n3) {
                    stringArray[n3] = stringArray[n3 + 2];
                }
                continue;
            }
            ++n2;
        }
        if (stringArray.length == n) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public DataType findDataType(String string, String string2) {
        String[] stringArray = this.splitPath(string, string2);
        DataType dataType = this.findDataType(stringArray);
        if (dataType != null) {
            dataType.setBindName(string);
        }
        return dataType;
    }

    private DataType findDataType(String[] stringArray) {
        DataType dataType = this.findDataType(stringArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('_');
            }
            stringBuffer.append(stringArray[i]);
        }
        if (dataType != null) {
            dataType.setNewBindName(stringBuffer.toString());
        }
        return dataType;
    }

    private DataType findDataType(String[] stringArray, int n) {
        DataType dataType = this.findDataType(stringArray[n++]);
        if (n < stringArray.length) {
            return dataType.findDataType(stringArray, n);
        }
        return dataType;
    }

    private DataType findDataType(String string) {
        DataType dataType = this.findChild(this, string);
        if (dataType != null) {
            return dataType;
        }
        if (this.m_oDataType != null) {
            dataType = this.findChild(this.m_oDataType, string);
            if (dataType != null) {
                return dataType;
            }
            dataType = this.findDataTypeFromBase(this.m_oDataType.m_oBaseType, string);
            if (dataType != null) {
                return dataType;
            }
        }
        if (this.m_oBaseType != null) {
            dataType = this.findChild(this.m_oBaseType, string);
            if (dataType != null) {
                return dataType;
            }
            dataType = this.findDataTypeFromBase(this.m_oBaseType.m_oBaseType, string);
            if (dataType != null) {
                return dataType;
            }
        }
        return null;
    }

    private DataType findDataTypeFromBase(DataType dataType, String string) {
        if (dataType == null) {
            return null;
        }
        DataType dataType2 = this.findChild(dataType, string);
        if (dataType2 != null) {
            return dataType2;
        }
        return this.findDataTypeFromBase(dataType.m_oBaseType, string);
    }

    private DataType findChild(DataType dataType, String string) {
        dataType = this.findRefSrc(dataType);
        if (dataType.m_oChildren != null) {
            Iterator iterator = dataType.m_oChildren.iterator();
            while (iterator.hasNext()) {
                dataType = this.findRefSrc((DataType)iterator.next());
                if (!string.equals(dataType.getName())) continue;
                return dataType.cloneOne();
            }
        }
        return null;
    }

    private DataType findRefSrc(DataType dataType) {
        while (dataType.getRefType() != null) {
            dataType = dataType.getRefType();
        }
        return dataType;
    }

    public void addChild(DataType dataType) {
        if (this.m_oChildren == null) {
            this.m_oChildren = new ArrayList();
        }
        this.m_oChildren.add(dataType);
    }

    public ArrayList getChildren() {
        return this.m_oChildren;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public String getTypeName() {
        return this.m_sTypeName;
    }

    public void setTypeName(String string) {
        this.m_sTypeName = string;
    }

    public String getDataName() {
        return this.m_sDataName;
    }

    public void setDataName(String string) {
        this.m_sDataName = string;
    }

    public DataType getDataType() {
        return this.m_oDataType;
    }

    public void setDataType(DataType dataType) {
        this.m_oDataType = dataType;
    }

    public String getBaseName() {
        return this.m_sBaseName;
    }

    public void setBaseName(String string) {
        this.m_sBaseName = string;
    }

    public DataType getBaseType() {
        return this.m_oBaseType;
    }

    public void setBaseType(DataType dataType) {
        this.m_oBaseType = dataType;
    }

    public String getRefName() {
        return this.m_sRefName;
    }

    public void setRefName(String string) {
        this.m_sRefName = string;
    }

    public DataType getRefType() {
        return this.m_oRefType;
    }

    public void setRefType(DataType dataType) {
        this.m_oRefType = dataType;
    }

    public boolean isInnerType() {
        if (this.m_zInnerType) {
            return true;
        }
        if (this.m_zSimpleType) {
            if (this.m_oDataType != null) {
                return this.m_oDataType.isInnerType();
            }
            if (this.m_oBaseType != null) {
                return this.m_oBaseType.isInnerType();
            }
        }
        return false;
    }

    public void setInnerType(boolean bl) {
        this.m_zInnerType = bl;
    }

    public boolean isSimpleType() {
        return this.m_zSimpleType;
    }

    public void setSimpleType(boolean bl) {
        this.m_zSimpleType = bl;
    }

    public boolean isComplexType() {
        return this.m_zComplexType;
    }

    public void setComplexType(boolean bl) {
        this.m_zComplexType = bl;
    }

    public String getBindName() {
        return this.m_sBindName;
    }

    public void setBindName(String string) {
        this.m_sBindName = string;
    }

    public String getNewBindName() {
        return this.m_sNewBindName;
    }

    public void setNewBindName(String string) {
        this.m_sNewBindName = string;
    }

    public String getDisplayName() {
        if (this.m_sDisplayName != null && this.m_sDisplayName.length() > 0) {
            return this.m_sDisplayName;
        }
        return this.m_sName;
    }

    public void setDisplayName(String string) {
        this.m_sDisplayName = string;
    }

    public boolean isDefaultNotNullType() {
        String string = this.getXSDTypeName();
        return "integer".equalsIgnoreCase(string) || "double".equalsIgnoreCase(string) || "boolean".equalsIgnoreCase(string) || "date".equalsIgnoreCase(string) || "datetime".equalsIgnoreCase(string);
    }

    public boolean isNillable() {
        if (this.m_sNillable != null) {
            return "true".equalsIgnoreCase(this.m_sNillable);
        }
        if (this.isDefaultNotNullType()) {
            return "true".equalsIgnoreCase(this.m_sNillable);
        }
        return this.getMinLength() <= 0;
    }

    public String getNillable() {
        return this.m_sNillable;
    }

    public void setNillable(String string) {
        this.m_sNillable = string;
    }

    public int getMaxLength() {
        int n = this.m_iMaxLength;
        if (this.m_zSimpleType && this.m_oDataType != null) {
            n = this.m_oDataType.getMaxLength();
        }
        if (n <= 0) {
            n = this.getDefaultLength();
        }
        return n;
    }

    public void setMaxLength(int n) {
        this.m_iMaxLength = n;
    }

    public int getMinLength() {
        if (this.m_zSimpleType && this.m_oDataType != null) {
            return this.m_oDataType.getMinLength();
        }
        if (this.m_zSimpleType && this.m_oBaseType != null) {
            return this.m_oBaseType.getMinLength();
        }
        return this.m_iMinLength;
    }

    public void setMinLength(int n) {
        this.m_iMinLength = n;
    }

    public Element getBindElement() {
        return this.m_oBindElement;
    }

    void setBindElement(Element element) {
        this.m_oBindElement = element;
    }

    public void setTRSObjectID(int n) {
        String string = String.valueOf(n);
        this.m_oBindElement.addAttribute("trs_obj_id", string);
    }

    public void setDisplayFieldType(String string) {
        this.m_sDisplayFieldType = string;
    }

    public String getDisplayFieldType() {
        return this.m_sDisplayFieldType;
    }
}

