/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.cms.ContextHelper;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.helper.ComplexFieldData;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.FieldInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class XMLContentRender {
    private static final String ATTR_COMPLEX_FIELD = "complex_field";
    private static final String ATTR_PARENT_FLAG = "ParentFlag";
    protected static Logger logger = Logger.getLogger(XMLContentRender.class);
    private List m_oComplexFieldDatas;

    public void render(InfoViewData infoViewData, String string, String[] stringArray) throws WCMException {
        this.render(infoViewData, InfoViewHelper.parseToDocument(string), stringArray);
    }

    public void render(InfoViewData infoViewData, Document document, String[] stringArray) throws WCMException {
        Element element = document.getRootElement();
        if (element == null) {
            return;
        }
        XMLContentRender.addRootElementField(infoViewData, document);
        String[] stringArray2 = this.getNSPrefix(element, stringArray);
        if (stringArray2 == null) {
            stringArray2 = new String[]{element.getNamespacePrefix()};
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            this.addElementField(infoViewData, (Element)iterator.next(), stringArray2);
        }
    }

    static void addRootElementField(InfoViewData infoViewData, Document document) throws WCMException {
        String string = "ROOTELEMENT";
        String string2 = document.getRootElement().getQualifiedName();
        infoViewData.setProperty(string, string2);
    }

    private void setProperty(InfoViewData infoViewData, String string, String string2) throws WCMException {
        this.setProperty(infoViewData, string, string2, null);
    }

    private void setProperty(InfoViewData infoViewData, String string, String string2, Element element) throws WCMException {
        Object object;
        String string3 = "ROOTELEMENT";
        String string4 = infoViewData.getPropertyAsString(string3);
        string = string.replaceAll("(?i)^/" + string4 + "/", "");
        String string5 = InfoViewHelper.getDBFieldByField(infoViewData.getInfoViewId(), string, false);
        String string6 = InfoViewConstants.makeTrueTableName(infoViewData.getInfoViewId());
        FieldInfo fieldInfo = DBManager.getDBManager().getFieldInfo(string6, string5);
        Object object2 = object = infoViewData.isAddMode() ? infoViewData.getProperty(string5) : infoViewData.getNewProperty(string5);
        if (fieldInfo != null) {
            String string7;
            String string8;
            String string9;
            String string10;
            ComplexFieldData complexFieldData;
            boolean bl;
            Object object3;
            Object object4;
            if (CMyString.isEmpty(string2)) {
                object4 = infoViewData.getPropertyAsString(string5);
                if (CMyString.isEmpty((String)object4)) {
                    // empty if block
                }
                string2 = "";
            }
            if ((object4 = fieldInfo.getDataType()) != null) {
                int n = ((DataType)object4).getType();
                if (n == 2005) {
                    infoViewData.setProperty(string5, new CDBText(DBManager.getDBManager().getDBTypeAsInt(), string2));
                } else if (n == 91 || n == 93) {
                    object3 = new CMyDateTime();
                    try {
                        if (!CMyString.isEmpty(string2) && !(bl = ((CMyDateTime)object3).setDateTimeWithString(string2))) {
                            throw new WCMException(I18NMessage.get(XMLContentRender.class, "XMLContentRender.label1", "\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e") + string2);
                        }
                    }
                    catch (CMyException cMyException) {
                        throw new WCMException(10, I18NMessage.get(XMLContentRender.class, "XMLContentRender.label2", "\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u503c\u548c\u683c\u5f0f\u65e0\u6548\uff08CMyDateTime.setDateTimeWithString\uff09"), cMyException);
                    }
                    infoViewData.setProperty(string5, object3);
                } else if (n == 4) {
                    infoViewData.setProperty(string5, Integer.parseInt(string2));
                } else if (n == 8) {
                    infoViewData.setProperty(string5, Double.parseDouble(string2));
                } else {
                    infoViewData.setProperty(string5, string2);
                }
            } else {
                infoViewData.setProperty(string5, string2);
            }
            if (element == null) {
                return;
            }
            Element element2 = element.getParent();
            if (element2 != null && element2.attribute(ATTR_PARENT_FLAG) == null) {
                element2.addAttribute(ATTR_PARENT_FLAG, String.valueOf(element2.hashCode()));
            }
            object3 = element.attributeValue(ATTR_COMPLEX_FIELD);
            if (element2 != null) {
                object3 = CMyString.showNull(element2.attributeValue(ATTR_COMPLEX_FIELD), (String)object3);
            }
            boolean bl2 = bl = !CMyString.isEmpty((String)object3) || object != null;
            if (bl && (complexFieldData = InfoViewHelper.makeComplexFieldData(string10 = string5, string9 = CMyString.isEmpty(string9 = element.getName()) ? string : string9, string8 = CMyString.showNull(string2), string7 = element2 != null ? element2.attributeValue(ATTR_PARENT_FLAG) : "", infoViewData)) != null) {
                complexFieldData.setCrUser(infoViewData.getPropertyAsString("CrUser", ContextHelper.getLoginUser().getName()));
                this.getComplexFieldDatas().add(complexFieldData);
            }
        } else if (logger.isDebugEnabled()) {
            logger.warn((Object)(I18NMessage.get(XMLContentRender.class, "XMLContentRender.label3", "InfoPath\u540d\u79f0[") + string + I18NMessage.get(XMLContentRender.class, "XMLContentRender.label4", "]\u5bf9\u5e94\u7684\u5b57\u6bb5[") + string5 + I18NMessage.get(XMLContentRender.class, "XMLContentRender.label5", "]\u5728\u6570\u636e\u5e93\u8868[") + string6 + I18NMessage.get(XMLContentRender.class, "XMLContentRender.label6", "]\u4e2d\u4e0d\u5b58\u5728\u3002")));
        }
    }

    private String[] getNSPrefix(Element element, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        List list = element.declaredNamespaces();
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!namespace.getURI().equals(stringArray[j])) continue;
                arrayList.add(namespace.getPrefix());
            }
        }
        if (arrayList.size() <= 0) {
            return null;
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private void addElementField(InfoViewData infoViewData, Element element, String[] stringArray) throws WCMException {
        if (!this.acceptNamespace(element, stringArray)) {
            return;
        }
        if (this.acceptElement(element, stringArray)) {
            this.newElementField(infoViewData, element);
        }
        Iterator iterator = element.attributeIterator();
        while (iterator.hasNext()) {
            this.addAttributeField(infoViewData, (Attribute)iterator.next(), stringArray);
        }
        iterator = element.elementIterator();
        while (iterator.hasNext()) {
            this.addElementField(infoViewData, (Element)iterator.next(), stringArray);
        }
    }

    private final void newElementField(InfoViewData infoViewData, Element element) throws WCMException {
        String string = element.getText();
        String string2 = element.getPath();
        this.setProperty(infoViewData, string2, string, element);
    }

    private boolean acceptElement(Element element, String[] stringArray) {
        if (element.hasMixedContent()) {
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                if (!this.acceptNamespace((Element)iterator.next(), stringArray)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean acceptNamespace(Element element, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        String string = element.getNamespacePrefix();
        if (string == null || string.length() <= 0) {
            return false;
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean acceptNamespace(Attribute attribute, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        String string = attribute.getNamespacePrefix();
        if (string == null || string.length() <= 0) {
            return true;
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void addAttributeField(InfoViewData infoViewData, Attribute attribute, String[] stringArray) throws WCMException {
        if (this.acceptNamespace(attribute, stringArray)) {
            this.newAttributeField(infoViewData, attribute);
        }
    }

    private final void newAttributeField(InfoViewData infoViewData, Attribute attribute) throws WCMException {
        String string = attribute.getValue();
        String string2 = attribute.getName();
        if (this.isSystemAutoAppendAttr(string2)) {
            return;
        }
        String string3 = attribute.getPath();
        this.setProperty(infoViewData, string3, string);
    }

    private boolean isSystemAutoAppendAttr(String string) {
        return string == null || string.toLowerCase().startsWith("trs") || ATTR_COMPLEX_FIELD.equalsIgnoreCase(string);
    }

    public List getComplexFieldDatas() {
        if (this.m_oComplexFieldDatas == null) {
            this.m_oComplexFieldDatas = new ArrayList(5);
        }
        return this.m_oComplexFieldDatas;
    }
}

