/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.db.IInfoViewDBMgr;
import com.trs.components.infoview.db.InfoViewDataType;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.TableInfo;
import org.apache.log4j.Logger;

public class InfoViewDBMgr
implements IInfoViewDBMgr {
    public static double RATE_OF_FIELD_LENGTH = 1.5;
    private static Logger logger = Logger.getLogger(InfoViewDBMgr.class);
    private DBManager m_oDBMgr = DBManager.getDBManager();

    public void createDBTable(User user, int n) throws WCMException {
        String string = InfoViewConstants.makeTrueTableName(n);
        if (this.m_oDBMgr.getTableInfo(string) != null) {
            return;
        }
        this.createTableInDB(user, n, string);
        if (string != null) {
            this.m_oDBMgr.reloadTableInfo(string);
        }
    }

    private void createTableInDB(User user, int n, String string) throws WCMException {
        if (this.m_oDBMgr.getTableInfo(string) != null) {
            return;
        }
        String string2 = this.m_oDBMgr.getDBType().sqlCreateTableWithPrimary(string, InfoViewConstants.getIdFieldName(string));
        this.m_oDBMgr.sqlExecuteUpdate(string2);
        this.m_oDBMgr.reloadTableInfo(string);
        this.appendDefaultFields(user, n);
        String string3 = String.valueOf(System.currentTimeMillis());
        string3 = string3.substring(string3.length() - 9);
        String string4 = "IXIV_" + n + "_" + string3;
        String string5 = "create unique index " + string4 + " on " + string + "(" + "DocumentId" + ")";
        this.m_oDBMgr.sqlExecuteUpdate(string5);
    }

    private void createDBField(User user, int n, int n2) throws WCMException {
        String string;
        String string2 = InfoViewConstants.makeTrueTableName(n);
        if (this.m_oDBMgr.getFieldInfo(string2, string = InfoViewConstants.makeTrueFieldName(n2)) != null) {
            return;
        }
        this.createFieldInDB(user, n2, string2);
        this.m_oDBMgr.reloadTableInfo(string2);
    }

    private void createFieldInDB(User user, int n, String string) throws WCMException {
        InfoViewField infoViewField = InfoViewField.findById(n);
        String string2 = InfoViewConstants.makeTrueFieldName(n);
        String string3 = this.m_oDBMgr.getDBType().sqlAddField(string, string2, infoViewField.getDataType(), infoViewField.getMaxLength(), !infoViewField.isNillable(), infoViewField.getDefaultValue(), 0);
        this.m_oDBMgr.sqlExecuteUpdate(string3);
        infoViewField.setTrueFieldName(string2);
        infoViewField.save(user);
    }

    public String createTableSQL(int n) throws WCMException {
        String string = InfoViewConstants.makeTrueTableName(n);
        String string2 = string + "Id";
        DBType dBType = this.m_oDBMgr.getDBType();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dBType.sqlCreateTable());
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append("(\n");
        stringBuffer.append("      ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(dBType.getTypeName(4));
        stringBuffer.append(" Primary Key \n");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void deleteDBField(User user, int n, int n2) throws WCMException {
        String string;
        DBType dBType = this.m_oDBMgr.getDBType();
        String string2 = InfoViewConstants.makeTrueTableName(n);
        if (this.m_oDBMgr.getFieldInfo(string2, string = InfoViewConstants.makeTrueFieldName(n2)) != null) {
            String string3 = null;
            try {
                string3 = dBType.sqlDropField(string2, string);
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label3", "\u751f\u6210\u5220\u9664\u5b57\u6bb5\u811a\u672c\u51fa\u9519\uff01"), exception);
            }
            this.m_oDBMgr.sqlExecuteUpdate(string3);
            this.m_oDBMgr.getTableInfos().getTableInfo(string2).removeFieldInfo(string);
        }
    }

    public void deleteDBField(User user, InfoView infoView, InfoViewField infoViewField) throws WCMException {
        int n = InfoViewDBMgr.getNewRuleFromInfoViewId();
        if (infoView.getId() < n) {
            this.deleteDBField(user, infoView.getId(), infoViewField.getId());
            return;
        }
        String string = infoViewField.getDesc();
        string = LetterConvertor.convertToFirstLetter(string);
        String string2 = InfoViewConstants.makeTrueTableName(infoView.getId());
        if (this.m_oDBMgr.getFieldInfo(string2, string) == null) {
            return;
        }
        String string3 = null;
        try {
            string3 = this.m_oDBMgr.getDBType().sqlDropField(string2, string);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label3", "\u751f\u6210\u5220\u9664\u5b57\u6bb5\u811a\u672c\u51fa\u9519\uff01"), exception);
        }
        this.m_oDBMgr.sqlExecuteUpdate(string3);
        this.m_oDBMgr.getTableInfos().getTableInfo(string2).removeFieldInfo(string);
    }

    public void deleteDBTable(User user, int n) throws WCMException {
        DBType dBType = this.m_oDBMgr.getDBType();
        String string = InfoViewConstants.makeTrueTableName(n);
        if (this.m_oDBMgr.getTableInfo(string) != null) {
            String string2 = null;
            try {
                string2 = dBType.sqlDropTable(string);
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label4", "\u751f\u6210\u5220\u9664\u8868\u811a\u672c\u51fa\u9519\uff01"), exception);
            }
            this.m_oDBMgr.sqlExecuteUpdate(string2);
            this.m_oDBMgr.getTableInfos().removeTableInfo(string);
        }
    }

    public void appendDefaultFields(User user, int n) throws WCMException {
        String string = InfoViewConstants.makeTrueTableName(n);
        this.appendDefaultFields(string);
    }

    private void appendDefaultFields(String string) throws WCMException {
        TableInfo tableInfo = this.m_oDBMgr.getTableInfo(string);
        if (tableInfo == null) {
            logger.info((Object)(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label5", "\u6307\u5b9a\u7684\u8868[") + string + I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label6", "]\u4e0d\u5b58\u5728\uff01")));
            return;
        }
        boolean bl = false;
        for (int i = 0; i < InfoViewConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            InfoViewDataType infoViewDataType = InfoViewConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String string2 = infoViewDataType.getKey();
            if (tableInfo.getFieldInfo(string2) != null) {
                logger.info((Object)(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label5", "\u6307\u5b9a\u7684\u8868[") + string + I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label7", "]\u7684\u5b57\u6bb5[") + string2 + I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label1", "]\u5df2\u7ecf\u5b58\u5728\uff01")));
                continue;
            }
            bl = true;
            String string3 = this.m_oDBMgr.getDBType().sqlAddField(string, string2, infoViewDataType.getSqlDataType(), infoViewDataType.getMaxLength(), true, null, 0);
            this.m_oDBMgr.sqlExecuteUpdate(string3);
        }
        if (bl) {
            this.m_oDBMgr.reloadTableInfo(string);
        }
    }

    public void createDBField(User user, InfoView infoView, InfoViewField infoViewField) throws WCMException {
        int n = InfoViewDBMgr.getNewRuleFromInfoViewId();
        if (infoView.getId() < n) {
            this.createDBField(user, infoView.getId(), infoViewField.getId());
            return;
        }
        String string = infoViewField.getDesc();
        string = LetterConvertor.convertToFirstLetter(string);
        String string2 = InfoViewConstants.makeTrueTableName(infoView.getId());
        if (this.m_oDBMgr.getFieldInfo(string2, string) != null) {
            return;
        }
        int n2 = (int)((double)infoViewField.getMaxLength() * RATE_OF_FIELD_LENGTH);
        String string3 = this.m_oDBMgr.getDBType().sqlAddField(string2, string, infoViewField.getDataType(), n2, !infoViewField.isNillable(), infoViewField.getDefaultValue(), 0);
        this.m_oDBMgr.sqlExecuteUpdate(string3);
        infoViewField.setTrueFieldName(string);
        infoViewField.save(user);
        this.m_oDBMgr.reloadTableInfo(string2);
    }

    private static int getNewRuleFromInfoViewId() throws WCMException {
        int n = -1;
        String string = ConfigServer.getServer().getSysConfigValue("NEWRULE_FROM_INFOVIEWID", "-1");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label8", "\u65b0\u89c4\u5219\u8d77\u59cb\u7684ID\u914d\u7f6e\u9519\u8bef![") + string + "]"), (Throwable)numberFormatException);
            n = -1;
        }
        return n;
    }
}

