/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;

public class WidgetInstParameter
extends CMSObj {
    public static final int OBJ_TYPE = 1568980485;
    public static final String DB_TABLE_NAME = "XWCMWIDGETINSTPARAMETER";
    public static final String DB_ID_NAME = "WIDGETINSTPARAMETERID";
    public static final int MAX_BYTE_LENGTH_4_STRING = 1000;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1568980485;
    }

    public int getWidgetInstId() {
        return this.getPropertyAsInt("WIDGETINSTID", 0);
    }

    public boolean setWidgetInstId(int n) throws WCMException {
        return this.setProperty("WIDGETINSTID", n);
    }

    public String getParamName() {
        return this.getPropertyAsString("PARAMNAME");
    }

    public boolean setParamName(String string) throws WCMException {
        return this.setProperty("PARAMNAME", string);
    }

    public String getParamValue() {
        String string = this.getPropertyAsString("PARAMVALUE");
        if (CMyString.isEmpty(string)) {
            return this.getParamClobValue();
        }
        return string;
    }

    public boolean setParamValue(String string) throws WCMException {
        if (CMyString.getBytesLength(string) > 1000) {
            this.setProperty("PARAMVALUE", "");
            return this.setParamClobValue(string);
        }
        if (CMyString.isEmpty(this.getPropertyAsString("PARAMVALUE"))) {
            this.setParamClobValue("");
        }
        return this.setProperty("PARAMVALUE", string);
    }

    private String getParamClobValue() {
        CDBText cDBText = (CDBText)this.getProperty("PARAMCLOBVALUE");
        if (cDBText == null) {
            return null;
        }
        return cDBText.getText();
    }

    private boolean setParamClobValue(String string) throws WCMException {
        return this.setProperty("PARAMCLOBVALUE", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String string = this.getParamName();
            if (!CMyString.isEmpty(string)) {
                this.setParamName(string.toUpperCase());
            }
        } else {
            String string = this.getNewPropertyAsString("PARAMNAME");
            if (!CMyString.isEmpty(string)) {
                this.setParamName(string.toUpperCase());
            }
            if (!this.isModified()) {
                throw new WCMException(1107, "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(WidgetInstParameter.isValid)");
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public static final WidgetInstParameter findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (WidgetInstParameter)BaseObj.findById(WidgetInstParameter.class, n);
    }

    public static final WidgetInstParameter createNewInstance() throws WCMException {
        return (WidgetInstParameter)BaseObj.createNewInstance(WidgetInstParameter.class);
    }

    public static final WidgetInstParameter findByKey(Object object) throws WCMException {
        return (WidgetInstParameter)BaseObj.findByKey(WidgetInstParameter.class, object);
    }
}

