/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IPageStyleServiceProvider;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyleExporter;
import com.trs.components.common.publish.widget.PageStyleImporter;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PageStyleServiceProvider
implements IPageStyleServiceProvider {
    private static transient Logger mLogger = Logger.getLogger(PageStyleServiceProvider.class);
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
    private IStyleCenterMgr m_oStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        PageStyles pageStyles = PageStyles.findByIds(user, string);
        for (int i = 0; i < pageStyles.size(); ++i) {
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null) continue;
            boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 13);
            if (!bl) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
            }
            this.m_oPageStyleMgr.delete(user, pageStyle);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        PageStyles pageStyles = this.m_oPageStyleMgr.query(wCMFilter);
        for (int i = pageStyles.size() - 1; i >= 0; --i) {
            boolean bl;
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null || (bl = SpecialAuthServer.hasRight(user, pageStyle, 4))) continue;
            pageStyles.removeAt(i, false);
        }
        return pageStyles;
    }

    public int save(MethodContext methodContext) throws Throwable {
        int n;
        boolean bl;
        User user = this.getLoginUser();
        int n2 = methodContext.getObjectId();
        PageStyle pageStyle = null;
        if (n2 > 0) {
            pageStyle = PageStyle.findById(n2);
            if (pageStyle == null) {
                throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n2 + "]");
            }
        } else {
            pageStyle = new PageStyle();
        }
        if (!(bl = SpecialAuthServer.hasRight(user, pageStyle, n = n2 > 0 ? 12 : 11))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (n2 > 0 ? "\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01" : "\u65b0\u5efa\u98ce\u683c\uff01"));
        }
        String[] stringArray = new String[]{"ObjectId"};
        if (n2 > 0) {
            stringArray = new String[]{"ObjectId", "StyleName"};
        }
        pageStyle = (PageStyle)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, pageStyle, stringArray);
        this.m_oPageStyleMgr.save(this.getLoginUser(), pageStyle);
        if (n2 == 0) {
            this.m_oStyleCenterMgr.createImgesDir(pageStyle);
            this.m_oStyleCenterMgr.copySystemStyle(user, pageStyle);
            StyleItem styleItem = new StyleItem();
            styleItem.setClassName("template_box_width");
            styleItem.setClassValue("950px");
            this.m_oStyleItemMgr.save(user, pageStyle, styleItem);
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        return pageStyle.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveBaseStyle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 12);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new StyleItem());
        xMLToCMSObj.parse(methodContext.getValue("StyleItemXML"));
        this.m_oStyleItemMgr.deleteUnuseStyleItems(pageStyle, xMLToCMSObj.getObjectIds());
        boolean bl2 = true;
        try {
            int n2 = xMLToCMSObj.getCMSObjs().length;
            for (int i = 0; i < n2; ++i) {
                StyleItem styleItem = (StyleItem)xMLToCMSObj.getCMSObjs()[i];
                if (styleItem == null) continue;
                this.m_oStyleItemMgr.save(user, pageStyle, styleItem);
            }
            bl2 = false;
            Object var12_12 = null;
            if (bl2) {
                xMLToCMSObj.cancelUpdate();
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (bl2) {
                xMLToCMSObj.cancelUpdate();
            }
            throw throwable;
        }
        try {
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        catch (WCMException wCMException) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + wCMException));
        }
        return pageStyle.getId();
    }

    public int saveCustomStyle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        String string = methodContext.getValue("CustomStyle");
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 12);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        pageStyle.setCustomStyle(string);
        this.m_oPageStyleMgr.save(this.getLoginUser(), pageStyle);
        try {
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        catch (WCMException wCMException) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + wCMException));
        }
        return pageStyle.getId();
    }

    public int saveStyleThumb(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        String string = methodContext.getValue("StyleThumb");
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 12);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        pageStyle.setStyleThumb(string);
        this.m_oPageStyleMgr.save(this.getLoginUser(), pageStyle);
        this.m_oStyleCenterMgr.saveStyleThumb(string);
        return pageStyle.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return PageStyle.findById(methodContext.getObjectId());
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return PageStyles.findByIds(this.getLoginUser(), methodContext.getObjectIds());
    }

    public String exportCssFile(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 4);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oStyleCenterMgr.export(pageStyle);
    }

    public String exportPageStyleZip(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        PageStyles pageStyles = PageStyles.findByIds(user, string);
        for (int i = pageStyles.size() - 1; i >= 0; --i) {
            boolean bl;
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null || (bl = SpecialAuthServer.hasRight(user, pageStyle, 4))) continue;
            pageStyles.removeAt(i, false);
        }
        PageStyleExporter pageStyleExporter = (PageStyleExporter)DreamFactory.createObjectById("PageStyleExporter");
        return pageStyleExporter.export(pageStyles, false);
    }

    public String importPageStyleZip(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("PageStyleZipFile");
        int n = methodContext.getValue("ImportMode", 1);
        int n2 = methodContext.getValue("SubStyleImportMode", 1);
        if (string == null) {
            throw new WCMException("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e3anull!");
        }
        boolean bl = SpecialAuthServer.hasRight(user, PageStyle.createNewInstance(), 11);
        if (!bl) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u65b0\u5efa\u98ce\u683c\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5bfc\u5165\u98ce\u683c");
        }
        PageStyleImporter pageStyleImporter = (PageStyleImporter)DreamFactory.createObjectById("PageStyleImporter");
        Reports reports = pageStyleImporter.importFromFile(string, n, n2);
        if (reports == null) {
            return null;
        }
        ArrayList arrayList = reports.getExtraData();
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (string2 == null || "".equals(string2)) continue;
            if (!bl2) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string2);
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String checkExistPageStyle(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("PageStyleZipFile");
        if (string == null) {
            throw new WCMException("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e3anull!");
        }
        PageStyleImporter pageStyleImporter = (PageStyleImporter)DreamFactory.createObjectById("PageStyleImporter");
        return pageStyleImporter.checkPageStyleNameExists(string);
    }

    public void importCssFile(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        String string = methodContext.getValue("UploadCssFile");
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        this.m_oStyleCenterMgr.importCssFile(pageStyle, string);
    }

    public String makeCssFile(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 14);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
    }

    public int copy(MethodContext methodContext) throws Throwable {
        boolean bl;
        User user = this.getLoginUser();
        int n = methodContext.getValue("SourcePageStyleId", -1);
        String string = methodContext.getValue("StyleName");
        String string2 = methodContext.getValue("StyleDesc");
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        String string3 = pageStyle.getStyleThumb();
        PageStyle pageStyle2 = new PageStyle();
        pageStyle2.setStyleName(string);
        pageStyle2.setStyleDesc(string2);
        if (!CMyString.isEmpty(string3)) {
            pageStyle2.setStyleThumb(string3);
        }
        if (!(bl = SpecialAuthServer.hasRight(user, pageStyle2, 11))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u7c7b\u4f3c\u521b\u5efa\u98ce\u683c\u3010" + pageStyle2.getStyleDesc() + "\u3011\uff01");
        }
        pageStyle2 = this.m_oPageStyleMgr.copy(this.getLoginUser(), pageStyle, pageStyle2);
        return pageStyle2.getId();
    }

    public boolean checkStyleName(MethodContext methodContext) throws WCMException {
        String string = methodContext.getValue("StyleName");
        if (CMyString.isEmpty(string)) {
            throw new WCMException("\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u98ce\u683c\u540d\u79f0\u3010StyleName\u3011\uff01");
        }
        int n = methodContext.getObjectId();
        WCMFilter wCMFilter = new WCMFilter("XWCMPAGESTYLE", "", "", "PageStyleId");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StyleName=?");
        if (n > 0) {
            stringBuffer.append(" and PageStyleId not in (" + n + ")");
        }
        wCMFilter.addSearchValues(string);
        wCMFilter.setWhere(stringBuffer.toString());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public boolean checkStyleDesc(MethodContext methodContext) throws WCMException {
        String string = methodContext.getValue("StyleDesc");
        if (CMyString.isEmpty(string)) {
            throw new WCMException("\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u98ce\u683c\u540d\u79f0\u3010StyleDesc\u3011\uff01");
        }
        int n = methodContext.getObjectId();
        WCMFilter wCMFilter = new WCMFilter("XWCMPAGESTYLE", "", "", "PageStyleId");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StyleDesc=?");
        if (n > 0) {
            stringBuffer.append(" and PageStyleId not in (" + n + ")");
        }
        wCMFilter.addSearchValues(string);
        wCMFilter.setWhere(stringBuffer.toString());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public String findStyleImageDir(MethodContext methodContext) throws WCMException {
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (n > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        return this.m_oStyleCenterMgr.findStyleImageDir(pageStyle);
    }

    public String makePreviewCssContent(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 14);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle);
    }

    public String previewStyle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 14);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new StyleItem());
        xMLToCMSObj.parse(methodContext.getValue("StyleItemXML"));
        StyleItems styleItems = StyleItems.createNewInstance(user);
        int n2 = xMLToCMSObj.getCMSObjs().length;
        for (int i = 0; i < n2; ++i) {
            StyleItem styleItem = (StyleItem)xMLToCMSObj.getCMSObjs()[i];
            if (styleItem == null) continue;
            styleItem.setId(i + 1);
            styleItem.setAddMode(false);
            styleItem.setStyleObjId(n);
            styleItem.setStyleObjType(368170809);
            styleItems.addElement(styleItem);
        }
        return this.m_oPageStyleMgr.previewStyle(pageStyle, styleItems);
    }

    public PageStyles queryPageStyles(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = "PageStyleId!=0";
        WCMFilter wCMFilter = new WCMFilter("", string, "", "");
        PageStyles pageStyles = this.m_oPageStyleMgr.query(wCMFilter);
        for (int i = pageStyles.size() - 1; i >= 0; --i) {
            boolean bl;
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null || (bl = SpecialAuthServer.hasRight(user, pageStyle, 4))) continue;
            pageStyles.removeAt(i, false);
        }
        return pageStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int savePageOtherStyle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 12);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\uff01");
        }
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new StyleItem());
        xMLToCMSObj.parse(methodContext.getValue("StyleItemXML"));
        this.m_oStyleItemMgr.deleteUnusePageOtherStyleItems(pageStyle, xMLToCMSObj.getObjectIds());
        boolean bl2 = true;
        try {
            int n2 = xMLToCMSObj.getCMSObjs().length;
            for (int i = 0; i < n2; ++i) {
                StyleItem styleItem = (StyleItem)xMLToCMSObj.getCMSObjs()[i];
                if (styleItem == null) continue;
                this.m_oStyleItemMgr.savePageOtherStyleItem(user, pageStyle, styleItem);
            }
            bl2 = false;
            Object var12_12 = null;
            if (bl2) {
                xMLToCMSObj.cancelUpdate();
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (bl2) {
                xMLToCMSObj.cancelUpdate();
            }
            throw throwable;
        }
        try {
            this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        catch (WCMException wCMException) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + wCMException));
        }
        return pageStyle.getId();
    }

    public ArrayList queryUploadImageFileList(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u9875\u9762\u98ce\u683c[PageStyleId=" + n + "]\u4e0d\u5b58\u5728\uff01");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 14);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u5c5e\u4e8e\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\u7684\u56fe\u7247\uff01");
        }
        String string = methodContext.getValue("FilterExts");
        ArrayList<File> arrayList = new ArrayList<File>();
        IStyleCenterMgr iStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
        String string2 = iStyleCenterMgr.findStyleImageDir(pageStyle);
        if (string2 == null) {
            return arrayList;
        }
        File file = new File(string2);
        if (file == null) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2 == null || file2.isDirectory() || string != null && this.ignoreFile(file2, string)) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private boolean ignoreFile(File file, String string) {
        if (file == null || string == null) {
            return true;
        }
        string = "," + string + ",";
        String string2 = file.getName();
        int n = string2.indexOf(".");
        if (n < 0 || string2.endsWith(".")) {
            return true;
        }
        String string3 = "," + string2.substring(n + 1) + ",";
        return string.indexOf(string3) < 0;
    }

    public void deleteUploadImages(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        PageStyle pageStyle = PageStyle.findById(n);
        if (pageStyle == null) {
            throw new WCMException("\u9875\u9762\u98ce\u683c[PageStyleId=" + n + "]\u4e0d\u5b58\u5728\uff01");
        }
        boolean bl = SpecialAuthServer.hasRight(user, pageStyle, 13);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u5c5e\u4e8e\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011\u7684\u56fe\u7247\uff01");
        }
        String string = methodContext.getValue("DeleteImgNames");
        IStyleCenterMgr iStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
        String string2 = iStyleCenterMgr.findStyleImageDir(pageStyle);
        if (string2 == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c[Id=" + n + "]\u7684\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84\u4e3anull\uff01");
        }
        File file = new File(string2);
        if (file == null || !file.exists()) {
            throw new WCMException("\u9875\u9762\u98ce\u683c[Id=" + n + "]\u6240\u5bf9\u5e94\u7684\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84[" + string2 + "]\u4e0d\u5b58\u5728\uff01");
        }
        File[] fileArray = file.listFiles();
        String string3 = null;
        string = "," + string + ",";
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2 == null || file2.isDirectory() || string.indexOf(string3 = "," + file2.getName() + ",") < 0) continue;
            file2.delete();
        }
    }
}

