/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.StyleHelper;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.components.common.publish.widget.StyleRepeatNameHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;

public class ContentStyleMgr
implements IContentStyleMgr {
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(User user, ContentStyle contentStyle) throws WCMException {
        if (contentStyle == null) {
            return;
        }
        this.m_oStyleItemMgr.delete(user, contentStyle);
        contentStyle.delete(user);
    }

    public String makeCssContent(ContentStyle contentStyle) throws WCMException {
        if (contentStyle == null) {
            return "";
        }
        String string = contentStyle.getCustomStyle();
        if (string != null && !string.trim().equals("")) {
            return StyleHelper.makeCustomCssContent(contentStyle.getCssFlag(), string);
        }
        String string2 = contentStyle.getTemplate();
        if (string2 == null || string2.equals("")) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u6a21\u677f\u540d\u79f0\u5931\u8d25\uff01sTemplateName=[" + string2 + "]");
        }
        String string3 = StylePathHelper.getCssTemplateFilePath() + string2;
        String string4 = "";
        try {
            string4 = CMyFile.readFile(string3, "UTF-8");
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
        if (string4 == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + string2);
        }
        if (string4.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + string2);
        }
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(contentStyle, null);
        return StyleHelper.makeCSSContent(contentStyle.getCssFlag(), string4, styleItems);
    }

    public ContentStyles query(PageStyle pageStyle, WCMFilter wCMFilter) throws WCMException {
        int n = pageStyle == null ? 0 : pageStyle.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "PageStyleId=?", "");
        wCMFilter2.addSearchValues(n);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return ContentStyles.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public ContentStyle save(User user, ContentStyle contentStyle) throws WCMException {
        if (contentStyle == null) {
            throw new WCMException("\u8981\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a!ContentStyle=[" + contentStyle + "]");
        }
        if (contentStyle.isAddMode()) {
            contentStyle.insert(user);
        } else {
            contentStyle.update(user);
        }
        return contentStyle;
    }

    public ContentStyle copy(User user, PageStyle pageStyle, ContentStyle contentStyle) throws WCMException {
        if (contentStyle == null) {
            return null;
        }
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        ContentStyle contentStyle2 = (ContentStyle)contentStyle.cloneToNewObj();
        contentStyle2.setPageStyleId(n);
        contentStyle2.setSrcContentStyleId(contentStyle.getId());
        if (contentStyle.getPageStyleId() == 0 || n == 0) {
            contentStyle2.setIsPrivate(0);
        } else {
            contentStyle2.setIsPrivate(1);
        }
        if (n == contentStyle.getPageStyleId()) {
            contentStyle2.setCssFlag(this.makeCssFlag(pageStyle));
        }
        this.save(user, contentStyle2);
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(contentStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            StyleItem styleItem2 = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(user, contentStyle2, styleItem2);
        }
        return contentStyle2;
    }

    public ContentStyle copy(User user, PageStyle pageStyle, ContentStyle contentStyle, int n, Reports reports) throws WCMException {
        Object object;
        Object object2;
        Object object3;
        if (contentStyle == null) {
            return null;
        }
        int n2 = 0;
        if (pageStyle != null) {
            n2 = pageStyle.getId();
        }
        ContentStyle contentStyle2 = (ContentStyle)contentStyle.cloneToNewObj();
        String string = pageStyle == null ? "\u7cfb\u7edf\u5185\u5bb9\u98ce\u683c" : "\u9875\u9762\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011";
        ContentStyle contentStyle3 = ContentStyles.findByCssFlagAndPageStyle(user, contentStyle2.getCssFlag(), n2);
        if (contentStyle3 != null) {
            object3 = contentStyle3.getCssFlag();
            String string2 = contentStyle3.getStyleName();
            object2 = StyleRepeatNameHelper.processCssFlag((String)object3, n, 3);
            object = StyleRepeatNameHelper.processStyleName(string2, n, 3);
            if (object2 == null) {
                reports.addSucessedReport(CMyString.format("\u5ffd\u7565\u5c06\u5185\u5bb9\u98ce\u683c{0}\u590d\u5236\u5230{1}!", new String[]{object3, string}));
                return null;
            }
            if (((String)object2).equals(object3)) {
                this.delete(this.getLoginUser(), contentStyle3);
                reports.addSucessedReport(CMyString.format("\u8986\u76d6\u4e86{0}\u4e0b\u540c\u540d\u7684\u5185\u5bb9\u98ce\u683c!", new String[]{string}));
            } else {
                contentStyle2.setCssFlag((String)object2);
                contentStyle2.setStyleName((String)object);
                contentStyle2.setStyleDesc((String)object);
                reports.addSucessedReport(CMyString.format("\u590d\u5236\u5185\u5bb9\u98ce\u683c\u5230{0}\u6210\u529f!", new String[]{string}));
            }
        }
        contentStyle2.setPageStyleId(n2);
        contentStyle2.setSrcContentStyleId(contentStyle.getId());
        if (contentStyle.getPageStyleId() == 0 || n2 == 0) {
            contentStyle2.setIsPrivate(0);
        } else {
            contentStyle2.setIsPrivate(1);
        }
        if (n2 == contentStyle.getPageStyleId()) {
            contentStyle2.setCssFlag(this.makeCssFlag(pageStyle));
        }
        this.save(user, contentStyle2);
        object3 = this.m_oStyleItemMgr.queryStyleItems(contentStyle, null);
        for (int i = 0; i < ((BaseObjs)object3).size(); ++i) {
            object2 = (StyleItem)((BaseObjs)object3).getAt(i);
            if (object2 == null) continue;
            object = (StyleItem)((BaseObj)object2).cloneToNewObj();
            this.m_oStyleItemMgr.save(user, contentStyle2, (StyleItem)object);
        }
        if (contentStyle3 == null) {
            reports.addSucessedReport(CMyString.format("\u590d\u5236\u5185\u5bb9\u98ce\u683c\u5230{0}\u6210\u529f!", new String[]{string}));
        }
        return contentStyle2;
    }

    private String makeCssFlag(PageStyle pageStyle) throws WCMException {
        ContentStyles contentStyles = this.queryContenetStyles(pageStyle);
        if (contentStyles.size() < 10) {
            return "f0" + contentStyles.size();
        }
        return "f" + contentStyles.size();
    }

    public ContentStyles queryContenetStyles(PageStyle pageStyle) throws WCMException {
        int n = pageStyle == null ? 0 : pageStyle.getId();
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId=?", "");
        wCMFilter.addSearchValues(n);
        return ContentStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    public boolean checkCssFlag(PageStyle pageStyle, ContentStyle contentStyle, String string) throws WCMException {
        int n = pageStyle == null ? 0 : pageStyle.getId();
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId=? and CssFlag='" + string + "'", "");
        wCMFilter.addSearchValues(n);
        ContentStyles contentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (contentStyle != null) {
            contentStyles.remove(contentStyle, false);
        }
        return contentStyles == null || contentStyles.isEmpty();
    }

    public boolean checkStyleName(PageStyle pageStyle, ContentStyle contentStyle, String string) throws WCMException {
        int n = pageStyle == null ? 0 : pageStyle.getId();
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId=? and StyleName='" + string + "'", "");
        wCMFilter.addSearchValues(n);
        ContentStyles contentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (contentStyle != null) {
            contentStyles.remove(contentStyle, false);
        }
        return contentStyles == null || contentStyles.isEmpty();
    }

    public ContentStyles findByCssFlagAndPageStyle(String string, PageStyle pageStyle) throws WCMException {
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        String string2 = "CssFlag='" + string + "'";
        if (n > 0) {
            string2 = string2 + " and PageStyleId=" + n;
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        ContentStyles contentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        return contentStyles;
    }

    public ContentStyles findByStyleNameAndPageStyle(String string, PageStyle pageStyle) throws WCMException {
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        String string2 = "StyleName='" + string + "'";
        if (n > 0) {
            string2 = string2 + " and PageStyleId=" + n;
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        ContentStyles contentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        return contentStyles;
    }
}

