/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class TempAppendix
extends CMSObj {
    public static final int OBJ_TYPE = 104;
    public static final String DB_TABLE_NAME = "WCMTEMPAPPENDIX";
    public static final String DB_ID_NAME = "TEMPAPPENDIXID";
    public static final int FLAG_NEW = 0;
    public static final int FLAG_DELETED = 1;
    public static final int FLAG_UPDATED = 2;
    public static final int FLAG_PUBLISHED = 3;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 104;
    }

    public int getRootType() {
        return this.getPropertyAsInt("ROOTTYPE", 0);
    }

    public int getRootId() {
        return this.getPropertyAsInt("ROOTID", 0);
    }

    public IPublishFolder getRoot() throws Exception {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getRootType(), this.getRootId());
    }

    public boolean setRoot(int n, int n2) throws WCMException {
        return this.setProperty("ROOTTYPE", n) && this.setProperty("ROOTID", n2);
    }

    public boolean setRoot(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, I18NMessage.get(TempAppendix.class, "TempAppendix.label1", "\u65e0\u6548\u7684\u6587\u4ef6\u5939\u6839\u76ee\u5f55\u5bf9\u8c61"));
        }
        return this.setRoot(iPublishFolder.getType(), iPublishFolder.getId());
    }

    public int getFlag() {
        return this.getPropertyAsInt("APDFLAG", 0);
    }

    public boolean setFlag(int n) throws WCMException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new WCMException(10, I18NMessage.get(TempAppendix.class, "TempAppendix.label2", "\u65e0\u6548\u7684\u9644\u4ef6\u6807\u8bc6\uff1a") + n);
        }
        return this.setProperty("APDFLAG", n);
    }

    public String getFile() {
        return (String)this.getProperty("APDFILE");
    }

    public boolean setFile(String string) throws WCMException {
        return this.setProperty("APDFILE", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("ROOTID") == null) {
                throw new WCMException(1106, I18NMessage.get(TempAppendix.class, "TempAppendix.label3", "\u5c5e\u6027WebSite\u6ca1\u6709\u8bbe\u7f6e(TempAppendix.isValid)"));
            }
            if (this.getProperty("APDFILE") == null) {
                throw new WCMException(1106, I18NMessage.get(TempAppendix.class, "TempAppendix.label4", "\u5c5e\u6027File\u6ca1\u6709\u8bbe\u7f6e(TempAppendix.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(TempAppendix.class, "TempAppendix.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(TempAppendix.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public boolean addRelation(int n) throws WCMException {
        Template template = Template.findById(n);
        return this.addRelation(template);
    }

    public boolean addRelation(Template template) throws WCMException {
        if (template == null || !template.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(TempAppendix.class, "TempAppendix.label6", "\u6307\u5b9a\u7684\u6a21\u677f\u5bf9\u8c61\u65e0\u6548\uff08TempAppendix.addRelation\uff09"));
        }
        try {
            String[] stringArray = new String[]{"insert into wcmTempApdRel(TempId,AppendixId) values(" + template.getId() + "," + this.getId() + ")"};
            this.getDBManager().sqlExecuteUpdate(stringArray);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(TempAppendix.class, "TempAppendix.label7", "\u6dfb\u52a0\u6a21\u677f\u9644\u4ef6\u5173\u8054\u65f6\u51fa\u9519\uff08TemplateAppendix.deleteRelation\uff09"), exception);
        }
        return true;
    }

    public boolean deleteRelation(Template template) throws WCMException {
        if (template == null || !template.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(TempAppendix.class, "TempAppendix.label8", "\u6307\u5b9a\u6a21\u677f\u5bf9\u8c61\u65e0\u6548\uff08TempAppendix.deleteRelation\uff09"));
        }
        return this.deleteRelation(template.getId());
    }

    public boolean deleteRelation(int n) throws WCMException {
        try {
            String[] stringArray = new String[]{"delete from wcmTempApdRel where TempId=" + n + " and AppendixId=" + this.getId()};
            this.getDBManager().sqlExecuteUpdate(stringArray);
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(TempAppendix.class, "TempAppendix.label9", "\u5220\u9664\u6a21\u677f\u9644\u4ef6\u5173\u8054\u5931\u8d25\uff08TemplateAppendix.deleteRelation\uff09"), exception);
        }
    }

    public static final TempAppendix findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (TempAppendix)BaseObj.findById(TempAppendix.class, n);
    }

    public static final TempAppendix createNewInstance() throws WCMException {
        return (TempAppendix)BaseObj.createNewInstance(TempAppendix.class);
    }

    public static final TempAppendix findByKey(Object object) throws WCMException {
        return (TempAppendix)BaseObj.findByKey(TempAppendix.class, object);
    }
}

