/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class TagBean
extends CMSObj {
    public static final int OBJ_TYPE = 951;
    public static final String DB_TABLE_NAME = "WCMTAGBEANS";
    public static final String DB_ID_NAME = "TAGBEANID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 951;
    }

    public String getTagName() {
        return (String)this.getProperty("TAGNAME");
    }

    public boolean setTagName(String string) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(10, "Tag name required!");
        }
        return this.setProperty("TAGNAME", string.toUpperCase());
    }

    public String getTagDesc() {
        return (String)this.getProperty("TAGDESC");
    }

    public boolean setTagDesc(String string) throws WCMException {
        return this.setProperty("TAGDESC", string);
    }

    public String getTagBean() {
        return (String)this.getProperty("TAGBEAN");
    }

    public boolean setTagBean(String string) throws WCMException {
        return this.setProperty("TAGBEAN", string);
    }

    public boolean isEnabled() {
        return this.getPropertyAsBoolean("ENABLED", true);
    }

    public boolean setEnabled(boolean bl) throws WCMException {
        return this.setProperty("ENABLED", bl);
    }

    public boolean isValid() throws WCMException {
        String string;
        String string2 = null;
        if (this.isAddMode()) {
            string2 = (String)this.getProperty("TAGNAME");
            if (string2 == null) {
                throw new WCMException(1106, I18NMessage.get(TagBean.class, "TagBean.label1", "\u5c5e\u6027TagName\u6ca1\u6709\u8bbe\u7f6e"));
            }
            string = (String)this.getProperty("TAGBEAN");
            if (string == null || string.length() == 0) {
                throw new WCMException(1106, I18NMessage.get(TagBean.class, "TagBean.label2", "\u5c5e\u6027TagBean\u6ca1\u6709\u8bbe\u7f6e\u6216\u4e3a\u7a7a\uff01"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(TagBean.class, "TagBean.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
            }
            string2 = (String)this.getNewProperty("TAGNAME");
            string = (String)this.getNewProperty("TAGBEAN");
        }
        if (string2 != null) {
            String string3 = "(TagName='" + CMyString.filterForSQL(string2) + "')";
            if (!this.isAddMode()) {
                string3 = string3 + " AND (" + this.getIdFieldName() + "<>" + this.getId() + ")";
            }
            if (this.checkExists(string3)) {
                throw new WCMException(1108, I18NMessage.get(TagBean.class, "TagBean.label4", "\u7f6e\u6807\u540d\u79f0[") + string2 + I18NMessage.get(TagBean.class, "TagBean.label5", "]\u5df2\u7ecf\u5b58\u5728"));
            }
        }
        if (string != null) {
            try {
                Class.forName(string);
            }
            catch (Exception exception) {
                throw new WCMException(13, "Bean class [" + string + "] is not found!", exception);
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ENABLED") == null) {
                this.setEnabled(true);
            }
            super.insert(user);
        }
    }

    public static final TagBean findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (TagBean)BaseObj.findById(TagBean.class, n);
    }

    public static final TagBean createNewInstance() throws WCMException {
        return (TagBean)BaseObj.createNewInstance(TagBean.class);
    }

    public static final TagBean findByKey(Object object) throws WCMException {
        return (TagBean)BaseObj.findByKey(TagBean.class, object);
    }
}

