/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.taskdispatch;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishErrorLog;
import com.trs.components.common.publish.persistent.taskdispatch.PublishErrorLogs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class PublishTask
extends CMSObj {
    private static final Logger s_logger = Logger.getLogger(PublishTask.class);
    public static final int OBJ_TYPE = -1676813972;
    public static final String DB_TABLE_NAME = "WCMPUBLISHTASK";
    public static final String DB_ID_NAME = "PUBLISHTASKID";
    public static final int TITLE_LENGTH_MAX = 400;
    private static final int MAX_URL_LENGTH = 500;
    private static final char URL_SEPERATOR = '~';
    private static Logger logger = Logger.getLogger(PublishTask.class);

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return -1676813972;
    }

    public int getPublishType() {
        return this.getPropertyAsInt("PUBLISHTYPE", 0);
    }

    public boolean setPublishType(int n) throws WCMException {
        return this.setProperty("PUBLISHTYPE", n);
    }

    public int getPriority() {
        return this.getPropertyAsInt("TASKPRIORITY", 5);
    }

    public void setPriority(int n) throws WCMException {
        this.setProperty("TASKPRIORITY", n);
    }

    public int getStatus() {
        return this.getPropertyAsInt("TASKSTATUS", 0);
    }

    public boolean isExecuted() {
        return PublishConstants.isTaskExecuted(this.getStatus());
    }

    public boolean setStatus(int n) throws WCMException {
        return this.setProperty("TASKSTATUS", n);
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public IPublishFolder getFolder() throws WCMException {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getFolderType(), this.getFolderId());
    }

    public boolean setFolder(int n, int n2) throws WCMException {
        return this.setProperty("FOLDERTYPE", n) && this.setProperty("FOLDERID", n2);
    }

    public boolean setFolder(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig required!");
        }
        return this.setFolder(iPublishFolder.getType(), iPublishFolder.getId());
    }

    public int getContentType() {
        return this.getPropertyAsInt("CONTENTTYPE", 0);
    }

    public String getContentIds() {
        return this.getPropertyAsString("CONTENTIDS");
    }

    public IPublishElements getContents() throws WCMException {
        String string = this.getContentIds();
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        return PublishElementFactory.lookupElements(this.getContentType(), string);
    }

    public boolean setContent(int n, String string) throws WCMException {
        return this.setProperty("CONTENTTYPE", n) && this.setProperty("CONTENTIDS", string);
    }

    public boolean setContent(IPublishContent iPublishContent) throws WCMException {
        if (iPublishContent == null) {
            return this.setProperty("CONTENTTYPE", 0L);
        }
        return this.setContent(iPublishContent.getType(), String.valueOf(iPublishContent.getId()));
    }

    public String getTitle() {
        return this.getPropertyAsString("TASKTITLE");
    }

    public boolean setTitle(String string) throws WCMException {
        if (string == null) {
            return false;
        }
        if (string.length() > 400) {
            string = string.substring(0, 400);
        }
        return this.setProperty("TASKTITLE", string);
    }

    public String[] getURLs() {
        String string = this.getPropertyAsString("TASKURL");
        return string == null ? null : CMyString.split(string, String.valueOf('~'));
    }

    public boolean setURL(String[] stringArray) throws WCMException {
        if (stringArray == null) {
            return false;
        }
        String string = null;
        if (stringArray != null) {
            int n = 0;
            for (int i = 0; i < stringArray.length && (n += stringArray[i].length()) < 500; ++i) {
                string = i == 0 ? stringArray[i] : string + '~' + stringArray[i];
            }
        } else {
            string = "";
        }
        return this.setProperty("TASKURL", string);
    }

    public String getDesc() {
        return this.getPropertyAsString("TASKDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("TASKDESC", string);
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("STARTTIME");
    }

    public boolean setStartTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("STARTTIME", cMyDateTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("ENDTIME");
    }

    public boolean setEndTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("ENDTIME", cMyDateTime);
    }

    public int getTimeUsed() {
        int n = this.getPropertyAsInt("TIMEUSED", 0);
        if (n <= 0 && (this.getEndTime() == null || this.getEndTime().isNull())) {
            long l = this.getStartTime().getTimeInMillis();
            if (l <= 0L) {
                return 0;
            }
            return (int)(System.currentTimeMillis() - l);
        }
        return n;
    }

    public boolean setTimeUsed(int n) throws WCMException {
        return this.setProperty("TIMEUSED", n);
    }

    public boolean isHasWarnings() {
        return this.getPropertyAsBoolean("HASWARNINGS", false);
    }

    public boolean setHasWarnings(boolean bl) throws WCMException {
        return this.setProperty("HASWARNINGS", bl);
    }

    public int getPageTaskCount() {
        return this.getPropertyAsInt("PAGETASKCOUNT", 0);
    }

    public boolean setPageTaskCount(int n) throws WCMException {
        return this.setProperty("PAGETASKCOUNT", n);
    }

    public String getAnalyzeError() {
        return this.getPropertyAsString("ANALYZEERROR");
    }

    public boolean setAnalyzeError(String string) throws WCMException {
        if (string != null && string.length() > 1000) {
            string = string.substring(0, 1000);
        }
        return this.setProperty("ANALYZEERROR", string);
    }

    public int getDetailPageCount() {
        return this.getPropertyAsInt("DETAILPAGES", 0);
    }

    public boolean setDetailPageCount(int n) throws WCMException {
        return this.setProperty("DETAILPAGES", n);
    }

    public int getOutlinePageCount() {
        return this.getPropertyAsInt("OUTLINEPAGES", 0);
    }

    public boolean setOutlinePageCount(int n) throws WCMException {
        return this.setProperty("OUTLINEPAGES", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("FOLDERTYPE") == null) {
                throw new WCMException(1106, "Property of FolerType required!");
            }
            if (this.getAllProperty().get("FOLDERID") == null) {
                throw new WCMException(1106, "Property of FolderId required!");
            }
            if (this.getAllProperty().get("PUBLISHTYPE") == null) {
                throw new WCMException(1106, "Property of PublishType required!");
            }
            if (this.getAllProperty().get("TASKSTATUS") == null) {
                throw new WCMException(1106, "Property of Status required!");
            }
            if (this.getAllProperty().get("TASKTITLE") == null) {
                throw new WCMException(1106, "Property of Title required!");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(PublishTask.class, "PublishTask.label1", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"who call me?", (Throwable)new Exception());
        }
        if (this.isAddMode() && this.getAllProperty() != null) {
            Hashtable hashtable = this.getAllProperty();
            if (hashtable.get("TASKSTATUS") == null) {
                this.setStatus(1);
            }
            if (hashtable.get("CONTENTTYPE") == null) {
                this.setContent(null);
            }
            if (hashtable.get("HASWARNINGS") == null) {
                this.setHasWarnings(false);
            }
            if (hashtable.get("TIMEUSED") == null) {
                this.setTimeUsed(0);
            }
            if (hashtable.get("PAGETASKCOUNT") == null) {
                this.setPageTaskCount(0);
            }
            if (hashtable.get("CRUSER") == null) {
                this.setCrUser(user);
            }
            if (hashtable.get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(user);
        }
    }

    public static final PublishTask findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (PublishTask)BaseObj.findById(PublishTask.class, n);
    }

    public static final PublishTask createNewInstance() throws WCMException {
        return (PublishTask)BaseObj.createNewInstance(PublishTask.class);
    }

    public static final PublishTask findByKey(Object object) throws WCMException {
        return (PublishTask)BaseObj.findByKey(PublishTask.class, object);
    }

    public boolean isPublishContent() {
        return this.getContentType() != 0;
    }

    public boolean isPublishFolder() {
        return this.getContentType() == 0;
    }

    public PublishErrorLogs getErrorLogs(User user, WCMFilter wCMFilter) throws WCMException {
        try {
            String string = "PUBLISHTASKID=?";
            WCMFilter wCMFilter2 = new WCMFilter("", string, "");
            wCMFilter2.addSearchValues(this.getId());
            if (wCMFilter != null) {
                wCMFilter2.mergeWith(wCMFilter);
            }
            PublishErrorLogs publishErrorLogs = new PublishErrorLogs(user);
            publishErrorLogs.open(wCMFilter2);
            publishErrorLogs.setPageSize(publishErrorLogs.size());
            return publishErrorLogs;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the task error logs!", exception);
        }
    }

    public PublishErrorLog addErrorLog(User user, IPublishElement iPublishElement, String string, int n, String string2) throws WCMException {
        try {
            PublishErrorLog publishErrorLog = PublishErrorLog.createNewInstance();
            if (iPublishElement != null) {
                if (iPublishElement instanceof IPublishFolder) {
                    publishErrorLog.setFolder((IPublishFolder)iPublishElement);
                } else {
                    publishErrorLog.setContent((IPublishContent)iPublishElement);
                    publishErrorLog.setFolder(((IPublishContent)iPublishElement).getFolder());
                }
            }
            publishErrorLog.setPublishTask(this);
            publishErrorLog.setDesc(string);
            publishErrorLog.setResult(n);
            publishErrorLog.setErrorDetail(string2);
            publishErrorLog.setCrUser(user);
            publishErrorLog.insert(user);
            return publishErrorLog;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to add error log for publish task!", exception);
        }
    }

    public PublishTask duplicate(User user, boolean bl) throws WCMException {
        try {
            PublishTask publishTask = PublishTask.createNewInstance();
            publishTask.setPublishType(this.getPublishType());
            publishTask.setFolder(this.getFolderType(), this.getFolderId());
            publishTask.setContent(this.getContentType(), this.getContentIds());
            publishTask.setPriority(this.getPriority());
            publishTask.setStatus(1);
            publishTask.setCrUser(user);
            if (bl) {
                publishTask.insert(user);
            }
            return publishTask;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to duplicate the publish task!", exception);
        }
    }

    public String getFolderIds() {
        return this.getPropertyAsString("FOLDERIDS");
    }

    public IPublishElements getFolders() throws WCMException {
        String string = this.getFolderIds();
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        return PublishElementFactory.lookupElements(this.getFolderType(), string);
    }

    public boolean setFolders(IPublishElements iPublishElements) throws WCMException {
        if (iPublishElements.size() > 0) {
            IPublishElement iPublishElement = iPublishElements.get(0);
            if (iPublishElement instanceof IPublishFolder) {
                int n = iPublishElement.getType();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(iPublishElement.getId());
                int n2 = iPublishElements.size();
                for (int i = 1; i < n2; ++i) {
                    stringBuffer.append(',');
                    stringBuffer.append(iPublishElements.get(i).getSubstance().getId());
                }
                return this.setProperty("FOLDERTYPE", n) && this.setFolders(stringBuffer.toString());
            }
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append('[').append(iPublishElement.getInfo()).append("] 's class is [");
            stringBuffer.append(iPublishElement.getClass().getName());
            stringBuffer.append("], not IPublishFolder");
            s_logger.warn((Object)stringBuffer.toString());
        }
        return false;
    }

    public boolean setFolders(String string) throws WCMException {
        if (string != null && (string = string.trim()).length() > 0) {
            return this.setProperty("FOLDERIDS", string);
        }
        return false;
    }

    public boolean isSchedulePublishTask() {
        return this.getPropertyAsBoolean("ISSCHEDULEDTASK", false);
    }

    public boolean setSchedulePublishTask(boolean bl) throws WCMException {
        return this.setProperty("ISSCHEDULEDTASK", bl);
    }
}

